<?php

use Core\Controller;
use Models\Users;
use Models\Permissao;
use Models\Orm;

class AcoesController extends controller {

  private $user;
  private $arr;
  private $permissao;

    public function __construct() {              
        $this->user = new Users();
        $this->permissao = new Permissao(); 

        if($this->user->isLogged() == false){                  
         header("Location: ".BASE_URL."login");        
         exit;         
        }

       $usuario = $this->user->getId();       
       $permissoes = $this->permissao->getPermissoes();
       $modulo_boleto = $this->permissao->getPermissoesBoleto();
       
        $this->arr = array(
         'user'=>$this->user,
         'menuActive'=>'home',
         'permissao'=>$permissoes,
         'modulo_boleto'=>$modulo_boleto
        );         
}

public function index() {      

$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'mask_init',
'plugins/sweetalert2',
'system'
);


$this->arr['list'] = (new Orm('usuario_acao'))->select('*')->get();
$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);

$this->loadTemplate('acoes/acao', $this->arr);
}//index 


public function add(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'mask_init',
);

if(isset($_POST['nome']) && !empty($_POST['nome'])):           
$nome = $this->limpaCampo($_POST['nome']);       
$insere = (new Orm('usuario_acao'))->set(['acao'=>$nome,'alias_acao'=>$this->Slug($nome)])->save();


$_SESSION['msg'] = ['type'=>'success','msg'=>"Ação cadastrada com sucesso!"];
header("Location:".BASE_URL."acoes");
exit;
endif;

  $this->loadTemplate('acoes/adicionar', $this->arr);

}//add



public function edit($id){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'mask_init',
);


$this->arr['info'] = (new Orm('usuario_acao'))->select('*')->where(['id_acao', $id])->first()->get();

if(isset($_POST['nome']) && !empty($_POST['nome'])):        
$nome = $this->limpaCampo($_POST['nome']);
$slug = $this->Slug($nome);   

$up = (new Orm('usuario_acao'))
->set(['acao'=>$nome, 'alias_acao'=>$slug])
->where(['id_acao', $id])->update();


$_SESSION['msg'] = ['type'=>'success','msg'=>'Ação Atualizada com sucesso!']; 
header("Location:".BASE_URL."acoes");
endif;

  $this->loadTemplate('acoes/editar', $this->arr);

}//edit


public function del($id){
$deletar = (new Orm('usuario_acao'))->del(['id_acao', $id]);
$_SESSION['msg'] = ['type'=>'success','msg'=>"Ação removida com sucesso!"];
header("Location: ".BASE_URL."acoes");
exit;
}//del 


}