<?php
use Core\Controller;
use Models\Users;
use Models\Email;
use Models\Orm;
use Models\Permissao;
use Models\Report;

class AjaxController extends Controller{

private $user;
private $arrayInfo;

public function __construct() {              
$this->user = new Users();

if($this->user->isLogged() == false){                  
 header("Location: ".BASE_URL."login");        
 exit;         
}  

$this->arrayInfo = array(
  'user'=>$this->user 
);  

}//construtor

public function changeUF(){
$estado = filter_input(INPUT_POST, 'estado'); 
$uf = (new Orm('estado'))->select('*')->where(['uf_estado',"{$estado}"])->first()->get();


$dados = (new Orm('cidade'))->select('*')->where(['id_estado',$uf->id_estado])->get();

echo json_encode($dados);
exit;
}

public function pegaCidade(){
$estado = filter_input(INPUT_POST, 'uf'); 
$uf = (new Orm('estado'))->select('*')
->where(['uf_estado',"{$estado}"])->first()->get();

$dados = (new Orm('cidade'))->select('*')->where(['id_estado',$uf->id_estado])->get();

echo json_encode($dados);
exit;

}//pegaCidade

public function buscacontratos(){
$operadora = filter_input(INPUT_POST,'operadora');

$saida = '';
$arr_produtos = [];
$arr_convenios = [];

$produtos = (new Orm('produtos'))->select(['id_produto'])
->where(['operadora', $operadora])->get();

foreach($produtos as $prod){
  $arr_produtos[] += $prod->id_produto;
}

$string = '';
//aqui pego o id de todos os convenios
$convenios = (new Orm('convenios'))->select(['id_convenio'])
->wherecustom("id_produto IN('".implode(',',$arr_produtos)."')")->get();
foreach($convenios as $conv){
$arr_convenios[] += $conv->id_convenio;
}


foreach($arr_convenios as $st){
  $string .= '"'.$st.'",';    
}
$string = substr($string, 0, -1);

$contratos = (new Orm('contratos'))->select([
'id_contrato',
'numero_proposta',
'nome_cliente'
])->wherecustom("convenio IN(".$string.") AND status = 'Ativo'")->get();

$saida .= '<option value="">Selecione...</option>';
foreach($contratos as $contrato){
$saida .= '<option value="'.$contrato->id_contrato.'">'.$contrato->numero_proposta.'-'.$contrato->nome_cliente.'</option>';
}

echo $saida;
exit;
}//buscacontratos


public function consultacontrato(){
$id_contrato = filter_input(INPUT_POST,'id_contrato');

$contrato = (new Orm('contratos'))->select(['contratos.id_contrato', 'contratos.numero_proposta','contratos.nome_cliente','contratos.convenio','contratos.produtor','contratos.valor_contrato','convenios.nome_convenio'])
->join(['convenios'])
->on(['contratos.convenio','=','convenios.id_convenio'])
->where(['id_contrato', $id_contrato])->first()->get();

$baixa = (new Orm('lancamento_historico'))->select('*')
->wherecustom("id_contrato = {$contrato->id_contrato} AND status_baixa = 'recebida'")
->get(); 

// echo "<pre>";
// print_r($baixa);
// exit;

if(!empty($baixa)){
	foreach($baixa as $bx){
    $parcela       = $bx->num_parcela;
    $valor_parcela = $bx->valor_parcela;
    $valor_baixa   = $bx->valor_baixa;
	}
	$contrato->num_parcela   = $parcela + 1;
  $contrato->valor_parcela = $valor_parcela;
  $contrato->valor_baixa   = $valor_baixa;
}else{ 
  $contrato->num_parcela = 1;
  $contrato->valor_parcela = 0;
  $contrato->valor_baixa = 0;
}

echo json_encode($contrato);
exit;
}//consultacontrato



public function toggleAside(){
if(!isset($_SESSION['marcado'])){
	$_SESSION['marcado'] = 'nao';
}

if($_SESSION['marcado'] == 'nao'){
	$_SESSION['marcado'] = 'sim';
}else if($_SESSION['marcado'] == 'sim'){
	$_SESSION['marcado'] = 'nao';
}
}//toggleAside


public function buscaGrade(){
$convenio = filter_input(INPUT_POST, 'convenio');
$data = filter_input(INPUT_POST, 'data_vigencia');
$produtor = filter_input(INPUT_POST, 'produtor');
$arr_produtores = [];

$dt_arr = explode('/', $data);

$grade = (new Orm('grades'))->select(['id_grade'])
->wherecustom("id_convenio = $convenio AND MONTH(data_vigencia) = '$dt_arr[1]' AND YEAR(data_vigencia) = '$dt_arr[2]'")->order(['data_vigencia desc'])->get();

if(empty($grade)){
//se ta vazio vai buscar o mais recente da grade
$grade = (new Orm('grades'))->select(['id_grade'])
->where(['id_convenio', $convenio])->get();
 $id_grade = '';

 foreach($grade as $grd){
    $id_grade = $grd->id_grade;    
 } 
}else{
 $id_grade = '';
 foreach($grade as $grd){
    $id_grade = $grd->id_grade;    
 } 
}//verifica se a grade veio vazio ou preenchida

//pegando todas as regras vinculadas a grade
$regras = (new Orm('regras_convenio'))->select('*')->where(['id_grade', $id_grade])->get();


if($regras[0]->produtor_compusorio == ''){

$produtores = (new Orm('produtor'))->select(['id_produtor, nome, grupo_produtor, superior'])->where(['id_produtor', $produtor])->first()->get();

array_push($arr_produtores, $produtores);

if(!empty($produtores)){
$arr_produtores = $this->addProdutores($arr_produtores, $produtores->superior);
}

$saida = '';
$comissao = [
1=>'Percentual da parcela (%)',
2=>'Valor por contrato (R$)',
3=>'Valor por vida (R$)'];


foreach($regras as $key=> $regra){

$nome_produtor = (isset($arr_produtores[$key]->nome)) ? $arr_produtores[$key]->nome : null;
if($nome_produtor != null){
 $prod_compusorio = $nome_produtor;
}else{
  $prod_compusorio = $regra->produtor_compusorio;
}

if(!empty($prod_compusorio)){

$saida .= '
<tr>
       <td>'.$prod_compusorio.'</td>
       <td>'.$comissao[$regra->forma_comissao].'</td>
       <td><input type="text" value="'.$regra->comissao_1_parcela.'/'.$regra->comissao_2_parcela.'/'.$regra->comissao_3_parcela.'/'.$regra->comissao_4_parcela.'/'.$regra->comissao_5_parcela.'/'.$regra->comissao_6_parcela.'" readonly/></td>
       <td><input type="text" name="parc_limite[]" value="'.$regra->parc_limite.'"/></td>
       <td>'.$regra->imposto_1_parcela.'/'.$regra->imposto_demais_parcelas.'</td>     

       <td>
       <input type="hidden" name="id_regra_convenio[]" value="0" />       
       <input type="hidden" name="produtor[]" value="'.$prod_compusorio.'" readonly/>
       <input type="hidden" name="comissao[]" value="'.$regra->forma_comissao.'" readonly/>
       <input type="hidden" name="grupo[]" value="'.$regra->grupo_produtor.'" readonly/>
       <input type="hidden" name="primeira_parcela[]" value="'.$regra->comissao_1_parcela.'" readonly/>
       <input type="hidden" name="segunda_parcela[]" value="'.$regra->comissao_2_parcela.'" readonly/>
       <input type="hidden" name="terceira_parcela[]" value="'.$regra->comissao_3_parcela.'"/>
       <input type="hidden" name="quarta_parcela[]" value="'.$regra->comissao_4_parcela.'"/>
       <input type="hidden" name="quinta_parcela[]" value="'.$regra->comissao_5_parcela.'"/>
       <input type="hidden" name="sexta_parcela[]" value="'.$regra->comissao_6_parcela.'"/>   
       <input type="hidden" name="demais_parcelas[]" value="'.$regra->imposto_demais_parcelas.'"/>
       <input type="hidden" name="taxa_adesao[]" value="'.$regra->taxa_adesao.'"/>
       <input type="hidden" name="imposto_demais_parc[]" value="'.$regra->imposto_demais_parcelas.'"/>
    
        
       <input type="hidden" name="imposto_primeira_parc[]" value="'.$regra->imposto_1_parcela.'"/>      
       <button type="button" onclick="removerTr(this)" class="btn btn-error">Excluir</button>
       </td>
       </tr>
';
}

}//percorrendo as regras 

echo $saida;
exit;
}//se veio com produtor vazio

//se ja veio com os produtores vamos vir por aqui
$saida = '';
$comissao = [1=>'Percentual da parcela (%)',2=>'Valor por contrato (R$)',3=>'Valor por vida (R$)'];

foreach($regras as $regra){  
$saida .= '
<tr>
       <td>'.$regra->produtor_compusorio.'</td>
       <td>'.$comissao[$regra->forma_comissao].'</td>
       <td><input type="text" value="'.$regra->comissao_1_parcela.'/'.$regra->comissao_2_parcela.'/'.$regra->comissao_3_parcela.'/'.$regra->comissao_4_parcela.'/'.$regra->comissao_5_parcela.'/'.$regra->comissao_6_parcela.'" readonly/></td>
       <td><input type="text" name="parc_limite[]" value="'.$regra->parc_limite.'"/></td>
       <td>'.$regra->imposto_1_parcela.'/'.$regra->imposto_demais_parcelas.'</td>     

       <td>
       <input type="hidden" name="id_regra_convenio[]" value="0" />       
       <input type="hidden" name="produtor[]" value="'.$regra->produtor_compusorio.'" readonly/>
       <input type="hidden" name="comissao[]" value="'.$regra->forma_comissao.'" readonly/>
       <input type="hidden" name="grupo[]" value="'.$regra->grupo_produtor.'" readonly/>
       <input type="hidden" name="primeira_parcela[]" value="'.$regra->comissao_1_parcela.'" readonly/>
       <input type="hidden" name="segunda_parcela[]" value="'.$regra->comissao_2_parcela.'" readonly/>
       <input type="hidden" name="terceira_parcela[]" value="'.$regra->comissao_3_parcela.'"/>
       <input type="hidden" name="quarta_parcela[]" value="'.$regra->comissao_4_parcela.'"/>
       <input type="hidden" name="quinta_parcela[]" value="'.$regra->comissao_5_parcela.'"/>
       <input type="hidden" name="sexta_parcela[]" value="'.$regra->comissao_6_parcela.'"/>   
       <input type="hidden" name="demais_parcelas[]" value="'.$regra->imposto_demais_parcelas.'"/>
       <input type="hidden" name="taxa_adesao[]" value="'.$regra->taxa_adesao.'"/>
       <input type="hidden" name="imposto_demais_parc[]" value="'.$regra->imposto_demais_parcelas.'"/>
    
        
       <input type="hidden" name="imposto_primeira_parc[]" value="'.$regra->imposto_1_parcela.'"/>      
       <button type="button" onclick="removerTr(this)" class="btn btn-error">Excluir</button>
       </td>
       </tr>
';
}

echo $saida;
exit;
}//buscaGrade


public function addProdutores($arr, $produtor){
$array = $arr;

$prod = (new Orm('produtor'))->select(['id_produtor, nome, grupo_produtor, superior'])->where(['id_produtor', $produtor])->first()->get();

if(empty($prod)){
  return $array;
}

if($prod->superior == null){
 array_push($array, $prod);
  
  return $array; 
}else{
array_push($array, $prod);
}

$array = $this->addProdutores($array, $prod->superior);
return $array;
}//addProdutores

public function delregra(){
$id = filter_input(INPUT_POST,'id');
$del = (new Orm('regras_comissao'))->del(['id_regra', $id]);

echo json_encode($del);
exit;
}


public function pegaProdutores(){
$grupos = filter_input(INPUT_POST,'dados');
$filial = filter_input(INPUT_POST,'filial');
$tipos  = filter_input(INPUT_POST,'tipos');
$data   = filter_input(INPUT_POST,'data');
$itens = [];

//transformando em string os grupos
$grupos = json_decode($grupos);
$grupo = '';
foreach($grupos as $gp){
 $grupo .= '"'.$gp.'",';    
}
$grupo = substr($grupo, 0, -1);

//transformando em string os lancamentos
$tipos = json_decode($tipos);
$tipo = '';
foreach($tipos as $tp){
 $tipo .= '"'.$tp.'",';    
}
$tipo = substr($tipo, 0, -1);

if($grupo != ''){
$produtores = (new Orm('produtor'))->select(['id_produtor'])
->wherecustom("grupo_produtor IN($grupo)")->group(['id_produtor'])->get();

foreach($produtores as $produtor){
array_push($itens, $produtor->id_produtor);
}

$itens = $this->convertArrayToString($itens);

if($tipo == ''){
$lancs = (new Orm('lanc_hist_comissoes'))->select('*')
->join(['produtor'])
->on(['produtor.id_produtor','=','lanc_hist_comissoes.produtor_id'])
->wherecustom("produtor_id IN(".$itens.") AND recibo = 'N' GROUP BY produtor_id")
->get();
}else{
$tipos_l = $tipo;

$lancs = (new Orm('lanc_hist_comissoes'))->select('*')
->join(['produtor'])
->on(['produtor.id_produtor','=','lanc_hist_comissoes.produtor_id'])
->wherecustom("produtor_id IN(".$itens.") AND tipo IN(".$tipos_l.") AND recibo = 'N' OR recibo = 'E' GROUP BY produtor_id")
->get();
}


$saida = '';

if(!empty($lancs)){
foreach($lancs as $lanc){
$saldo = $this->getSaldo($lanc->id_produtor);

$saida .=' 
<tr>
<td><input style="border:1px solid #333;display: inline-block;" type="checkbox" name="produtor[]" value="'.$lanc->id_produtor.'"/></td>
<td>'.$lanc->nome.'</td>
<td>'.$lanc->grupo_produtor.'</td>
<td><input type="hidden" name="saldo[]" value="'.$saldo.'"/>R$ '.$saldo.'</td>  
<td align="center"><a href="'.BASE_URL.'"><i class="fas fa-file"></i></a></td>
</tr>';
}

}else{
$saida .= '<tr>
<td colspan="5">Nenhum produtor localizado</td>
</tr>';
}


echo $saida;
}else{
$saida = '';
echo $saida;
}


}//pegaProdutores




public function getSaldo($produtor){
$credito = 0;
$despesa = 0;
$extorno = 0;
$total = 0;


$lancamentos = [];

$sql = (new Orm('lanc_hist_comissoes'))->select('*')
->wherecustom("produtor_id = {$produtor} AND recibo IN('N', 'E') ")->get();

foreach($sql as $key=>$item){

if(!is_null($item->id_lancamento)){ 
$lanc = (new Orm('lanc_hist_comissoes'))->select('*')
 ->wherecustom("id_historico_comissao = {$item->id_lancamento}")
 ->first()->get();

array_push($lancamentos, $sql[$key]);
}

// if(!empty($lanc) && $lanc->status_baixa != 'Cancelado'){
//  $sql[$key]->id_historico   = $lanc->id_historico ?? '';
//  $sql[$key]->id_contrato    = $lanc->id_contrato ?? '';
//  $sql[$key]->convenio_id    = $lanc->convenio_id ?? '';
//  $sql[$key]->num_proposta   = $lanc->num_proposta ?? '';
//  $sql[$key]->valor_contrato = $lanc->valor_contrato ?? '';
//  $sql[$key]->num_parcela    = $lanc->num_parcela ?? '';
//  $sql[$key]->valor_parcela  = $lanc->valor_parcela ?? '';
//  $sql[$key]->valor_baixa    = $lanc->valor_baixa ?? '';
//  $sql[$key]->data_baixa     = $lanc->data_baixa ?? '';
//  $sql[$key]->data_pagamento = $lanc->data_pagamento ?? '';
//  $sql[$key]->id_usuario     = $lanc->id_usuario ?? '';
//  $sql[$key]->status_baixa   = $lanc->status_baixa ?? '';

//  array_push($lancamentos, $sql[$key]);
// }
// }else{
//  array_push($lancamentos, $sql[$key]);
// }
}

if(!empty($lancamentos)){
foreach($lancamentos as $item){

switch($item->tipo){
case 'L':
case 'LM':
case 'LA':
case 'ED':
$credito += $item->valor;
break;

case 'D':
case 'DM':
case 'A':
case 'T':
case 'EC':
$despesa += $item->valor;
break;

// case 'ED':
// $extorno += $item->valor;
// break;

// case 'EC':
// $extorno -= $item->valor;

}//switch

}//foreach



$total = $credito - $despesa;
return number_format($total,2,',','.');
}else{
return number_format($total,2,',','.');
}
}//getSaldo





public function emitirRecibos(){
foreach($_POST['recibos'] as $recibo){

$up = (new Orm('recibos'))->set(['status_recibo'=>'emitido'])
->where(['id_recibo', $recibo])->update();
}

echo json_encode('200');
exit;
}//emitirRecibos


public function montaColuna(){
$retorno = [];
$titulo = '';
$html = '';
$coluna = addslashes(trim($_POST['coluna']));
$tipo = addslashes(trim($_POST['tipo']));
$obrigatorio = addslashes(trim($_POST['obrigatorio']));


$exp = explode('_', $coluna);
foreach($exp as $ln){
  $titulo .= ucfirst($ln)." ";
}

$html .= '<li class="tarea" data-obg="'.$obrigatorio.'" data-tipo="'.$tipo.'" data-id="'.$coluna.'">'.trim($titulo).'<span class="remove_tag">X</span></li>';

echo $html;
exit;
}



public function consultaDash(){
$r = new Report(); 
$periodo1     = $_POST['periodo1'];
$periodo2     = $_POST['periodo2']; 
$comparativo1 = $_POST['comparativo1'];
$comparativo2 = $_POST['comparativo2']; 
$grupo        = $_POST['grupo'];
$produtor     = $_POST['produtor'];
$convenio     = $_POST['convenio'];

$retorno = ['total_contratos'=>0,'total_valor'=>0,'total_leads'=>0,'total_vidas'=>0];

$periodo1     = $this->converterData($periodo1, '/');
$periodo2     = $this->converterData($periodo2, '/');
$comparativo1 = $this->converterData($comparativo1, '/');
$comparativo2 = $this->converterData($comparativo2, '/');


$result = $r->homedash($periodo1, $periodo2, $comparativo1, $comparativo2, $produtor, $grupo, $convenio);

$leads  = (new Orm('leads'))->select(['count(id_lead) as total_leads, sum(qtde_vidas) total_vidas'])
->wherecustom("data_entrada >= '$periodo1' AND data_entrada <= '$periodo2'")
->first()->get();

$leads2  = (new Orm('leads'))->select(['count(id_lead) as total_leads, sum(qtde_vidas) total_vidas'])
->wherecustom("data_entrada >= '$comparativo1' AND data_entrada <= '$comparativo2'")
->first()->get();

$result = (object) $result;

$retorno = [
'total_contratos'=>$result->total1 ?? 0,
'total_valor'=>$result->valor1 ?? 0,
'total_contratos2'=>$result->total2 ?? 0,
'total_valor2'=>$result->valor2 ?? 0,
'total_leads'=>$leads->total_leads ?? 0,
'total_vidas'=>$leads->total_vidas ?? 0,
'total_leads2'=>$leads2->total_leads ?? 0,
'total_vidas2'=>$leads2->total_vidas ?? 0
];

echo json_encode($retorno);
exit;
}//consultaDash

public function emitirlotepagamentos(){
$recibos = $_POST['recibos'];

foreach($recibos as $recibo){
$up = (new Orm('recibos'))->set(['data_emissao'=>date('Y-m-d'), 'status_recibo'=>'pago'])->where(['id_recibo', $recibo])->update();
}


echo json_encode('200');
exit;
}

public function emitirloteemail(){
$recibos = $_POST['recibos'];
$conta = 0;
$errors = 0;

foreach($recibos as $recibo){

$recibo = (new Orm('recibos'))->select('*')
->where(['id_recibo', $recibo])->first()->get();

$produtor = (new Orm('produtor'))->select(['email'])->where(['id_produtor', $recibo->id_produtor])->first()->get();

$this->arr['recibo'] = $recibo;

ob_start();
$this->loadView('recibos/email_marketing',$this->arr);
$content = ob_get_contents();
ob_end_clean();

//aqui eu envio o email
$mail = new Email();
$mail->addAdress($produtor->email, 'PowerControl');
$info = array('assunto'=>'Recibo', 'corpo'=>$content);
$mail->formatarEmail($info);

if($mail->enviarEmail()){
$conta++;
}else{
$errors++;  
}

}//foreach

echo json_encode("Foram enviados {$conta} E-mails com sucesso e {$errors} com erro");
exit;
}


private function diferencaDatas($inicial, $final){
$entrada = new Datetime($inicial);
$saida   = new Datetime($final);
$intervalo = $entrada->diff($saida);

//pegando os segundos
$segundos = $saida->getTimestamp() - $entrada->getTimestamp();
//pegando os minutos
$minutos = ($saida->getTimestamp() - $entrada->getTimestamp()) / 60;
//horas
$horas = (($saida->getTimestamp() - $entrada->getTimestamp()) / 60) / 60;


$retorno = [
'anos'=>$intervalo->y,
'meses'=>$intervalo->m,
'dias'=>$intervalo->days,
'horas'=>$intervalo->h,
'minutos'=>$intervalo->i,
'min'=>floor($minutos),
'hor'=>floor($horas)
];

return $retorno;
}//diferencaDatas


public function getNotificacoes(){
$itens = [];
$total2 = 0;  
$id = addslashes(trim($_POST['id_usuario_logado']));

//echo "<pre>";
//print_r($_POST);
//exit;

//$total = (new Orm('leads'))->select('*')->where(['para', $id])->total()->get();
$total = (new Orm('leads'))->select('*')->wherecustom("para = '$id' AND funil_id = 11")->total()->get();
$leads = (new Orm('leads'))->select('*')->wherecustom("para = '$id' AND funil_id = 11")->get();

foreach($leads as $key=>$lead){
   array_push($itens, $lead->nome);
}

$retorno = [
'total'=>$total,
'itens'=>$itens
];
//print_r($retorno);
//exit;
echo json_encode($retorno);
exit;
}

public function getNotificacoes2(){
  $itens = [];
  $total2 = 0;  
  $id = addslashes(trim($_POST['id_usuario_logado']));
  $total = (new Orm('leads'))->select('*')->where(['para', $id])->total()->get();
  $leads = (new Orm('leads'))->select('*')->where(['para', $id])->get();
  
  foreach($leads as $key=>$lead){
  $comentarios = (new Orm('leads_comentarios'))->select('*')->wherecustom("id_lead = '$lead->id_lead' AND finalizado = 'N'")->get();
  
  if(!empty($comentarios)){
  foreach($comentarios as $comentario){
     $agora = date('Y-m-d H:i:s');
     $data_lead = $comentario->data_agendamento." ".$comentario->hora_agendamento;
     $tempo = $this->diferencaDatas($agora, $data_lead);
   /* echo '<pre>';
     echo $comentario->id_comentario.'<br>';
     echo $tempo['minutos'].'<br>';
     echo $data_lead.'<br>';
     print_r($tempo);
    // exit;*/

     if ($tempo['anos'] == 0 && $tempo['meses'] == 0 && $tempo['horas'] == 0 && $tempo['dias'] == 0 && $tempo['min'] <= 5 && $tempo['min'] >= -20 && $tempo['minutos'] != 0 ){
       $total2++;
       $info = $comentario->data_agendamento." ".$comentario->hora_agendamento;
       array_push($itens, $info);
    }
  }
  }
  }
  //echo $total2;
  //exit;
  $retorno = [
  'total'=>$total2,
  'total_comentarios'=>$total2,
  'itens'=>$itens
  ];
  
  echo json_encode($retorno);
  exit;
  }

}//fim da class ajaxController