<?php
use Core\Controller;
use Models\Users;
use Models\Funil;
use Models\Motivo;
use Models\Permissao;
use Models\Orm;
use Models\Callcenter;

class CallcenterController extends Controller {

  private $user;
  private $arr;
  private $permissao;

    public function __construct() {              
        $this->user = new Users();
        $this->permissao = new Permissao(); 

        if($this->user->isLogged() == false){                  
         header("Location: ".BASE_URL."login");        
         exit;         
        }

        $permissoes = $this->permissao->getPermissoes();
        $modulo_boleto = $this->permissao->getPermissoesBoleto();
        
         $this->arr = array(
          'user'=>$this->user,
          'menuActive'=>'home',
          'permissao'=>$permissoes,
          'modulo_boleto'=>$modulo_boleto
         );           
}

public function index() {   
$this->arr['list_js'] = array(
'plugins/sweetalert2',
'system'
);  

$tab = new Orm('motivo');
$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);

if(isset($_GET['nome']) && !empty($_GET['nome'])){
$nome = addslashes($_GET['nome']);
$this->arr['lista'] = $tab->select('*')->search(['nome_motivo', $nome])->get();
}else{
$this->arr['lista'] = $tab->select('*')->paginate('10')->get();
$this->arr['paginacao'] = $tab->render("motivo");
}


$this->loadTemplate('motivo/listar', $this->arr);
}//function index  


public function callcenter_relatorios() {   
  $this->arr['list_js'] = array(
  'plugins/sweetalert2',
  'system'
  );  
  $this->arr['lista_atendente'] = (new Orm('usuarios'))->select('*')->wherecustom("ramal != ''")->order(['nome asc'])->get();
  
  $modulo_boleto = $this->permissao->getPermissoesBoleto();

  $chave = $modulo_boleto->callcenter_chave;

  $url = 'https://app.voxfree.com/crm/clique/webchamadas.php';
  $data = [
      'chave' => $chave,
  ];
  $payload = json_encode($data);
  //print_r($payload );
  //exit;
  $curl = curl_init();
  curl_setopt_array($curl, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POSTFIELDS=>$payload,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_HTTPHEADER => [    
      "accept: application/json"
    ],
  ]);
  
  $response = curl_exec($curl);
  $err = curl_error($curl);
  $datar = json_decode($response, TRUE);
  if(isset($datar) && !empty($datar)){
    print_r($datar);
    exit;


  }


  $this->loadTemplate('callcenter/callcenter_relatorios', $this->arr);
}//function index 

public function callcenter_gravacoes() {   
    $this->arr['list_js'] = array(
    'plugins/sweetalert2',
    'system'
    );  
    $this->arr['lista_atendente'] = (new Orm('usuarios'))->select('*')->wherecustom("ramal != ''")->order(['nome asc'])->get();
  
    $modulo_boleto = $this->permissao->getPermissoesBoleto();
  
    $chave = $modulo_boleto->callcenter_chave;
    $idcrm = $modulo_boleto->callcenter_idCRM;
  
    $url = 'https://app.voxfree.com/crm/clique/webgravacao.php';
    $data = [
        'chave' => $chave,
        'IdCRM'=> $idcrm
    ];
    $payload = json_encode($data);
    //print_r($payload );
    //exit;
    $curl = curl_init();
    curl_setopt_array($curl, [
      CURLOPT_URL => $url,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_POSTFIELDS=>$payload,
      CURLOPT_ENCODING => "",
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 30,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => "POST",
      CURLOPT_HTTPHEADER => [    
        "accept: application/json"
      ],
    ]);
    
    $response = curl_exec($curl);
    $err = curl_error($curl);
    $datar = json_decode($response, TRUE);
  
    if(isset($datar[0]['Status'])){
        echo 'Sem gravacoes(s) ativa(s)';
        exit;
    }else{
          
            foreach($datar as $data){
            $calldate = $data['calldate'];
            $usuario = $data['usuario'];  
            $ramal = $data['ramal'];  
            $duracao = $data['duracao'];  
            $nome_gravacao = $data['nome_gravacao'];  
            $bdbanco = $modulo_boleto->bdbanco;
            $bduser = $modulo_boleto->bduser;
            $bdpass = $modulo_boleto->bdpass;
          
            try{
              $dsn = $bdbanco;
              $dbuser = $bduser;
              $dbpass = $bdpass;   
              $pdo = new PDO($dsn, $dbuser, $dbpass);
              }catch(PDOException $e){
                  die($e->getMessage());  
              }     

            $tem = $pdo->query("SELECT * FROM callcenter_gravagravacoes WHERE calldate = '$calldate' AND usuario = '$usuario' AND ramal = '$ramal'");
            $result = $tem->fetch();
        
            if(!empty($result)){
        
            }else{
              $sql = $pdo->query("INSERT INTO callcenter_gravagravacoes SET calldate = '$calldate', usuario = '$usuario', ramal = '$ramal', duracao = '$duracao', nome_gravacao = '$nome_gravacao'"); 
              $sql->execute();
            }
          };
   };

    
    $this->loadTemplate('callcenter/callcenter_gravacoes', $this->arr);
  }//function index 

public function ramais_listar() {   
  $this->arr['list_js'] = array(
  'plugins/sweetalert2',
  'system'
  );  
  $this->arr['lista_status'] = (new Orm('callcenter_status'))->select('*')->wherecustom("codigo != 1")->order(['codigo asc'])->get();
  $tab = new Orm('callcenter_ramaisativar');
  $this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
  $this->arr['lista'] = $tab->select('*')->get();
   
  
  $this->loadTemplate('callcenter/ramais_listar', $this->arr);
  }//function index 

public function campanha_consultar($campanha) {   
  $this->arr['list_js'] = array(
  'plugins/sweetalert2',
  'system'
  );  
  $modulo_boleto = $this->permissao->getPermissoesBoleto();

  $bdbanco = $modulo_boleto->bdbanco;
  $bduser = $modulo_boleto->bduser;
  $bdpass = $modulo_boleto->bdpass;

  try{
    /*$dsn = "mysql:dbname=crm;host=localhost";
    $dbuser = "root";
    $dbpass = "123456";*/
    //$dsn = "mysql:dbname=unixs958_crmapaepiracicaba;host=localhost";
    //$dbuser = "unixs958_apaepiracicaba";
    //$dbpass = "n1jo7%rZ=PwD";
    $dsn = $bdbanco;
    $dbuser = $bduser;
    $dbpass = $bdpass;   
    $pdo = new PDO($dsn, $dbuser, $dbpass);
    }catch(PDOException $e){
        die($e->getMessage());  
    }
  
    $tem = $pdo->query("SELECT * FROM clientes");
    $result = $tem->fetch();
    //echo '<pre>';
    //print_r($result);
    $chave = $result['callcenter_chave'];

// API URL
$url = 'https://app.voxfree.com/crm/clique/consultMailing.php';
$data = [
    'chave' => $chave,
    'campanha' => $campanha
];
$payload = json_encode($data);

//print_r($payload);
//exit;

$curl = curl_init();
curl_setopt_array($curl, [
  CURLOPT_URL => $url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POSTFIELDS=>$payload,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "POST",
  CURLOPT_HTTPHEADER => [    
    "accept: application/json"
  ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);


$result = array();
$data = json_decode($response, TRUE);

/*echo "<pre>";
print_r($data);
echo "<hr>";
print_r($response);
exit;*/
$NomeMailing = '';
$totalClientes = '';
$ClientesNaoDiscados = '';
$ClientesDiscados = '';
$ClientesFinalizados = '';
$TotalNumeros = '';
$NumerosNaoDiscados = '';
$NumerosDicados = '';
$NumerosFinalizados = '';

if(isset($data[0]['Status'])){
echo 'Sem mailing(s) ativo(s)';
exit;
}else{
//  print_r($data).'<br>';
//  echo $data[0]['NomeMailing'];
//  exit;
    
    $NomeMailing = $data[0]['NomeMailing'];
    $totalClientes = $data[0]['totalClientes'];  
    $ClientesNaoDiscados = $data[0]['ClientesNaoDiscados'];  
    $ClientesDiscados = $data[0]['ClientesDiscados'];  
    $ClientesFinalizados = $data[0]['ClientesFinalizados'];  
    $TotalNumeros = $data[0]['TotalNumeros'];  
    $NumerosNaoDiscados = $data[0]['NumerosNaoDiscados'];  
    $NumerosDiscados = $data[0]['NumerosDiscados'];  
    $NumerosFinalizados = $data[0]['NumerosFinalizados'];  
    
    $tem = $pdo->query("SELECT * FROM callcenter_campanhas_resumo WHERE id_campanha = '$campanha'");
    $result = $tem->fetch();

    if(!empty($result)){
      $sql = $pdo->query("UPDATE callcenter_campanhas_resumo SET id_campanha = '$campanha', NomeMailing = '$NomeMailing', totalClientes = '$totalClientes', ClientesNaoDiscados = '$ClientesNaoDiscados', ClientesDiscados = '$ClientesDiscados', ClientesFinalizados = '$ClientesFinalizados', TotalNumeros = '$TotalNumeros', NumerosNaoDiscados = '$NumerosNaoDiscados', NumerosDiscados = '$NumerosDiscados', NumerosFinalizados = '$NumerosFinalizados' WHERE id_campanha = '$campanha'"); 
      $sql->execute();

    }else{
      $sql = $pdo->query("INSERT INTO callcenter_campanhas_resumo SET id_campanha = '$campanha', NomeMailing = '$NomeMailing', totalClientes = '$totalClientes', ClientesNaoDiscados = '$ClientesNaoDiscados', ClientesDiscados = '$ClientesDiscados', ClientesFinalizados = '$ClientesFinalizados', TotalNumeros = '$TotalNumeros', NumerosNaoDiscados = '$NumerosNaoDiscados', NumerosDiscados = '$NumerosDicados', NumerosFinalizados = '$NumerosFinalizados'"); 
      $sql->execute();
    }
};
 
curl_close($curl);
echo "<script type=\"text/javascript\"> window.location='../campanha_consultar_resumo';</script>";
//echo 'deu certo';
exit;
}//function campanha_listar 

public function fazligacao() {   
  $this->arr['list_js'] = array(
  'plugins/sweetalert2',
  'system'
  );  
  $modulo_boleto = $this->permissao->getPermissoesBoleto();

  $bdbanco = $modulo_boleto->bdbanco;
  $bduser = $modulo_boleto->bduser;
  $bdpass = $modulo_boleto->bdpass;
  $callcenter_equipe = $modulo_boleto->callcenter_equipe;

  try{
    /*$dsn = "mysql:dbname=crm;host=localhost";
    $dbuser = "root";
    $dbpass = "123456";*/
    //$dsn = "mysql:dbname=unixs958_crmapaepiracicaba;host=localhost";
    //$dbuser = "unixs958_apaepiracicaba";
    //$dbpass = "n1jo7%rZ=PwD";
    $dsn = $bdbanco;
    $dbuser = $bduser;
    $dbpass = $bdpass;   
    $pdo = new PDO($dsn, $dbuser, $dbpass);
    }catch(PDOException $e){
        die($e->getMessage());  
    }

  $tem = $pdo->query("SELECT * FROM clientes");
  $result = $tem->fetch();
  //echo '<pre>';
  //print_r($result);
  $id_usuario = $this->user->getId();
  $temn = $pdo->query("SELECT * FROM usuarios WHERE id_usuario ='$id_usuario'");
  $resultn = $temn->fetch();
  
  $temnn = $pdo->query("SELECT * FROM callcenter_campanhas");
  $resultnn = $temnn->fetchall();
    $campa = '';
  foreach($resultnn as $camp){
    $campa = $camp['id_campanha'].'|';
  }
    
    //echo $campanhas;
    //exit;
  $campanhas = substr($campa, 0, -1);    
  $chave = $result['callcenter_chave'];
  $idCRM = $result['callcenter_idCRM'];
  $ramal = $resultn['ramal'];
  $destino = $_POST['tel1'];

  $url = 'https://app.voxfree.com/crm/clique/webagent.php';
  $data = [
    'chave' => $chave,
    'codigoStatus' => 1,
    'equipe' => $callcenter_equipe,
    'nomeRamal' => $ramal,
    'ramal' => $ramal];  
  $payload = json_encode($data);
  $curl = curl_init();
  curl_setopt_array($curl, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POSTFIELDS=>$payload,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_HTTPHEADER => [    
      "accept: application/json"
    ],
  ]);
  $response = curl_exec($curl);
  $err = curl_error($curl);  
  curl_close($curl);

// API URL
$url = 'https://app.voxfree.com/crm/clique/webcall_dial.php';
$data = [
    'chave' => $chave,
    'ramal' => $ramal,
    'destino' => $destino,
    'IdCRM' => $idCRM
];
$payload = json_encode($data);
//print_r($payload );
//exit;

$curl = curl_init();
curl_setopt_array($curl, [
  CURLOPT_URL => $url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POSTFIELDS=>$payload,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "POST",
  CURLOPT_HTTPHEADER => [    
    "accept: application/json"
  ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);

/*
echo "<pre>";
print_r($response);
echo "<hr>";
print_r($err);
exit;*/

curl_close($curl);




}//function campanha_consultar_resumo  

public function campanha_consultar_resumo() {   
  $this->arr['list_js'] = array(
  'plugins/sweetalert2',
  'system'
  );  
//echo 'aqui';
//exit;
  $tab = new Orm('callcenter_campanhas_resumo');
  $this->arr['lista'] = $tab->select('*')->get();
  
  $this->loadTemplate('callcenter/campanha_consultar', $this->arr);
}//function campanha_consultar_resumo  

public function campanha_consultar_detalhe($campanha) {   
    $this->arr['list_js'] = array(
    'plugins/sweetalert2',
    'system'
    );  
    $modulo_boleto = $this->permissao->getPermissoesBoleto();

    $bdbanco = $modulo_boleto->bdbanco;
    $bduser = $modulo_boleto->bduser;
    $bdpass = $modulo_boleto->bdpass;

    try{
      /*$dsn = "mysql:dbname=crm;host=localhost";
      $dbuser = "root";
      $dbpass = "123456";*/
      //$dsn = "mysql:dbname=unixs958_crmapaepiracicaba;host=localhost";
      //$dbuser = "unixs958_apaepiracicaba";
      //$dbpass = "n1jo7%rZ=PwD";
      $dsn = $bdbanco;
      $dbuser = $bduser;
      $dbpass = $bdpass;      
      $pdo = new PDO($dsn, $dbuser, $dbpass);
      }catch(PDOException $e){
          die($e->getMessage());  
      }
    
      $tem = $pdo->query("SELECT * FROM clientes");
      $result = $tem->fetch();
      //echo '<pre>';
      //print_r($result);
      $chave = $result['callcenter_chave'];

      $callcenter = new Callcenter();
      $nome = $callcenter->pegaretorno($campanha);
    //  echo '<pre>';
    //  echo 'nome';
    //  print_r($nome);
    //  exit;
//      $nomeresult = $nome->fetchall();
//if(isset($nome) && !empty($nome)){
      //print_r($nome);
      //exit;
    
// API URL
foreach($nome as $n) {
$url = 'https://app.voxfree.com/crm/clique/retornoMailing.php';
$data = [
    'chave' => $chave,
    'campanha' => $campanha,
    'NomeMailing' => $n->NomeMailing
];
$payload = json_encode($data);
//print_r($payload );
//exit;
$curl = curl_init();
curl_setopt_array($curl, [
  CURLOPT_URL => $url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POSTFIELDS=>$payload,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "POST",
  CURLOPT_HTTPHEADER => [    
    "accept: application/json"
  ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);
$datar = json_decode($response, TRUE);
if(isset($datar) && !empty($datar)){

//echo "<pre>";
//print_r($datar);
//echo "<hr>";
//print_r($response);
//exit;
/*$nome = '';
$tokenCliente = '';
$idCRM = '';  
$numero = '';  
$datan = '';
$resultado = '';*/

if(isset($datar[0]['nome'])){
$nome = $datar[0]['nome'];
$tokenCliente = $datar[0]['tokenCliente'];  
$idCRM = $datar[0]['idCRM'];  
$numero = $datar[0]['numero'];  
$datan = $datar[0]['data']; 
$resultado = $datar[0]['resultado']; 
};

$callcenter = new Callcenter();
$gravadetalhe = $callcenter->gravadetalhe($campanha,$n->NomeMailing,$nome,$tokenCliente,$idCRM,$numero,$datan,$resultado);
};
}
//print_r($datar);
//echo $datan;
//exit;
curl_close($curl);
echo "<script type=\"text/javascript\"> window.location='../campanha_gravadetalhe';</script>";
exit;
}//function campanha_listar 

public function campanha_gravadetalhe() {   
  $this->arr['list_js'] = array(
  'plugins/sweetalert2',
  'system'
  );  
//echo 'aqui';
//exit;
  $tab = new Orm('callcenter_gravadetalhe');
 // $this->arr['lista'] = $tab->select('*')->where(['id_campanha', $campanha])->order(['datan desc'])->get();
 $this->arr['lista'] = $tab->select('*')->order(['datan desc'])->get();
  
  $this->loadTemplate('callcenter/campanha_gravadetalhe', $this->arr);
}//function campanha_listar 


public function campanha_excluir($campanha,$NomeMailing) {   
    $this->arr['list_js'] = array(
    'plugins/sweetalert2',
    'system'
    );  
    $modulo_boleto = $this->permissao->getPermissoesBoleto();

    $bdbanco = $modulo_boleto->bdbanco;
    $bduser = $modulo_boleto->bduser;
    $bdpass = $modulo_boleto->bdpass;

    try{
      /*$dsn = "mysql:dbname=crm;host=localhost";
      $dbuser = "root";
      $dbpass = "123456";*/
      //$dsn = "mysql:dbname=unixs958_crmapaepiracicaba;host=localhost";
      //$dbuser = "unixs958_apaepiracicaba";
      //$dbpass = "n1jo7%rZ=PwD";
      $dsn = $bdbanco;
      $dbuser = $bduser;
      $dbpass = $bdpass;   
      $pdo = new PDO($dsn, $dbuser, $dbpass);
      }catch(PDOException $e){
          die($e->getMessage());  
      }
    
      $tem = $pdo->query("SELECT * FROM clientes");
      $result = $tem->fetch();
      //echo '<pre>';
      //print_r($result);
      $chave = $result['callcenter_chave'];

// API URL
$url = 'https://app.voxfree.com/crm/clique/limpaMaling.php';
$data = [
    'chave' => $chave,
    'campanha' => $campanha,
    'NomeMailing' => $NomeMailing.'.csv',
];
$payload = json_encode($data);

//print_r($payload);
//exit;

$curl = curl_init();
curl_setopt_array($curl, [
  CURLOPT_URL => $url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POSTFIELDS=>$payload,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "POST",
  CURLOPT_HTTPHEADER => [    
    "accept: application/json"
  ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);
/*curl_close($curl);
echo "<pre>";
print_r($response);
echo "<hr>";
print_r($err);
exit;*/
curl_close($curl);
echo "<script type=\"text/javascript\"> window.location='../../campanha_listar';</script>";
exit;
  //  $this->loadTemplate('callcenter/campanha_listar', $this->arr);
  }//function campanha_excluir 

public function campanha_listar() {   
  $this->arr['list_js'] = array(
  'plugins/sweetalert2',
  'system'
  );  

  $tab = new Orm('callcenter_campanhas');
  $this->arr['lista'] = $tab->select('*')->get();
  
  $this->loadTemplate('callcenter/campanha_listar', $this->arr);
  }//function campanha_listar  

  public function discadorsave() {   
    $this->arr['list_js'] = array(
    'plugins/sweetalert2',
    'system'
    );  
    $modulo_boleto = $this->permissao->getPermissoesBoleto();
    $chave = $modulo_boleto->callcenter_chave;
    $IdCRM = $modulo_boleto->callcenter_idCRM;
    $tokenCliente = $modulo_boleto->callcenter_tokenCliente;
    $callcenter_equipe = $modulo_boleto->callcenter_equipe;

    $campanha = $_POST['id_campanha'];
    $tipo_disparo = $_POST['tipo_disparo'];
    $qtde_final = $_POST['qtde_final'];
    $qtde_inicial = $_POST['qtde_inicial'];
    $NomeMailing = $_POST['identificacao'].'.csv';
    $registro = array();
    $id_usuario = $this->user->getId();
   // echo $id_usuario;
   // exit;
    $callcenter = new Callcenter();
    $ativarramais = $callcenter->ativarramais();
    $callcenter->geradiscador($id_usuario,$campanha,$tipo_disparo,$qtde_inicial,$qtde_final,$NomeMailing);
    /*
    foreach($ativarramais as $atramais){
      //echo $chave.'<br>';
      //echo $callcenter_equipe.'<br>';
      //echo $atramais->ramal.'<br>';
      //echo $atramais->ramal.'<br>';
      //exit;
    $url = 'https://app.voxfree.com/crm/clique/webagent.php';
    $data = [
      'chave' => $chave,
      'codigoStatus' => 1,
      'equipe' =>  $callcenter_equipe,
      'nomeRamal' => $atramais->ramal,
      'ramal' => $atramais->ramal];  
    $payload = json_encode($data);
    $curl = curl_init();
    curl_setopt_array($curl, [
      CURLOPT_URL => $url,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_POSTFIELDS=>$payload,
      CURLOPT_ENCODING => "",
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 30,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => "POST",
      CURLOPT_HTTPHEADER => [    
        "accept: application/json"
      ],
    ]);
    $response = curl_exec($curl);
    $err = curl_error($curl);  
    curl_close($curl);

    };*/


    $callcenter = new Callcenter();
    $geranumeros = $callcenter->geranumeros($tipo_disparo,$qtde_final);
    //print_r($geranumeros);
    //exit;
    foreach($geranumeros as $gera){
    $registro[] = [
      "nome"=> $gera->nome,
      'IdCRM'=> $IdCRM,
      'tokenCliente'=> $tokenCliente,
      'tel1'=> $gera->telefone
    ];
     $callcenter->atualizaultimadata($gera->id);
    }

   //print_r($registro);
   // exit;
        
$tab = new Orm('callcenter_campanhas');
$this->arr['lista'] = $tab->select('*')->get();
    
$url = 'https://app.voxfree.com/crm/clique/importMailing.php';
$data = [
    'chave' => $chave,
    'campanha' => $campanha,
    'NomeMailing' => $NomeMailing,
    "registros"=>$registro];

$payload = json_encode($data);
//echo $payload;
//exit;

$curl = curl_init();
curl_setopt_array($curl, [
  CURLOPT_URL => $url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POSTFIELDS=>$payload,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "POST",
  CURLOPT_HTTPHEADER => [    
    "accept: application/json"
  ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);
/*
echo "response <pre>";
print_r($response);
echo "<hr>";
echo "error <pre>";
print_r($err);
exit;
*/
curl_close($curl);
    
    /*}else{
    $this->arr['lista'] = $tab->select('*')->paginate('10')->get();
    $this->arr['paginacao'] = $tab->render("motivo");
    }*/

    //$this->arr['idcampanha'] = $id_campanha;
    echo "<script type=\"text/javascript\"> window.location='campanha_listar';</script>";
    //$this->loadTemplate('callcenter/campanha_listar');
    }//function discadorsave 

  public function campanha_discador($id_campanha) {   
    $this->arr['list_js'] = array(
    'plugins/sweetalert2',
    'system'
    );  
    /*
    
    $this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
    
    if(isset($_GET['nome']) && !empty($_GET['nome'])){
    $nome = addslashes($_GET['nome']);*/
    //$tab = new Orm('callcenter_campanhas');
    //$this->arr['lista'] = $tab->select('*')->get();
    /*}else{
    $this->arr['lista'] = $tab->select('*')->paginate('10')->get();
    $this->arr['paginacao'] = $tab->render("motivo");
    }*/
    $this->arr['idcampanha'] = $id_campanha;
    
    $this->loadTemplate('callcenter/campanha_discador', $this->arr);
    }//function campanha_discador 

public function add(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'preview_imagem',
'uploadImage',
'functions_js',
'plugins/sweetalert2',
'system'
);


$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('motivo/adicionar', $this->arr);
}//add


public function edit($id){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'preview_imagem',
'uploadImage',
);

$this->arr['id_motivo'] = $id;
$this->arr['info'] = (new Orm('motivo'))->select('*')->where(['id_motivo', $id])
->first()->get();



$this->loadTemplate('motivo/editar', $this->arr);
}//edit

public function edit_action(){

  $this->arr['list_js'] = array(
    'plugins/jquery.mask.min',
    'plugins/parsley/parsley.min',
    'plugins/parsley/pt-br',
    'mask_init',
    'preview_imagem',
    'uploadImage',
    );
      
  $funil = new Funil();
  $up = new Motivo();
  $id = $_POST['id_funil'];
  $nome = $_POST['nome_funil'];

  $funil->edit_action($id,$nome);
  $del = $up->delsubmotivo($id);
//print_r($_POST['motivo']);
//exit;
if(isset($_POST['motivo']) && !empty($_POST['motivo'])){ 
  foreach($_POST['motivo'] as $mot){
  $gravamot = $up->addsubmotivo($id,$mot);

  }

}
$_SESSION['msg'] = array('type'=>'success', 'msg'=>'Funil Editado com sucesso!');
header("Location:".BASE_URL."funil");
exit;

}

public function save(){

if(isset($_POST['nome']) && !empty($_POST['nome'])){
 $id_motivo   = (isset($_POST['id_motivo'])) ? $this->limpaCampo($_POST['id_motivo']) : NULL; 
 $nome            = $this->limpaCampo($_POST['nome']);

 
$consulta = (new Orm('motivo'))->select('*')->where(['nome_motivo', $nome])->first()->get();

if(!empty($consulta)){
  $_SESSION['msg'] = array('type'=>'error', 'msg'=>'Ooppss, ja existe cadastro com esse número ou nome no sistema, por favor tente novamente!!!');
  header("Location:".BASE_URL."motivo");
  exit;  
}

$dados_form = [
'nome_motivo'=>$nome
];

if($id_motivo == null){
 $grv = (new Orm('motivo'))->set($dados_form)->save();
 $_SESSION['msg'] = array('type'=>'success', 'msg'=>'Motivo cadastrado com sucesso!');
 $this->redirect(BASE_URL."motivo"); 
}else{
 $grv = (new Orm('motivo'))->set($dados_form)->where(['id_motivo', $id_motivo])->update();
 $_SESSION['msg'] = array('type'=>'success', 'msg'=>'Motivo Editado com sucesso!');
 header("Location:".BASE_URL."motivo");
 exit;
}

}

}//save

public function remover($id){
$del = (new Orm('motivo'))->del(['id_origem', $id]);
$_SESSION['msg'] = array('type'=>'success', 'msg'=>'Motivo removido com sucesso!');
$this->redirect(BASE_URL."motivo");
}//remover

}