<?php
use Core\Controller;
use Models\Users;
use Models\Permissao;
use Models\Orm;
use Models\Validate;

class ClientesController extends controller {

  private $user;
  private $arr;
  private $permissao;

    public function __construct() {              
        $this->user = new Users();
        $this->permissao = new Permissao(); 

        if($this->user->isLogged() == false){                  
         header("Location: ".BASE_URL."login");        
         exit;         
        }
      
        $permissoes = $this->permissao->getPermissoes();
        $modulo_boleto = $this->permissao->getPermissoesBoleto();
        
         $this->arr = array(
          'user'=>$this->user,
          'menuActive'=>'home',
          'permissao'=>$permissoes,
          'modulo_boleto'=>$modulo_boleto
         );          
}

public function index() {
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'mask_init',
'plugins/sweetalert2',
'system'
);     

$tab = new Orm('clientes');
$this->arr['lista'] = $tab->select('*')->paginate('10')->get();
$this->arr['paginacao'] = $tab->render('clientes');

if(isset($_POST['nome']) && !empty($_POST['nome'])){

$campo = addslashes(trim($_POST['nome']));
$this->arr['lista'] = (new Orm('clientes'))->select('*')
->search(['nome', $campo])->get();
}


 
$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('clientes/listar', $this->arr);
}//index


public function add(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'mask_init',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'flatpickr/flatpickr',
'flatpickr/pt',
'flatpickr/flatpickr_init'
);   
  

$this->loadTemplate('clientes/adicionar', $this->arr);
}//add


public function edit($id){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'mask_init',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'flatpickr/flatpickr',
'flatpickr/pt',
'flatpickr/flatpickr_init'
);   

$this->arr['info'] = (new Orm('clientes'))->select('*')->where(['id_cliente', $id])->first()->get();  
$this->arr['id_cliente'] = $id;
$this->loadTemplate('clientes/editar', $this->arr);
}//edit

public function save(){
$validator = new Validate();
if(isset($_POST['nome']) && !empty($_POST['razao_social'])){

$validate = $validator->validate([
'id_cliente'=>'null',
'nome'=>'required',
'razao_social'=>'null',
'website'=>'required',
'cnpj'=>'required',
'email_franqueado'=>'required',
'franqueado'=>'null',
'email'=>'required',
'senha'=>'required',
'webhook_zapier'=>'required',
'leads_mensais'=>'required',
'vencimento'=>'required|data',
'id_dep_livechat'=>'required',
'email_leads'=>'required',
'tempo_espera'=>'required',
'media_visitantes'=>'required',
'descricao'=>'required',
'horario_atendimento'=>'required',
'descricao_cliente'=>'required'
],true);

//se nao esta valido os campos
if(!$validate){
$_SESSION['msg'] = ['type'=>'error','msg'=>'Ooops... Alguns campos estão inválidos, tente novamente'];
 unset($_SESSION['flash']);
 unset($_SESSION['old']);
 header("Location:".BASE_URL."clientes/add");
 exit;   
}

if($validate['id_cliente'] == null){
  $grava = (new Orm('clientes'))->set($validate)->save(); 
  $_SESSION['msg'] = ['type'=>'success','msg'=>'Cliente cadastrado com sucesso!'];
  header("Location:".BASE_URL."clientes");
  exit;

}else{
 $grava = (new Orm('clientes'))->set($validate)->where(['id_cliente', $validate['id_cliente']])->update();  
 $_SESSION['msg'] = ['type'=>'alert','msg'=>'Oopsss... erro ao cadastrar cliente'];
  header("Location:".BASE_URL."clientes/add");
  exit;   
}

}else{
header("Location:".BASE_URL."clientes/add");
exit;
}

}//save



public function edit_action($id){
$validator = new Validate();


if(isset($_POST['nome']) && !empty($_POST['razao_social'])){

$validate = $validator->validate([
'id_cliente'=>'null',
'nome'=>'required',
'razao_social'=>'null',
'website'=>'required',
'cnpj'=>'required',
'email_franqueado'=>'required',
'franqueado'=>'null',
'email'=>'required',
'senha'=>'senha:clientes-id_cliente-'.$id,
'webhook_zapier'=>'required',
'leads_mensais'=>'required',
'vencimento'=>'required|data',
'id_dep_livechat'=>'required',
'email_leads'=>'required',
'tempo_espera'=>'required',
'media_visitantes'=>'required',
'descricao'=>'required',
'horario_atendimento'=>'required',
'descricao_cliente'=>'required'
],true);

//se nao esta valido os campos
if(!$validate){
$_SESSION['msg'] = ['type'=>'error','msg'=>'Ooops... Alguns campos estão inválidos, tente novamente'];
 unset($_SESSION['flash']);
 unset($_SESSION['old']);
 header("Location:".BASE_URL."clientes/edit/".$id);
 exit;   
}

 $grava = (new Orm('clientes'))->set($validate)->where(['id_cliente', $validate['id_cliente']])->update();  
 $_SESSION['msg'] = ['type'=>'success','msg'=>'Cliente atualizado com sucesso!'];
  header("Location:".BASE_URL."clientes");
  exit;   


}else{
header("Location:".BASE_URL."clientes/edit/".$id);
exit;
}
}//edit_action



public function del($id){

if(isset($id) && intval($id)){
$qr = new Orm('clientes');
$deletar = $qr->del(['id_cliente', $id]);

$_SESSION['msg'] = ['type'=>'success','msg'=>'Registro removido com sucesso!'];
$this->redirect(BASE_URL."clientes");
}
}//del

}