<?php
use Core\Controller;
use Models\Users;
use Models\Permissao;
use Models\Orm;
use Models\Validate;

class FaqController extends Controller {

	private $user;
  private $arr;
  private $permissao;

    public function __construct() {              
        $this->user = new Users();
        $this->permissao = new Permissao(); 

        if($this->user->isLogged() == false){                  
         header("Location: ".BASE_URL."login");        
         exit;         
        }
           
       $permissoes = $this->permissao->getPermissoes();

        $this->arr = array(
         'user'=>$this->user,
         'menuActive'=>'Faq',
         'permissao'=>$permissoes             
        );          
}

public function index() {
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'mask_init',
'plugins/sweetalert2',
'system'
);

$tab = new Orm('faq');
//Filtrando pesquisas
if(isset($_GET['nome']) && !empty($_GET['nome'])){

}else{
$this->arr['lista'] = $tab->select('*')->paginate('10')->get();
$this->arr['paginacao']  = $tab->render('faq'); 
}

$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('faq/listar', $this->arr);
}//function index   



public function add(){
$this->arr['list_js'] = array(
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'plugins/jquery.mask.min',
'mask_init',
'plugins/sweetalert2'
);    


$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('faq/adicionar', $this->arr);
}//add



public function add_action(){
$validator = new Validate();  
$tab = new Orm('afq');

if(isset($_POST['pergunta']) && !empty($_POST['tipo'])){ 

$validate = $validator->validate([
'id_faq'=>'null',
'tipo'=>'required',
'pergunta'=>'required',
'resposta'=>'required'
],true);


if(!$validate){
$_SESSION['msg'] = ['type'=>'error','msg'=>'Ooops... Alguns campos estão inválidos, tente novamente'];
 unset($_SESSION['flash']);
 unset($_SESSION['old']);
 header("Location:".BASE_URL."faq/add");
 exit;   
}

$grava = (new Orm('faq'))->set($validate)->save();
if($grava){
$_SESSION['msg'] = ['type'=>'success', 'msg'=>"Faq cadastrado com sucesso!"];
header("Location: ".BASE_URL."faq");
exit;
}else{
$_SESSION['msg'] = ['type'=>'error', 'msg'=>"Oopss, erro ao cadastrar plano"];
header("Location: ".BASE_URL."faq/add");
exit;
}

}
}//add action


public function edit($id){
$this->arr['list_js'] = array(
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'plugins/jquery.mask.min',
'mask_init',
'plugins/sweetalert2',
'system'
);  


$tab = new Orm('faq');
$this->arr['info'] = $tab->select('*')->where(['id_faq', $id])->first()->get();
$this->arr['id_faq'] = $id;

$this->loadTemplate('faq/editar', $this->arr);
}//edit


public function edit_action($id){
$validator = new Validate();  
$tab = new Orm('faq');

if(isset($_POST['pergunta']) && !empty($_POST['tipo'])){ 

$validate = $validator->validate([
'id_faq'=>'null',
'tipo'=>'required',
'pergunta'=>'required',
'resposta'=>'required'
],true);

if(!$validate){
$_SESSION['msg'] = ['type'=>'error','msg'=>'Ooops... Alguns campos estão inválidos, tente novamente'];
 unset($_SESSION['flash']);
 unset($_SESSION['old']);
 header("Location:".BASE_URL."faq/edit/".$id);
 exit;   
}

$grava = (new Orm('faq'))->set($validate)->where(['id_faq', $validate['id_faq']])->update();
$_SESSION['msg'] = ['type'=>'success', 'msg'=>"Faq atualizado com sucesso!"];
header("Location: ".BASE_URL."faq");
exit;
}
}//edit action


public function del($id){ 
$tab = new Orm('faq');
$tab->del(['id_faq', $id]); 
       
$_SESSION['msg'] = ['type'=>'success', 'msg'=>"Removido com sucesso!"];
header("Location: ".BASE_URL."faq");
exit;
}//del

}