<?php
use Core\Controller;
use Models\Users;
use Models\Permissao;
use Models\Orm;
use Models\Validate;
use Models\Leads;
use Models\ReportLead;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\IOFactory;

class FunilController extends Controller {

  private $user;
  private $arr;
  private $permissao;

    public function __construct() {              
        $this->user = new Users();
        $this->permissao = new Permissao(); 

        if($this->user->isLogged() == false){                  
         header("Location: ".BASE_URL."login");        
         exit;         
        }
          
        $permissoes = $this->permissao->getPermissoes();
        $modulo_boleto = $this->permissao->getPermissoesBoleto();
        
         $this->arr = array(
          'user'=>$this->user,
          'menuActive'=>'home',
          'permissao'=>$permissoes,
          'modulo_boleto'=>$modulo_boleto
         );         
}

public function index() {   
$this->arr['list_js'] = array(
'plugins/sweetalert2',
'system',
'plugins/sortable.min'
);  

$tab = new Orm('funil');

if(isset($_GET['nome']) && !empty($_GET['nome'])){
$nome = addslashes($_GET['nome']);
$this->arr['lista'] = $tab->select('*')->search(['nome_funil', $nome])
->order(['nome_funil asc'])
->get();
//print_r($this->arr['lista']);
//exit;
foreach($this->arr['lista'] as $key=>$item){
$this->arr['lista'][$key]->itens = (new Orm('leads'))->select('*')
->where(['funil_id', $item->id_funil])->get();
}

}else{

$this->arr['lista'] = $tab->select('*')
->order(['nome_funil asc'])
->get();
//print_r($this->arr['lista']);
//exit;
foreach($this->arr['lista'] as $key=>$item){
$this->arr['lista'][$key]->itens = (new Orm('leads'))->select('*')
->where(['funil_id', $item->id_funil])->get();
}
}

$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
//echo 'aqui';
//exit;
$this->loadTemplate('funil/listar', $this->arr);
}//function index  


public function dashboard(){

$hoje = date('Y-m-d');
$id_usuario = $this->user->getId();
$this->arr['usuario_logado'] = $this->user->getId();
switch($this->user->getTipo()){
case 'Super Admin':
$this->arr['tarefas_hoje'] = (new Orm('leads_comentarios'))
->select(['leads_comentarios.*, usuarios.nome, leads.nome as nome_lead, leads.telefone, leads.para'])
->join(['usuarios'],['leads'])
->on(
  ['leads_comentarios.id_user','=','usuarios.id_usuario'],
['leads_comentarios.id_lead','=','leads.id_lead'])
->wherecustom("data_agendamento = '$hoje' AND finalizado = 'N' AND leads_comentarios.tipo != 'comentario'")
->order(['hora_agendamento asc'])
->get();

$this->arr['tarefas_atrasadas'] = (new Orm('leads_comentarios'))
->select(['leads_comentarios.*, usuarios.nome, leads.nome as nome_lead, leads.telefone, leads.para'])
->join(['usuarios'],['leads'])
->on(['leads_comentarios.id_user','=','usuarios.id_usuario'],['leads_comentarios.id_lead','=','leads.id_lead'])
->wherecustom("data_agendamento < '$hoje' AND finalizado = 'N' AND leads_comentarios.tipo != 'comentario'")
->order(['hora_agendamento asc'])
->get();
break;

case 'Produtor':
$this->arr['tarefas_hoje'] = (new Orm('leads_comentarios'))
->select(['leads_comentarios.*, usuarios.nome, leads.nome as nome_lead, leads.telefone, leads.para'])
->join(['usuarios'],['leads'])
->on(
  ['leads_comentarios.id_user','=','usuarios.id_usuario'],
['leads_comentarios.id_lead','=','leads.id_lead'])->wherecustom("data_agendamento = '$hoje' AND para = $id_usuario AND finalizado = 'N' AND leads_comentarios.tipo != 'comentario'")
->order(['hora_agendamento asc'])->get();

$this->arr['tarefas_atrasadas'] = (new Orm('leads_comentarios'))
->select(['leads_comentarios.*, usuarios.nome, leads.nome as nome_lead, leads.telefone, leads.para'])
->join(['usuarios'],['leads'])
->on(['leads_comentarios.id_user','=','usuarios.id_usuario'],['leads_comentarios.id_lead','=','leads.id_lead'])
->wherecustom("data_agendamento < '$hoje' AND para = $id_usuario AND finalizado = 'N' AND leads_comentarios.tipo != 'comentario'")->order(['hora_agendamento asc'])->get();
break;
}//switch




$this->loadTemplate('funil/dashboard', $this->arr);
}//dashboard

public function getProdutor($id){
$p = (new Orm('usuarios'))->select(['nome'])->where(['id_usuario', $id])
->first()->get();


if(!empty($p)){
return $p->nome;
}

return '';
}//getProdutor


public function add(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'plugins/sweetalert2',
'system'
);


$this->loadTemplate('funil/adicionar', $this->arr);
}

public function atustatusramal_listar(){
  $this->arr['list_js'] = array(
  'plugins/jquery.mask.min',
  'plugins/parsley/parsley.min',
  'plugins/parsley/pt-br',
  'mask_init',
  'plugins/sweetalert2',
  'system'
  );
  $ramal = $_POST['ramal'];
  $equipe = $_POST['equipe'];
  $status = $_POST['status'];

  $up = (new Orm('callcenter_ramaisativar'))->set(['status'=>$status])->where(['ramal', $ramal])->update();
  $modulo_boleto = $this->permissao->getPermissoesBoleto();
  $chave = $modulo_boleto->callcenter_chave;
 // $callcenter_equipe = $modulo_boleto->callcenter_equipe;
  $callcenter_equipe = $equipe;
  $campanhas = '';


// API URL
$url = 'https://app.voxfree.com/crm/clique/webagent.php';
$data = [
    'chave' => $chave,
    'codigoStatus' => $status,
    'equipe' => $callcenter_equipe,
    'nomeRamal' => $ramal,
    'ramal' => $ramal
];
$payload = json_encode($data);

//print_r($payload);
//exit;

$curl = curl_init();
curl_setopt_array($curl, [
  CURLOPT_URL => $url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POSTFIELDS=>$payload,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "POST",
  CURLOPT_HTTPHEADER => [    
    "accept: application/json"
  ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

  
  //$this->loadTemplate('funil/editar', $this->arr);
}

public function atustatusramal(){
  $this->arr['list_js'] = array(
  'plugins/jquery.mask.min',
  'plugins/parsley/parsley.min',
  'plugins/parsley/pt-br',
  'mask_init',
  'plugins/sweetalert2',
  'system'
  );
  $ramal = $this->user->getramal();
  $status = $_POST['val'];

  $up = (new Orm('callcenter_ramaisativar'))->set(['status'=>$status])->where(['ramal', $ramal])->update();
  $modulo_boleto = $this->permissao->getPermissoesBoleto();
  $chave = $modulo_boleto->callcenter_chave;
  //$callcenter_equipe = $modulo_boleto->callcenter_equipe;
  $callcenter_equipe = $this->user->equipe();
  $campanhas = '';


// API URL
$url = 'https://app.voxfree.com/crm/clique/webagent.php';
$data = [
    'chave' => $chave,
    'codigoStatus' => $status,
    'equipe' => $callcenter_equipe,
    'nomeRamal' => $ramal,
    'ramal' => $ramal
];

$payload = json_encode($data);

//print_r($payload);
//exit;

$curl = curl_init();
curl_setopt_array($curl, [
  CURLOPT_URL => $url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POSTFIELDS=>$payload,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "POST",
  CURLOPT_HTTPHEADER => [    
    "accept: application/json"
  ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

  
  //$this->loadTemplate('funil/editar', $this->arr);
}

public function edit($id){
  $this->arr['list_js'] = array(
  'plugins/jquery.mask.min',
  'plugins/parsley/parsley.min',
  'plugins/parsley/pt-br',
  'mask_init',
  'plugins/sweetalert2',
  'system'
  );

  $this->arr['id_funil'] = $id;
  $this->arr['info'] = (new Orm('funil'))->select('*')->where(['id_funil', $id])
  ->first()->get();
  $up = new Orm('funil_motivo');
  $this->arr['infomotivos'] = $up->select('*')->order(['nome_motivo asc'])->where(['id_funil', $id])->get();

  $this->arr['motivos'] = (new Orm('motivo'))->order(['nome_motivo asc'])->select('*')->get();
  //print_r($this->arr['motivos']);
  //exit;


  
  $this->loadTemplate('funil/editar', $this->arr);
}

public function filtroapae(){
  $this->arr['list_js'] = array(
  'plugins/jquery.mask.min',
  'plugins/parsley/parsley.min',
  'plugins/parsley/pt-br',
  'mask_init',
  'plugins/sweetalert2',
  'system'
  );


  $this->arr['usuario_logado'] = $this->user->getId();
  $ramal = $this->arr['usuario_ramal'] = $this->user->getramal();
  //echo $ramal;
  //exit;
  $l = new Leads();
  $teste = $l->getCliente();
  $cliente = $teste->nome;
  $this->arr['cliente'] = $cliente;
  
  $this->arr['status_ramal'] = (new Orm('callcenter_ramaisativar'))->select('*')->where(['ramal', $ramal])->first()->get();
  $this->arr['lista_status'] = (new Orm('callcenter_status'))->select('*')->order(['codigo asc'])->get();
  $this->arr['produtores'] = (new Orm('usuarios'))->select('*')->order(['nome asc'])->where(['tipo','Produtor'])->get();
  $this->arr['produtos'] = (new Orm('produtos'))->select('*')->order(['nome_produto asc'])->get();
  
  $tab = new Orm('funil');
  $id_usuario = $this->user->getId();
  
  $this->arr['lista'] = $tab->select('*')->order(['nome_funil asc'])->get();
  $this->arr['tipo'] = $this->user->getTipo();
  $agora = date('Y-m-d');
 // echo $agora;
 // exit;
  foreach($this->arr['lista'] as $key=>$item){
  $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
  ->wherecustom("funil_id = $item->id_funil AND para = $id_usuario AND data_liberacao <= '$agora'")
  //->wherecustom("funil_id = $item->id_funil AND para = $id_usuario AND data_liberacao = '$agora' OR funil_id = '23' AND para = $id_usuario OR funil_id = '26' AND para = $id_usuario OR funil_id = '27' AND para = $id_usuario")
  ->order(['data_entrada desc'])
  ->paginate('200')->get();   
  }
  
  $this->loadTemplate('leads/funilapae', $this->arr);
}

public function filtroapaen(){
  $this->arr['list_js'] = array(
  'plugins/jquery.mask.min',
  'plugins/parsley/parsley.min',
  'plugins/parsley/pt-br',
  'mask_init',
  'plugins/sweetalert2',
  'system'
  );


  $this->arr['usuario_logado'] = $this->user->getId();
  $ramal = $this->arr['usuario_ramal'] = $this->user->getramal();
  //echo $ramal;
  //exit;
  $l = new Leads();
  $teste = $l->getCliente();
  $cliente = $teste->nome;
  $this->arr['cliente'] = $cliente;
  
  $this->arr['status_ramal'] = (new Orm('callcenter_ramaisativar'))->select('*')->where(['ramal', $ramal])->first()->get();
  $this->arr['lista_status'] = (new Orm('callcenter_status'))->select('*')->order(['codigo asc'])->get();
  $this->arr['produtores'] = (new Orm('usuarios'))->select('*')->order(['nome asc'])->where(['tipo','Produtor'])->get();
  $this->arr['produtos'] = (new Orm('produtos'))->select('*')->order(['nome_produto asc'])->get();
  
  $tab = new Orm('funil');
  $id_usuario = $this->user->getId();
  
  $this->arr['lista'] = $tab->select('*')->order(['nome_funil asc'])->get();
  $this->arr['tipo'] = $this->user->getTipo();
  $agora = date('Y-m-d');
 // echo $agora;
 // exit;
  foreach($this->arr['lista'] as $key=>$item){
  $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
  ->wherecustom("funil_id = $item->id_funil AND para = $id_usuario AND data_liberacao <= '$agora'")
  //->wherecustom("funil_id = $item->id_funil AND para = $id_usuario AND data_liberacao = '$agora' OR funil_id = '23' AND para = $id_usuario OR funil_id = '26' AND para = $id_usuario OR funil_id = '27' AND para = $id_usuario")
  ->order(['data_entrada desc'])
  ->paginate('200')->get();   
  }
  
  $this->loadTemplate('leads/funilapae', $this->arr);
}

public function filtro(){
$this->arr['list_js'] = array(
'plugins/sweetalert2',
'system',
'plugins/sortable.min'
);  
$this->arr['usuario_logado'] = $this->user->getId();
$ramal = $this->arr['usuario_ramal'] = $this->user->getramal();
//echo $ramal;
//exit;
$l = new Leads();
$teste = $l->getCliente();
$cliente = $teste->nome;
$this->arr['cliente'] = $cliente;


$this->arr['status_ramal'] = (new Orm('callcenter_ramaisativar'))->select('*')->where(['ramal', $ramal])->first()->get();
$this->arr['lista_status'] = (new Orm('callcenter_status'))->select('*')->order(['codigo asc'])->get();
$this->arr['produtores'] = (new Orm('usuarios'))->select('*')->order(['nome asc'])->where(['tipo','Produtor'])->get();
$this->arr['produtos'] = (new Orm('produtos'))->select('*')->order(['nome_produto asc'])->get();
$this->arr['origens'] = (new Orm('origem_venda'))->select('*')->order(['nome_origem asc'])->get();

$tab = new Orm('funil');
$id_usuario = $this->user->getId();

$this->arr['lista'] = $tab->select('*')->order(['nome_funil asc'])->get();
$this->arr['tipo'] = $this->user->getTipo();

if(isset($_POST['origem']) && !empty($_POST['origem']) && isset($_POST['data_inicial']) && !empty($_POST['data_inicial'])){
  $origem = $_POST['origem'];
  echo $origem;
  foreach($this->arr['lista'] as $key=>$item){
    switch($this->user->getTipo()){
      case 'Super Admin':
      $data_inicial = "'".$_POST['data_inicial'].' 00:00:01'."'";
      $data_final = "'".$_POST['data_final'].' 23:59:59'."'";

      
      echo "<script>localStorage.setItem('data_inicial', '$data_inicial');</script>";
      echo "<script>localStorage.setItem('data_final', '$data_final');</script>";

        $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
        ->wherecustom("funil_id = $item->id_funil")
        ->order(['data_entrada desc'])
        ->paginate('200')->get();        
  
      echo "<pre>";
      print_r($this->arr['lista']);
      exit;
      //echo 'aqui';
      //exit;
      break;
      
      case 'Produtor':
      if(isset($_POST['funcionario']) && !empty($_POST['funcionario'])){
      $funcionario = $_POST['funcionario'];
      $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
      ->wherecustom("funil_id = $item->id_funil AND funcionario = '$funcionario' AND para = $id_usuario AND origem = '$origem' AND data_entrada between $data_inicial and $data_final")
      ->order(['data_entrada desc'])
      ->paginate('200')->get();
      
      }else{
        $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
        ->wherecustom("funil_id = $item->id_funil AND para = $id_usuario AND origem = '$origem' AND data_entrada between $data_inicial and $data_final")
        ->order(['data_entrada desc'])
        ->paginate('200')->get();
      
      }
      break;
      }
  }

}

if(isset($_POST['produto']) && !empty($_POST['produto']) && isset($_POST['nome']) && !empty($_POST['nome']) && isset($_POST['data_inicial']) && !empty($_POST['data_inicial']) && isset($_POST['data_final']) && !empty($_POST['data_final']) && isset($_POST['dia_inicial']) && !empty($_POST['dia_inicial']) && isset($_POST['dia_final']) && !empty($_POST['dia_final'])){
  $produtor = addslashes(trim($_POST['nome']));
  $produto = $_POST['produto'];
  //echo 'aquip'.$produtor;
  //exit;
  if($_POST['dia_inicial'] > 0 && $_POST['dia_final'] > 0){
    foreach($this->arr['lista'] as $key=>$item){
      switch($this->user->getTipo()){
      case 'Super Admin':
      $data_inicial = "'".$_POST['data_inicial'].' 00:00:01'."'";
      $data_final = "'".$_POST['data_final'].' 23:59:59'."'";
      $dia_inicial = "'".$_POST['dia_inicial']."'";
      $dia_final = "'".$_POST['dia_final']."'";
      
      echo "<script>localStorage.setItem('data_inicial', '$data_inicial');</script>";
      echo "<script>localStorage.setItem('data_final', '$data_final');</script>";
      echo "<script>localStorage.setItem('dia_inicial', '$dia_inicial');</script>";
      echo "<script>localStorage.setItem('dia_final', '$dia_final');</script>";  
      //echo '<pre>';
      //echo $data_inicial.'<br>';
      //echo $data_final.'<br>';
      if(isset($_POST['funcionario']) && !empty($_POST['funcionario'])){
      $funcionario = $_POST['funcionario'];
      $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
      ->wherecustom("funil_id = $item->id_funil AND funcionario = '$funcionario' AND para = $produtor AND produto = '$produto' AND data_entrada between $data_inicial AND $data_final AND dia between $dia_inicial AND $dia_final")
      ->order(['data_entrada desc'])
      ->paginate('200')->get();
      }else{
        $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
        ->wherecustom("funil_id = $item->id_funil AND para = $produtor AND produto = '$produto' AND data_entrada between $data_inicial AND $data_final AND dia between $dia_inicial AND $dia_final")
        ->order(['data_entrada desc'])
        ->paginate('200')->get();        
      }
      //echo "<pre>";
      //print_r($this->arr['lista']);
      //exit;
      
      break;
      
      case 'Produtor':
      if(isset($_POST['funcionario']) && !empty($_POST['funcionario'])){
      $funcionario = $_POST['funcionario'];
      $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
      ->wherecustom("funil_id = $item->id_funil AND funcionario = '$funcionario' AND para = $id_usuario AND produto = '$produto' AND data_entrada between $data_inicial and $data_final AND dia between $dia_inicial and $dia_final")
      ->order(['data_entrada desc'])
      ->paginate('200')->get();
      
      }else{
        $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
        ->wherecustom("funil_id = $item->id_funil AND para = $id_usuario AND produto = '$produto' AND data_entrada between $data_inicial and $data_final AND dia between $dia_inicial and $dia_final")
        ->order(['data_entrada desc'])
        ->paginate('200')->get();
      
      }
      break;
      }
      }//foreach
  }else{
    foreach($this->arr['lista'] as $key=>$item){
      switch($this->user->getTipo()){
      case 'Super Admin':
      $data_inicial = "'".$_POST['data_inicial'].' 00:00:01'."'";
      $data_final = "'".$_POST['data_final'].' 23:59:59'."'";
      
      echo "<script>localStorage.setItem('data_inicial', '$data_inicial');</script>";
      echo "<script>localStorage.setItem('data_final', '$data_final');</script>";
      
      //echo '<pre>';
      //echo $produtor.'<br>';
      //exit;
      //echo $data_final.'<br>';
      if(isset($_POST['funcionario']) && !empty($_POST['funcionario'])){
        $funcionario = $_POST['funcionario'];      
        $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
        ->wherecustom("funil_id = $item->id_funil AND funcionario = '$funcionario' AND para = $produtor AND produto = '$produto' AND data_entrada between $data_inicial and $data_final")
        ->order(['data_entrada desc'])
        ->paginate('200')->get();
      }else{
        $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
        ->wherecustom("funil_id = $item->id_funil AND para = $produtor AND produto = '$produto' AND data_entrada between $data_inicial and $data_final")
        ->order(['data_entrada desc'])
        ->paginate('200')->get();        
      }
      //echo "<pre>";
      //print_r($this->arr['lista']);
      //exit;
      
      break;
      
      case 'Produtor':
      if(isset($_POST['funcionario']) && !empty($_POST['funcionario'])){
      $funcionario = $_POST['funcionario'];           
        $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
        ->wherecustom("funil_id = $item->id_funil AND funcionario = '$funcionario' AND para = $id_usuario AND produto = '$produto' AND data_entrada between $data_inicial and $data_final")
        ->order(['data_entrada desc'])
        ->paginate('200')->get();
      }else{
        $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
        ->wherecustom("funil_id = $item->id_funil AND para = $id_usuario AND produto = '$produto' AND data_entrada between $data_inicial and $data_final")
        ->order(['data_entrada desc'])
        ->paginate('200')->get();        
      }
      break;
      }
      }//foreach
  }
 // exit;

}

if(isset($_POST['produto']) && !empty($_POST['produto']) && isset($_POST['data_inicial']) && !empty($_POST['data_inicial']) && isset($_POST['data_final']) && !empty($_POST['data_final'])){
  
  $produto = $_POST['produto'];

  if(isset($_POST['dia_inicial']) && !empty($_POST['dia_inicial']) && isset($_POST['dia_final']) && !empty($_POST['dia_final'])){
    foreach($this->arr['lista'] as $key=>$item){
      switch($this->user->getTipo()){
      case 'Super Admin':
      $produtor = $_POST['nome'];
      $data_inicial = "'".$_POST['data_inicial'].' 00:00:01'."'";
      $data_final = "'".$_POST['data_final'].' 23:59:59'."'";
      $dia_inicial = "'".$_POST['dia_inicial']."'";
      $dia_final = "'".$_POST['dia_final']."'";
      
      echo "<script>localStorage.setItem('data_inicial', '$data_inicial');</script>";
      echo "<script>localStorage.setItem('data_final', '$data_final');</script>";
      echo "<script>localStorage.setItem('dia_inicial', '$dia_inicial');</script>";
      echo "<script>localStorage.setItem('dia_final', '$dia_final');</script>";      
      //echo '<pre>';
      //echo $data_inicial.'<br>';
      //echo $data_final.'<br>';
      if(isset($_POST['funcionario']) && !empty($_POST['funcionario'])){
        $funcionario = $_POST['funcionario'];          
      $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
      ->wherecustom("funil_id = $item->id_funil AND funcionario = '$funcionario' AND produto = '$produto' AND data_entrada between $data_inicial and $data_final AND dia between $dia_inicial and $dia_final")
      ->order(['data_entrada desc'])
      ->paginate('200')->get();
      }else{
        $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
        ->wherecustom("funil_id = $item->id_funil AND produto = '$produto' AND data_entrada between $data_inicial and $data_final AND dia between $dia_inicial and $dia_final")
        ->order(['data_entrada desc'])
        ->paginate('200')->get();

      }
      //echo "<pre>";
      //print_r($this->arr['lista']);
      //exit;
      
      break;
      
      case 'Produtor':
        $data_inicial = "'".$_POST['data_inicial'].' 00:00:01'."'";
        $data_final = "'".$_POST['data_final'].' 23:59:59'."'";
        $dia_inicial = "'".$_POST['dia_inicial']."'";
        $dia_final = "'".$_POST['dia_final']."'";
        
        echo "<script>localStorage.setItem('data_inicial', '$data_inicial');</script>";
        echo "<script>localStorage.setItem('data_final', '$data_final');</script>";
        echo "<script>localStorage.setItem('dia_inicial', '$dia_inicial');</script>";
        echo "<script>localStorage.setItem('dia_final', '$dia_final');</script>";  
      if(isset($_POST['funcionario']) && !empty($_POST['funcionario'])){
      $funcionario = $_POST['funcionario'];  
        $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
        ->wherecustom("funil_id = $item->id_funil AND funcionario = '$funcionario' AND produto = '$produto' AND para = $id_usuario AND data_entrada between $data_inicial and $data_final AND dia between $dia_inicial and $dia_final")
        ->order(['data_entrada desc'])
        ->paginate('200')->get();
      }else{
        $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
        ->wherecustom("funil_id = $item->id_funil AND produto = '$produto' AND para = $id_usuario AND data_entrada between $data_inicial and $data_final AND dia between $dia_inicial and $dia_final")
        ->order(['data_entrada desc'])
        ->paginate('200')->get();        
      }
      break;
      }
      }//foreach
  }else{
    foreach($this->arr['lista'] as $key=>$item){
      switch($this->user->getTipo()){
      case 'Super Admin':
      $data_inicial = "'".$_POST['data_inicial'].' 00:00:01'."'";
      $data_final = "'".$_POST['data_final'].' 23:59:59'."'";
      
      echo "<script>localStorage.setItem('data_inicial', '$data_inicial');</script>";
      echo "<script>localStorage.setItem('data_final', '$data_final');</script>";
      
      //echo '<pre>';
      //echo $data_inicial.'<br>';
      //echo $data_final.'<br>';
      if(isset($_POST['funcionario']) && !empty($_POST['funcionario'])){
        $funcionario = $_POST['funcionario'];       
        $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
        ->wherecustom("funil_id = $item->id_funil AND funcionario = '$funcionario' AND produto = '$produto' AND data_entrada between $data_inicial and $data_final")
        ->order(['data_entrada desc'])
        ->paginate('200')->get();
      }else{
        $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
        ->wherecustom("funil_id = $item->id_funil AND produto = '$produto' AND data_entrada between $data_inicial and $data_final")
        ->order(['data_entrada desc'])
        ->paginate('200')->get();        

      }
      
      //echo "<pre>";
      //print_r($this->arr['lista']);
      //exit;
      
      break;
      
      case 'Produtor':
        $data_inicial = "'".$_POST['data_inicial'].' 00:00:01'."'";
        $data_final = "'".$_POST['data_final'].' 23:59:59'."'";
        
        echo "<script>localStorage.setItem('data_inicial', '$data_inicial');</script>";
        echo "<script>localStorage.setItem('data_final', '$data_final');</script>";
        if(isset($_POST['funcionario']) && !empty($_POST['funcionario'])){
        $funcionario = $_POST['funcionario']; 
        $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
        ->wherecustom("funil_id = $item->id_funil AND funcionario = '$funcionario' AND para = $id_usuario AND produto = '$produto' AND data_entrada between $data_inicial and $data_final")
        ->order(['data_entrada desc'])
        ->paginate('200')->get();
        }else{
          $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
          ->wherecustom("funil_id = $item->id_funil AND para = $id_usuario AND produto = '$produto' AND data_entrada between $data_inicial and $data_final")
          ->order(['data_entrada desc'])
          ->paginate('200')->get();          
        }
      break;
      }
      }//foreach
  }
  //exit;

  
}
if(isset($_POST['produto']) && !empty($_POST['produto'])){
}else{
  if(isset($_POST['nome']) && !empty($_POST['nome']) && isset($_POST['data_inicial']) && !empty($_POST['data_inicial']) && isset($_POST['data_final']) && !empty($_POST['data_final'])){
  $produtor = addslashes(trim($_POST['nome']));
  $produto = $_POST['produto'];
  //echo $produto;
  //exit;

  foreach($this->arr['lista'] as $key=>$item){
  switch($this->user->getTipo()){
  case 'Super Admin':
  $data_inicial = "'".$_POST['data_inicial'].' 00:00:01'."'";
  $data_final = "'".$_POST['data_final'].' 23:59:59'."'";

  echo "<script>localStorage.setItem('data_inicial', '$data_inicial');</script>";
  echo "<script>localStorage.setItem('data_final', '$data_final');</script>";

  //echo '<pre>';
  //echo $data_inicial.'<br>';
  //echo $data_final.'<br>';
  if(isset($_POST['funcionario']) && !empty($_POST['funcionario'])){
    $funcionario = $_POST['funcionario'];   
  $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
  ->wherecustom("funil_id = $item->id_funil AND funcionario = '$funcionario' AND para = $produtor AND data_entrada between $data_inicial and $data_final")
  ->order(['data_entrada desc'])
  ->paginate('200')->get();
  }else{
    $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
    ->wherecustom("funil_id = $item->id_funil AND para = $produtor AND data_entrada between $data_inicial and $data_final")
    ->order(['data_entrada desc'])
    ->paginate('200')->get();    
  }
  //echo "<pre>";
  //print_r($this->arr['lista']);
  //exit;

  break;

  case 'Produtor':
    if(isset($_POST['funcionario']) && !empty($_POST['funcionario'])){
      $funcionario = $_POST['funcionario'];      
  $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
  ->wherecustom("funil_id = $item->id_funil AND funcionario = '$funcionario' AND para = $id_usuario AND data_entrada between $data_inicial and $data_final")
  ->order(['data_entrada desc'])
  ->paginate('200')->get();
    }else{
      $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
      ->wherecustom("funil_id = $item->id_funil AND produto != 'INATIVO' AND para = $id_usuario AND data_entrada between $data_inicial and $data_final")
      ->order(['data_entrada desc'])
      ->paginate('200')->get();      

    }
  break;
  }
  }//foreach

  }else{//se teve pesquisa

  //echo 'aqui';
  //exit;
  //aqui é quando n tem pesquisa

  if(isset($_POST['data_inicial']) && !empty($_POST['data_inicial']) && isset($_POST['data_final']) && !empty($_POST['data_final']) && isset($_POST['dia_inicial']) && !empty($_POST['dia_inicial']) && isset($_POST['dia_final']) && !empty($_POST['dia_final'])){
  $data_inicial = "'".$_POST['data_inicial'].' 00:00:01'."'";
  $data_final = "'".$_POST['data_final'].' 23:59:59'."'";
  $dia_inicial = "'".$_POST['dia_inicial']."'";
  $dia_final = "'".$_POST['dia_final']."'";

  $data_inicialls = "'".$_POST['data_inicial']."'";
  $data_finalls = "'".$_POST['data_final']."'";
  $dia_inicialls = "'".$_POST['dia_inicial']."'";
  $dia_finalls = "'".$_POST['dia_final']."'";  

  echo "<script>localStorage.setItem('data_inicial', $data_inicialls);</script>";
  echo "<script>localStorage.setItem('data_final', $data_finalls);</script>";
  echo "<script>localStorage.setItem('dia_inicial', $dia_inicialls);</script>";
  echo "<script>localStorage.setItem('dia_final', $dia_finalls);</script>";

    foreach($this->arr['lista'] as $key=>$item){
    switch($this->user->getTipo()){
    case 'Super Admin':
      if(isset($_POST['funcionario']) && !empty($_POST['funcionario'])){
        $funcionario = $_POST['funcionario']; 
    $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
    ->wherecustom("funil_id = $item->id_funil AND funcionario = '$funcionario' AND data_entrada between $data_inicial and $data_final AND dia between $dia_inicial and $dia_final")
    ->order(['data_entrada desc'])
    ->paginate('500')->get();
      }else{
        $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
        ->wherecustom("funil_id = $item->id_funil AND data_entrada between $data_inicial and $data_final AND dia between $dia_inicial and $dia_final")
        ->order(['data_entrada desc'])
        ->paginate('500')->get();        
      }

    break;

    case 'Produtor':
      if(isset($_POST['funcionario']) && !empty($_POST['funcionario'])){
        $funcionario = $_POST['funcionario'];       
        $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
        ->wherecustom("funil_id = $item->id_funil AND funcionario = '$funcionario' AND para = $id_usuario AND data_entrada between $data_inicial and $data_final AND dia between $dia_inicial and $dia_final")
        ->order(['data_entrada desc'])
        ->paginate('500')->get();
      }else{
        $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
        ->wherecustom("funil_id = $item->id_funil AND produto != 'INATIVO' AND para = $id_usuario AND data_entrada between $data_inicial and $data_final AND dia between $dia_inicial and $dia_final")
        ->order(['data_entrada desc'])
        ->paginate('200')->get();        
      }
    break;
    }
    }//foreach
    

  }else{
   // echo $_POST['dia_inicial'];
   // echo $_POST['dia_final'];
   // echo 'nao preecheu';
   // exit;
   if(isset($_POST['data_inicial']) && !empty($_POST['data_inicial']) && isset($_POST['data_final']) && !empty($_POST['data_final'])){
    $data_inicial = "'".$_POST['data_inicial'].' 00:00:01'."'";
    $data_final = "'".$_POST['data_final'].' 23:59:59'."'";
    
    $data_inicialls = "'".$_POST['data_inicial']."'";
    $data_finalls = "'".$_POST['data_final']."'";
    
    echo "<script>localStorage.setItem('data_inicial', $data_inicialls);</script>";
    echo "<script>localStorage.setItem('data_final', $data_finalls);</script>";

    foreach($this->arr['lista'] as $key=>$item){
    switch($this->user->getTipo()){
    case 'Super Admin':
      if(isset($_POST['funcionario']) && !empty($_POST['funcionario'])){
        //echo $_POST['funcionario'];
        //exit;
    $funcionario = $_POST['funcionario'];   
    $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
    ->wherecustom("funil_id = $item->id_funil AND funcionario = $funcionario AND data_entrada between $data_inicial and $data_final")
    ->order(['data_entrada desc'])
    ->paginate('500')->get();
       // echo '<pre>';
       // print_r($this->arr);
       // exit;

      }else{
        $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
        ->wherecustom("funil_id = $item->id_funil AND data_entrada between $data_inicial and $data_final")
        ->order(['data_entrada desc'])
        ->paginate('500')->get();        
      }
    
    break;

    case 'Produtor':
      if(isset($_POST['funcionario']) && !empty($_POST['funcionario'])){
        $funcionario = $_POST['funcionario'];       
    $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
    ->wherecustom("funil_id = $item->id_funil AND funcionario = $funcionario AND para = $id_usuario AND data_entrada between $data_inicial and $data_final")
    ->order(['data_entrada desc'])
    ->paginate('500')->get();
      }else{
        $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
        ->wherecustom("funil_id = $item->id_funil AND para = $id_usuario AND data_entrada between $data_inicial and $data_final")
        ->order(['data_entrada desc'])
        ->paginate('200')->get();        
      }
    break;
    }
    }//foreach

  }else{

    foreach($this->arr['lista'] as $key=>$item){
      switch($this->user->getTipo()){
      case 'Super Admin':
        if(isset($_POST['funcionario']) && !empty($_POST['funcionario'])){
          //echo $_POST['funcionario'];
          //exit;
      $funcionario = $_POST['funcionario'];   
      $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
      ->wherecustom("funil_id = $item->id_funil AND funcionario = $funcionario")
      ->order(['data_entrada desc'])
      ->paginate('500')->get();
         // echo '<pre>';
         // print_r($this->arr);
         // exit;
  
        }else{
          $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
          ->wherecustom("funil_id = $item->id_funil")
          ->order(['data_entrada desc'])
          ->paginate('500')->get();        
        }
      
      break;
  
      case 'Produtor':
        if(isset($_POST['funcionario']) && !empty($_POST['funcionario'])){
          $funcionario = $_POST['funcionario'];       
      $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
      ->wherecustom("funil_id = $item->id_funil AND funcionario = $funcionario AND para = $id_usuario")
      ->order(['data_entrada desc'])
      ->paginate('500')->get();
        }else{
          $this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
          ->wherecustom("funil_id = $item->id_funil AND para = $id_usuario")
          ->order(['data_entrada desc'])
          ->paginate('200')->get();        
        }
      break;
      }
      }//foreach    



  }

    }
  }//se n teve pesquisa
}
$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('leads/funil', $this->arr);

}//filtro

public function save(){
$validator = new Validate();

if(isset($_POST['nome_funil']) && !empty($_POST['nome_funil'])){

$validate = $validator->validate([
'nome_funil'=>'required'
],true);


if(!$validate){
$_SESSION['msg'] = ['type'=>'error','msg'=>'Ooops... Alguns campos estão inválidos, tente novamente'];
 unset($_SESSION['flash']);
 unset($_SESSION['old']);
 header("Location:".BASE_URL."funil");
 exit;   
}
if(isset($_POST['id_funil']) && !empty($_POST['id_funil'])){
  $id_funil = $_POST['id_funil'];
  $grv = (new Orm('funil'))->set($validate)->where(['id_funil', $id_funil])->update();
  $_SESSION['msg'] = array('type'=>'success', 'msg'=>'Funil Editado com sucesso!');
  header("Location:".BASE_URL."funil");
  exit;
}else{
  $grava = (new Orm('funil'))->set($validate)->save();
  $_SESSION['msg'] = ['type'=>'success','msg'=>'Funil cadastrado com sucesso!'];
  header("Location:".BASE_URL."funil");
  exit;  
}

}


/*
if(isset($_POST['nome']) && !empty($_POST['nome'])){
 $id_origem   = (isset($_POST['id_origem'])) ? $this->limpaCampo($_POST['id_origem']) : NULL; 
 $nome            = $this->limpaCampo($_POST['nome']);

 
$consulta = (new Orm('origem_venda'))->select('*')->where(['nome_origem', $nome])->first()->get();

if(!empty($consulta)){
  $_SESSION['msg'] = array('type'=>'error', 'msg'=>'Ooppss, ja existe cadastro com esse número ou nome no sistema, por favor tente novamente!!!');
  header("Location:".BASE_URL."origem");
  exit;  
}

$dados_form = [
'nome_origem'=>$nome
];

if($id_origem == null){
 $grv = (new Orm('origem_venda'))->set($dados_form)->save();
 $_SESSION['msg'] = array('type'=>'success', 'msg'=>'Origem cadastrada com sucesso!');
 $this->redirect(BASE_URL."origem"); 
}else{
 $grv = (new Orm('origem_venda'))->set($dados_form)->where(['id_origem', $id_origem])->update();
 $_SESSION['msg'] = array('type'=>'success', 'msg'=>'Origem Editada com sucesso!');
 header("Location:".BASE_URL."origem");
 exit;
}

*/
}//save

public function relatorio(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'plugins/sweetalert2',
'system',
'flatpickr/flatpickr',
'flatpickr/pt',
'flatpickr/flatpickr_init'
);

$l = new Leads();
$teste = $l->getCliente();
$cliente = $teste->nome;
$this->arr['cliente'] = $cliente;

$this->arr['usuario_logado'] = $this->user->getId();
$this->arr['lista'] = [];  
$this->arr['origens'] = (new Orm('origem_venda'))->select('*')->get();
$this->arr['produtos'] = (new Orm('produtos'))->select('*')->get();
$this->arr['funils'] = (new Orm('funil'))->select('*')->get();
$this->arr['produtores'] = (new Orm('usuarios'))->select('*')->where(['tipo','Produtor'])->get();

if(isset($_GET['nome']) || isset($_GET['produto']) || isset($_GET['origem']) || isset($_GET['status']) || isset($_GET['funil'])){
$nome = $_GET['nome'];
$produto = $_GET['produto'];
$origem = $_GET['origem'];
$status = $_GET['status'];
$funil = $_GET['funil'];

$lista = (new Orm('leads'))->select('*')
->orSearch(
  ['nome', $nome],
  ['produto', $produto],
  ['origem', $origem],
  ['status', $status],
  ['funil', $funil],)
->get();

$this->arr['lista'] = $lista;
}

$this->loadTemplate('funil/relatorio', $this->arr);
}//relatori


public function exportar(){
$rl = new ReportLead();


$produtor = isset($_POST['produtor']) ? $_POST['produtor'] : null;
$origem   = isset($_POST['origem']) ? $_POST['origem'] : null;
$produto  = isset($_POST['produto']) ? $_POST['produto'] : null;
$funil  = isset($_POST['funil']) ? $_POST['funil'] : null;

$funilt = array();
//$filtront = array();
//print_r($funil);
if(!empty($funil)){
  foreach($funil as $filtron){
    //echo $filtron;

    $filtront = (new Orm('funil'))->select(['id_funil, nome_funil'])->where(['id_funil', $filtron])->first()->get();

    if(!empty($filtront)){

      $filtronc = $filtront->id_funil;
      $filtronn = $filtront->nome_funil;

      switch ($filtronc) {
        case 11:
            $funilt[] =  $filtronn;
            //exit;
            break;
        case 12:
            $funilt[] =  $filtronn;
            break;
        default:
            $funilt[] = "";
        }; 
    }



  };
};
$str_funil = $this->convertArrayToString($funilt);

$tipo     = $_POST['tipo'];
$data_inicial = $_POST['data_inicial'];
$data_final   = $_POST['data_final'];


if($data_inicial != null){
$data_inicial = $this->converterData($data_inicial,'/');
$data_inicial = $data_inicial." 00:00:00";
}

if($data_final != null){
$data_final = $this->converterData($data_final,'/');
$data_final = $data_final." 23:59:59";
}

$filtro = (new Orm('leads'))
->select('*')
->join(['funil'])
->on(
  ['leads.funil_id','=','funil.id_funil'])
->in(
  ['produto', $produto],
  ['para', $produtor],
  ['origem', $origem],
  ['funil_id', $funil])
->between(['data_entrada','>=',$data_inicial],['data_entrada','<=', $data_final])
->get();


if($tipo == 'excel'){
$this->exportarexcel($filtro);
}

if($tipo == 'excelatendimento'){
  $filtroatendimento = (new Orm('vw_leadsatendimento'))
->select('*')
->in(
  ['produto', $produto],
  ['para', $produtor],
  ['origem', $origem],
  ['funil_id', $funil])
->between(['data','>=',$data_inicial],['data','<=', $data_final])
->get();

  $this->exportarexcelatendimento($filtroatendimento);
}

if($tipo == 'excelatendimentoapae'){
  $filtroatendimentoapae = (new Orm('vw_leadsatendimentoapae'))
  ->select('*')
  ->in(
    ['produto', $produto],
    ['para', $produtor],
    ['origem', $origem],
    ['funil_id', $funil])
  ->between(['data','>=',$data_inicial],['data','<=', $data_final])
  ->get();  
  $this->exportarexcelatendimentoapae($filtroatendimentoapae);
}

if($tipo == 'excelatendimentoapaemensageiro'){
  $filtroatendimentoapaemensageiro = (new Orm('vw_leadsatendimentoapaemensageiro'))
  ->select('*')
  ->wherecustom("data_faturamento >= '$data_inicial' AND data_faturamento <= '$data_final'")
  ->get();  
  $this->exportarexcelatendimentoapaemensageiro($filtroatendimentoapaemensageiro);
}

$str_produto = $this->convertArrayToString($produto);
$str_origem = $this->convertArrayToString($origem);
//$str_funil = $this->convertArrayToString($funil);


//print_r($str_funil);
//exit;
$header = [
'produto'=>$str_produto,
'origem'=>$str_origem,
'datas'=>$data_inicial." / ".$data_final,
'funil'=>$str_funil
];

$filtro = $this->montaLead($filtro);
$rl->gerar($filtro, $header);

}//exportar



public function montaLead($array){
$arr = [];

foreach($array as $key=>$value){
$produtor = (new Orm('usuarios'))->select(['nome'])->where(['id_usuario', $value->para])->first()->get();

$nome_produtor = $produtor->nome ?? 'Sem Produtor';
$value->para = $nome_produtor;

if(!isset($arr[$value->para])){
$arr[$value->para] = [];
array_push($arr[$value->para], $value);
}else{
 array_push($arr[$value->para], $value);
}

//print_r($arr);
//exit;
}//foreach


return $arr;
}//montaRelatorioProducao


public function export(){
$e = new SimpleXLSXGen();

$employees = [
  ['Nome', 'Produto', 'E-mail', 'Telefone', 'Origem']
];

foreach($dados as $item){
 $employees = array_merge($employees, array(
  array($item->nome, $item->produto, $item->email, $item->telefone, $item->origem)));
}

$xlsx = SimpleXLSXGen::fromArray($employees);
// This will download the file to your local system
$xlsx->downloadAs('Leads.xlsx'); 
// This will save the file to your server
// $xlsx->saveAs('employees.xlsx');

echo "<pre>";
print_r($employees);
}

public function exportarexcelatendimentoapaemensageiro($dadosatendimentoapae){
  // echo '<pre>';
  // print_r($dadosatendimentoapae);
  // exit;
 
 //Aqui começa a exportação
 $formato = 'Xlsx';//Xlsx - Xls - Csv
 $file = new Spreadsheet();
 $active_sheet = $file->getActiveSheet();
 
 $active_sheet->setCellValue('a1', 'Data Faturamento');
 $active_sheet->setCellValue('b1', 'Data Agendada');
 $active_sheet->setCellValue('c1', 'Mensageiro');
 $active_sheet->setCellValue('d1', 'Data Recebimento');
 $active_sheet->setCellValue('e1', 'Nome');
 $active_sheet->setCellValue('f1', 'Telefone');
 $active_sheet->setCellValue('g1', 'E-mail');
 $active_sheet->setCellValue('h1', 'Produto');
 $active_sheet->setCellValue('i1', 'Cidade');
 $active_sheet->setCellValue('j1', 'recebido');
 $active_sheet->setCellValue('k1', 'fpagamento');
 $active_sheet->setCellValue('l1', 'valor');
 $active_sheet->setCellValue('m1', 'valor_pago');
   
 $count = 2;
 foreach($dadosatendimentoapae as $row){
 $produtor = (new Orm('usuarios'))->select(['nome'])
 ->where(['id_usuario', $row->para])->first()->get();
 
 if(!empty($produtor)){
   $prod = $produtor->nome;
 }else{
   $prod = 'Sem Produtor';
 }
 //echo $prod.'<br>';
 //exit;
 $active_sheet->setCellValue('a'.$count, $row->data_faturamento ?? '');
 $active_sheet->setCellValue('b'.$count, $row->data_agendada ?? '');
 $active_sheet->setCellValue('c'.$count, $row->funcionario ?? '');
 $active_sheet->setCellValue('d'.$count, $row->data_recebimento ?? '');
 $active_sheet->setCellValue('e'.$count, $row->nome ?? '');
 $active_sheet->setCellValue('f'.$count, $row->telefone ?? '');
 $active_sheet->setCellValue('g'.$count, $row->email ?? '');
 $active_sheet->setCellValue('h'.$count, $row->produto ?? '');
 $active_sheet->setCellValue('i'.$count, $row->cidade ?? '');
 $active_sheet->setCellValue('j'.$count, $row->recebido ?? '');
 $active_sheet->setCellValue('k'.$count, $row->fpagamento ?? '');
 $active_sheet->setCellValue('l'.$count, $row->valor ?? '');
 $active_sheet->setCellValue('m'.$count, $row->valor_pago ?? '');
 
 $count = $count +1;
 }
 
 $writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($file, $formato);
 
 $file_name = time().'.'.strtolower(($formato));
 $writer->save($file_name);
 header("Content-Type: application/x-www-form-urlencoded");
 header("Content-Transfer-Encoding:Binary");
 header("Content-disposition:attachment;filename=\"".$file_name."\"");
 readfile($file_name);
 unlink($file_name);
 exit;
 
 }//exportar atendimento apae

public function exportarexcelatendimentoapae($dadosatendimentoapae){
 // echo '<pre>';
 // print_r($dadosatendimentoapae);
 // exit;

//Aqui começa a exportação
$formato = 'Xlsx';//Xlsx - Xls - Csv
$file = new Spreadsheet();
$active_sheet = $file->getActiveSheet();

$active_sheet->setCellValue('a1', 'Data');
$active_sheet->setCellValue('b1', 'Vendedor');
$active_sheet->setCellValue('c1', 'Funil');
$active_sheet->setCellValue('d1', 'Data Entrada');
$active_sheet->setCellValue('e1', 'Data Comentario');
$active_sheet->setCellValue('f1', 'Data Fechamento');
$active_sheet->setCellValue('g1', 'Nome');
$active_sheet->setCellValue('h1', 'Telefone');
$active_sheet->setCellValue('i1', 'E-mail');
$active_sheet->setCellValue('j1', 'Produto');
$active_sheet->setCellValue('k1', 'Origem');
$active_sheet->setCellValue('l1', 'Cidade');
$active_sheet->setCellValue('m1', 'Tipo');
$active_sheet->setCellValue('n1', 'Texto');
$active_sheet->setCellValue('o1', 'recebido');
$active_sheet->setCellValue('p1', 'fpagamento');
$active_sheet->setCellValue('q1', 'valor');
$active_sheet->setCellValue('r1', 'valor_pago');
$active_sheet->setCellValue('s1', 'valor_cancelado');
$active_sheet->setCellValue('t1', 'data_agendada');
$active_sheet->setCellValue('u1', 'funcionario');


$count = 2;
foreach($dadosatendimentoapae as $row){
$produtor = (new Orm('usuarios'))->select(['nome'])
->where(['id_usuario', $row->para])->first()->get();

if(!empty($produtor)){
  $prod = $produtor->nome;
}else{
  $prod = 'Sem Produtor';
}
//echo $prod.'<br>';
//exit;
$active_sheet->setCellValue('a'.$count, $row->data ?? '');
$active_sheet->setCellValue('b'.$count, $row->vendedor ?? '');
$active_sheet->setCellValue('c'.$count, $row->nome_funil ?? '');
$active_sheet->setCellValue('d'.$count, $row->data_entrada ?? '');
$active_sheet->setCellValue('e'.$count, $row->data_comentario ?? '');
$active_sheet->setCellValue('f'.$count, $row->data_fechamento ?? '');
$active_sheet->setCellValue('g'.$count, $row->nome ?? '');
$active_sheet->setCellValue('h'.$count, $row->telefone ?? '');
$active_sheet->setCellValue('i'.$count, $row->email ?? '');
$active_sheet->setCellValue('j'.$count, $row->produto ?? '');
$active_sheet->setCellValue('k'.$count, $row->origem ?? '');
$active_sheet->setCellValue('l'.$count, $row->cidade ?? '');
$active_sheet->setCellValue('m'.$count, $row->tipo ?? '');
$active_sheet->setCellValue('n'.$count, $row->texto ?? '');
$active_sheet->setCellValue('o'.$count, $row->recebido ?? '');
$active_sheet->setCellValue('p'.$count, $row->fpagamento ?? '');
$active_sheet->setCellValue('q'.$count, $row->valor ?? '');
$active_sheet->setCellValue('r'.$count, $row->valor_pago ?? '');
$active_sheet->setCellValue('s'.$count, $row->valor_cancelado ?? '');
$active_sheet->setCellValue('t'.$count, $row->data_agendada ?? '');
$active_sheet->setCellValue('u'.$count, $row->funcionario ?? '');

$count = $count +1;
}

$writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($file, $formato);

$file_name = time().'.'.strtolower(($formato));
$writer->save($file_name);
header("Content-Type: application/x-www-form-urlencoded");
header("Content-Transfer-Encoding:Binary");
header("Content-disposition:attachment;filename=\"".$file_name."\"");
readfile($file_name);
unlink($file_name);
exit;

}//exportar atendimento apae

public function exportarexcelatendimento($dadosatendimento){
  //echo '<pre>';
  //print_r($dados);
  //exit;

//Aqui começa a exportação
$formato = 'Xlsx';//Xlsx - Xls - Csv
$file = new Spreadsheet();
$active_sheet = $file->getActiveSheet();

$active_sheet->setCellValue('a1', 'Data');
$active_sheet->setCellValue('b1', 'Vendedor');
$active_sheet->setCellValue('c1', 'Funil');
$active_sheet->setCellValue('d1', 'Data Entrada');
$active_sheet->setCellValue('e1', 'Data Comentario');
$active_sheet->setCellValue('f1', 'Data Fechamento');
$active_sheet->setCellValue('g1', 'Nome');
$active_sheet->setCellValue('h1', 'Telefone');
$active_sheet->setCellValue('i1', 'E-mail');
$active_sheet->setCellValue('j1', 'Produto');
$active_sheet->setCellValue('k1', 'Origem');
$active_sheet->setCellValue('l1', 'Cidade');
$active_sheet->setCellValue('m1', 'Tipo');
$active_sheet->setCellValue('n1', 'Texto');

$count = 2;
foreach($dadosatendimento as $row){
$produtor = (new Orm('usuarios'))->select(['nome'])
->where(['id_usuario', $row->para])->first()->get();

if(!empty($produtor)){
  $prod = $produtor->nome;
}else{
  $prod = 'Sem Produtor';
}
//echo $prod.'<br>';
//exit;
$active_sheet->setCellValue('a'.$count, $row->data ?? '');
$active_sheet->setCellValue('b'.$count, $row->vendedor ?? '');
$active_sheet->setCellValue('c'.$count, $row->nome_funil ?? '');
$active_sheet->setCellValue('d'.$count, $row->data_entrada ?? '');
$active_sheet->setCellValue('e'.$count, $row->data_comentario ?? '');
$active_sheet->setCellValue('f'.$count, $row->data_fechamento ?? '');
$active_sheet->setCellValue('g'.$count, $row->nome ?? '');
$active_sheet->setCellValue('h'.$count, $row->telefone ?? '');
$active_sheet->setCellValue('i'.$count, $row->email ?? '');
$active_sheet->setCellValue('j'.$count, $row->produto ?? '');
$active_sheet->setCellValue('k'.$count, $row->origem ?? '');
$active_sheet->setCellValue('l'.$count, $row->cidade ?? '');
$active_sheet->setCellValue('m'.$count, $row->tipo ?? '');
$active_sheet->setCellValue('n'.$count, $row->texto ?? '');

$count = $count +1;
}

$writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($file, $formato);

$file_name = time().'.'.strtolower(($formato));
$writer->save($file_name);
header("Content-Type: application/x-www-form-urlencoded");
header("Content-Transfer-Encoding:Binary");
header("Content-disposition:attachment;filename=\"".$file_name."\"");
readfile($file_name);
unlink($file_name);
exit;

}//exportar atendimento


public function exportarexcel($dados){
  //echo '<pre>';
  //print_r($dados);
  //exit;

//Aqui começa a exportação
$formato = 'Xlsx';//Xlsx - Xls - Csv
$file = new Spreadsheet();
$active_sheet = $file->getActiveSheet();

$active_sheet->setCellValue('a1', 'Produtor');
$active_sheet->setCellValue('b1', 'Nome');
$active_sheet->setCellValue('c1', 'Produto');
$active_sheet->setCellValue('d1', 'Funil');
$active_sheet->setCellValue('e1', 'E-mail');
$active_sheet->setCellValue('f1', 'Telefone');
$active_sheet->setCellValue('g1', 'Origem');
$active_sheet->setCellValue('h1', 'Data Entrada');
$active_sheet->setCellValue('i1', 'Status');

$count = 2;
foreach($dados as $row){
$produtor = (new Orm('usuarios'))->select(['nome'])
->where(['id_usuario', $row->para])->first()->get();

if(!empty($produtor)){
  $prod = $produtor->nome;
}else{
  $prod = 'Sem Produtor';
}
//echo $prod.'<br>';
//exit;
$active_sheet->setCellValue('a'.$count, $prod ?? '');
$active_sheet->setCellValue('b'.$count, $row->nome ?? '');
$active_sheet->setCellValue('c'.$count, $row->produto ?? '');
$active_sheet->setCellValue('d'.$count, $row->nome_funil ?? '');
$active_sheet->setCellValue('e'.$count, $row->email ?? '');
$active_sheet->setCellValue('f'.$count, $row->telefone ?? '');
$active_sheet->setCellValue('g'.$count, $row->origem ?? '');
$active_sheet->setCellValue('h'.$count, $row->data_entrada ?? '');
$active_sheet->setCellValue('i'.$count, $row->status ?? '');
$count = $count +1;
}

$writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($file, $formato);

$file_name = time().'.'.strtolower(($formato));
$writer->save($file_name);
header("Content-Type: application/x-www-form-urlencoded");
header("Content-Transfer-Encoding:Binary");
header("Content-disposition:attachment;filename=\"".$file_name."\"");
readfile($file_name);
unlink($file_name);
exit;

}//exportar



public function verificaTarefa($id_lead){
$reg = (new Orm('leads_comentarios'))->select(['status_tarefa, finalizado'])
->where(['id_lead', $id_lead])->get();

if(empty($reg)){
 return 0;
}

$status = '';
foreach($reg as $rg){
 if($rg->status_tarefa != '' || $rg->status_tarefa != null){
  
  if($rg->finalizado != 'N'){
    $status = 0;
  }else{
    $status = $rg->status_tarefa;
  } 
   
 }
}

return $status;
}//verificaTarefa


public function update(){
$funil = $_POST['funil'];
$lead = $_POST['lead'];

$up = (new Orm('leads'))->set(['funil_id'=>$funil])->where(['id_lead', $lead])->update();

if($up){
echo json_encode('1');
exit;
}

echo json_encode('0');
exit;

}//update


public function remover($id){
$qr = new Orm('funil');
$qr->del(['id_funil', $id]);
$_SESSION['msg'] = ['type'=>'success','msg'=>'Funil removido com sucesso!'];
header("Location:".BASE_URL."funil");
exit;
}


}