<?php
use Core\Controller;
use Models\Users;
use Models\Permissao;
use Models\Orm;
use Models\Email;
use Dompdf\Dompdf;

class HomeController extends Controller {

  private $user;
  private $arr;
  private $permissao;

    public function __construct() {              
        $this->user = new Users();
        $this->permissao = new Permissao(); 

        if($this->user->isLogged() == false){                  
         header("Location: ".BASE_URL."login");        
         exit;         
        }
      
       $permissoes = $this->permissao->getPermissoes();
       $modulo_boleto = $this->permissao->getPermissoesBoleto();
       
        $this->arr = array(
         'user'=>$this->user,
         'menuActive'=>'home',
         'permissao'=>$permissoes,
         'modulo_boleto'=>$modulo_boleto
        );          
}

public function teste(){
  $data = []; 

  ob_start();
  $this->loadview("financeiro/financeiro_report_recibos_pdf", $data);
 // exit;
  $html = ob_get_contents();
  ob_end_clean();
/*
  $dompdf = new Dompdf();
  $dompdf->loadHtml($html);
  // Render the HTML as PDF
  $dompdf->render();
  $dompdf->stream("Letter",["Attachment" => false]);
*/
   $options = new Dompdf\Options();
   $options->set('isRemoteEnabled', true);

   $dompdf  = new Dompdf\Dompdf($options);
   $dompdf->set_option('isHtml5ParserEnabled', true);
   $dompdf->loadHtml($html);
   $dompdf->setPaper('A4', 'portrait');
   ini_set('xdebug.max_nesting_level', 2000);
   ini_set('memory_limit', '256M');
   $dompdf->render();
   $dompdf->stream("OS",array("Attachment"=>0));
// echo "teste";exit;
}//teste


public function index() {   
$this->arr['list_js'] = array(
'plugins/sweetalert2',
'plugins/jquery.mask.min',
'flatpickr/flatpickr',
'flatpickr/pt',
'flatpickr/flatpickr_init'
); 

$this->arr['usuario_logado'] = $this->user->getId();


//muda para seu email sobe para o serv ja esta ja esta online? esse eh local
//so funciona online o phpmailer

//como utilizar

/*
$response = (new Email())->send([
     'from'=>'Jorge Santos',
     'para'=>'sistema@gestaocrm.crmd.com.br',
     'assunto'=>'Texte disparo de email',
     'mensagem'=>'conteudo da mensagem aqui'
     ]);

     if($response){
        echo "enviado";exit;
     }else{
     echo "erro ao enviar ";exit;
     }
*/

$this->arr['anuncios_recentes'] = [];
$this->arr['usuarios_recentes'] = [];


$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('home', $this->arr);
}//function index   


public function calendario(){



  switch($this->user->getTipo()){
    case 'Super Admin':
      $this->arr['produtores'] = (new Orm('usuarios'))->select('*')->where(['tipo','Produtor'])->get();     
    $this->loadTemplate('calendario', $this->arr);
    break;
    case 'Produtor':
      //$this->loadTemplate('calendarioprod', $this->arr);
      echo 'acesso nao permitido';
      break;
    }   
}

public function calendarioprod(){


  $this->loadTemplate('calendarioprod', $this->arr);
}


//esse é o padrao para trazer os dados e exibir 
//vou pegar a tabela para vc ver
public function pegaeventos(){


$source = $_GET['source'];
//echo $source;
//exit;

  switch($this->user->getTipo()){
    case 'Super Admin':

  $where_sql = '';
  if(!empty($_GET['start']) && !empty($_GET['end'])){

if($source == 'admin'){
  $where_sql .= "date_time BETWEEN '".$_GET['start']."' AND '".$_GET['end']."' ";
}else{
  $where_sql .= "date_time BETWEEN '".$_GET['start']."' AND '".$_GET['end']."' AND team_member = '$source' ";
}
  
}
  
  $result = (new Orm('shedules'))->select('*')
  ->join(['leads_comentarios'])
  ->on(['leads_comentarios.id_comentario','=','shedules.event_type'])
  ->wherecustom("$where_sql")
  ->get();
 
  
  $eventsArr = [];
  $nomevendedor = '';
  
  foreach($result as $row){
    $idlead = $row->id_lead;
    $lead = (new Orm('leads'))->select('*')->where(['id_lead',$idlead])->get(); 
    foreach($lead as $leadpara){
      $vendedor = $leadpara->para;
//      echo $idlead.' vendedor'.$vendedor;
//      exit;
      $vend = (new Orm('usuarios'))->select('*')->where(['id_usuario',$vendedor])->limit('1')->get(); 
      foreach($vend as $vende){
      $nomevendedor = $vende->nome;
      }
    } 
  $evento = [
  'title'=>$nomevendedor.' - '.$row->subject,
  'client'=>$row->client,
  'description'=>$row->texto,
  'start'=>date('Y-m-d', strtotime($row->date_time)),
  'end'=>date('Y-m-d', strtotime($row->from_date_time)),
  'color'=>$row->color
  ];
  
  array_push($eventsArr, $evento);
  }
  
  
  echo json_encode($eventsArr);
  break;

  case 'Produtor':
    //$this->loadTemplate('calendarioprod', $this->arr);
    echo 'acesso nao permitido';
    break;
  }
 


  }//pegaeventos

  public function pegaeventosprod(){

    $where_sql = '';
    $id_usuario = $this->user->getId();
    if(!empty($_GET['start']) && !empty($_GET['end'])){
    $where_sql .= "date_time BETWEEN '".$_GET['start']."' AND '".$_GET['end']."' AND team_member = '$id_usuario' ";
    }
    
    $result = (new Orm('shedules'))->select('*')
    ->join(['leads_comentarios'])
    ->on(['leads_comentarios.id_comentario','=','shedules.event_type'])
    ->wherecustom("$where_sql")
    ->get();
   
    
    $eventsArr = [];
    foreach($result as $row){
    
    $evento = [
    'title'=>$row->subject,
    'client'=>$row->client,
    'description'=>$row->texto,
    'start'=>date('Y-m-d', strtotime($row->date_time)),
    'end'=>date('Y-m-d', strtotime($row->from_date_time)),
    'color'=>$row->color
    ];
    
    array_push($eventsArr, $evento);
    }
    
    
    echo json_encode($eventsArr);
    }//pegaeventosprod




}