<?php
use Core\Controller;
use Models\Users;
use Models\Permissao;
use Models\Orm;
use Models\Validate;
use Models\Email;
use Models\Leads;
use Models\Financeiro;
use Dompdf\Dompdf;
use Dompdf\Exception;
use Dompdf\Options;
use Models\ReportFinanceiro;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\IOFactory;

class LeadsController extends Controller {

  private $user;
  private $arr;
  private $permissao;

    public function __construct() {              
        $this->user = new Users();
        $this->permissao = new Permissao(); 

        if($this->user->isLogged() == false){                  
         header("Location: ".BASE_URL."login");        
         exit;         
        }

       
        $permissoes = $this->permissao->getPermissoes();
        $modulo_boleto = $this->permissao->getPermissoesBoleto();
        
         $this->arr = array(
          'user'=>$this->user,
          'menuActive'=>'home',
          'permissao'=>$permissoes,
          'modulo_boleto'=>$modulo_boleto
         );          

}

public function index() {   
$this->arr['list_js'] = array(
'plugins/sweetalert2',
'helpers',
'system',
'functions_js'
);  

$this->arr['usuario_logado'] = $this->user->getId();

//$this->permissao->temPermissao('crm', 'crm-meus-leads');
$this->arr['tipo'] = $this->user->getTipo();
$tab = new Orm('leads');
$id_usuario = $this->user->getId();
$this->arr['origens'] = (new Orm('origem_venda'))->select('*')->order(['nome_origem asc'])->get();
$this->arr['produtos'] = (new Orm('produtos'))->select('*')->order(['nome_produto asc'])->get();
$this->arr['funis'] = (new Orm('funil'))->select('*')->order(['nome_funil asc'])->get();
$this->arr['produtores'] = (new Orm('usuarios'))
->select(['id_usuario, nome'])->where(['tipo','Produtor'])->order(['nome asc'])->get();
$this->arr['flow'] = (new Orm('whats_flow'))->select('*')->get();

$l = new Leads();
$teste = $l->getCliente();
$cliente = $teste->nome;
$this->arr['cliente'] = $cliente;
$this->arr['iduser'] = $this->user->getId();
/*

switch($this->user->getTipo()){
case 'Super Admin':
$this->arr['lista'] = $tab->select('*')->order(['id_lead desc'])->paginate('50')
->get();
$this->arr['paginacao'] = $tab->render("leads");
break;

case 'Produtor':
$this->arr['lista'] = $tab->select('*')
->where(['para',$id_usuario])
->order(['id_lead desc'])->paginate('50')->get();
$this->arr['paginacao'] = $tab->render("leads");
break;
}
*/

switch($this->user->getTipo()){
  case 'Super Admin':
    if($cliente == 'UPA Piracicaba'){ 
    $tab = new Orm('leads');
    $this->arr['lista'] = $tab->select('*')->wherecustom("origem != 'V ONLINE' and para = '0'")->order(['data_atend, idade desc'])->paginate('50')->get();
    $this->arr['paginacao'] = $tab->render("leads");
    }else{
    $tab = new Orm('leads');
    $this->arr['lista'] = $tab->select('*')->wherecustom("origem != 'V ONLINE' and para = '0'")->order(['data_entrada desc'])->paginate('50')->get();
    $this->arr['paginacao'] = $tab->render("leads");
    }
    // $l = new Leads();
    // $this->arr['lista'] = $l->getVOnlinef(); 
   



    //$this->arr['paginacao'] = $tab->render("leads");
    /*
    $this->arr['lista'] = $tab->select('*')
  ->where(['para',0])
  ->order(['id_lead desc'])->paginate('50')
  ->get();
  $this->arr['paginacao'] = $tab->render("leads");*/
  break;
  
  case 'Produtor':
    $vendedor = $this->user->getId();
   /* $tab = new Orm('leads');
    $this->arr['lista'] = $tab->select('*')
    ->wherecustom("origem != 'V ONLINE' AND ORIGEM != 'INATIVO' AND para = '$vendedor'")->order(['data_entrada desc'])->paginate('10')->get();
    $this->arr['paginacao'] = $tab->render("leads");*/
    
/*
    $sql = $this->db->prepare("SELECT * FROM leads join usuario_produto on leads.para = usuario_produto.id_usuario and leads.produto = usuario_produto.produto where origem != 'V ONLINE' AND para = '$vendedor' order by data_entrada DESC");
     $sql->execute();
     if($sql->rowCount()>0){
       $array = $sql->fetchall();
     }*/

   // aqui funciona
   if($cliente == 'UPA Piracicaba'){ 
    $l = new Leads();
    $vendedor = $this->user->getId();
    //if($cliente == 'Apae Piracicaba' || $cliente == 'Clique Responde' ){
      $this->arr['lista'] = $tab->select('*')->wherecustom("para = '$vendedor'")->order(['data_atend, idade desc'])->paginate('10')->get();
      $this->arr['paginacao'] = $tab->render("leads");    
   }else{
    $l = new Leads();
    $vendedor = $this->user->getId();
    //if($cliente == 'Apae Piracicaba' || $cliente == 'Clique Responde' ){
      //$this->arr['lista'] = $tab->select('*')->wherecustom("para = '$vendedor' and status != 'repique'")->order(['data_entrada desc'])->paginate('10')->get();
        $this->arr['lista'] = $tab->select('*')->wherecustom("para = '$vendedor'")->order(['data_entrada desc'])->paginate('10')->get();      
      $this->arr['paginacao'] = $tab->render("leads");
   }
    //}else{
    //  $this->arr['lista'] = $l->getProdutorf($vendedor);
    //}

    
  

   // $this->arr['paginacao'] = $tab->render("leads");
    /*
  $this->arr['lista'] = $tab->select('*')
  ->where(['para',$id_usuario])
  ->order(['id_lead desc'])->paginate('50')->get();
  $this->arr['paginacao'] = $tab->render("leads");*/
  break;
  }
  
//$this->arr['paginacao'] = $tab->render("leads");
$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);


if(isset($_GET['nome']) || isset($_GET['produto']) || isset($_GET['origem']) || isset($_GET['status']) || isset($_GET['codsocio']) || isset($_GET['codsistema']) || isset($_GET['vendedor']) || isset($_GET['funil'])){
$nome    = $_GET['nome'];
$produto = $_GET['produto'];
$origem  = $_GET['origem'];
$status  = $_GET['status'];
$codsocio  = $_GET['codsocio'];
$codsistema  = $_GET['codsistema'];
$funil  = $_GET['funil'];
$telefone  = $_GET['telefone'];


switch($this->user->getTipo()){
case 'Super Admin':
$vendedor  = $_GET['vendedor'];

/* atualizar aqui os ids q irao ver o V ONLINE */
$l = new Leads();
$teste = $l->getCliente();
$cliente = $teste->nome;
$this->arr['cliente'] = $cliente;
$this->arr['iduser'] = $this->user->getId();
//echo $cliente;
//exit;
//$vonline = 'V ONLINE';
//$this->user->getId() == 27 && $cliente == 'Clique Responde'
if($this->user->getId() == 33 && $cliente == 'Cartao de Todos Piracicaba' || $this->user->getId() == 27 && $cliente == 'Clique Responde' ){
  $lista = (new Orm('leads'))->select('*')
  ->orSearch(
    ['nome', $nome],
    ['produto', $produto],
    ['origem', $origem],
    ['status', $status],
    ['codsocio', $codsocio],
    ['codsistema', $codsistema],
    ['para', $vendedor],
    ['funil_id', $funil],
    ['telefone', $telefone])
  ->order(['data_entrada desc'])->paginate('50')
  ->get();
 // $this->arr['paginacao'] = $lista->render("leads");
}else{
  $l = new Leads();
  $lista = $l->getVOnline($nome,$produto,$origem,$status,$codsocio,$codsistema,$vendedor,$funil,$telefone);

 //echo '<pre>';
 //print_r($vonlineget);
//exit;

}

break;

case 'Produtor':
$id_usuario = $this->user->getId();
$l = new Leads();
$teste = $l->getCliente();
$cliente = $teste->nome;
$this->arr['cliente'] = $cliente;

$l = new Leads();
if($cliente == 'Apae Piracicaba' || $cliente == 'Clique Responde' ){
  $lista = $l->getProdutorApae($nome,$produto,$origem,$status,$codsocio,$codsistema,$id_usuario,$funil,$telefone);
}else{
  $lista = $l->getProdutor($nome,$produto,$origem,$status,$codsocio,$codsistema,$id_usuario,$funil,$telefone);
  
}
 //echo '<pre>';
 //print_r($lista);
 //exit;
/*
$lista = (new Orm('leads'))->select('*')
->orSearch(
  ['nome', $nome],
  ['produto', $produto],
  ['origem', $origem],
  ['status', $status],
  ['funil_id', $funil])
->e(['para',$id_usuario])
->join(['usuario_produto'])
->on(['leads.para','=','usuario_produto.id_usuario']) 
->get();*/
//echo 'aqui';
//exit;
break;
}//switch

$this->arr['lista'] = $lista;
}

$this->loadTemplate('leads/listar', $this->arr);
}//function index  

public function confere_importar() {  
  $this->arr['usuario_logado'] = $this->user->getId();

  //$this->permissao->temPermissao('crm', 'crm-meus-leads');
  $this->arr['tipo'] = $this->user->getTipo();
  $tab = new Orm('leads');
  $id_usuario = $this->user->getId();
  $this->arr['origens'] = (new Orm('origem_venda'))->select('*')->order(['nome_origem asc'])->get();
  $this->arr['produtos'] = (new Orm('produtos'))->select('*')->order(['nome_produto asc'])->get();
  $this->arr['funis'] = (new Orm('funil'))->select('*')->order(['nome_funil asc'])->get();
  $this->arr['produtores'] = (new Orm('usuarios'))
  ->select(['id_usuario, nome'])->where(['tipo','Produtor'])->order(['nome asc'])->get();
  $l = new Leads();
  $teste = $l->getCliente();
  $cliente = $teste->nome;
  $this->arr['cliente'] = $cliente;
  $this->arr['iduser'] = $this->user->getId();
  /*
  
  switch($this->user->getTipo()){
  case 'Super Admin':
  $this->arr['lista'] = $tab->select('*')->order(['id_lead desc'])->paginate('50')
  ->get();
  $this->arr['paginacao'] = $tab->render("leads");
  break;
  
  case 'Produtor':
  $this->arr['lista'] = $tab->select('*')
  ->where(['para',$id_usuario])
  ->order(['id_lead desc'])->paginate('50')->get();
  $this->arr['paginacao'] = $tab->render("leads");
  break;
  }
  */
  
  switch($this->user->getTipo()){
    case 'Super Admin':
      $tab = new Orm('leads');
      $this->arr['lista'] = $tab->select('*')->wherecustom("origem != 'V ONLINE' and para = '0'")->order(['data_entrada desc'])->paginate('50')->get();
      $this->arr['paginacao'] = $tab->render("leads");
  
      // $l = new Leads();
      // $this->arr['lista'] = $l->getVOnlinef(); 
     
  
  
  
      //$this->arr['paginacao'] = $tab->render("leads");
      /*
      $this->arr['lista'] = $tab->select('*')
    ->where(['para',0])
    ->order(['id_lead desc'])->paginate('50')
    ->get();
    $this->arr['paginacao'] = $tab->render("leads");*/
    break;
    
    case 'Produtor':
      $vendedor = $this->user->getId();
      $tab = new Orm('leads');
      $this->arr['lista'] = $tab->select('*')
      ->wherecustom("origem != 'V ONLINE' AND ORIGEM != 'INATIVO' AND para = '$vendedor'")->order(['data_entrada desc'])->paginate('10')->get();
      $this->arr['paginacao'] = $tab->render("leads");
      
  /*
      $sql = $this->db->prepare("SELECT * FROM leads join usuario_produto on leads.para = usuario_produto.id_usuario and leads.produto = usuario_produto.produto where origem != 'V ONLINE' AND para = '$vendedor' order by data_entrada DESC");
       $sql->execute();
       if($sql->rowCount()>0){
         $array = $sql->fetchall();
       }*/
  
     /* aqui funciona
     $l = new Leads();
      $vendedor = $this->user->getId();
      $this->arr['lista'] = $l->getProdutorf($vendedor);
    */
  
     // $this->arr['paginacao'] = $tab->render("leads");
      /*
    $this->arr['lista'] = $tab->select('*')
    ->where(['para',$id_usuario])
    ->order(['id_lead desc'])->paginate('50')->get();
    $this->arr['paginacao'] = $tab->render("leads");*/
    break;
    }
    
  //$this->arr['paginacao'] = $tab->render("leads");
  $this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
  
  
  if(isset($_GET['nome']) || isset($_GET['produto']) || isset($_GET['origem']) || isset($_GET['status']) || isset($_GET['codsocio']) || isset($_GET['codsistema']) || isset($_GET['vendedor']) || isset($_GET['funil'])){
  $nome    = $_GET['nome'];
  $produto = $_GET['produto'];
  $origem  = $_GET['origem'];
  $status  = $_GET['status'];
  $codsocio  = $_GET['codsocio'];
  $codsistema  = $_GET['codsistema'];
  $funil  = $_GET['funil'];
  $telefone  = $_GET['telefone'];
  
  
  switch($this->user->getTipo()){
  case 'Super Admin':
  $vendedor  = $_GET['vendedor'];
  
  /* atualizar aqui os ids q irao ver o V ONLINE */
  $l = new Leads();
  $teste = $l->getCliente();
  $cliente = $teste->nome;
  $this->arr['cliente'] = $cliente;
  $this->arr['iduser'] = $this->user->getId();
  //echo $cliente;
  //exit;
  //$vonline = 'V ONLINE';
  //$this->user->getId() == 27 && $cliente == 'Clique Responde'
  if($this->user->getId() == 33 && $cliente == 'Cartao de Todos Piracicaba' || $this->user->getId() == 27 && $cliente == 'Clique Responde' ){
    $lista = (new Orm('leads'))->select('*')
    ->orSearch(
      ['nome', $nome],
      ['produto', $produto],
      ['origem', $origem],
      ['status', $status],
      ['codsocio', $codsocio],
      ['codsistema', $codsistema],
      ['para', $vendedor],
      ['funil_id', $funil],
      ['telefone', $telefone])
    ->order(['data_entrada desc'])->paginate('50')
    ->get();
   // $this->arr['paginacao'] = $lista->render("leads");
  }else{
    $l = new Leads();
    $lista = $l->getVOnline($nome,$produto,$origem,$status,$codsocio,$codsistema,$vendedor,$funil,$telefone);
   //echo '<pre>';
   //print_r($vonlineget);
  //exit;
  
  }
  
  break;
  
  case 'Produtor':
  $id_usuario = $this->user->getId();
  $l = new Leads();
  $teste = $l->getCliente();
  $cliente = $teste->nome;
  $this->arr['cliente'] = $cliente;
  
  $l = new Leads();
  $lista = $l->getProdutor($nome,$produto,$origem,$status,$codsocio,$codsistema,$id_usuario,$funil,$telefone);
   //echo '<pre>';
   //print_r($lista);
   //exit;
  /*
  $lista = (new Orm('leads'))->select('*')
  ->orSearch(
    ['nome', $nome],
    ['produto', $produto],
    ['origem', $origem],
    ['status', $status],
    ['funil_id', $funil])
  ->e(['para',$id_usuario])
  ->join(['usuario_produto'])
  ->on(['leads.para','=','usuario_produto.id_usuario']) 
  ->get();*/
  //echo 'aqui';
  //exit;
  break;
  }//switch
  
  $this->arr['lista'] = $lista;
  }

  $this->loadTemplate('leads/listar_confere_importacao', $this->arr);
}

public function add(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'helpers',
'functions_js',
'plugins/sweetalert2',
'system'
);
$this->arr['usuario_logado'] = $this->user->getId();
$this->arr['bairros'] = (new Orm('financeiro_bairro'))->select('*')->get();
$this->arr['produtos'] = (new Orm('produtos'))->select('*')->order(['nome_produto asc'])->get();
$this->arr['origens']  = (new Orm('origem_venda'))->select('*')->get();
$l = new Leads();
$teste = $l->getCliente();
$cliente = $teste->nome;
$this->arr['cliente'] = $cliente;

$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('leads/adicionar', $this->arr);
}//add

public function addProdutor(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'helpers',
'functions_js',
'plugins/sweetalert2',
'system'
);

$this->arr['id_produtor'] = $this->user->getId();
$this->arr['bairros'] = (new Orm('financeiro_bairro'))->select('*')->get();
$this->arr['produtos'] = (new Orm('produtos'))->select('*')->order(['nome_produto asc'])->get();
$this->arr['origens']  = (new Orm('origem_venda'))->select('*')->get();
$l = new Leads();
$teste = $l->getCliente();
$cliente = $teste->nome;
$this->arr['cliente'] = $cliente;

$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('leads/adicionar_produtor', $this->arr);
}//addProdutor

public function distribuir_atendimento(){
  $this->arr['list_js'] = array(
  'plugins/jquery.mask.min',
  'plugins/parsley/parsley.min',
  'plugins/parsley/pt-br',
  'mask_init',
  'plugins/sweetalert2',
  'system'
  );

  $l = new Leads();
  $teste = $l->getCliente();
  $cliente = $teste->nome;
  $this->arr['cliente'] = $cliente;
  $this->arr['atendentes'] = (new Orm('usuarios'))->select('*')->where(['tipo', 'produtor'])->get();
  $this->arr['tipos'] = (new Orm('produtos'))->select('*')->get();

  $tipo = $this->user->getTipo();
  
  if($tipo == 'Super Admin'){
    if(isset($_POST['atendente']) && !empty($_POST['atendente'])){
      $tipon = explode(';',$_POST['tipo']);
      $tiponum = $tipon[0];
      $tipoprod = $tipon[1];
      //echo $tiponum.'-'.$tipoprod;
      //exit;
      if(isset($_POST['funcionario']) && !empty($_POST['funcionario'])){
      $l->distribuir_leadsfuncionario($_POST['atendente'],$_POST['qtde'],$tiponum,$tipoprod,$_POST['funcionario']);
      }else{
      $l->distribuir_leads($_POST['atendente'],$_POST['qtde'],$tiponum,$tipoprod);
      }
    }

  }



  $this->loadTemplate('leads/distribuir_atendimento', $this->arr);
}//edit

public function relatorioprod(){
  $data = array();
  $idusuario = $this->user->getId();

  $this->arr['lista_atendente'] = (new Orm('usuarios'))->select('*')->where(['id_usuario', $idusuario])->get();

  if( isset($_POST['data_inicial']) && !empty($_POST['data_inicial']) && isset($_POST['data_final']) && !empty($_POST['data_final'])){
    $tipo = $_POST['tipo'];
    $data_inicial = $_POST['data_inicial'];
    $data_final = $_POST['data_final'];
    $aten = explode(';',$_POST['atendente']);
    $atendente = $aten[0];
    $data['atendente'] = $aten[1];
    $data['data_inicial'] = $data_inicial;
    $data['data_final'] = $data_final;

    if($tipo == 'recebimento_resumo'){
      $data['consulta'] = (new Orm('vw_report_resumorecebidonatendente'))
      ->select(['*'])
      ->wherecustom("id_user = '$atendente' and data_recebimento >= '$data_inicial' and data_recebimento <= '$data_final'")
      ->get();       
     
      ob_start();
      $this->loadview("leads/financeiro_report_recebimentoresumoatendente_pdf", $data);      
      //exit;
      $html = ob_get_contents();
      ob_end_clean();      
      $options = new Options();
      $options->set('isRemoteEnabled',true);
      $dompdf = new Dompdf($options);
      //$dompdf = new Dompdf();
      $dompdf->loadHtml($html);
      // Render the HTML as PDF
      $dompdf->setPaper('A4', 'portrait');
      $dompdf->render();
      $dompdf->stream("Letter",["Attachment" => false]);  
      }
  
      if($tipo == 'recebimento_detalhe'){
            
        $filtroatendimento = (new Orm('financeiro_faturamento'))
        ->select(['financeiro_faturamento.*, leads.id_importacao,leads.nome, leads.produto, usuarios.nome as agente, leads.cobranca as lcobranca'])
        ->join(['leads'],['usuarios'])
        ->on(
          ['financeiro_faturamento.id_lead','=','leads.id_lead'],
          ['financeiro_faturamento.id_user','=','usuarios.id_usuario'])
        ->wherecustom("financeiro_faturamento.id_user = '$atendente' and financeiro_faturamento.tipo like 'extra_esporadico%' and financeiro_faturamento.recebido = 'SIM' and data_recebimento >= '$data_inicial' and data_recebimento <= '$data_final'")
        ->get();
  
        $this->exportarboletos($filtroatendimento);    

        }

        if($tipo == 'faturamento_resumo'){
          $data['consulta'] = (new Orm('vw_report_resumofaturadonatendente'))
          ->select(['*'])
          ->wherecustom("id_user = '$atendente' and data_agendada >= '$data_inicial' and data_agendada <= '$data_final'")
          ->get();       
         // print_r($data);
         // exit;
         
          ob_start();
          $this->loadview("leads/financeiro_report_faturamentoresumoatendente_pdf", $data);      
          //exit;
          $html = ob_get_contents();
          ob_end_clean();      
          $options = new Options();
          $options->set('isRemoteEnabled',true);
          $dompdf = new Dompdf($options);
          //$dompdf = new Dompdf();
          $dompdf->loadHtml($html);
          // Render the HTML as PDF
          $dompdf->setPaper('A4', 'portrait');
          $dompdf->render();
          $dompdf->stream("Letter",["Attachment" => false]);  
          }

        if($tipo == 'faturamento_detalhe'){
            
          $filtroatendimento = (new Orm('financeiro_faturamento'))
          ->select(['financeiro_faturamento.*, leads.id_importacao,leads.nome, leads.produto, usuarios.nome as agente, leads.cobranca as lcobranca'])
          ->join(['leads'],['usuarios'])
          ->on(
            ['financeiro_faturamento.id_lead','=','leads.id_lead'],
            ['financeiro_faturamento.id_user','=','usuarios.id_usuario'])
          ->wherecustom("financeiro_faturamento.id_user = '$atendente'  and financeiro_faturamento.tipo like 'extra_esporadico%' and data_agendada >= '$data_inicial' and data_agendada <= '$data_final'")
          ->get();
    
          $this->exportarboletos($filtroatendimento);    
  
          }

          if($tipo == 'atendimento_resumo'){

            echo 'relatorio ainda nao disponivel';
            exit;
            $data['consulta'] = (new Orm('vw_report_resumofaturadonatendente'))
            ->select(['*'])
            ->wherecustom("id_user = '$atendente' and data_agendada >= '$data_inicial' and data_agendada <= '$data_final'")
            ->get();       
           // print_r($data);
           // exit;
           
            ob_start();
            $this->loadview("leads/financeiro_report_faturamentoresumoatendente_pdf", $data);      
            //exit;
            $html = ob_get_contents();
            ob_end_clean();      
            $options = new Options();
            $options->set('isRemoteEnabled',true);
            $dompdf = new Dompdf($options);
            //$dompdf = new Dompdf();
            $dompdf->loadHtml($html);
            // Render the HTML as PDF
            $dompdf->setPaper('A4', 'portrait');
            $dompdf->render();
            $dompdf->stream("Letter",["Attachment" => false]);  
            }          

          if($tipo == 'atendimento_detalhe'){
            
            $filtroatendimentoapae = (new Orm('vw_leadsatendimentoapae'))
            ->select('*')
            ->where(['para', $atendente])
            ->between(['data','>=',$data_inicial],['data','<=', $data_final])
            ->get();  
            $this->exportarexcelatendimentoapae($filtroatendimentoapae);  
    
            }



  }
  



$this->loadTemplate('leads/relatorio_prod', $this->arr);
}

public function exportarexcelatendimentoapae($dadosatendimentoapae){
  // echo '<pre>';
  // print_r($dadosatendimentoapae);
  // exit;
 
 //Aqui começa a exportação
 $formato = 'Xlsx';//Xlsx - Xls - Csv
 $file = new Spreadsheet();
 $active_sheet = $file->getActiveSheet();
 
 $active_sheet->setCellValue('a1', 'Data');
 $active_sheet->setCellValue('b1', 'Vendedor');
 $active_sheet->setCellValue('c1', 'Funil');
 $active_sheet->setCellValue('d1', 'Data Entrada');
 $active_sheet->setCellValue('e1', 'Data Comentario');
 $active_sheet->setCellValue('f1', 'Data Fechamento');
 $active_sheet->setCellValue('g1', 'Nome');
 $active_sheet->setCellValue('h1', 'Telefone');
 $active_sheet->setCellValue('i1', 'E-mail');
 $active_sheet->setCellValue('j1', 'Produto');
 $active_sheet->setCellValue('k1', 'Origem');
 $active_sheet->setCellValue('l1', 'Cidade');
 $active_sheet->setCellValue('m1', 'Tipo');
 $active_sheet->setCellValue('n1', 'Texto');
 $active_sheet->setCellValue('o1', 'recebido');
 $active_sheet->setCellValue('p1', 'fpagamento');
 $active_sheet->setCellValue('q1', 'valor');
 $active_sheet->setCellValue('r1', 'valor_pago');
 $active_sheet->setCellValue('s1', 'valor_cancelado');
 $active_sheet->setCellValue('t1', 'data_agendada');
 $active_sheet->setCellValue('u1', 'funcionario');
 
 
 $count = 2;
 foreach($dadosatendimentoapae as $row){
 $produtor = (new Orm('usuarios'))->select(['nome'])
 ->where(['id_usuario', $row->para])->first()->get();
 
 if(!empty($produtor)){
   $prod = $produtor->nome;
 }else{
   $prod = 'Sem Produtor';
 }
 //echo $prod.'<br>';
 //exit;
 $active_sheet->setCellValue('a'.$count, $row->data ?? '');
 $active_sheet->setCellValue('b'.$count, $row->vendedor ?? '');
 $active_sheet->setCellValue('c'.$count, $row->nome_funil ?? '');
 $active_sheet->setCellValue('d'.$count, $row->data_entrada ?? '');
 $active_sheet->setCellValue('e'.$count, $row->data_comentario ?? '');
 $active_sheet->setCellValue('f'.$count, $row->data_fechamento ?? '');
 $active_sheet->setCellValue('g'.$count, $row->nome ?? '');
 $active_sheet->setCellValue('h'.$count, $row->telefone ?? '');
 $active_sheet->setCellValue('i'.$count, $row->email ?? '');
 $active_sheet->setCellValue('j'.$count, $row->produto ?? '');
 $active_sheet->setCellValue('k'.$count, $row->origem ?? '');
 $active_sheet->setCellValue('l'.$count, $row->cidade ?? '');
 $active_sheet->setCellValue('m'.$count, $row->tipo ?? '');
 $active_sheet->setCellValue('n'.$count, $row->texto ?? '');
 $active_sheet->setCellValue('o'.$count, $row->recebido ?? '');
 $active_sheet->setCellValue('p'.$count, $row->fpagamento ?? '');
 $active_sheet->setCellValue('q'.$count, $row->valor ?? '');
 $active_sheet->setCellValue('r'.$count, $row->valor_pago ?? '');
 $active_sheet->setCellValue('s'.$count, $row->valor_cancelado ?? '');
 $active_sheet->setCellValue('t'.$count, $row->data_agendada ?? '');
 $active_sheet->setCellValue('u'.$count, $row->funcionario ?? '');
 
 $count = $count +1;
 }
 
 $writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($file, $formato);
 
 $file_name = time().'.'.strtolower(($formato));
 $writer->save($file_name);
 header("Content-Type: application/x-www-form-urlencoded");
 header("Content-Transfer-Encoding:Binary");
 header("Content-disposition:attachment;filename=\"".$file_name."\"");
 readfile($file_name);
 unlink($file_name);
 exit;
 
 }//exportar atendimento apae

public function exportarboletos($dadosatendimento){
  $rl = new ReportFinanceiro();
 // echo '<pre>';
 // print_r($dadosatendimento);
 // exit;

//Aqui começa a exportação
$formato = 'Xlsx';//Xlsx - Xls - Csv
$file = new Spreadsheet();
$active_sheet = $file->getActiveSheet();

$active_sheet->setCellValue('a1', 'Cod Recibo');
$active_sheet->setCellValue('b1', 'Nome');
$active_sheet->setCellValue('c1', 'Produto');
$active_sheet->setCellValue('d1', 'Agente');
$active_sheet->setCellValue('e1', 'Anomes');
$active_sheet->setCellValue('f1', 'Data Agendada');
$active_sheet->setCellValue('g1', 'Valor a Receber');
$active_sheet->setCellValue('h1', 'Valor Recebido');
$active_sheet->setCellValue('i1', 'Valor Cancelado');
$active_sheet->setCellValue('j1', 'Valor Desconto');
$active_sheet->setCellValue('k1', 'Endereco');
$active_sheet->setCellValue('l1', 'Bairro');
$active_sheet->setCellValue('m1', 'Cidade');
$active_sheet->setCellValue('n1', 'Estado');
$active_sheet->setCellValue('o1', 'Cpf Cnpj');
$active_sheet->setCellValue('p1', 'Setor');
$active_sheet->setCellValue('q1', 'Funcionario');
$active_sheet->setCellValue('r1', 'Recebido');
$active_sheet->setCellValue('s1', 'Data Recebimento');
$active_sheet->setCellValue('t1', 'Data Faturamento');
$active_sheet->setCellValue('u1', 'Cobranca');
$active_sheet->setCellValue('v1', 'Impresso');
$active_sheet->setCellValue('w1', 'Confirmar Doacao');
$active_sheet->setCellValue('x1', 'Cod Antigo');


$count = 2;
foreach($dadosatendimento as $row){
/*$produtor = (new Orm('usuarios'))->select(['nome'])
->where(['id_usuario', $row->para])->first()->get();

if(!empty($produtor)){
  $prod = $produtor->nome;
}else{
  $prod = 'Sem Produtor';
}*/
//echo $prod.'<br>';
//exit;
$active_sheet->setCellValue('a'.$count, $row->nrecibo ?? '');
$active_sheet->setCellValue('b'.$count, $row->nome ?? '');
$active_sheet->setCellValue('c'.$count, $row->produto ?? '');
$active_sheet->setCellValue('d'.$count, $row->agente ?? '');
$active_sheet->setCellValue('e'.$count, $row->anomes ?? '');
$active_sheet->setCellValue('f'.$count, $row->data_agendada ?? '');
$active_sheet->setCellValue('g'.$count, $row->valor ?? '');
$active_sheet->setCellValue('h'.$count, $row->valor_pago ?? '');
$active_sheet->setCellValue('i'.$count, $row->valor_cancelado ?? '');
$active_sheet->setCellValue('j'.$count, $row->desconto ?? '');
$active_sheet->setCellValue('k'.$count, $row->endereco ?? '');
$active_sheet->setCellValue('l'.$count, $row->bairro ?? '');
$active_sheet->setCellValue('m'.$count, $row->cidade ?? '');
$active_sheet->setCellValue('n'.$count, $row->estado ?? '');
$active_sheet->setCellValue('o'.$count, $row->cpf_cnpj ?? '');
$active_sheet->setCellValue('p'.$count, $row->setor ?? '');
$active_sheet->setCellValue('q'.$count, $row->funcionario ?? '');
$active_sheet->setCellValue('r'.$count, $row->recebido ?? '');
$active_sheet->setCellValue('s'.$count, $row->data_recebimento ?? '');
$active_sheet->setCellValue('t'.$count, $row->data_faturamento ?? '');
$active_sheet->setCellValue('u'.$count, $row->cobranca ?? '');
$active_sheet->setCellValue('v'.$count, $row->impresso ?? '');
$active_sheet->setCellValue('w'.$count, $row->confirmardoacao ?? '');
$active_sheet->setCellValue('x'.$count, $row->id_importacao ?? '');

$count = $count +1;
}

$writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($file, $formato);

$file_name = time().'.'.strtolower(($formato));
$writer->save($file_name);
header("Content-Type: application/x-www-form-urlencoded");
header("Content-Transfer-Encoding:Binary");
header("Content-disposition:attachment;filename=\"".$file_name."\"");
readfile($file_name);
unlink($file_name);
exit;

}//exportar boletos

public function edit($id){
$this->arr['list_js'] = array(
  'plugins/sweetalert2',
  'plugins/jquery.mask.min',
  'plugins/parsley/parsley.min',
  'plugins/parsley/pt-br',
  'mask_init', 
  'system',
  'flatpickr/flatpickr',
  'flatpickr/pt',
  'flatpickr/flatpickr_init',
  'multiuploads'
  ); 

$this->arr['tipo'] = $this->user->getTipo();
$this->arr['produtos'] = (new Orm('produtos'))->select('*')->get();
$this->arr['bairros'] = (new Orm('financeiro_bairro'))->select('*')->get();
$this->arr['origens']  = (new Orm('origem_venda'))->select('*')->get();
$this->arr['anexos'] = (new Orm('leads'))->select('anexos')->where(['id_lead', $id])
->first()->get();

$this->arr['usuario_logado'] = $this->user->getId();
$l = new Leads();
$this->arr['colunas'] = $l->listaColunas();
$teste = $l->getCliente();
$cliente = $teste->nome;
$this->arr['cliente'] = $cliente;
$this->arr['id_lead'] = $id;

//$this->arr['info'] = (new Orm('leads'))->select('*')->where(['id_lead', $id])
//->first()->get();

$this->arr['info'] = $l->getLead($id);


$this->loadTemplate('leads/editar', $this->arr);
}//edit

public function pegacel(){
  $cel = $_POST['cel'];
 /*
  $celret = (new Orm('leads'))->select('*')
  ->join(['usuarios'])
  ->on(['leads.para','=','usuarios.id_usuario'])  
  ->where(['telefone', $cel])->first()->get();*/
  $l = new Leads();
  $celret = $l->pegacel($cel);

  echo json_encode($celret); 
  exit;
}

public function pegacpf(){
  $cpf = $_POST['cpf'];
 /*
  $celret = (new Orm('leads'))->select('*')
  ->join(['usuarios'])
  ->on(['leads.para','=','usuarios.id_usuario'])  
  ->where(['telefone', $cel])->first()->get();*/
  $l = new Leads();
  $celret = $l->pegacpf($cpf);

  echo json_encode($celret); 
  exit;
}

public function pegamatricula(){
  $matricula = $_POST['matricula'];
 /*
  $celret = (new Orm('leads'))->select('*')
  ->join(['usuarios'])
  ->on(['leads.para','=','usuarios.id_usuario'])  
  ->where(['telefone', $cel])->first()->get();*/
  $l = new Leads();
  $celret = $l->pegamatricula($matricula);

  echo json_encode($celret); 
  exit;
}

public function edit_action(){
$validator = new Validate();

if(isset($_POST)){

$nome = $_POST['nome'];
$produto = $_POST['produto'];

if(isset($_POST['email']) && !empty($_POST['email'])){
  $email = $_POST['email'];
}else{
  $email = '';
}

if(isset($_POST['telefone']) && !empty($_POST['telefone'])){
  $telefone = $_POST['telefone'];
}else{
  echo 'preencher numero de telefone';
  exit;
}

$obsn = $_POST['obsn'];
$cidade = $_POST['cidade'];
if(isset($_POST['codsocio']) && !empty($_POST['codsocio'])){
  $codsocio = $_POST['codsocio'];
}else{
  $codsocio = '';
}

//$codsocio = $_POST['codsocio'];
$codsistema = $_POST['codsistema'];
$id = $_POST['id_webform'];
$origem = $_POST['origem'];

$this->arr['anexos'] = (new Orm('leads'))->select('anexos')->where(['id_lead', $id])
->first()->get();

$l = new Leads();
$teste = $l->getCliente();
$cliente = $teste->nome;
$this->arr['cliente'] = $cliente;
$l = new Leads();
//echo $_POST['telefone'];
//exit;
$pegacel = $l->getcel($_POST['telefone']);
$modulo_boleto = $this->permissao->getPermissoesBoleto();
$modulo_whatsapp = $modulo_boleto->modulo_whatsapp;
$chave_botconversa = $modulo_boleto->chave_botconversa;
if( $modulo_whatsapp == 1){
  $telwhats = '+55'.str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$_POST['telefone']))));
  $nome = $_POST['nome'];
  $produto = $_POST['produto'];
  $data = [
    'phone' => $telwhats,
    'first_name' => $nome,
    'last_name' => $produto
  ];
  $dataheader = [
    'API-KEY' => $chave_botconversa,
    'Content-type' => 'application/json'
  ];    

// API URL
$url = 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/';

$payload = json_encode($data);
$payloadheader = json_encode($dataheader);
//print_r($payloadheader);
//exit;
$curl = curl_init();
curl_setopt_array($curl, [
  CURLOPT_URL => $url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POSTFIELDS=>$payload,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "POST",
  CURLOPT_HTTPHEADER => [
    "API-KEY: $chave_botconversa", 
    //"API-KEY: 00134073-cce6-4897-bcc1-42d6fb9f00fc", 
    //"API-KEY: 00134073-cce6-4897-bcc1-42d6fb9f00fc", 
    //"API-KEY: 7c33c5f1-8a21-4147-8d84-37b03f1cc98c",  
    "Content-type: application/json"
  ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);

$datax = json_decode($response);

 if(isset($datax->id) && !empty($datax->id)){
  $id_subscriber = $datax->id;
  $grava = (new Orm('leads'))->set(['id_subscriber'=>$id_subscriber])->where(['id_lead', $id])->update();
 }

 $telefoneget = '+55'.str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$_POST['telefone']))));
 // /subscriber/get_by_phone/{phone}/
 $data = [
  'phone' => $telefoneget
];
$dataheader = [
  'API-KEY' => $chave_botconversa,
  'Content-type' => 'application/json'
];    

// API URL
$url = 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/get_by_phone/'.$telefoneget.'/';

$payload = json_encode($data);
$payloadheader = json_encode($dataheader);
//print_r($payloadheader);
//exit;
$curl = curl_init();
curl_setopt_array($curl, [
CURLOPT_URL => $url,
CURLOPT_RETURNTRANSFER => true,
CURLOPT_POSTFIELDS=>$payload,
CURLOPT_ENCODING => "",
CURLOPT_MAXREDIRS => 10,
CURLOPT_TIMEOUT => 30,
CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
CURLOPT_CUSTOMREQUEST => "GET",
CURLOPT_HTTPHEADER => [
  "API-KEY: $chave_botconversa", 
  //"API-KEY: 00134073-cce6-4897-bcc1-42d6fb9f00fc", 
  //"API-KEY: 7c33c5f1-8a21-4147-8d84-37b03f1cc98c",  
  "Content-type: application/json"
],
]);

$responseg = curl_exec($curl);
$err = curl_error($curl);

$dataxg = json_decode($responseg);

if(isset($dataxg->id) && !empty($dataxg->id)){
$id_lead = $id;
$id_subscriber = $dataxg->id;
$id_whats = $dataxg->id;
$grava = (new Orm('leads'))->set(['id_subscriber'=>$id_subscriber])->where(['id_lead', $id_lead])->update();
}else{
$id_whats = $_POST['id_whats'];
}

}

if($pegacel['total'] >1 && $cliente != 'UPA Piracicaba'){
  //print_r($pegacel);
  echo 'Telefone ja cadastrado verifique com o Coordenador.';
  exit;
}else{

if($cliente == 'Apae Piracicaba'){ 
  $l = new Leads();
  $vlr = $_POST['vlr'];
  $dia = $_POST['dia'];

  $tipo = $this->user->getTipo();
  
  if($tipo == 'Super Admin' || $tipo == 'Produtor'){
  $cpf_cnpj = $_POST['cpf_cnpj'];
  $cobranca = $_POST['cobranca'];
  $end_cli = $_POST['end_cli'];
  $n_cli = $_POST['n_cli'];
  $bairro_cli = $_POST['bairro_cli'];
  $complemento_cli = $_POST['complemento_cli'];
  $cep_cli = $_POST['cep_cli'];
  $dsc_localidade = $_POST['dsc_localidade'];
  $dsc_sigla = $_POST['dsc_sigla'];
  $nme_funcionario = $_POST['nme_funcionario'];
  $dsc_setor = $_POST['dsc_setor'];
  $cdg_setor = $_POST['cdg_setor'];
  $telefone2 = $_POST['telefone2'];
  $telefone3 = $_POST['telefone3'];
  $update = $l->editapaeadmin($id,$nome,$produto,$email,$telefone,$obsn,$cidade,$codsocio,$codsistema,$origem,$vlr,$cobranca,$end_cli,$n_cli,$bairro_cli,$complemento_cli,$cep_cli,$dsc_localidade,$dsc_sigla,$nme_funcionario,$dsc_setor,$cdg_setor,$telefone2,$telefone3,$dia,$cpf_cnpj);
  }else{
  $update = $l->editapae($id,$nome,$produto,$email,$telefone,$obsn,$cidade,$codsocio,$codsistema,$origem,$vlr);
  };
  
}else{

  if($cliente == 'FIP Corp'){ 
    $l = new Leads();
   // $vlr = $_POST['vlr'];
   // $dia = $_POST['dia'];
  
    $tipo = $this->user->getTipo();
    //if($tipo == 'Super Admin' || $tipo == 'Produtor'){
    $cpf_cnpj = $_POST['cpf_cnpj'];
    $resp_empresa = $_POST['resp_empresa'];
    $resp_empresa_cpf = $_POST['resp_empresa_cpf'];
    $resp_empresa_email = $_POST['resp_empresa_email'];
    $resp_tecnico = $_POST['resp_tecnico'];
    $resp_tecnico_cpf = $_POST['resp_tecnico_cpf'];
    $resp_tecnico_email = $_POST['resp_tecnico_email'];
    $telefone2 = $_POST['telefone2'];
    $end_cli = $_POST['end_cli'];
    $n_cli = $_POST['n_cli'];
    $bairro_cli = $_POST['bairro_cli'];
    $dsc_localidade = $_POST['cidade'];
    $dsc_sigla = $_POST['dsc_sigla'];
    $complemento_cli = $_POST['complemento_cli'];
    $cep_cli = $_POST['cep_cli'];

    $update = $l->editfipadmin($id,$nome,$produto,$telefone,$obsn,$cidade,$codsistema,$origem,$resp_empresa,$resp_empresa_cpf,$end_cli,$n_cli,$bairro_cli,$complemento_cli,$cep_cli,$dsc_localidade,$dsc_sigla,$resp_empresa_email,$resp_tecnico,$resp_tecnico_cpf,$resp_tecnico_email,$telefone2,$cpf_cnpj);
    //}else{
    //$update = $l->editapae($id,$nome,$produto,$email,$telefone,$obsn,$cidade,$codsocio,$codsistema,$origem,$vlr);
    //};
  }else{
    $telefone2 = $_POST['telefone2'];
    $telefone3 = $_POST['telefone3'];
  $l = new Leads();
  if($cliente == 'UPA Piracicaba'){ 
    $updateupa = $l->editupa($id,$nome,$produto,$email,$telefone,$telefone2,$telefone3,$obsn,$cidade,$codsocio,$codsistema,$origem);  
  }else{

    if($cliente == 'Cartao de Todos Piracicaba'){ 
      $situacao_pv = $_POST['situacao_pv'];


    if($situacao_pv == 'Enviar Link Cartao'){
      $chave_botconversa = 'd239fdb6-33f4-4c67-aee5-f86cbb0effcd';
      $id = $_POST['id_webform'];
      $campanha = '4129394';
    }

    if($situacao_pv == 'Enviar Link Cartao Adimplencia'){
      $chave_botconversa = 'd239fdb6-33f4-4c67-aee5-f86cbb0effcd';
      $id = $_POST['id_webform'];
      $campanha = '4178885';
    }
    
    if($situacao_pv == 'Enviar Link Cartao' || $situacao_pv == 'Enviar Link Cartao Adimplencia'){

      $telwhats = '+55'.str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$_POST['telefone']))));
      $nome = $_POST['nome'];
      $produto = $_POST['produto'];
      $data = [
        'phone' => $telwhats,
        'first_name' => $nome,
        'last_name' => $produto
      ];
      $dataheader = [
        'API-KEY' => $chave_botconversa,
        'Content-type' => 'application/json'
      ];    
    
    // API URL
    $url = 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/';
    
    $payload = json_encode($data);
    $payloadheader = json_encode($dataheader);
    $curl = curl_init();
    curl_setopt_array($curl, [
      CURLOPT_URL => $url,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_POSTFIELDS=>$payload,
      CURLOPT_ENCODING => "",
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 30,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => "POST",
      CURLOPT_HTTPHEADER => [
        "API-KEY: $chave_botconversa", 
        "Content-type: application/json"
      ],
    ]);
    
    $response = curl_exec($curl);
    $err = curl_error($curl);
    
    $datax = json_decode($response);
    
     if(isset($datax->id) && !empty($datax->id)){
      $id_subscriber = $datax->id;
      $grava = (new Orm('leads'))->set(['id_subscriber'=>$id_subscriber])->where(['id_lead', $id])->update();
     }
    
     $telefoneget = '+55'.str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$_POST['telefone']))));
     // /subscriber/get_by_phone/{phone}/
     $data = [
      'phone' => $telefoneget
    ];
    $dataheader = [
      'API-KEY' => $chave_botconversa,
      'Content-type' => 'application/json'
    ];    
    
    // API URL
    $url = 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/get_by_phone/'.$telefoneget.'/';
    
    $payload = json_encode($data);
    $payloadheader = json_encode($dataheader);
    //print_r($payloadheader);
    //exit;
    $curl = curl_init();
    curl_setopt_array($curl, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POSTFIELDS=>$payload,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "GET",
    CURLOPT_HTTPHEADER => [
      "API-KEY: $chave_botconversa", 
      "Content-type: application/json"
    ],
    ]);
    
    $responseg = curl_exec($curl);
    $err = curl_error($curl);
    
    $dataxg = json_decode($responseg);
    
    if(isset($dataxg->id) && !empty($dataxg->id)){
    $id_lead = $id;
    $id_subscriber = $dataxg->id;
    $id_whats = $dataxg->id;
    $grava = (new Orm('leads'))->set(['id_subscriber'=>$id_subscriber])->where(['id_lead', $id_lead])->update();
    }else{
    $id_whats = $_POST['id_whats'];
    }
      
      $data = [
        'flow' => $campanha
      ];
      $dataheader = [
        'API-KEY' => $chave_botconversa,
        'Content-type' => 'application/json'
      ];    
    $payload = json_encode($data);
    $headerjson = json_encode($dataheader);
  
     $curl = curl_init();
  
      curl_setopt_array($curl, array(
      CURLOPT_URL => 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/'.$id_whats.'/send_flow/',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS =>$payload,
      CURLOPT_HTTPHEADER => [
        "API-KEY: $chave_botconversa", 
        //"API-KEY: 7c33c5f1-8a21-4147-8d84-37b03f1cc98c",  
        "Content-type: application/json"
      ],
      ));
  
      $response = curl_exec($curl);
      curl_close($curl);


    }


      $fp_agencia ='';
      $fp_conta = '';
      $fp_cartao_nome = '';
      $fp_cartao_numero = '';
      $fp_cartao_cseguranca = '';
      $fp_cartao_validade = '';
      $fp_cartao_bandeira = '';
      $fp_energia_uc ='';
      $fp_energia_pn = '';

      $acao = $_POST['acao'];
      $horario = $_POST['horario'];
      $data_nascimento = $_POST['data_nascimento'];
      $rg = $_POST['rg'];
      $estado_civil = $_POST['estado_civil'];
      $adesao = $_POST['adesao'];
    
      if(isset($_POST['Financeiro'])){
        $resp_nome = $_POST['nome'];
        $resp_cpf = $_POST['codsocio'];
        $resp_rg = $_POST['rg'];
        $resp_data_nascimento = $_POST['data_nascimento'];
        $resp_telefone = $_POST['telefone'];               
     
        //echo 'checked';
        //exit;
      }else{
        $resp_nome = $_POST['resp_nome'];
        $resp_cpf = $_POST['resp_cpf'];
        $resp_rg = $_POST['resp_rg'];
        $resp_data_nascimento = $_POST['resp_data_nascimento'];
        $resp_telefone = $_POST['resp_telefone']; 
        //echo 'unchecked';
        //exit;
      }

      $cep_cli = $_POST['cep_cli'];
      $end_cli = $_POST['end_cli'];
      $n_cli = $_POST['n_cli'];
      $bairro_cli = $_POST['bairro_cli'];
      $complemento_cli = $_POST['complemento_cli'];
      $cidade_cli = $_POST['cidade_cli'];
      $estado_cli = $_POST['estado_cli'];
      $fp_anual_meio_pagamento = $_POST['fp_anual_meio_pagamento'];
      $forma_pagamento = $_POST['forma_pagamento'];
      if($forma_pagamento == 'Bradesco'){
        $fp_agencia = $_POST['fpbradesco_fp_agencia'];
        $fp_conta = $_POST['fpbradesco_fp_conta'];
      }
      if($forma_pagamento == 'Caixa Economica Federal'){
        $fp_agencia = $_POST['fpcaixa_fp_agencia'];
        $fp_conta = $_POST['fpcaixa_fp_conta'];
      }      
      if($forma_pagamento == 'Itau'){
        $fp_agencia = $_POST['fpitau_fp_agencia'];
        $fp_conta = $_POST['fpitau_fp_conta'];
      }       
      if($forma_pagamento == 'Santander'){
        $fp_agencia = $_POST['fpsantander_fp_agencia'];
        $fp_conta = $_POST['fpsantander_fp_conta'];
      }  
      if($forma_pagamento == 'Sicoob'){
        $fp_agencia = $_POST['fpssicoob_fp_agencia'];
        $fp_conta = $_POST['fpssicoob_fp_conta'];
      }  
      if($forma_pagamento == 'Sicoob - PJ'){
        $fp_agencia = $_POST['fpssicoobpj_fp_agencia'];
        $fp_conta = $_POST['fpssicoobpj_fp_conta'];
      }  
     
      if($forma_pagamento == 'Cartao de Credito'){
        $fp_cartao_nome = $_POST['fpcredito_fp_cartao_nome'];
        $fp_cartao_numero = $_POST['fpcredito_fp_cartao_numero'];
        $fp_cartao_cseguranca = $_POST['fpcredito_fp_cartao_cseguranca'];
        $fp_cartao_validade = $_POST['fpcredito_fp_cartao_validade'];
        $fp_cartao_bandeira = $_POST['fpcredito_fp_cartao_bandeira'];
   
      }
      if($forma_pagamento == 'Cartao de Debito'){
        $fp_cartao_nome = $_POST['fpdebito_fp_cartao_nome'];
        $fp_cartao_numero = $_POST['fpdebito_fp_cartao_numero'];
        $fp_cartao_cseguranca = $_POST['fpdebito_fp_cartao_cseguranca'];
        $fp_cartao_validade = $_POST['fpdebito_fp_cartao_validade'];
        $fp_cartao_bandeira = $_POST['fpdebito_fp_cartao_bandeira'];
   
      }

      if($forma_pagamento == 'CPFL'){
        $fp_energia_uc = $_POST['fpcpfl_fp_energia_uc'];
        $fp_energia_pn = $_POST['fpcpfl_fp_energia_pn'];
      }
      if($forma_pagamento == 'EDP'){
        $fp_energia_uc = $_POST['fpedp_fp_energia_uc'];
        $fp_energia_pn = $_POST['fpedp_fp_energia_pn'];
      }
      if($forma_pagamento == 'ELEKTRO'){
        $fp_energia_uc = $_POST['fpelektro_fp_energia_uc'];
      }

      if($forma_pagamento == 'ENEL'){
        $fp_energia_uc = $_POST['fpenel_fp_energia_uc'];
      }

      if($forma_pagamento == 'ENERGISA'){
        $fp_energia_pn = $_POST['fpenergisa_fp_energia_pn'];
      }
      if($forma_pagamento == 'Neoenergia'){
        $fp_energia_uc = $_POST['fpneoenergia_fp_energia_uc'];
        $fp_energia_pn = $_POST['fpneoenergia_fp_energia_pn'];
      }

      $fp_operacao = $_POST['fp_operacao'];
      $fp_cartao_tipo = $_POST['fp_cartao_tipo'];
      $fp_cartao_banco = $_POST['fp_cartao_banco'];
      $fp_razaosocial = $_POST['fp_razaosocial'];
      $fp_cnpj = $_POST['fp_cnpj'];


      //echo $fp_agencia.$fp_conta;
      //exit;
      //$id_lead = $id;
/*
      echo '<pre>';
      echo 'anexos;';print_r($_POST['anexos']);
      echo 'multiplo;';print_r($_POST['mutiplo_upload']);
      echo 'anexoview;';print_r($_POST['anexosview']);
      print_r($this->arr['anexos']);
      exit;
*/
      if($_POST['anexos'] != '' && $_POST['anexos'] != NULL){
        $id_lead = $id;
        //$id_lead = $_POST['id_lead'];
        $files = '';
        $anexos = $_POST['anexos'];
        $anexosname = $_POST['mutiplo_upload'];
        $dados = array();


          if($_POST['anexosview'] != ''){
            $old = (new Orm('leads'))->select(['anexos'])
            ->where(['id_lead', $id_lead])->first()->get(); 
            $arquivo = json_decode($old->anexos, true);
           //print_r($arquivo);
           // exit;
            foreach($arquivo as $arq){
              array_push($dados, $arq);  
            }
            $novos = $this->gravaAnexos($anexos,$anexosname,$id_lead);
            $files = json_decode($novos['files'], true);
            foreach($files as $file){
              array_push($dados, $file);
            }
             $dados = json_encode($dados);     
             $files = $dados;
          }else{
            $files = $this->gravaAnexos($anexos,$anexosname,$id_lead);  
            $files = $files['files'];
          };   
     


          $grava = (new Orm('leads'))->set(['anexos'=>$files])->where(['id_lead', $id_lead])->update();
      };      

      $update = $l->editcartaodetodos($id,$nome,$produto,$email,$telefone,$telefone2,$telefone3,$obsn,$cidade,$codsocio,$codsistema,$origem,$situacao_pv,$acao,$horario,$data_nascimento,$rg,$estado_civil,$adesao,$resp_nome,$resp_cpf,$resp_rg,$resp_data_nascimento,$resp_telefone,$cep_cli,$end_cli,$n_cli,$bairro_cli,$complemento_cli,$cidade_cli,$estado_cli,$fp_anual_meio_pagamento,$fp_operacao,$fp_agencia,$fp_conta,$fp_cartao_nome,$fp_cartao_numero,$fp_cartao_cseguranca,$fp_cartao_tipo,$fp_cartao_banco,$fp_energia_uc,$fp_energia_pn,$fp_razaosocial,$fp_cnpj,$forma_pagamento,$fp_cartao_validade,$fp_cartao_bandeira);  


    }else{
      $update = $l->edit($id,$nome,$produto,$email,$telefone,$telefone2,$telefone3,$obsn,$cidade,$codsocio,$codsistema,$origem);  
    }


  }
  
  }
}



//exit;
/*$p = $_POST;
$form = [];

foreach($p as $key=>$input){
  if($key != 'id_webform'){
    @$form[$key] .= 'required';
  }
}

$validate = $validator->validate($form,true);
$grava = (new Orm('leads'))->set($validate)
->where(['id_lead', $p['id_webform']])->update();
*/
//echo 'aaaa';
//exit;

$_SESSION['msg'] = ['type'=>'success','msg'=>'Lead Atualizado com sucesso!'];
header("Location:".BASE_URL."leads");
exit;
}
}
}//edit_ action

public function atribuir_lead(){
  $modulo_boleto = $this->permissao->getPermissoesBoleto();
  $chave_botconversa = $modulo_boleto->chave_botconversa;
  $modulo_whatsapp = $modulo_boleto->modulo_whatsapp;
  if($modulo_whatsapp == 1){
    $id_manager = $_POST['id_manager'];
    $id_subscriber = $_POST['id_subscriber'];
    $enviawhats = $_POST['enviawhats'];
    $nome = $_POST['nome'];
    $produto = $_POST['produto'];

    $telwhats = '+55'.str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$_POST['enviawhats']))));
    $nome = $_POST['nome'];
    $produto = $_POST['produto'];
    $data = [
      'phone' => $telwhats,
      'first_name' => $nome,
      'last_name' => $produto
    ];
    $dataheader = [
      'API-KEY' => $chave_botconversa,
      'Content-type' => 'application/json'
    ];    
  
  // API URL
  $url = 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/';
  
  $payload = json_encode($data);
  $payloadheader = json_encode($dataheader);
  //print_r($payloadheader);
  //exit;
  $curl = curl_init();
  curl_setopt_array($curl, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POSTFIELDS=>$payload,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_HTTPHEADER => [
      "API-KEY: $chave_botconversa", 
      //"API-KEY: 00134073-cce6-4897-bcc1-42d6fb9f00fc", 
      //"API-KEY: 7c33c5f1-8a21-4147-8d84-37b03f1cc98c",  
      "Content-type: application/json"
    ],
  ]);
  
  $response = curl_exec($curl);
  $err = curl_error($curl);
  
  $datax = json_decode($response);
  
   if(isset($datax->id) && !empty($datax->id)){
    $id_lead = $_POST['id_lead'];
    $id_subscriber = $datax->id;
    $id_whats = $datax->id;
    $grava = (new Orm('leads'))->set(['id_subscriber'=>$id_subscriber])->where(['id_lead', $id_lead])->update();
   }else{
    $id_whats = $_POST['enviawhats'];
    $id_subscriber = $_POST['id_subscriber'];
   }
   $telefoneget = '+55'.str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$_POST['enviawhats']))));
   // /subscriber/get_by_phone/{phone}/
   $data = [
    'phone' => $telefoneget
  ];
  $dataheader = [
    'API-KEY' => $chave_botconversa,
    'Content-type' => 'application/json'
  ];    

// API URL
$url = 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/get_by_phone/'.$telefoneget.'/';

$payload = json_encode($data);
$payloadheader = json_encode($dataheader);
//print_r($payloadheader);
//exit;
$curl = curl_init();
curl_setopt_array($curl, [
  CURLOPT_URL => $url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POSTFIELDS=>$payload,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "GET",
  CURLOPT_HTTPHEADER => [
    "API-KEY: $chave_botconversa", 
    //"API-KEY: 00134073-cce6-4897-bcc1-42d6fb9f00fc", 
    //"API-KEY: 7c33c5f1-8a21-4147-8d84-37b03f1cc98c",  
    "Content-type: application/json"
  ],
]);

$responseg = curl_exec($curl);
$err = curl_error($curl);

$dataxg = json_decode($responseg);

 if(isset($dataxg->id) && !empty($dataxg->id)){
  $id_lead = $_POST['id_lead'];
  $id_subscriber = $dataxg->id;
  $id_whats = $dataxg->id;
  $grava = (new Orm('leads'))->set(['id_subscriber'=>$id_subscriber])->where(['id_lead', $id_lead])->update();
 }else{
  $id_whats = $_POST['enviawhats'];
  $id_subscriber = $_POST['id_subscriber'];
 }


    
  // API URL /subscriber/{subscriber_id}/change_conversation_status/
  $data = [
    'open_conversation' => true,
    'manager' => $id_manager
  ];
  $dataheader = [
    'API-KEY' => $chave_botconversa,
    'Content-type' => 'application/json'
  ];    
  //echo $id_subscriber;
  //exit;
// API URL
$url = 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/'.$id_subscriber.'/change_conversation_status/';

$payload = json_encode($data);
$payloadheader = json_encode($dataheader);

//print_r($payload);
//exit;
$curl = curl_init();
curl_setopt_array($curl, [
  CURLOPT_URL => $url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POSTFIELDS=>$payload,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "POST",
  CURLOPT_HTTPHEADER => [
    "API-KEY: $chave_botconversa", 
    //"API-KEY: 00134073-cce6-4897-bcc1-42d6fb9f00fc", 
    //"API-KEY: 7c33c5f1-8a21-4147-8d84-37b03f1cc98c",  
    "Content-type: application/json"
  ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);
print_r($response);
exit; 
  }

}

public function add_coment(){
$validator = new Validate();
$validates = array();
$existecom = array();
//echo 'tipo='.$_POST['id_lead'];
//exit;
//echo '<pre>';
//echo 'aqui';
//exit;
//$id_lead = $_POST['id_lead'];
//echo $id_lead;
$modulo_boleto = $this->permissao->getPermissoesBoleto();
$chave_botconversa = $modulo_boleto->chave_botconversa;
$modulo_whatsapp = $modulo_boleto->modulo_whatsapp;

//echo $modulo_whatsapp;
//exit;
$data = date('Y-m-d');
$datah = ' '.date('H').':';
$datam = date('i');

if($datam == '59'){
  $datah = ' '.(date('H')+1).':';
  $datam = (date('i')+1);
}

$agorai = $data.$datah.$datam.':00';
$agoraf = $data.$datah.$datam.':59';
//echo $agorai.'<br>';
//echo $agoraf.'<br>';

$leadsn = new Leads();
$id_lead = $_POST['id_lead'];
$existecom = $leadsn->existecom($agorai,$agoraf,$id_lead);
//print_r($existecom);
//exit;
if($existecom == 0){
  //echo 'sem registro pode salvar';
if($modulo_whatsapp == 1){
  if(isset($_POST['campanha_whats']) && !empty($_POST['campanha_whats'])){
    $data_atual = date('Y-m-d');
   // echo $_POST['campanha_whats'];
    
    if($_POST['campanha_whats'] == '2829397'){
      $up = (new Orm('leads'))->set(['funil_id'=>'15'])
      ->where(['id_lead', $id_lead])->update();
      $telwhats = str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$_POST['enviawhats']))));
      $nome = $_POST['nome'];
      $faa = $_POST['faa'];
      $data_atend = $_POST['data_atend'];
      $prof_medico = $_POST['prof_medico'];
      $telepara = $this->user->getId();
      $origempesquisa = 'whatsapp';      
    
      $grava = (new Orm('leads_pesquisa'))->set(['unidade'=>'UPA VILA CRISTINA','data_envio'=>$data_atual,'situacao'=>'ENVIADO','telefone'=>$telwhats,'nome'=>$nome,'faa'=>$faa,'data_atend'=>$data_atend,'prof_medico'=>$prof_medico,'telepara'=>$telepara,'origempesquisa'=>$origempesquisa])->save();
      //echo 'vila cristina';
      }
      //2829397

      if($_POST['campanha_whats'] == '2830876'){
        $up = (new Orm('leads'))->set(['funil_id'=>'14'])
        ->where(['id_lead', $id_lead])->update();
        $telwhats = str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$_POST['enviawhats']))));
        $nome = $_POST['nome'];
        $faa = $_POST['faa'];
        $data_atend = $_POST['data_atend'];
        $prof_medico = $_POST['prof_medico'];    
        $telepara = $this->user->getId();
        $origempesquisa = 'whatsapp';             
    
        $grava = (new Orm('leads_pesquisa'))->set(['unidade'=>'UPA VILA SONIA','data_envio'=>$data_atual,'situacao'=>'ENVIADO','telefone'=>$telwhats,'nome'=>$nome,'faa'=>$faa,'data_atend'=>$data_atend,'prof_medico'=>$prof_medico,'telepara'=>$telepara,'origempesquisa'=>$origempesquisa])->save();
       // echo 'vila sonia';
      }

      //echo 'aqui';
      //exit;


    $telwhats = '+55'.str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$_POST['enviawhats']))));
    $nome = $_POST['nome'];
    $produto = $_POST['produto'];
    $data = [
      'phone' => $telwhats,
      'first_name' => $nome,
      'last_name' => $produto
    ];
    $dataheader = [
      'API-KEY' => $chave_botconversa,
      'Content-type' => 'application/json'
    ];    
  
  // API URL
  $url = 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/';
  
  $payload = json_encode($data);
  $payloadheader = json_encode($dataheader);
  //print_r($payloadheader);
  //exit;
  $curl = curl_init();
  curl_setopt_array($curl, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POSTFIELDS=>$payload,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_HTTPHEADER => [
      "API-KEY: $chave_botconversa", 
      //"API-KEY: 00134073-cce6-4897-bcc1-42d6fb9f00fc", 
      //"API-KEY: 7c33c5f1-8a21-4147-8d84-37b03f1cc98c",  
      "Content-type: application/json"
    ],
  ]);
  
  $response = curl_exec($curl);
  $err = curl_error($curl);
  
  //$datax = json_decode($response);
  //print_r($data_x);
  //exit;
  
   if(isset($datax->id) && !empty($datax->id)){
    $id_lead = $_POST['id_lead'];
    $id_subscriber = $datax->id;
    $id_whats = $datax->id;
    $grava = (new Orm('leads'))->set(['id_subscriber'=>$id_subscriber])->where(['id_lead', $id_lead])->update();
   }else{
    $id_whats = $_POST['id_whats'];
   }
   $telefoneget = '+55'.str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$_POST['enviawhats']))));
   // /subscriber/get_by_phone/{phone}/
   $data = [
    'phone' => $telefoneget
  ];
  $dataheader = [
    'API-KEY' => $chave_botconversa,
    'Content-type' => 'application/json'
  ];    


$url = 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/get_by_phone/'.$telefoneget.'/';

$payload = json_encode($data);
$payloadheader = json_encode($dataheader);
$curl = curl_init();
curl_setopt_array($curl, [
  CURLOPT_URL => $url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POSTFIELDS=>$payload,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "GET",
  CURLOPT_HTTPHEADER => [
    "API-KEY: $chave_botconversa", 
    //"API-KEY: 00134073-cce6-4897-bcc1-42d6fb9f00fc", 
    //"API-KEY: 7c33c5f1-8a21-4147-8d84-37b03f1cc98c",  
    "Content-type: application/json"
  ],
]);

$responseg = curl_exec($curl);
$err = curl_error($curl);

$dataxg = json_decode($responseg);

 if(isset($dataxg->id) && !empty($dataxg->id)){
  $id_lead = $_POST['id_lead'];
  $id_subscriber = $dataxg->id;
  $id_whats = $dataxg->id;
  $grava = (new Orm('leads'))->set(['id_subscriber'=>$id_subscriber])->where(['id_lead', $id_lead])->update();
 }else{
  $id_whats = $_POST['id_whats'];
 }



    $campanha = $_POST['campanha_whats'];
    //$id_whats = $_POST['id_whats'];
    $data = [
      'flow' => $campanha
    ];
    $dataheader = [
      'API-KEY' => $chave_botconversa,
      'Content-type' => 'application/json'
    ];    
  $payload = json_encode($data);
  $headerjson = json_encode($dataheader);

  // print_r($payload);
  // print_r($headerjson);
  // exit;
    //echo $id_whats;
   // exit;/subscriber/{subscriber_id}/send_flow/
    $curl = curl_init();

    curl_setopt_array($curl, array(
    CURLOPT_URL => 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/'.$id_whats.'/send_flow/',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'POST',
    CURLOPT_POSTFIELDS =>$payload,
    CURLOPT_HTTPHEADER => [
      "API-KEY: $chave_botconversa", 
      //"API-KEY: 7c33c5f1-8a21-4147-8d84-37b03f1cc98c",  
      "Content-type: application/json"
    ],
    ));

    $response = curl_exec($curl);
    curl_close($curl);

  }

}

}else{
  echo 'registro ja salvo clique em voltar';
  exit;
}

if(isset($_POST['texto']) && !empty($_POST['texto'])){

  if($_POST['tipo'] == 'mensagem'){
    //echo 'aqui mensagem';
    //exit;
    $modulo_boleto = $this->permissao->getPermissoesBoleto();
    $chave_botconversa = $modulo_boleto->chave_botconversa;
    $modulo_whatsapp = $modulo_boleto->modulo_whatsapp;
    //echo $modulo_whatsapp;
    //exit;
    if($modulo_whatsapp == 1){
          
   //echo 'aqui mensagem';
   //exit;
  
    $telwhats = '+55'.str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$_POST['enviawhats']))));
    $nome = $_POST['nome'];
    $produto = $_POST['produto'];
    $data = [
      'phone' => $telwhats,
      'first_name' => $nome,
      'last_name' => $produto
    ];
    $dataheader = [
      'API-KEY' => $chave_botconversa,
      'Content-type' => 'application/json'
    ];    
  
  // API URL
  $url = 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/';
  
  $payload = json_encode($data);
  $payloadheader = json_encode($dataheader);
  //print_r($payload);
  //exit;
  $curl = curl_init();
  curl_setopt_array($curl, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POSTFIELDS=>$payload,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_HTTPHEADER => [
      "API-KEY: $chave_botconversa", 
      "Content-type: application/json"
    ],
  ]);
  
  $response = curl_exec($curl);
  $err = curl_error($curl);
  
  $datax = json_decode($response);
  
   if(isset($datax->id) && !empty($datax->id)){
    $id_lead = $_POST['id_lead'];
    $id_subscriber = $datax->id;
    $id_whats = $datax->id;
    $grava = (new Orm('leads'))->set(['id_subscriber'=>$id_subscriber])->where(['id_lead', $id_lead])->update();
   }else{
    $id_whats = $_POST['id_whats'];
   }

   $atendimento_automatico = $_POST['atendimento_automatico_whats'];
   $id_subscriber = $id_whats;
   //echo 'id'. $id_whats;
   //exit;
$l = new Leads();
$teste = $l->getCliente();
$cliente = $teste->nome;

if($cliente == 'i9 Doctor Prime'){
  $id_automatico = '1367525';
}
if($cliente == 'Clique Responde'){
  $id_automatico = '1367449';
}

if($cliente != 'Clique Responde' && $cliente != 'i9 Doctor Prime'){
  $id_automatico = '';
}
//echo $cliente;
//  exit;
   $data = [
     'value' => $atendimento_automatico
   ];
   $dataheader = [
     'API-KEY' => $chave_botconversa,
     'Content-type' => 'application/json'
   ];    
 
 // API URL
 $url = 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/'.$id_whats.'/custom_fields/'.$id_automatico.'/';
 
 $payload = json_encode($data);
 $payloadheader = json_encode($dataheader);
 //print_r($payloadheader);
 //exit;
 $curl = curl_init();
 curl_setopt_array($curl, [
   CURLOPT_URL => $url,
   CURLOPT_RETURNTRANSFER => true,
   CURLOPT_POSTFIELDS=>$payload,
   CURLOPT_ENCODING => "",
   CURLOPT_MAXREDIRS => 10,
   CURLOPT_TIMEOUT => 30,
   CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
   CURLOPT_CUSTOMREQUEST => "POST",
   CURLOPT_HTTPHEADER => [
     "API-KEY: $chave_botconversa", 
     //"API-KEY: 00134073-cce6-4897-bcc1-42d6fb9f00fc", 
     //"API-KEY: 7c33c5f1-8a21-4147-8d84-37b03f1cc98c",  
     "Content-type: application/json"
   ],
 ]);
 
 $response = curl_exec($curl);
 $err = curl_error($curl);


    $texto = $_POST['texto'];
    //$id_whats = $_POST['id_whats'];
    $data = [
      'type' => 'text',
      'value' => $texto
    ];
    $dataheader = [
      'API-KEY' => $chave_botconversa,
      'Content-type' => 'application/json'
    ];    
  $payload = json_encode($data);
  $headerjson = json_encode($dataheader);

    //print_r($payload);
    //print_r($headerjson);
    //exit;
    //echo $id_whats;
    //exit;
    $curl = curl_init();

    curl_setopt_array($curl, array(
    CURLOPT_URL => 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/'.$id_whats.'/send_message/',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'POST',
    CURLOPT_POSTFIELDS =>$payload,
    CURLOPT_HTTPHEADER => [
      "API-KEY: $chave_botconversa", 
      //"API-KEY: 00134073-cce6-4897-bcc1-42d6fb9f00fc", 
      //"API-KEY: 7c33c5f1-8a21-4147-8d84-37b03f1cc98c",  
      "Content-type: application/json"
    ],
    ));

    $response = curl_exec($curl);
    curl_close($curl);
    };
    }
    //echo $response;
    //echo 'aqui';
    //exit;
}

if(isset($_POST['texto']) && !empty($_POST['texto'])){
$user = $this->user->getId();
$stt = 'definido:agendada';
if($_POST['tipo'] == 'comentario'){
$stt = 'null';
}

$validate = $validator->validate([
'id_lead'=>'definido:'.$_POST['id_lead'],
'id_user'=>'definido:'.$user,
'tipo'=>'null',
'texto'=>'required',
'status_tarefa'=>$stt,
'data_agendamento'=>'null|data',
'hora_agendamento'=>'null|hora',
'finalizado'=>'definido:N'
//'anexos'=>'null|anexos',
],true);

/*if(!$validate){
$_SESSION['msg'] = ['type'=>'error','msg'=>'Ooops... Alguns campos estão inválidos, tente novamente'];
 unset($_SESSION['flash']);
 unset($_SESSION['old']);
 if(isset($_GET['f']) && !empty($_GET['f'])){
  header("Location:".BASE_URL."leads/view/".$_POST['id_lead']/"?f=s");
  exit;   
  }else{
  header("Location:".BASE_URL."leads/view/".$_POST['id_lead']);
  exit;   
 }
}*/
//echo '<pre>';
//print_r($_POST['mutiplo_upload']);
//exit;

//echo '<pre>';
//echo 'anexos;';echo $_POST['anexos'];
//echo 'multiplo;';print_r($_POST['mutiplo_upload']);
//echo 'anexoview;';print_r($_POST['anexosview']);
//print_r($this->arr['anexos']);
//exit;

if($_POST['anexos'] != '' && $_POST['anexos'] != NULL){
  $id_lead = $_POST['id_lead'];
  $files = '';
  $anexos = $_POST['anexos'];
  $anexosname = $_POST['mutiplo_upload'];
  //print_r($anexosname);
  //exit;
  $dados = array();
  //$anexos = (isset($_POST[$field])) ? $_POST[$field] : '';
  
   //if($anexos != '' && $_POST[$param] == null){
    if($_POST['anexosview'] != ''){
      $old = (new Orm('leads'))->select(['anexos'])
      ->where(['id_lead', $id_lead])->first()->get(); 
      $arquivo = json_decode($old->anexos, true);
      foreach($arquivo as $arq){
        array_push($dados, $arq);  
      }
      $novos = $this->gravaAnexos($anexos,$anexosname);
      $files = json_decode($novos['files'], true);
      foreach($files as $file){
        array_push($dados, $file);
      }
      
       $dados = json_encode($dados);     
       $files = $dados;
      // print_r($dados);
      // exit;
      //$files = $this->atualizaAnexos($id_lead, $anexos);  
    }else{
      $files = $this->gravaAnexos($anexos,$anexosname);  
      $files = $files['files'];
    };
    
    
    //return $files;
  // }
  
    //if($anexos != '' && $_POST[$param] != null){ 
    
    //return $files;
    //}*/


  $grava = (new Orm('leads'))->set(['anexos'=>$files])->where(['id_lead', $id_lead])->update();
 // exit;
};
//echo '<pre>';
//echo $_POST['motivos'][0].'<br>';
//print_r($_POST);
//exit;

if($_POST['motivos'][0] != '' && $_POST['motivos'][0] != NULL){
$idel = 1;
  foreach($_POST['motivos'] as $motivos){
    $l = new Leads();
    $motivose = explode(";",$motivos);
    $id_lead = $_POST['id_lead'];
    $motivosn = $motivose[1];
    $motivosnid = $motivose[0];  
    if($idel == 1){
      //echo 'aqui';
      //exit;
      $l->deletemotivos($motivosn,$motivosnid,$id_lead);
      $idel++;
    }
    if($_POST['funil'] != 0){
      $l->updatemotivos($motivosn,$motivosnid,$id_lead);
    }
  }
  //print_r($_POST['motivos']);
  //exit;
}else{
  //echo 'ss';
  //exit;
}
$grava = (new Orm('leads_comentarios'))->set($validate)->save(); 
$id_comentario = $grava;
//echo $id_comentario;
//error_reporting(0);
//ini_set(“display_errors”, 0 );
//exit;
$todos = array();
$todos['lista'] = (new Orm('vw_atualizacalendario'))->select('*')->get();
//echo '<pre>';
//print_r($todos['lista']);
//exit;
foreach($todos['lista'] as $atualiza){
$validator = new Validate();
if($atualiza->finalizado == 'S'){
  
  $validates = $validator->validate([
    'event_type'=>'definido:'. $atualiza->id_comentario,
    'color'=>'definido:'. '#37d84f',    
    'subject'=>'definido:'. $atualiza->nome.' - '. $atualiza->produto.' - '. $atualiza->telefone ,
    'date_time'=>'definido:'. $atualiza->data_agendamento.' '.$atualiza->hora_agendamento,
    'from_date_time'=>'definido:'. $atualiza->data_agendamento.' '.$atualiza->hora_agendamento,
    'client'=>'definido:'. $atualiza->id_lead,
    'team_member'=>'definido:'. $atualiza->id_user,
    'location'=>'definido:'. $atualiza->status_tarefa,
    'remark'=>'definido:'. $atualiza->finalizado,
    ],true);
}else{
  
  //exit;
  //echo $atualiza->id_lead;
  //exit;
  if(isset($atualiza->id_user) && !empty($atualiza->id_user) && isset($atualiza->data_agendamento) && !empty($atualiza->data_agendamento) && isset($atualiza->hora_agendamento) && !empty($atualiza->hora_agendamento)){
  $validates = $validator->validate([
    'event_type'=>'definido:'. $atualiza->id_comentario,
    'color'=>'definido:'. '#3788d8',    
    'subject'=>'definido:'. $atualiza->nome.' - '. $atualiza->produto.' - '. $atualiza->telefone ,
    'date_time'=>'definido:'. $atualiza->data_agendamento.' '.$atualiza->hora_agendamento,
    'from_date_time'=>'definido:'. $atualiza->data_agendamento.' '.$atualiza->hora_agendamento,
    'client'=>'definido:'. $atualiza->id_lead,
    'team_member'=>'definido:'. $atualiza->id_user,
    'location'=>'definido:'. $atualiza->status_tarefa,
    'remark'=>'definido:'. $atualiza->finalizado,
    ],true);
    //echo 'aqui';
    //exit;
  }else{
   // echo 'user:'.$atualiza->data_agendamento.' '.$atualiza->hora_agendamento.'<br>';
   // $validate = $validator->validate([
   //  'event_type'=>'definido:'. $atualiza->id_comentario,
   //   'color'=>'definido:'. '#3788d8',    
   //   'subject'=>'definido:'. $atualiza->nome.' - '. $atualiza->produto.' - '. $atualiza->telefone ,
   //   'date_time'=>'definido:'. $atualiza->data_agendamento.' '.$atualiza->hora_agendamento,
   //   'from_date_time'=>'definido:'. $atualiza->data_agendamento.' '.$atualiza->hora_agendamento,
   //   'client'=>'definido:'. $atualiza->id_lead,
   //   'team_member'=>'definido:'. 0,
   //   'location'=>'definido:'. $atualiza->status_tarefa,
   //   'remark'=>'definido:'. $atualiza->finalizado,
   //   ],true);    
  }
}
if(isset($validates) && !empty($validates)){
$grava = (new Orm('shedules'))->set($validates)->save(); 
//echo 'aquin';
//exit;
}
}
//echo '<pre>';
//print_r($validates);
//exit;

  if($_POST['funil'] != 0 ){
    $id_lead = $_POST['id_lead'];
    $id_funil = $_POST['funil'];
    //$validate = $validator->validate($form,true);
    $grava = (new Orm('leads'))->set(['funil_id'=>$id_funil])
    ->where(['id_lead', $id_lead])->update();
   // exit;
  };

  if($_POST['codsocio'] != '' ){
    $id_lead = $_POST['id_lead'];
    $codsocio = $_POST['codsocio'];
    //$validate = $validator->validate($form,true);
    $grava = (new Orm('leads'))->set(['codsocio'=>$codsocio])
    ->where(['id_lead', $id_lead])->update();
   // exit;
  };

  if($_POST['codsistema'] != '' ){
    $id_lead = $_POST['id_lead'];
    $codsistema = $_POST['codsistema'];
    //$validate = $validator->validate($form,true);
    $grava = (new Orm('leads'))->set(['codsistema'=>$codsistema])
    ->where(['id_lead', $id_lead])->update();
   // exit;
  };

  if(isset($_POST['vlrr']) && !empty($_POST['vlrr']) && $_POST['vlrr'] != '' && $_POST['vlrr'] != 0){
    //echo $_POST['id_lead'];
    //exit;
    $id_lead = $_POST['id_lead'];
    $vlr = $_POST['vlrr'];
    //echo 'aqui';
    //exit;
    //$codsistema = $_POST['codsistema'];
    //$validate = $validator->validate($form,true);
    $grava = (new Orm('leads'))->set(['vlr'=>$vlr])
    ->where(['id_lead', $id_lead])->update();
   // exit;
  };

  if($_POST['datafechamento'] != '' && $_POST['datafechamento'] != NULL){
    $id_lead = $_POST['id_lead'];
    $datafechamento = $_POST['datafechamento'];
    //$validate = $validator->validate($form,true);
    $grava = (new Orm('leads'))->set(['data_fechamento'=>$datafechamento])
    ->where(['id_lead', $id_lead])->update();
   // exit;
  };  

  if(isset($_POST['data_agendada']) && !empty($_POST['data_agendada'])){
    $modulo_boleto = $this->permissao->getPermissoesBoleto();
    $modulo_boleton = $modulo_boleto->modulo_boleto;
    if($modulo_boleton == 1){
    $id_lead = $_POST['id_lead'];
    $data_agendada = $_POST['data_agendada'];
    $periodo = $_POST['periodo'];
    $valor = $_POST['valor'];
    $cep = $_POST['cep'];
    $endereco = $_POST['endereco'];
    $bairro = $_POST['bairro'];
    $cidade = $_POST['cidade'];
    $cpf_cnpj = $_POST['cpf_cnpj'];
    $obsfat = $_POST['obsfat'];
    $fpagamento = $_POST['fpagamento'];
    $estado = $_POST['estado'];

    $fin = new Financeiro();
    $fin->gerafaturamento($id_comentario, $id_lead, $user,$data_agendada,$periodo,$valor,$cep,$endereco,$bairro,$cidade,$cpf_cnpj,$obsfat,$fpagamento,$estado);
    }
  //echo 'aqui';
 //exit;
  }
  $_SESSION['msg'] = ['type'=>'success','msg'=>'Comentário Cadastrado com sucesso!'];
 //$id_lead = $_POST['id_lead'];

  if(isset($_GET['f']) && !empty($_GET['f'])){ 
    header("Location:".BASE_URL."leads/view/".$_POST['id_lead']."?f=s");
    exit;
  }else{
    header("Location:".BASE_URL."leads/view/".$id_lead);
    exit;
  
 }

}


}//add coment


public function save(){
$validator = new Validate();
$validate = '';
//$l = new Leads();


if(isset($_POST['nome']) && !empty($_POST['produto'])){

$status = 'novo';
$tem = (new Orm('leads'))->select(['telefone'])->where(['telefone', $_POST['telefone']])->first()->get();
if($tem){
$status = 'repetido';
}

$l = new Leads();
$teste = $l->getCliente();
$cliente = $teste->nome;
$this->arr['cliente'] = $cliente;
$l = new Leads();
$pegacel = $l->pegacel($_POST['telefone']);
//echo '<pre>';
$modulo_boleto = $this->permissao->getPermissoesBoleto();
$modulo_whatsapp = $modulo_boleto->modulo_whatsapp;
$chave_botconversa = $modulo_boleto->chave_botconversa;
if( $modulo_whatsapp == 1){
  $telwhats = '+55'.str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$_POST['telefone']))));
  $nome = $_POST['nome'];
  $produto = $_POST['produto'];
  
  $data = [
    'phone' => $telwhats,
    'first_name' => $nome,
    'last_name' => $produto
  ];
  $dataheader = [
    'API-KEY' => $chave_botconversa,
    'Content-type' => 'application/json'
  ];    

// API URL
$url = 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/';

$payload = json_encode($data);
$payloadheader = json_encode($dataheader);
//print_r($payloadheader);
//exit;

$curl = curl_init();
curl_setopt_array($curl, [
  CURLOPT_URL => $url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POSTFIELDS=>$payload,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "POST",
  CURLOPT_HTTPHEADER => [
    "API-KEY: $chave_botconversa", 
    //"API-KEY: 00134073-cce6-4897-bcc1-42d6fb9f00fc", 
    //"API-KEY: 7c33c5f1-8a21-4147-8d84-37b03f1cc98c",  
    "Content-type: application/json"
  ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);

//url_close($curl);


}


if(isset($pegacel) && !empty($pegacel) && $cliente != 'UPA Piracicaba'){
  //print_r($pegacel);
  echo 'Telefone ja cadastrado verifique com o Coordenador.';
  exit;
}else{

if($cliente == 'Cartao de Todos Americana'){ 

  $validate = $validator->validate([
  'id_lead'=>'null',
  'nome'=>'required',
  'produto'=>'required',
  //'email'=>'required',
  'telefone'=>'required',
  'origem'=>'required',
  'codsocio'=>'definido:'.$_POST['codsocio'],
  'codsistema'=>'definido:'.$_POST['codsistema'],
  //'data_entrada'=>'null|datetime',
  'status'=>'definido:'.$status
  ],true);

}else{

  if($cliente == 'Clique Responde' || $cliente == 'Apae Piracicaba'){ 
    $validate = $validator->validate([
      'id_lead'=>'null',
      'nome'=>'required',
      'produto'=>'required',
      //'email'=>'required',
      'telefone'=>'required',
      'origem'=>'required',
      'cobranca'=>'definido:'.$_POST['cobranca'],
      'end_cli'=>'definido:'.$_POST['end_cli'],
      'n_cli'=>'definido:'.$_POST['n_cli'],
      'bairro_cli'=>'definido:'.$_POST['bairro_cli'],
      'complemento_cli'=>'definido:'.$_POST['complemento_cli'],
      'cep_cli'=>'definido:'.$_POST['cep_cli'],
      'cidade_cli'=>'definido:'.$_POST['dsc_localidade'],
      'estado_cli'=>'definido:'.$_POST['dsc_sigla'],
      'funcionario'=>'definido:'.$_POST['nme_funcionario'],
      'setor'=>'definido:'.$_POST['dsc_setor'],
      'codsetor'=>'definido:'.$_POST['cdg_setor'],
      //'codsocio'=>'required',
      //'codsistema'=>'required',
      //'data_entrada'=>'null|datetime',
      'status'=>'definido:'.$status
      ],true);
  }else{
    if($cliente == 'i9 Doctor Prime'){ 
    $validate = $validator->validate([
    'id_lead'=>'null',
    'nome'=>'required',
    'produto'=>'required',
    //'email'=>'required',
    'telefone'=>'required',
    'origem'=>'required',
    'codsocio'=>'definido:'.$_POST['codsocio'],
    'codsistema'=>'definido:'.$_POST['codsistema'],
    'vlr'=>'definido:'.$_POST['vlr'],
    //'data_entrada'=>'null|datetime',
    'status'=>'definido:'.$status
    ],true);
  }else{
    $validate = $validator->validate([
      'id_lead'=>'null',
      'nome'=>'required',
      'produto'=>'required',
      //'email'=>'required',
      'telefone'=>'required',
      'origem'=>'required',
      //'codsocio'=>'required',
      //'codsistema'=>'required',
      //'data_entrada'=>'null|datetime',
      'status'=>'definido:'.$status
      ],true);    
  }
  }

}

if(!$validate){
$_SESSION['msg'] = ['type'=>'error','msg'=>'Ooops... Alguns campos estão inválidos, tente novamente'];
 unset($_SESSION['flash']);
 unset($_SESSION['old']);
 header("Location:".BASE_URL."leads/add");
 exit;   
}


if($validate['id_lead'] == null){
  //grava no banco
 // print_r($validate);
  //exit;
  $grava = (new Orm('leads'))->set($validate)->save(); 
 // print_r($grava);
 // exit;
// Depois de salvar enviar notificação antes de mostrar msg de alerta
//mando para o push em json a quantidade e a lista para exibir no icone
//atualização PUSH
/*
$options = array(
  'cluster' => 'sa1',
  'useTLS' => true
);
$pusher = new Pusher\Pusher(
    'f9824928d137cc25989b',
    '5b73861e45d1ff6efe08',
    '1481742',
    $options
);

$total = (new Orm('leads'))->select('*')->where(['status','novo'])->total()->get();
$lista = (new Orm('leads'))->select('*')->where(['status','novo'])->get();

$data = json_encode(['qtde'=>$total,'lista'=>$lista]);
$pusher->trigger('my-channel', 'my-event', $data);
*/
//fim da atualização PUSH


  $_SESSION['msg'] = ['type'=>'success','msg'=>'Lead Cadastrado com sucesso!'];
  header("Location:".BASE_URL."leads");
  exit;
}else{
 $grava = (new Orm('leads'))->set($validate)->where(['id_lead', $validate['id_lead']])->update(); 
 $_SESSION['msg'] = ['type'=>'success','msg'=>'Lead atualizado com sucesso!'];
  header("Location:".BASE_URL."leads");
  exit; 
}

}
}
}//save

public function saveProdutor(){
$validator = new Validate();

if(isset($_POST['nome']) && !empty($_POST['produto'])){
$id_produtor = (isset($_POST['id_produtor'])) ? $_POST['id_produtor'] : 0;
$l = new Leads();
$teste = $l->getCliente();
$cliente = $teste->nome;
$this->arr['cliente'] = $cliente;

$pegacel = $l->pegacel($_POST['telefone']);
//echo '<pre>';

if(isset($pegacel) && !empty($pegacel) && $cliente != 'UPA Piracicaba'){
  //print_r($pegacel);
  echo 'Telefone ja cadastrado verifique com o Coordenador.';
  exit;
}else{
  //echo 'ok pode cadastrar';

$hoje = date('Y-m-d H:i:s');
if($cliente == 'Cartao de Todos Americana'){ 
$validate = $validator->validate([
'id_lead'=>'null',
'nome'=>'required',
'produto'=>'required',
//'email'=>'required',
'telefone'=>'required',
'origem'=>'required',
'codsocio'=>'definido:'.$_POST['codsocio'],
'codsistema'=>'definido:'.$_POST['codsistema'],
//'tipo_cotacao'=>'required',
//'qtde_vidas'=>'required',
//'data_entrada'=>'definido:'.$hoje,
'status'=>'definido:entregue',
'para'=>'definido:'.$id_produtor
],true);
}else{
  if($cliente == 'Clique Responde' || $cliente == 'Apae Piracicaba'){ 
    $validate = $validator->validate([
      'id_lead'=>'null',
      'nome'=>'required',
      'produto'=>'required',
      //'email'=>'required',
      'telefone'=>'required',
      'origem'=>'required',
      'cobranca'=>'definido:'.$_POST['cobranca'],
      'end_cli'=>'definido:'.$_POST['end_cli'],
      'n_cli'=>'definido:'.$_POST['n_cli'],
      'bairro_cli'=>'definido:'.$_POST['bairro_cli'],
      'complemento_cli'=>'definido:'.$_POST['complemento_cli'],
      'cep_cli'=>'definido:'.$_POST['cep_cli'],
      'cidade_cli'=>'definido:'.$_POST['dsc_localidade'],
      'estado_cli'=>'definido:'.$_POST['dsc_sigla'],
      'funcionario'=>'definido:'.$_POST['nme_funcionario'],
      'setor'=>'definido:'.$_POST['dsc_setor'],
      'codsetor'=>'definido:'.$_POST['cdg_setor'],
      'para'=>'definido:'.$id_produtor,
      //'codsocio'=>'required',
      //'codsistema'=>'required',
      //'data_entrada'=>'null|datetime',
      'status'=>'definido:entregue',
      ],true);
  }else{
    if($cliente == 'UPA Piracicaba'){
      $validate = $validator->validate([
      'id_lead'=>'null',
      'nome'=>'required',
      'produto'=>'required',
      //'email'=>'required',
      'telefone'=>'required',
      'origem'=>'required',
      //'codsocio'=>'required',
      //'codsistema'=>'required',
      'data_atend'=>'definido:'.$_POST['data_atend'],
      'faa'=>'definido:'.$_POST['faa'],
      'codsistema'=>'definido:'.$_POST['faa'],
      'status'=>'definido:manual',
      'para'=>'definido:'.$id_produtor
      ],true);
    }else{
    $validate = $validator->validate([
    'id_lead'=>'null',
    'nome'=>'required',
    'produto'=>'required',
    //'email'=>'required',
    'telefone'=>'required',
    'origem'=>'required',
    //'codsocio'=>'required',
    //'codsistema'=>'required',
    //'data_entrada'=>'null|datetime',
    'status'=>'definido:entregue',
    'para'=>'definido:'.$id_produtor
    ],true);
    }
  }
  /*
  $validate = $validator->validate([
    'id_lead'=>'null',
    'nome'=>'required',
    'produto'=>'required',
    //'email'=>'required',
    'telefone'=>'required',
    'origem'=>'required',
    //'codsocio'=>'required',
    //'codsistema'=>'required',
    //'data_entrada'=>'null|datetime',
    'status'=>'definido:'.$status
    ],true);*/


}

if(!$validate){
$_SESSION['msg'] = ['type'=>'error','msg'=>'Ooops... Alguns campos estão inválidos, tente novamente'];
 unset($_SESSION['flash']);
 unset($_SESSION['old']);
 header("Location:".BASE_URL."leads/add");
 exit;   
}


if($validate['id_lead'] == null){
  //grava no banco
 // echo '<pre>';
 // print_r($validate);
  $grava = (new Orm('leads'))->set($validate)->save(); 
 // echo $grava;
 // exit;
  $_SESSION['msg'] = ['type'=>'success','msg'=>'Lead Cadastrado com sucesso!'];
  header("Location:".BASE_URL."leads");
  exit;
}else{
 $grava = (new Orm('leads'))->set($validate)->where(['id_lead', $validate['id_lead']])->update(); 
 $_SESSION['msg'] = ['type'=>'success','msg'=>'Lead atualizado com sucesso!'];
  header("Location:".BASE_URL."leads");
  exit; 
}
}

}
}//save

public function getmotivos(){
$array = array();
  //echo 'aqui';
//exit;
$funil = $_POST['motivo'];
$array['motivos'] = (new Orm('funil_motivo'))->select('*')->where(['id_funil', $funil])->order(['nome_motivo asc'])->get();
//echo '<pre>';
//print_r($this->arr['motivos']);
//exit;
echo json_encode($array['motivos']);
//return $this->arr['motivos'];

}

public function viewn($id){
  $this->arr['list_js'] = array(
  'plugins/sweetalert2',
  'plugins/jquery.mask.min',
  'plugins/parsley/parsley.min',
  'plugins/parsley/pt-br',
  'mask_init', 
  'system',
  'flatpickr/flatpickr',
  'flatpickr/pt',
  'flatpickr/flatpickr_init',
  'multiuploads'
  ); 
  $this->atualizaleads($id);
  $this->arr['usuario_logado'] = $this->user->getId();
$this->arr['info'] = (new Orm('leads'))->select('*')->wherecustom("id_lead = $id")->first()->get();
$up = new Orm('leads_motivo');
$this->arr['infomotivos'] = $up->select('*')->where(['id_lead', $id])->get();
$l = new Leads();
$teste = $l->getCliente();
$cliente = $teste->nome;
$this->arr['cliente'] = $cliente;

$produtor = (new Orm('usuarios'))->select(['nome'])->where(['id_usuario', $this->arr['info']->para])->first()->get();
$this->arr['anexos'] = (new Orm('leads'))->select('anexos')->where(['id_lead', $id])
->first()->get();

$this->arr['info']->para = $produtor->nome ?? '';

$this->arr['notificacao'] = false;
$this->arr['funil'] = (new Orm('funil'))->select('*')->get();
$id_funil = $this->arr['info']->funil_id;
$this->arr['funil_nome'] = (new Orm('funil'))->select('*')->where(['id_funil', $id_funil])->first()->get();
if(isset($this->arr['info']->email) && $this->arr['info']->email != ''){
$email = $this->arr['info']->email;
$tem = (new Orm('leads'))->select('*')->wherecustom("email = '$email'")->total()->get();
  if($tem >1){
   $this->arr['notificacao'] = true;
  }
}
$this->arr['id_lead'] = $id;
$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);

$com = new Leads();
$this->arr['comentarios'] = $com->getcomentario($id); 

$this->loadTemplate('leads/visualiza', $this->arr);
//  echo '<pre>';
//  print_r($this->arr);
//  exit;
}

public function view($id){
$this->arr['list_js'] = array(
'plugins/sweetalert2',
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init', 
'system',
'flatpickr/flatpickr',
'flatpickr/pt',
'flatpickr/flatpickr_init',
'multiuploads'
); 

$this->atualizaleads($id);

$this->arr['usuario_logado'] = $this->user->getId();
//$this->arr['titulos'] = (new Orm('titulos'))->select('*')->get();
//->wherecustom("funil_id = $item->id_funil AND produto != 'INATIVO' AND para = $id_usuario AND data_entrada between $data_inicial and $data_final")
//$this->arr['info'] = (new Orm('leads'))->select('*')->where(['id_lead', $id])
$this->arr['info'] = (new Orm('leads'))->select('*')->wherecustom("id_lead = $id")->first()->get();
$up = new Orm('leads_motivo');
$this->arr['infomotivos'] = $up->select('*')->where(['id_lead', $id])->get();
$l = new Leads();
$teste = $l->getCliente();
$cliente = $teste->nome;
$this->arr['cliente'] = $cliente;

$modulo_boleto = $this->permissao->getPermissoesBoleto();
$modulo_whatsapp = $modulo_boleto->modulo_whatsapp;
if($modulo_whatsapp == 1){
  $this->arr['whats_flow']  = (new Orm('whats_flow'))->select('*')->order(['seq asc'])->get();
  $this->arr['id_manager'] = $this->user->id_manager();
  //echo '<pre>';
  //print_r($this->arr['id_manager']);
  //exit;
}

//$this->arr['montavw'] = (new Orm('leads'))->select(['Nome','Produto','Email','telefone','origem','data_entrada','status','para','curso_texto','cidade'])->where(['id_lead', $id])
//->first()->get();
$produtor = (new Orm('usuarios'))->select(['nome'])->where(['id_usuario', $this->arr['info']->para])->first()->get();
$this->arr['anexos'] = (new Orm('leads'))->select('anexos')->where(['id_lead', $id])
->first()->get();

$this->arr['info']->para = $produtor->nome ?? '';

$this->arr['notificacao'] = false;
$this->arr['funil'] = (new Orm('funil'))->select('*')->get();
$id_funil = $this->arr['info']->funil_id;
$this->arr['funil_nome'] = (new Orm('funil'))->select('*')->where(['id_funil', $id_funil])->first()->get();
if(isset($this->arr['info']->email) && $this->arr['info']->email != ''){

$email = $this->arr['info']->email;
$tem = (new Orm('leads'))->select('*')->wherecustom("email = '$email'")->total()->get();
//echo '<pre>';
//print_r($this->arr['info']);
  if($tem >1){
   $this->arr['notificacao'] = true;
  }
}

$this->arr['id_lead'] = $id;
$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);

$com = new Leads();
$this->arr['comentarios'] = $com->getcomentario($id); 
//$this->arr['comentarios'] = (new Orm('leads_comentarios'))->select(['leads_comentarios.*, usuarios.nome'])
//->join(['usuarios'])
//->on(['leads_comentarios.id_user','=','usuarios.id_usuario'])
//->where(['id_lead', $id])->order(['id_comentario desc'])->get();
//echo '<pre>';
//print_r($this->arr);
//exit;


$this->loadTemplate('leads/visualiza', $this->arr);
}//view

public function atualizaleads($id){
$tab = (new Orm('leads_comentarios'))->select('*')
->where(['id_lead', $id])->get();

if(empty($tab)){
  return '';
}

foreach($tab as $lead){

  if($lead->status_tarefa == 'agendada'){
    $inicio = date('Y-m-d');
    $dias = $this->calculoDias($inicio, $lead->data_agendamento);
    if($dias < 0){
      $up = (new Orm('leads_comentarios'))
      ->set(['status_tarefa'=>'atrasado'])
      ->where(['id_comentario', $lead->id_comentario])->update();
    }     
  }
}
}//atualizaleads


public function send($id){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'functions_js',
'plugins/sweetalert2',
'system'
);  

$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->arr['id_lead'] = $id;  
$this->arr['produtores'] = (new Orm('usuarios'))->select('*')->where(['tipo','Produtor'])->get();
$this->arr['titulos'] = (new Orm('titulos'))->select('*')->get();

if(isset($_POST['produtor']) && !empty($_POST['produtor'])){
$produtor = $this->limpaCampo($_POST['produtor']);
$id_lead = $this->limpaCampo($_POST['id_lead']);

//dados do produtor
$info = (new Orm('usuarios'))->select(['email'])->where(['id_usuario', $produtor])->first()->get();


if(empty($info)){
$_SESSION['msg'] = ['type'=>'info','msg'=>'Email não informado para esse produtor'];
header("Location:".BASE_URL."leads/send/".$id);
exit;
}


$up = (new Orm('leads'))->set(['status'=>'entregue', 'para'=>$produtor])
->where(['id_lead', $id_lead])->update();

//montando o corpo do email
$array = (new Orm('leads'))->select('*')->where(['id_lead', $id])
->first()->get();
$saida = '';

foreach($array as $key=>$item):  
 if($key != 'id_lead' && $key != 'para'){
$ind = $this->searcharray($key, 'indice_titulo', $this->arr['titulos']);


if($ind !== null){
$saida .= '<p><b>'.$this->arr['titulos'][$ind]->novo_titulo.'</b>: '.$item.'</p>';
}
else{
$arr_titulo = $key;
$titulo = ucfirst($arr_titulo);
$titulo = str_replace('_',' ',$titulo);

if($key === 'data_entrada'){
$saida .= '<p><b>'.$titulo.'</b>: '.date('d/m/Y', strtotime($item)).'</p>';
}else{
$saida .= '<p><b>'.$titulo.'</b>: '.$item.'</p>';
}
}
}
endforeach;
header("Location:".BASE_URL."leads");
exit;
/*
//aqui eu envio o email
$mail = new Email();
$mail->addAdress($info->email, 'PowerControl');
$info = array('assunto'=>'Lead Power Controle', 'corpo'=>$saida);
$mail->formatarEmail($info);

if($mail->enviarEmail()){
 $_SESSION['msg'] = ['type'=>'success','msg'=>'E-mail enviado com sucesso!'];
 header("Location:".BASE_URL."leads");
 exit;
}else{  
  $_SESSION['msg'] = ['type'=>'error','msg'=>'Ooopss, erro ao enviar E-mail tente novamente!'];
 header("Location:".BASE_URL."leads");
 exit;
} */
}

$this->loadTemplate('leads/send', $this->arr);
}

public function sendlodte_flow(){
  $flow = $_POST['flow'];  
  $mail = new Email();
  $data_atual = date('Y-m-d');
  $modulo_boleto = $this->permissao->getPermissoesBoleto();
  $modulo_whatsapp = $modulo_boleto->modulo_whatsapp;
  $chave_botconversa = $modulo_boleto->chave_botconversa;

  //echo $chave_botconversa;
  //exit;
  foreach($_POST['leads'] as $lead){
    $this->arr['leads_get'] = (new Orm('leads'))->select('*')->where(['id_lead', $lead])->first()->get();

    $gravapes = 0;
  //$item = (new Orm('leads'))->select(['email'])->where(['id_lead', $lead])
  //->first()->get();
  
  //atualizar o status para entregue depois de enviado
  if($_POST['flow'] == '2829397'){
  $up = (new Orm('leads'))->set(['funil_id'=>'15'])
  ->where(['id_lead', $lead])->update();
  $tel = $this->arr['leads_get']->telefone;
  $telefone = str_replace(" ","",str_replace(")","",str_replace("(","",str_replace("-","",$tel)))); 
  $nome = $this->arr['leads_get']->nome;
  $faa = $this->arr['leads_get']->faa;
  $data_atend = $this->arr['leads_get']->data_atend;
  $prof_medico = $this->arr['leads_get']->prof_medico;
  $telepara = $this->user->getId();
  $origempesquisa = 'whatsapp'; 

  $gravapes = (new Orm('leads_pesquisa'))->set(['unidade'=>'UPA VILA CRISTINA','data_envio'=>$data_atual,'situacao'=>'AGENVIO','telefone'=>$telefone,'nome'=>$nome,'faa'=>$faa,'data_atend'=>$data_atend,'prof_medico'=>$prof_medico,'telepara'=>$telepara,'origempesquisa'=>$origempesquisa])->save();

  }

  if($_POST['flow'] == '2830876'){
    $up = (new Orm('leads'))->set(['funil_id'=>'14'])
    ->where(['id_lead', $lead])->update();
    $tel = $this->arr['leads_get']->telefone;
    $telefone = str_replace(" ","",str_replace(")","",str_replace("(","",str_replace("-","",$tel))));
    $nome = $this->arr['leads_get']->nome;
    $faa = $this->arr['leads_get']->faa;
    $data_atend = $this->arr['leads_get']->data_atend;
    $prof_medico = $this->arr['leads_get']->prof_medico;
    $telepara = $this->user->getId();
    $origempesquisa = 'whatsapp'; 

    $gravapes = (new Orm('leads_pesquisa'))->set(['unidade'=>'UPA VILA SONIA','data_envio'=>$data_atual,'situacao'=>'AGENVIO','telefone'=>$telefone,'nome'=>$nome,'faa'=>$faa,'data_atend'=>$data_atend,'prof_medico'=>$prof_medico,'telepara'=>$telepara,'origempesquisa'=>$origempesquisa])->save();
  
  }
  
  $telwhats = '+55'.str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$this->arr['leads_get']->telefone))));
  $nome = $this->arr['leads_get']->nome;
  $produto = $this->arr['leads_get']->produto;
  $data = [
    'phone' => $telwhats,
    'first_name' => $nome,
    'last_name' => $produto
  ];
  $dataheader = [
    'API-KEY' => $chave_botconversa,
    'Content-type' => 'application/json'
  ];    

// API URL
$url = 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/';

$payload = json_encode($data);
$payloadheader = json_encode($dataheader);
//print_r($payloadheader);
//exit;
$curl = curl_init();
curl_setopt_array($curl, [
  CURLOPT_URL => $url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POSTFIELDS=>$payload,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "POST",
  CURLOPT_HTTPHEADER => [
    "API-KEY: $chave_botconversa", 
    //"API-KEY: 00134073-cce6-4897-bcc1-42d6fb9f00fc", 
    //"API-KEY: 7c33c5f1-8a21-4147-8d84-37b03f1cc98c",  
    "Content-type: application/json"
  ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);

$datax = json_decode($response);

 if(isset($datax->id) && !empty($datax->id)){
  $id_lead = $this->arr['leads_get']->id_lead;
  $id_subscriber = $datax->id;
  $id_whats = $datax->id;
  $grava = (new Orm('leads'))->set(['id_subscriber'=>$id_subscriber])->where(['id_lead', $id_lead])->update();
 }else{
  $id_whats = $this->arr['leads_get']->id_subscriber;
 }
 $telefoneget = '+55'.str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$this->arr['leads_get']->telefone))));
 // /subscriber/get_by_phone/{phone}/
 $data = [
  'phone' => $telefoneget
];
$dataheader = [
  'API-KEY' => $chave_botconversa,
  'Content-type' => 'application/json'
];    


$url = 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/get_by_phone/'.$telefoneget.'/';

$payload = json_encode($data);
$payloadheader = json_encode($dataheader);
$curl = curl_init();
curl_setopt_array($curl, [
CURLOPT_URL => $url,
CURLOPT_RETURNTRANSFER => true,
CURLOPT_POSTFIELDS=>$payload,
CURLOPT_ENCODING => "",
CURLOPT_MAXREDIRS => 10,
CURLOPT_TIMEOUT => 30,
CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
CURLOPT_CUSTOMREQUEST => "GET",
CURLOPT_HTTPHEADER => [
  "API-KEY: $chave_botconversa", 
  //"API-KEY: 00134073-cce6-4897-bcc1-42d6fb9f00fc", 
  //"API-KEY: 7c33c5f1-8a21-4147-8d84-37b03f1cc98c",  
  "Content-type: application/json"
],
]);

$responseg = curl_exec($curl);
$err = curl_error($curl);

$dataxg = json_decode($responseg);

if(isset($dataxg->id) && !empty($dataxg->id)){
$id_lead = $this->arr['leads_get']->id_lead;
$id_subscriber = $dataxg->id;
$id_whats = $dataxg->id;
$grava = (new Orm('leads'))->set(['id_subscriber'=>$id_subscriber])->where(['id_lead', $id_lead])->update();
}else{
$id_whats =$this->arr['leads_get']->id_subscriber;
}
$flow = $_POST['flow'];
date_default_timezone_set('America/Fortaleza');
$data_ag = date("Y-m-d H:i:s");
$data_ag_data = date("Y-m-d");
$data_ag_hora = date("H");
$data_ag_min = date("i");
$telwhats = '+55'.str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$this->arr['leads_get']->telefone))));


$this->arr['leads_getdis'] = (new Orm('whats_disparo'))->select('*')->wherecustom("telefone = '$telwhats' and data_ag_data = '$data_ag_data' and data_ag_hora = '$data_ag_hora' and data_ag_min = '$data_ag_min'")->first()->get();
if(isset($this->arr['leads_getdis']) && !empty($this->arr['leads_getdis'])){
}else{
  $gravadis = (new Orm('whats_disparo'))->set(['id_lead'=>$id_lead,'id_subscriber'=>$id_subscriber,'id_whats'=>$id_whats,'telefone'=>$telwhats,'nome'=>$nome,'produto'=>$produto,'flow'=>$flow,'data_ag'=>$data_ag,'data_ag_data'=>$data_ag_data,'data_ag_hora'=>$data_ag_hora,'data_ag_min'=>$data_ag_min,'chave_bot'=>$chave_botconversa,'id_pes'=>$gravapes])->save();
}

/*
$this->arr['leads_getdis'] = (new Orm('whats_disparo'))->select('*')->wherecustom("telefone = '$telwhats' and data_ag_data = '$data_ag_data' and data_ag_hora = '$data_ag_hora' and data_ag_min = '$data_ag_min'")->first()->get();
if(isset($this->arr['leads_getdis']) && !empty($this->arr['leads_getdis'])){
  $gravadis = (new Orm('whats_disparo'))->set(['id_lead'=>$id_lead,'id_subscriber'=>$id_subscriber,'id_whats'=>$id_whats,'telefone'=>$telwhats,'nome'=>$nome,'produto'=>$produto,'flow'=>$flow,'data_ag'=>$data_ag,'data_ag_data'=>$data_ag_data,'data_ag_hora'=>$data_ag_hora,'data_ag_min'=>$data_ag_min])->save();
}else{
}

  $campanha = $_POST['flow'];
  //$id_whats = $_POST['id_whats'];
  $data = [
    'flow' => $campanha
  ];
  $dataheader = [
    'API-KEY' => $chave_botconversa,
    'Content-type' => 'application/json'
  ];    
$payload = json_encode($data);
$headerjson = json_encode($dataheader);

// print_r($payload);
// print_r($headerjson);
// exit;
  //echo $id_whats;
 // exit;/subscriber/{subscriber_id}/send_flow/
  $curl = curl_init();

  curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/'.$id_whats.'/send_flow/',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS =>$payload,
  CURLOPT_HTTPHEADER => [
    "API-KEY: $chave_botconversa", 
    //"API-KEY: 7c33c5f1-8a21-4147-8d84-37b03f1cc98c",  
    "Content-type: application/json"
  ],
  ));

  $response = curl_exec($curl);
  curl_close($curl);
*/
  }//foreach
  
  
  echo json_encode('1');
  exit;
  
  }//sendlote flow

public function sendlodte(){
$produtor = $_POST['produtor'];  
$mail = new Email();
$this->arr['titulos'] = (new Orm('titulos'))->select('*')->get();


foreach($_POST['leads'] as $lead){
$item = (new Orm('leads'))->select(['email'])->where(['id_lead', $lead])
->first()->get();

//atualizar o status para entregue depois de enviado
$up = (new Orm('leads'))->set(['status'=>'entregue', 'para'=>$produtor])
->where(['id_lead', $lead])->update();


//montando o corpo do email
$array = (new Orm('leads'))->select('*')->where(['id_lead', $lead])
->first()->get();
$saida = '';

foreach($array as $key=>$item):  
 if($key != 'id_lead' && $key != 'para'){
$ind = $this->searcharray($key, 'indice_titulo', $this->arr['titulos']);


if($ind !== null){
$saida .= '<p><b>'.$this->arr['titulos'][$ind]->novo_titulo.'</b>: '.$item.'</p>';
}
else{
$arr_titulo = $key;
$titulo = ucfirst($arr_titulo);
$titulo = str_replace('_',' ',$titulo);

if($key === 'data_entrada'){
$saida .= '<p><b>'.$titulo.'</b>: '.date('d/m/Y', strtotime($item)).'</p>';
}else{
$saida .= '<p><b>'.$titulo.'</b>: '.$item.'</p>';
}
}
}
endforeach;


$dados_produtor = (new Orm('usuarios'))->select(['email'])->where(['id_usuario', $produtor])->where(['tipo','Produtor'])->first()->get();
/*
//aqui eu envio o email
$mail->addAdress($dados_produtor->email, 'PowerControl');
$info = array('assunto'=>'Lead Power Controle', 'corpo'=>$saida);
$mail->formatarEmail($info);
$mail->enviarEmail();
*/
}//foreach


echo json_encode('1');
exit;

}//sendlote

public function montaViewlead($array){
  $this->arr['titulos'] = (new Orm('titulos'))->select('*')->get();
  $saida = '';
  
  foreach($array as $key=>$item):  
    //if($key != 'id_lead' && $key != 'funil_id'){
    if($key != 'id_lead' && $key != 'qtde_vidas' && $key != 'tipo_cotacao' && $key != 'funil_id' && $key != 'anexos'){
  $ind = $this->searcharray($key, 'indice_titulo', $this->arr['titulos']);
  
  
  if($ind !== null){
  $saida .= '<p><b>'.$this->arr['titulos'][$ind]->novo_titulo.'</b>: '.$item.'</p>';
  }
  else{
  $arr_titulo = $key;
  $titulo = ucfirst($arr_titulo);
  $titulo = str_replace('_',' ',$titulo);
  
  if($key === 'data_entrada'){
  $saida .= '<p><b>'.$titulo.'</b>: '.date('d/m/Y', strtotime($item)).'</p>';
  }elseif($key == 'para'){
  $saida .= '<p><b>Produtor:</b> '.$item.'</p>';
  }else{
  $saida .= '<p><b>'.$titulo.'</b>: '.$item.'</p>';
  }
  }
  }
  endforeach;
  
  echo $saida;
  }//monta view

public function montaView($array){
$this->arr['titulos'] = (new Orm('titulos'))->select('*')->get();
$saida = '';

foreach($array as $key=>$item):  
  //if($key != 'id_lead' && $key != 'funil_id'){
  if($key != 'id_lead' && $key != 'qtde_vidas' && $key != 'tipo_cotacao' && $key != 'funil_id'){
$ind = $this->searcharray($key, 'indice_titulo', $this->arr['titulos']);


if($ind !== null){
$saida .= '<p><b>'.$this->arr['titulos'][$ind]->novo_titulo.'</b>: '.$item.'</p>';
}
else{
$arr_titulo = $key;
$titulo = ucfirst($arr_titulo);
$titulo = str_replace('_',' ',$titulo);

if($key === 'data_entrada'){
$saida .= '<p><b>'.$titulo.'</b>: '.date('d/m/Y', strtotime($item)).'</p>';
}elseif($key == 'para'){
$saida .= '<p><b>Produtor:</b> '.$item.'</p>';
}else{
$saida .= '<p><b>'.$titulo.'</b>: '.$item.'</p>';
}
}
}
endforeach;

echo $saida;
}//monta view

public function getProdutor($id){  
$vendedor = '';

//$prod = (new Orm('usuarios'))->select(['nome'])->where(['id_usuario', $id])->where(['tipo','Produtor'])->first()->get();
$prod = (new Orm('usuarios'))->select(['nome'])->where(['id_usuario', $id])->first()->get();
//print_r($prod);

if($prod){
$vendedor = $prod->nome;
}
return $vendedor;
//exit;
//echo '11';
}//getProdutor

public function finalizatarefa(){
$tarefa = addslashes($_POST['vlr']);

$up = (new Orm('leads_comentarios'))->set(['finalizado'=>'S'])
->where(['id_comentario', $tarefa])->update();

$grava = (new Orm('shedules'))->set(['color'=>'#37d84f','remark'=>'S'])
->where(['event_type', $tarefa])->update(); 


if($up){
echo json_encode('1');
exit;
}

echo json_encode('2');
exit;
}

public function cancelartarefa(){
  $tarefa = addslashes($_POST['vlr']);
  
  $up = (new Orm('financeiro_faturamento'))->set(['fpagamento'=>'CANCELADO'])
  ->where(['id_comentario', $tarefa])->update();
  /*
  $grava = (new Orm('shedules'))->set(['color'=>'#37d84f','remark'=>'S'])
  ->where(['event_type', $tarefa])->update(); 
  */
  
  if($up){
  echo json_encode('1');
  exit;
  }
  
  echo json_encode('2');
  exit;
  }

public function removetarefa($id, $lead){
$del = (new Orm('leads_comentarios'))->del(['id_comentario', $id]);
$_SESSION['msg'] = array('type'=>'success', 'msg'=>'Tarefa removida com sucesso!');
$this->redirect(BASE_URL."leads/view/".$lead);
}

public function del($id){

$del = (new Orm('leads'))->del(['id_lead', $id]);
$_SESSION['msg'] = array('type'=>'success', 'msg'=>'Lead removido com sucesso!');
$this->redirect(BASE_URL."leads");
}//remover

public function lendoAnexos($anexos){
  //echo '<script>alert("aqui");</script>';
  if($anexos != ''){
   $anexos = json_decode($anexos, true);
   
    foreach($anexos as $key=> $value){
      $rota = BASE_URL.$value;
  
      if(substr($value, -3) == 'png' || substr($value, -3) == 'jpg' || substr($value, -4) == 'jpeg'){
       echo ' <li>
                  <div class="img_resp">
                  <img src="'.$rota.'">
                  </div>
                   <p>'.mb_strimwidth($value, 0, 30, "...").'</p>                  
                  <button type="button">
                  <a href="'.$rota.'" download style="color:white;"><i class="fa fa-download"></i></a></button>  
                  <button type="button" temporario class="apagarArquivo2"><i class="fa fa-times"></i></button>              
                  </li>'; 
      }
  
  
      if(substr($value, -3) == 'pdf'){
        echo '<li>
              <div class="img_icon"><i class="fa fa-file-pdf-o"></i></div>
              <p>'.mb_strimwidth($value, 0, 30, "...").'</p>
               <button type="button"><a href="'.$rota.'" download style="color:white;"><i class="fa fa-download"></i></a></button> 
               <button type="button" temporario class="apagarArquivo2"><i class="fa fa-times"></i></button>           
        </li>';
      }
  
      if(substr($value, -3) == 'doc' || substr($value, -4) == 'docx'){
        echo '<li>
                   <div class="img_icon"><i class="fa fa-file-word-o"></i></div>   
                    <p>'.mb_strimwidth($value, 0, 30, "...").'</p>                
                   <button type="button"><a href="'.$rota.'" download style="color:white;"><i class="fa fa-download"></i></a></button> 
                   <button type="button" temporario class="apagarArquivo2"><i class="fa fa-times"></i></button>                
                   </li>';
      }
  
      if(substr($value, -3) == 'xls' || substr($value, -4) == 'xlsx'){
        echo '<li>
                   <div class="img_icon"><i class="fa fa-file-excel-o"></i></div>
                    <p>'.mb_strimwidth($value, 0, 30, "...").'</p>
                   <button type="button"><a href="'.$rota.'" download style="color:white;"><i class="fa fa-download"></i></a></button>  
                   <button type="button" temporario class="apagarArquivo2"><i class="fa fa-times"></i></button>                
                   </li>  ';
      }
  
  
    }
  }
  
  }//lendoAnexos 



public function disparo(){
$total = (new Orm('leads'))->select('*')->where(['status','novo'])->total()->get();
$lista = (new Orm('leads'))->select(['nome'])->where(['status','novo'])->order(['id_lead desc'])->limit('5')->get();


//mando para o push em json a quantidade e a lista para exibir no icone
//atualização PUSH
/*
$options = array(
  'cluster' => 'sa1',
  'useTLS' => true
);
$pusher = new Pusher\Pusher(
    'f9824928d137cc25989b',
    '5b73861e45d1ff6efe08',
    '1481742',
    $options
);

$data = json_encode(['qtde'=>$total]);
$pusher->trigger('my-channel', 'my-event', $data);
*/
//fim da atualização PUSH

}//disparo

public function assinar($idlead){
    
     /*
  $data['consulta'] = (new Orm('financeiro_faturamento'))
  ->select(['financeiro_faturamento.*, leads.id_importacao,leads.nome, leads.produto, leads.cobranca as lcobranca'])
  ->join(['leads'])
  ->on(
    ['financeiro_faturamento.id_lead','=','leads.id_lead'])
  ->wherecustom("financeiro_faturamento.id_lead = '$idlead' and valor_pago > 0 and recebido = 'SIM'")
  ->order(['financeiro_faturamento.data_recebimento desc'])
  ->get();       
  $data['consultaaberto'] = '';    
  */
  $data['idlead'] = $idlead;
  /*
  ob_start();
  $this->loadview("/leads/leads_report_assinarwaterpark_pdf", $data);      
  //exit;
  $html = ob_get_contents();
  ob_end_clean();      
  $options = new Options();
  $options->set('isRemoteEnabled',true);
  $dompdf = new Dompdf($options);
  //$dompdf = new Dompdf();
  $dompdf->set_option('isHtml5ParserEnabled', true);
  $dompdf->set_option("isPhpEnabled", true);
  $dompdf->loadHtml($html);
  ini_set('xdebug.max_nesting_level', 2000);
  ini_set('memory_limit', '256M');

  // Render the HTML as PDF
  $dompdf->setPaper('A4', 'portrait');
  $dompdf->render();
  $dompdf->stream("Letter",["Attachment" => false]); 
  $output = $dompdf->output();
  file_put_contents('Contratos/Teste123.pdf', $output);
*/

$image = 'Contratos/Teste123.pdf';
//$image = 'https://luizaotenisclub.com.br/Teste123.pdf';

// Read image path, convert to base64 encoding
$imageData = base64_encode(file_get_contents($image));

// Format the image SRC:  data:{mime};base64,{data};
$src = 'data: '.mime_content_type($image).';base64,'.$imageData;

// Echo out a sample image
//echo $src;
//exit;
$pdf="JVBERi0xLjcKMSAwIG9iago8PCAvVHlwZSAvQ2F0YWxvZwovT3V0bGluZXMgMiAwIFIKL1BhZ2VzIDMgMCBSID4+CmVuZG9iagoyIDAgb2JqCjw8IC9UeXBlIC9PdXRsaW5lcyAvQ291bnQgMCA+PgplbmRvYmoKMyAwIG9iago8PCAvVHlwZSAvUGFnZXMKL0tpZHMgWzYgMCBSCjEyIDAgUgoxNCAwIFIKMTYgMCBSCl0KL0NvdW50IDQKL1Jlc291cmNlcyA8PAovUHJvY1NldCA0IDAgUgovRm9udCA8PCAKL0YxIDggMCBSCi9GMiA5IDAgUgo+PgovWE9iamVjdCA8PCAKL0kxIDEwIDAgUgovSTIgMTEgMCBSCj4+Cj4+Ci9NZWRpYUJveCBbMC4wMDAgMC4wMDAgNTk1LjI4MCA4NDEuODkwXQogPj4KZW5kb2JqCjQgMCBvYmoKWy9QREYgL1RleHQgL0ltYWdlQyBdCmVuZG9iago1IDAgb2JqCjw8Ci9Qcm9kdWNlciAo/v8AZABvAG0AcABkAGYAIAAyAC4AMAAuADMAIAArACAAQwBQAEQARikKL0NyZWF0aW9uRGF0ZSAoRDoyMDI0MDUyNDIyNTQ0My0wMycwMCcpCi9Nb2REYXRlIChEOjIwMjQwNTI0MjI1NDQzLTAzJzAwJykKPj4KZW5kb2JqCjYgMCBvYmoKPDwgL1R5cGUgL1BhZ2UKL01lZGlhQm94IFswLjAwMCAwLjAwMCA1OTUuMjgwIDg0MS44OTBdCi9QYXJlbnQgMyAwIFIKL0NvbnRlbnRzIDcgMCBSCj4+CmVuZG9iago3IDAgb2JqCjw8IC9GaWx0ZXIgL0ZsYXRlRGVjb2RlCi9MZW5ndGggNDAzOCA+PgpzdHJlYW0KeJytW81y20iSvvsp6rAHd6wEA4XCX89l1TTVQYctqUXaMxHjOZTIkowekKABUOPo15h5mr5t7HnfYb0+dHgj+jQzlzltZgFIFkgARYfbjrDkJLKY35df1h+qnriO67rM/Ld4ePLdgvnCcb2QRb7v8CRiixV8KoRgi7+wZ5ceSxyXLe4Z++PTG5XlbFuoUm0qxWabsip2a/g9ZzeyqNLlLpMFWyk2UWX5KcffnqeFSqu8xN9fl+AsC8kmWaobmP99meZg3n0s4OebtJLZr2iZflhmuzJ9zJliG8nWKnuXF+w+L9YS21nVbZ598ye2eNEAgVCnCxML507oBjUWrw+LLDGYSpVnTK3ZNlObnO1K/MqH/Ccde7mDZ+4loFrJlSrhkyx9BPD42fudTMv3O1WwRwwZbDlb5hskJq0ZyXeszJcpPHbG7lMIfc0M7uDZqpBVQ0jOSrUbheN5TuL5NZzAC47h3KcqgwjVB2x0uVtvizqOM5bflap4lJtVfl4qJlmmUjCW7A7ChTjKClIIMUowyPP7z2dNbCk4gG+RPshfIJdbyECZwjdApCVQs4QU5wU6QlOaDfgE7D9CagCqHEXjeg7nHqLpgqjjLlgKFD0UMltrrqq8JrdS/4JfVmm5haBzUAaEn33claC6ksn3uxQfelQbyMdGriQmtqwQNyZst2aZXOV1WHU0PAycWIQsjGLQil+Hw5kHDDfxzNg5m0yfT68WU9OxgREGsRMEjcYCaEgnhRt4ppNrdjudX98u2HfXry5nr/o16/mR44fBQIMmQWyLtEv24674dZUuzXIAbaWPgBDzt4ZcrHTtTFLULj42l5tKslvIDmr1RpalZD/sZFWAB0h/ClTVTM0/4ce7DO2jaQxF5MShf5zGS/mT2qwk+y5f36frM1Y+2/x8BkTeAFIRRu45tHYGX/UIwdUpTjflssDQIJLJ1c2LZ68uoXruoDA2PzPuO26cOJEIn4Gjd+4lvztMI4cwQg4/RdCXRszjYrZ4/fLiljyPO8Pb78EYBewvzGUv2B8Z+xP8snrSonWF48Ona8Zd7riRS5aMzYcc/cTTj0WBC46NIUg8xw1i7YdsBlDRIViFE9a9b1dEV/lafWsCDsHdFV2Hjkj+UP/p/DRwH0fKoSB97hoYfagJ0QQ/hhE9wyQwQLaWA5RIWgxfMQhzrj7kHZgc8h570RjOUVB+FIFmPANUAMzxUNgTB+C9JuVN5hqLCarPMwhdJ44Tw7O1HCY9SkCs3jAdzyVUw5Usl06HFAGkRDy2J3+cmlrSGJPwfUPSrcUiaXwsdmND0g0/B5KOPWgjOAbXdDaT9DHNOvDiwIki3nXsQ3einvcAWz3bAJrqrRGSpQuR9DyEcXJzeSRnH4bwE7CdkMBG23uArbatGTSU3KSwtRgAx7S99yTLQfZbbQ9Rc/t9hxk/gaz7sZWZkyTd5NmQdGOxSRoei8PQkDQMK14kDiUdwmOef4zpMt8odqvKdIUTENmVtedC1cIQ1fH+Gl0TStK1BaWp4homWbo4SdejQCcwJhVHMHkYQR93EswvkDhhJYnbMmoIuklpazGwjkqcPMlyoIZW4kMsTVSGi6Fu3w2TeO6HJ9FzktYhpkAkptYbi03r8FjChaH1gENk/FDrAcyPI6+n+17Lg34bMhPgUG16fI2+CRnp24LMVHMNjSxdbKTvIXC/fyerUm63XWWLAAI7CeAXKJtQkrJt+TN03CSwtRgoR5VNnmSxeLZiC3BBHZliayw2scFjScwNsflQO4l7KDYBj/GkR2yblSrUL/lw58qBvCDptvA14iOkJD4LUlNqNVSydLGS+IbAXv3clZ0HS5o4sEE7TW0Ei9RmS6ChrSaDrcWANao28iTLQfLbfnSIEBhotpnSOxndvtQPHc5PSvqX9KgQXRiaa7zWYqsOHsK0vDOTbiy26hCw9hTm4hD8fHG0OOQJENmzTPhOpkXRpSbEkNyuy9eUA3FC5WDhhDyJFPK0kEJlQ6yQpUsLFdIQL/W+R7eYfJiAc89GDHt9+e2H5s9phUUEUWHZRNN6EkHkaVNNW4B72bQWg6DRkiRPshwori3JQWqnN91SdF0YQOJTBHeoOz2yCh0/yMMJvd5NOL19M7luNnDY26fT+dtvTilnEcGHQlelDwKEZXNrsVSliDwIyljfiiAC/8P1rcCdmLBngeN6HYLE8dNfuV/jR04YxQZA4cVO5PpWgEgETtH3CMnShchBwx5+xRBGWN8+e3WwxI1CxwtjO1J77yO8yEkC30DYlogNITLh61S3CMliIBwrkb0nWbrcCC9xBAY3xM3Q5k3oOwnUnpWfk8QNMcWuZ4q7sdjEHUCPERkrXQECFfHhSlcIeIz3LG1c3idu8+nfSNwEkMRtAbiXcouQLF2IJO4hjGPitiH9AnETQhK3BeFeyi1CshgIR8VNnmTpckPiHuLGJm4bPyeJG2KKg8QUd2OxiRsWatw3lrbCh6WpOFzaCvjpxT2rP9fvE7f59G8kbgJI4rYA3Eu5RUiWLkQS9xDGMXHbkH6BuAkhiduCcC/lFiFZDISj4iZPsnS5IXEPcWMTt42fk8Tt48vcyBR3Y7GJ24elemIspZGf0D1cSguOK/qexZQr+sRtPv0biZsAkrgtAPdSbhGSpQuRxD2EcUzcNqRfIG5CSOK2INxLuUVIFgPhqLjJkyxdbkjcQ9zYxG3j5yRxQ0xJ/Zq0FXdjsSyhhRs6rt+ZrDcWW1UAbN98vyrcwAmP3q8KN2lPtxxURdBXFebTv1FVEDNUFRZmyJOoIU8LNfvqabkhS5ccqqchdsbqycbRF9QTcUP1ZOGGPIkb8rRws6+7lhuyGNyMViJ5kqXLKlXiEKu2SrQxe0ol+vjGmethJkycANYbrcVSiT6A4vUuWOvYWCyViO0L1xif/CBx4qOt3no3iFjxOMGbvYGV/g87maX36VIfO2qPqmzzoupu57SNhUJvVzRUGY3NPxepYi9kld99HC9Q/T4mMAiD3sdJuGcljDyJMfK0MIbMesDMnjKydDnjsNz18SsGSUPOZhs8Mffp4ABF6zpI0SKt9JG9f2duwJb5eVX/X5XjRctxCeEZfLWlZ+OLPIkv8rTwhZ54ImrPF1kMvsaKdu9Jli7TgifQ23pjTONG1E0h6+OBr8uDLenWf5DuN7PFxcv/nsyuu3v8kHeMhsPUMug7vvRGb4BdXt++umDPp+zm4vuLV9OrxXW3HJrahY7Ic3t6jjcXL69vp3M2rRuad1o6pTvhie8ECXa0Hh7fE3uLpTvhIXdi3zMdG4ulO8H2k9DYhUM/ERzuwvEYd1P8nnxN8RzjSvZ1GzwMYaEd9STp9t+Y65657ignnuuCRjqkRAFgiq2kkOeeldbTwgp64rvHPS1k6fKCNCfJGDFzma3ygxMKjc84LycwA2jcODaY8bFQXWFnpvUkZsjTxgx4wtBpMtNaDpiBmUuAXzHIzGV7yPhGPsjj107UwCBNp817fB6BVRgsCcFhDnJCUbWexBJ52qoKO1+emGXVWg7qCjoyjl8xyNIPlWaoWKpMvn1avv2mW2Kt/yBJFg0JAYv2yKyudpiwsUOexA55WthBzyQwq4ssBjtjA8zekyxdXoXwHTcaq8s3MsuLYWKpgdM7r+ZUDr5t4ogninoGmOcXbDKdz//rumdA4dxrX7BybTg65Ow57PruR1XBoCibk//f9h9zhpHODYaa7ExzJ/mmrHYpy5uGVWmemZdsSRcMVsYFAzy+Dz+2NGHE/2XyJ1UwmbcHgDXU2fXVf97OrpkaO9/M9Xmd5j5EHPDjOOmlFAys20I9pnScGQ9nryCqt0/VGgP/cbfRODb5Ot3g2ce/GmHM//b2G1aoe1Vob1nieehKZvKXf+JtA9meQWf78+Sjcbt4erzn9UJ9Bv3t07/+XlbAyaXMMjZd6ssbf8bjFUAZRHLGsnwJU/CfMMxNzlR7AAPvN1QSI4SQ3ndm6XjQ3ulRjxcjc+29BbdXPV4vFtzJC4ca6GjlnL1Sq1THhcLI1F1BQe1Fo+8pmJwzoACfak7Py87tj/o6yOo4E/paRVpIpiq5lUw2FzpgljGWEQ9m4l7o1SgSt+f6Bl5BKXIt9nSNjWIsa7aWqZY0d7nAtdBw4upj/+rDUmnsELnC2znVrsBfmXq/S7f1gFayLNXnb0vMblrB13iOf8Zk9nk9CgKmyyLs2R5ayfc7lWmutOzxXgbE0hSkvpbwCD/hkVbIvVLxEyeKmmrDEa5HKnxUKr0NHEjl2uwd5ApYKVKU+adG3voSSaVnAPD/Vb7+dQMZKPO7QuH1HVlB/v+Bpn1VnrENUEg60pWhbwZt634c2gJyoJOsBTZKMYycbtxcAIm85BhCfTfpUJdjwkAdfNRg0vpiTM7+R+tbNjeD/hePVGEbt+oBVn/17aUZlFOBxa/v0FS7Kq9vM2UAD+8AQemMAsEdlaTnJZC+vbNJ71LdvwAOCKNUywLKqaijANbwK/IdXknCSyGfiwO6ge18VxWQMbmBgHSq1rtN0xdhewX1wFjXRtX3CS/BLbWmNvGIZ4/u/DHd9fofya5/JNO3mtZbFIkxjulrZp3LaKPlrD5APePIoesuP+ijzlgJI07dncOzoyUex2BOmm4q6Omm2j4KBjJMgL6XhQe0PuS23gnSIu/g0ypHMHj5Li2X6UajgaqqhQwdycdlbYK+6VGyj4WSrB5BEX6zI3Sbjoovihzfa/qB0IuPUbysL8ZhJyWpy9TUr+t7bMVj+kvesFmoFV5PLOH5d7sC6Ad1ArmlHib/rIr6l2bEYXdy8yCzfzR3z3TB1QWlOmS9yysYqNJiFAfM8kKuOwPPCcOe6cezd3m5VSv5oNZn7E7TtNZA9vMPs9etP+52y86hNCetNCu5vvu8bnvGRqWQG5ynpJitsdCDwEl8vw6d43nZw9A1x7r+kWGgCoQNXwIwcPsJr1rKzfJdvlFVdwa0n5qU+gLgWpVriZnbwjTl/7AnK81BWbffinaD3wONwVSFLUCG430xVrfoedNH3XtNxCd90/NO3Wk0K/WoZxWl7v4fIEhZ3zLFROynoM0tSmP6uO+YPB2N+W/x0G6lRLCY8VyfBTCDjmAaIUIY8TyIhN0/ef/Eg6VhAM/j3+aTA7/lmj2bcfY8f/JDz/23+jKwl+CBrIhFMb45FbRc8Gm5cHMxn1/cwCR0ymhHi03/MHn5ej57c320XNbfn8Asrm/pMbuaL25f600odnNxu5hNNEHPp82KBH97PrudzhbX8+5hPg5YY40s8inKiBqeX0y+NUaW/6iHFehgZJUucweExZ7B7NxLYOotXMHPQzeMO4utuOEuSWAo69uXu/oZa7otmO5KLU40eVGMr7K8HuebNy/OO/sE/w9EHeUwCmVuZHN0cmVhbQplbmRvYmoKOCAwIG9iago8PCAvVHlwZSAvRm9udAovU3VidHlwZSAvVHlwZTEKL05hbWUgL0YxCi9CYXNlRm9udCAvVGltZXMtUm9tYW4KL0VuY29kaW5nIC9XaW5BbnNpRW5jb2RpbmcKPj4KZW5kb2JqCjkgMCBvYmoKPDwgL1R5cGUgL0ZvbnQKL1N1YnR5cGUgL1R5cGUxCi9OYW1lIC9GMgovQmFzZUZvbnQgL1RpbWVzLUJvbGQKL0VuY29kaW5nIC9XaW5BbnNpRW5jb2RpbmcKPj4KZW5kb2JqCjEwIDAgb2JqCjw8Ci9UeXBlIC9YT2JqZWN0Ci9TdWJ0eXBlIC9JbWFnZQovV2lkdGggMTk5Ci9IZWlnaHQgNzMKL0ZpbHRlciAvRmxhdGVEZWNvZGUKL0RlY29kZVBhcm1zIDw8IC9QcmVkaWN0b3IgMTUgL0NvbG9ycyAxIC9Db2x1bW5zIDE5OSAvQml0c1BlckNvbXBvbmVudCA4Pj4KL0NvbG9yU3BhY2UgL0RldmljZUdyYXkKL0JpdHNQZXJDb21wb25lbnQgOAovTGVuZ3RoIDEwOT4+CnN0cmVhbQpoge3PAQkAMAzAsPkXfW7i8DISBe2cHeZ3wCM+Wny0+Gjx0eKjxUeLjxYfLT5afLT4aPHR4qPFR4uPFh8tPlp8tPho8dHio8VHi48WHy0+Wny0+Gjx0eKjxUeLjxYfLT5afLT4aNnycQGAMFDLCmVuZHN0cmVhbQplbmRvYmoKMTEgMCBvYmoKPDwKL1R5cGUgL1hPYmplY3QKL1N1YnR5cGUgL0ltYWdlCi9XaWR0aCAxOTkKL0hlaWdodCA3MwovU01hc2sgMTAgMCBSCi9GaWx0ZXIgL0ZsYXRlRGVjb2RlCi9EZWNvZGVQYXJtcyA8PCAvUHJlZGljdG9yIDE1IC9Db2xvcnMgMyAvQ29sdW1ucyAxOTkgL0JpdHNQZXJDb21wb25lbnQgOD4+Ci9Db2xvclNwYWNlIC9EZXZpY2VSR0IKL0JpdHNQZXJDb21wb25lbnQgOAovTGVuZ3RoIDExOTk0Pj4Kc3RyZWFtCnic7X13fBbV8v4zZ8vbkrwJJCSBUENXQFRQsCMgIqgXLlIUQVARrmK7XlTEdhE7SlFRsYsoYgURQUCw0ZQiKEgNCZCQXt68ZXfP/P7YN70AISDe33c++8f7nj19n52ZM2fOLEkp8X/0f1SvpP7VHahAhsSRkAxKmIBDIEqhaI3or+7V6UyWZeUX5sdExxBOo3miv5ZXEfDmYeP+XQECNCKNoBB0QCWoRDpBJWiAQnAJzOzoauEWf2Fv/1rKyc9687MZKzcuAYOZ7cSE2KSZkz6YPf+JSE/kDVeNi45q+Nd20qa/DFU7imXHtUUqQSOoIJWgEBxECqALqIBKYZxpBAXQSnK6BL/b1eP4/wNdkuXbX8z+eNnbNWVwOdzzpn373cYlM+dPtVOYeegVY266diLAAKSUeQV5kRGRmqqdmj7jL5GA89ON63/zQwAEk8GAJGYmCQCsEViSJDAAsARJhkawsc/EUtLwX4vB/P7ZbrdyGrH9+qXcgqwh/75UU/XasxUWFyiKmpTQilkSCQBEtGDZWwuWvaVp+sLnVts1GIbxv4yq19JC9+z0AwATABAsBgMglkwAPAJuhTwKpETAYgkGAWHMgQEJBkgjGr3Z384jpnZwlkiDvzH5A/5AMEBEmqo5dL3v+LMcmuOokAJARDv2bY1rkBAMBZ0OV/lbhhG65s4eHlfk248vOcUS6aRIwPPW+1L8VrYFIpwdIRZ18cTplZnKyN+K56UbEESE9zq6hiVotcg0Q+JffwS2Fli2cAyLRSINkIzXu7gaVqn/70U2qsqnMPOsD5/4ectKqnW5wkCn1mdPufWFARPP9Tg91WRg/uLFdbkF2YmNGvOpev9OCqr+LGYBtHJTGCiSwRKKUimbZBiM49KQ/BJXbPCpgELQCBpIIeiEiS31ng1Or/Xs8ZJhGn3GdXY5XIpQrrr4n0OvuNVG05pNy19ZMI2oxmnyRsS88ciXP21eNX3ew1XvWtJa9OLGPWk77p9586KZ608NsE4KqmRqfuG492AVUyRRQwd5NWiAasIMwAqQS3GNGy0SGte5fr+FKzb4HARNUIlej7FNtSsaaX9TYfj73i13PXujqlR4MYQQ709dxgwhxE2P9A+EAtWWtSxz4bM/5Rdlj36kv645Kt+V1pcvrE85vPeu566XLD+b/oPLUQ1Lq1+q56VU/nlv5SU/V3Tfx+oFCYjUwJLz/fJIPmflcW4hAkEATFbw4w+Ln5li7d1Zt1ZcCr4/39PJK0KSDXBA4r5kR9+/LaTWbVtzz/TRqqqCUP6SLEdM7n3PCzcKobz56JIhvUdXymBfiqr+Z8ZNkR7vxWdfUW0GAEQAQQjxj3sv3Ll/28keUT2hiig/eW5uzIuiWwQaOOWuPOPbvQgYYECUXBRukKSUBfkAQl99EHjtUdTJzMnA9Paucc31gMRlcdS20Jt9IC4zJcYIbgSwu0j+XYynm3aue3TOnYoQRKj2OpJzaMh/LkjPTrv2shvuGvEowFXz7D/0p8vhGX31HaZlCKJKly2R7N+qUO5+/sas3PQT7znXfNUDqqxNR3LV50UvL5yKueAAFwShMqkICPHktVfefNOoxQ+MpycnOgdeCl1AAMQAQIBlwgwGP3ymbsACMCRBe7qds2noPgkdAJOWnd4/6F8D4PcCyzrtedeetJ33z7xFURSqlVRVu2f6Dd9v+qZ7x4vuGPpQ1QyKqt7zwsgoT/T4fz5QiVGRIIADIX/4L0ERYtQj/e1FQC3IOOpVC50oqvK7vF1wwTz1rmTzzVQUGtAAsqIWjIn+dlLimLFPe5su9Dtu+ENGfRcMXdoj4skHI554GEQkGGRfQEEmZx2ocwe6RyvkfYmhh5khK5mH+7eJVP4olA9tC5zODItANz8+UNf0mrhU+cvpcPY9fxCDe3a+vHf3q6tm2Jv2RyDo79XtqqDhJ4HSS9d0KWWRv8D+a8sNoYhr7z2/9tXlidAJoSqv2Wsyz0ftI80X9oAAFfrVbWN2/Ec0b9hsSS5QBuzUftEe1X7q7Jn0AFiCONw4sfHVC3VmVwCGJrDiHsRgMDFYiKjCgnmDm+gZQXnAf5runRPRyEf6RXi8RwcUkQS///hKwwwNuf8CXXOOufpuX9BXlZ9NeHqwrurzn1gdCPpLCzt1lyWtvMKcSpValnnjw/1OErDqjqqCLu8wGxSp8dYCOyXq5xs9rwwEUGxyqs8EM8BgfNQtIslZriGngyJLliGCQcxmAGaozj0BEBX7CrO9RCKGyMwYD6BdlAidElDVQXz8sGVFbkHmsXCpVklt5/93lWmZ9864we3y3PTffqqqzrxnvsVWJWFnSmPck9c4NOcHU78Lmn6bLTkcDsly059ryxTckiunMHPdtjUnY0LqiCqZUWT9nqUMbsJ/FNkpUVtHKR1iARCQ/FU2mCElJMOQ1zWusjpzOCisvzMEEwkYwRMYBQgAOe1WGCByB/wbG+lCPeZX8SRpGNWSIJryym1CUK144paN27z7yLJHb55tmKHhUy7OyDlIhOJA4bPv3980odU57XpULZXvy5nw7CCn7vpo6g9up4cATdWZec2mr6suDQXRs+/dL04Cu6oTqojyW76h3tvaenmvrcwobaKVM0p2ywkZfgvMkAzmnVdGVzPvLEEgwSQYsDnWiY5NqC1LWB+ItJCx16FQQ51OEjLqTES04Ns3Iz3e6q0AxC6ne/a/P3774eWP3vISCeXp9yaNeeLKUrsDCVr/+2qXwz164N2GFapaQ4Evd/R/++ia45X/fPbsxHcSY5uBweBqkWsYoWfeexBAbl5OXn5ufY2xLvbo4MxfqaFqzkkJb/lKGbnhhtIn0/aLDLCEFCCGibaRSlVzLgeLicKpRAxpQneHb1XMSRlvIHcWlELoBXC4OCG1WgwwQBRR2hCDLFmYHKFEaiRPs5UgAXM+fTrSHVWaIplbJiZPGPxwo5jE0sTigO++WSOLgz4AlbQfTdWnvHbb5FHTmyUkp2enVW3Cktbwhy/u12PIsN633DP8v8WBIk2rwU+NaN3274p9xUQUFemtpyHWAVUE/5Qf1NtbGE/uClvYol0UqdvPmgiHiy1IQEiANlwRW81DZUbID43sVxPE0F0sBCqhL+cn2v8A3AlwdIE4jMjzwdv5IFETCYCqAZfC4BKxSsz+7jGKPJ12npnZkta+tD9fuOsDrycm0u2tBBcisXbbyneXzCwO+cJJNciSPw5sduiuCYMfmvL6rdVu5hDom/ULv163YMHjP2XnH9E1tVpUMfMbDywJmUGXyyVEvZnEq0dVrY+CuChkzNxb6nsY+fPwcs+Oi4ISAoAAc3JkNR0NvPMKSEAwwvYFqJdPqAQp2vEUCr6DRjBSgALoBfCtg+4k50D2vaRE3N7h+8Ifz/dEl+hNBLAsBkhChJ0cyHU4yI0dp1S61UKmaRb6CggUF13GkFjKL36c99NvyzPz0ssjrOZNv5IMwGer37myx3X+oM/jiqwpm8cRYVnmgYw9VB1iXLrnlfu+YJYvLpjy+K0v1eMbqB5vTWyYaOhAbtmSjSLKHHdmbC8EM5ggJUAxuqjMq4j4yGFSy1R1SIO8FfcEd76E3J+gSgAQFsi+JGQmKx2t/DuC7ttzLY6q6FxlWYdhw4sJAAn3wvTQsEStqrvEX0KqqsZ4G+w/tOuO6ddVdXGpZfO4JEOFvwopP237tn/PoWe36/lnao07MNERDU3LmP3ZY5WYIrN8avw7jaITLcu86cm+9a6wHz/TC0kETZRbsbPfLP0947cCsISUYPyzhasq+gPvvgGwraqHkyK8KP+2SRPpy2Er2cIC+7n1BoAAyUTgQjB2+eBRSa3YdylzGGQ7azFYVRodDMo9xaeVvYp2pW1zaLogVL3Kmy6rXlW18sM5B3TVMaDn8Bq0fkjIIb3GGJYRCBWXJjLk5JEvvPnAskbRidv2bhz7dD9FUSDora9m1OM4j1uvIo+OQlne9b6wx3xv1gRb0vhNCckQgJSPd46qwqeIU/dBZ3vThgQTpNr3rjLxR4Qfx0OogAUhQZKTpkH1gnwQNnYJwJyDcu4ZrvJcMBTczKyAwEwMkjIQ4Wy3scA636sAlT1w/ioShG/WfqzUbdld8oNLuJppGYJEQ288gRVR7RhFjzN6px3Z63F4iMjlcD9923sO3QUgvyj33peGKULRStyTftyydFT/iXXpWXVUJ58kl4KAVfqPcwJ82EcJHkEImhJSAgIER6WREhVPfxaCYPt1CoCYCeRtVIoq3vIiGUWky7DI4wJ4r6LDt4AUkGRmlulKxN07MkKXxTjKo8pfOAekoUQjZFhQknb4CoqsavX6v4x+T9kc6a7LUqvqEIQQ32/9umOLs01pKFV815g5PqZJyAi8vfS5qTfPbdSgiZ2+bd/GFz+eLEgIIbhcrf5QsSCqL9Xq+FHFrI8+MzRnS1kKIf+MV/VxnSKe7GtZEgxICVHZAhmYN599hWQbRMN7zJY2+KEKjCpzMxRb4ZYg5pYzIFQEf4aw7Ill8xc1+oF3O2oV1DUiM7DFVtVt815s7OP//jOkCAqcTnaFrIIjmqodFeSSZSNvQq9z/tG0UStddRhWKO3I3jVblhzMSqmg0RO27d3YrcOlphVyVHGrYrYm3zhbsvz3sOcABEOBh+aOKSjOBaCU19xL6gua/noYYQnVhVe5X+odeu93+IzwfwEQjI+2FG/Zy4P7gBmwtfVyxJA7d9hbwKVWdWragaJiS1Elf3uLOASyISUh/fCcS/mfwMoIo0UbyMFFUj2niVJxwQgYxnbADUBRGpvGwQYRPT/aFjCYLJxGlHZkr72XXIXY6244ccgTTWJbVFuwTVKny86+xv4dMoKvfvnf7ft/IUJBcQ4QtmhWogZRcR5nxIGMXc/MvydkhN39RA1KuccZ+fztC4OhkKbVz4mJOklA5uiCifnRM7nQAAACFGaVrIM5CiGsV4FMWcaEfFOfJiJbTweBiNkytF4jKzCqrC0ghig59xDRDqoXWc+AFJDJkGz8qsT9XNmsBRRkTwS5mAkwGV6Jvc8e7pprFjiIa5rHv4QCIb9ib9OUUKw38cHrZ7mc7pIE+mzN3J+2f1vkz69UlsENIhoN7TW+S+vz7xg8lYhW/vrFxh2rAdheVOUzSylvHvCAZDn5jdEuh6dGNAHMPGn4iy0T20lp+QIF0Vr9HCesq683szf3DmtPXmHndwALCuBRI9bdpc9LAey9GorSw5zW/+JrCAShM1GZA4zjmn9Bc5avkgJHyF5xk4SQ3PR+OvgwrAzoJoRJynlAiLTzK0kQIgoWL7FP7CjKGSHzYJsmb09dVyDBIcB5OsHKtAwSRATTMv499Pm2SZ3tdGa+fcaA8loOVSOjKL8487XFjwPQNcf0CZ9e1vXqy7peTSCFKsOmYXR8u2ZddhzYVO58RDXzQKCX7/lasvVn6tYXF06adMML0ZE96mWkJ3SCQEmOjvbdWfqXAUeJDWnxVYkNbHVdsjx4GDZ+Slz2GCYltS7PdeTuRUQESCIJsiCL4D4DKQuhMSBBBpvrREJxVaXElzedrTyGwmwJ4bSsg7ek9C+wChWCwojRTiNVXUqLwY/dGNadAyH/nEWP3jf0xZ+2LQXh2I+0h8zQ7TMHRLqjnx+/kKUFEuVFoCXNZ8Z96A/6np5/l1N31VLPa/cuN8zQrE8n70jdDEF5RTknMrryVM/nUs5p5EwrKoIp+zXzALbsmwFBIEapgYqk48bJlQVZ+i8QBFGiqqsRtGsYiMNWUDgR+x3IWak5IgoUzrbRqjn7BILrkpvOn7u6AApZgCW5jft0MSsA6Nyyx5y7lwJIy9w37YPxYIy+4j8EvPLlwx5n1FGLV6KCoizDCubkH3HqjlJexcwXdepvWMY7S591O6qDFBEAyXLGhC8NK/Tcx/fsT98pBDGjQUTsiYyuPNUzqt67PCFqz64tI1qGX55giPMKyInwXrJgElA796DImAqoIkIov0Q42nqVidAuqBbIgkLsfRbaeVUZVVHWHVIWMASzwTKbZeEHuf1Buba9DxIdPFWM+38RhYyQlDI1c+8T827TFF0RamKDZhec2W/jztUeVxSOg1WFSVedTs2dXZihamWW+lhv4g197s7ITf117w9Ug/RncPd2vVRVXbX58/0ZO0vbbd64XR3HVoXq+YxNpCYAtPaGlxK+aa+SUjJftm3XMpQL+lXVuGEW2tYEACALQgK21YqgJsN9ezULcqJg0ds2D9SdfUOhDU2Svnv3YBFAYAbjkoan0QlBXdNTs/98+sMJDk0XAqYMPnD9bCKa+fkkIUiIaqzttV9N45INMzTv2xdKU6LcUVNHvxMIFT/y9ihFUE0FI52RY/pNyivK/vT718sfmoj2xNTXYOt53iVz62jdrRFAKUHEFBaQYpuQwqq6/o/RVMW4AoCsACklvEpI2NoVMVDA8YeqhVTBoe4gJ8CKcqYZ2hTdYJrm6PjNkVyEdTuekKSfJozKpmaNWhumoegaM1/edbCA8u2mTyrLvmPjWKZl3jnoaV+gID0v1aE5Abj0iGdv/cS0jIkvD6hFnWLm2wY8LqWcNPc6p+6uKduxELMs97vCRNf/2/zH8BaS0W3B/qVXNIKUUBHWqATYDCnN21RfjCwAYVXdFoLE4DxuUVit2bA4a5Rl7mYoYFMiYFoZkdG3jdziC+utDJh8XYJ2WqEqJjJWsiEEEhs0G3bZxOyC9A9XzXBolZXFY6HEBklO3f3Ln6tcuhNAlDt66k3zTcu8e87V7lo1dJcjolXjjvvSf3c73EDZrrWuuRiQsn4MfPUfsEcQBNGvmUH3hi3hRR+Fl35K+07QaohIQShR1UuEIOdz26xq84aK3gkVf8ZM4JCinmMZWxOb7yLg/dQQEHbufLSd8zRa/pVQqyZnBM3ggyNeI+Cpj/7l0F01+RdXPtRX7mLIQRfeysyvfDUFhK7JFz026n1Lmre/1Ich7TyiuosIyU3OkCyf/mhCOLFELDo1h2WZRx/AsdFJ0Tz+zA2BoZmmBEOAbGAJ1i+6ohqNCkDIV+bBBwYxhMkdD1TLpazQ+kDu7YAOSMXRJxRYEdt4paI0HLih0PaDAQgW35qkn1buCgCY0evsQUG/35Jy2cYPQqavbn5ycdGNO7fquSN1U6QretpNH2qqw+fPf/CtoUeNIcPgCVdPy8lP1zVHRVHLZ7e5uOyP5Jo0/WOk+keVIOr19SEI0i8+J/jtqvKqerWQsjbOpaw1pKEEUhaExc1mVgsp0/dqMPdekAaWinZBKLjKGz9fc3T/IC20ON2AAJgAntremegQpxJVtSgZ5emijleFjNCW3WuW/vL+sZ6aqpjLktaYvg9allkcKHz2lk+JlMXr3ly19VNNrw1Sdh0uLcKyrLTsvapa4bkz801XTjItk5kLCguIKCryuC0d5an+UbUjNzihreeLFAUeNxRhu2faqnrwnenOe58uyUgybSuvf4m0EOkgqqCq0/5R3Gl3BWARGennmObvDB2wSO1uGWu9sa/rrn4CfMMvRVAo7FtlYnJr5/FqVMwVTkWcjNgpRb4iKeXvKWvfWfW0KHGIOd4TeY0bJjeOTWaWnVv1AMAs+3cbdWbz815aPIlBtdfmcnqkNBd8P7MSK3I7oqSUPp/PkhYRuT0npMXjZKBKEo1sF33/OapkFg280pcDlPAqTQm+8gDpkjSDhAXdJE2WqnZUtu4DVCftacfNV0OJ4MBSmT9RymwZFpMmiXaWuTEy7mPN1UcQ0+e54T0LBoAVPT2WlKcsVtOxk8vpMi3TQFCt4rhydCIAkCwfuO71oFFsSWvS29cKITo16zH68inN4zs8M/ZLZjat0HdbFy7b/CGRqGqvj46IZSC78JC9+mOwlFbXVpcMu/juvII8AIqieNz1EDGGrJMahY3IN3UayQBpDN0ijUmXpJqkWaRa0EzSDNJM0g1qM4QKf4Z/C9QAND+0QugFUIugFUqQhLBsdzzqYFqHLZkXkbBFqMmCWPm8MOyWRwAwrb1zUvJpp1FVJBr9fDe3o0Zn85oo0hn9yIh5phXyBQqmzBumqxUMNDER8SMv+U+T2OTS/URmZpYhw5+WvSe78HC+Lzs6olH3tn027VnVOrGrxxlJVLbVreu601GX1Wi1dFJQVUHJECIw7TFSTFIldCZdkmKSbpFqkmZCNahhY/SYAiFAivhtDFl7oRdBLYTmg1YArViCLCZGQwtkSR+0c12xywH+JsMY8HMxRJmV9fwY5ecLPeZpx6QqEJFYtPaNr395/7hKNfI2vffa2VJKZr7nzX61mJoIpGvu89r1vaDNVd6IWIQ5eCXfIQKQnX9o8aY3FKGMv+rJOgykFqoJVVxegpyINFEFLdhVOPDgj9j0PWtEukWaSZpFikGtz6ezh1U6UELZX4qMR6H54SiEXgABCw0kZ0qGFIl63CZQpKrgjKV5vxcxhAhPESHZLXb3iTBPbzZlExHdNP3cmvb+uIpqFO9tdvfVs6SUilBmLLrzUN6+ozdRUfaV/1seZKrQZo1fbtafTSHcnGEaR891YqQq8Ly6z29JUcqcQVJi+dWNL2viqg6wTKED8L1JvJ6VSNbOh2sMKAoQKuGm9YVv7wvC1nYFQQgQ9Y1Tv+npPs25VHnauHvlOyueOJbNP6fmfnz4JyHTD+Bw7r5ZS+4SpADHaoWvhZj5pt5Tzk6+9EQrqkKnAlUABND8/ZQ0X2XTLQGXJjkXX5GoHy0iwu58s9eK7MMBQBCIwoJPCAAzz4qY0Er/+yAKAFRFnfT2P4oCNR9CJwJgWsYTwz4TQgGgCPW5L27JKT5yXA3VMq0RzugnRi48GcuaU4Qqm+b+kT9+dVa1IRXsNeJZcXr/5u7OMQ6vLvKCcnOu8cE+X6pPSgrzpFIkwd6PNZE+qEHDv2dIf0uaE1692O2IqCkDgzs07j78gkn2n5AVeHjBYIdW24bMsZMi1BfHLqt32WfTKUUVAEFo/8GBXQVHHYzt4Ei2s3LJkTmARNiIQOL5c6PubFutAP3bUMqRHdMXT1BE9fYdyzKevWFFIBSOupOavWPud5Pr9r2aSnYsyXL6qGWnaVS0OpBk/D68mTWuVc/42g+rMyQDJYdGpe21DLCEyS938xoj4if+zSEFoHmj9mN7PQag2sCNHZqeXwopAqVk/SFIVM5U83Zh+av86VOGvK3vkycPUjj1vKo8SeYt2cG+iw7nBbmGN7CcCsXo18w5/7K4iNrC/f8t6beU799ePbXSYzat0LQhX5syHNZLEeqL39yW6zs+paqUSiPwMMuxvaZ1aNLtRDp89Ob+QlSVEjMkONtvvfNn4epD/gOFls+QMQ7RoYF+aRPniNaRuiL+d79YAwB7j2yb9c2dqig7OOV1xd3T73XTCsezUIQ2aUFvl16j7fRYpkeyfOja96MjGp1od49GpwWq/o8AFPlzJ398rVMLmzdbx3cd2u3+0ruK0B74pK9Lr1G1PyoRxHMjvjHlSVHPK9H/mjT5+1KEK2bWqO87NOlOCrHg5EZdKmUg5Vi1qKpKVev4Lk8N/erUQArHtbssgPvXZU/fkm+L6A7R2sZ/Jqn1dOBOAMWGdB6PzqQqdOGnaZckuqae1+CoodXzgpZDIZdqR9ZCSqHRPOr08hQFIFmOvvgxXyB38ifXdG7aq+JNdukee/UbTji2iVdIeWLwIj61HozHJAEFIe7t/TkBCUaiR5wT51ie6g9KAFjcL+GK5tXvSd39Y9bs3wp2Xd+0ReRRzlkrYDFnHwj3nxXzxPkxx/KwFUKPTw+uywgketTneza8LjmilkL3/JQ1a2sBmBcPSLyqhSf+rf1H/BZCku9qa1qn6RZPfkF+ef1dkPLhpif2Zm6ppUh5IkARykNXfaTXk33ruOjovEol6K/uNRjjOkbOujCudKTv7Swc813mgK8OF45r5axOl551caPZ2wravJPin5BcC0tTFeGcsweEh8+JnnLuMUEKwKIU37o0f+5trWJe3xeliVoKfb7fN2tLPhj3dvUWG3zBJweP+K0GDtE+od626E8qMTMRMcu2jc7bl721NL2mCZVSntfqymvOuuPUdK9aOjqqIubuMxgPdo16rHuFU4jXt40YsyoTgvwml6KqQlgflg0cIgc4UGS1iqrckJ2TgE7zDwQlQ/Jj3Ruax4YpVaHbv88a2MZz5w/ZsPjCxBrxoSpiyJJ0KPTmpXGPbcyNcag/pQcQkjtHt3hkQ85f+83po5IQgkCWtAAwuH2jbgfzt/155JeQFai4W8yaondM6HFh8qDE6FZUEh3lVNLxnbGxmH0mQ/JD51aO67AyLQAAkl0KAVAA59y9IQsAG+OSAUiGJghAsDqtp+NHqbvzjDL/S0HilT1LrkronXR0R8Rv9vtS84w11zRp+W5Kv2SP1yGqdVUgYNDXh6AQLFYEPXBOzG0rjkCl1/rGX/jZwbWDm5xuelV58kaVhbli5mJ/sRMRI857qOT5lT3Gulnbq9Lxbggy88iHrnzolufatziz0q2jaMfrj4RPrVQKgSsIQ7/NACHCobg0UgXEq3tDBrtVAtMRvwVAEAUsBlCtCv770KTJZ3ttwdjWqz1yrvexbt5mERVQrhC6fZK25mCF0EqqoPvW5iiaMmbVEQDP94ytyfuFGZ/tKoLkldc2HrUs/besIFSCwfsKQhPOjIo8ydZUVVGnLRp234Jelb76VwciIo/bExUZVe7Blx3HKZ+TT4COq0uhUGDgxO75BTkvz59W9e5RBtw+WgMAQcWm9JR7DG9sLygISQC7RzQloMGb+wH8PrxZ14Vp4BKBSJQfkpAc4xAKofOC1O05Blt8XmPnusMBnpB82xnR/92YB8aKqxsnuBUAc7bnn/FRKoFuPzNqxoWxC/f4Nh8Jrs8MmBJXLD40vG3EB73jQfjtSKB3M8+3B4sndI7qEKNZDFWhxm/vTy+2xraP+jHD3y/JPf3C2IFLDkMVERr1+uQg39mGZu6CJrweZX+hOe382GOUtnUjVVGfWXJTYSive8v+xyVnGad4uVZHGjDx/CZxzSYMn9St4wVV7x4FVTEO4dUo3+DoN/dn39TCDh6kChr3fRaAJm4R61IKgjI3IGHx+iOBoMluXUQ7hGQs2V8EBpjiPWrka3uLDF42MHHsqiPrMoIxTgVEly8+BEGdY/Qkj8JAh/mpO/ON3kmuDUdCs37JnXlx3JObcsGYs70wpSgXghLcKgMDFh2CKr495EdIzroozmIQmGbuAXPGzc0T302VjDs7aSBavLsImvDqonBsy3+tzoQqIHl6z5hR7bz1CCkKe9pXcHI0TOOuPq/aizir8tHN8NHqurdI9MWq+Z98++77Ty4rPcSXV5gzfNLlF3Tt/ci46XaLpmWMfeTavMLs8mWZ+bxOl0y+5RkAQSMw7rFBOQXZAN04cMKQPqO5JIrwn/u3v/H5jB37tgJoltjq0dtebBhdwSKvqaph+ru2615tD4/OnLPGtLQkM1gVtv8AoufuYwCStw9rxkCXj9NAODveOX5NFphTR7aQDIUwamUmCNuvb9ri3ZQig/8c0bRNtGYwwLx2cBMQ7cgJAfi4X7zJ+MfX6TvzjWVXJfRp7mn27v7G8S4wR2gCgggc61SyisyJnbwkxIpDAQCweNvI5pKhKiLq9b2QXDi+VYRDlSbD5NHtIm9ffQSqQEimTUgGsHCfD4QXL4gd1c7LlVYV1dFRJQKR+GrzKz/tXWT/Nczgo9d87tI9mqrd91FvUc4NgVle1n5Yy9hOb37/YGncc8k8sNOtPdpcA9DG/Us/+eWFe/vOjY1M8hu+Rz6/RlfLzAGmNB4euMCtV3AcZeac/Kx/PTF01gMfMLOqqEPuvcTpcK3buvrWxwbPefhjgJ56a3JOfmbVcXVo2YlAb34249OVpV7O/M6Xs99bPGfJSxsM0/D5C+95bnSpXWP/wd2jpwxIim/2ykML7ZTtuzcLEvlF+YPuunDxSxuqMuNj0i0UQWrJdOwvNPINCeDTKxM8miCgyJAANmUH/RbvHNHM5mdrDvqz/BYYTT1KSqHRq4kz2avlBWS6zwRRW6/26LpsgGChbbSmKvTdYT9M9upK6/dSUnOMdYMbg8QPhwPLByTe2yU6y2/2belqEaV+urswaEgwvr46sV2MDmDUt+mFIfnBlYlOVYxZkQGFnrsk1qGJH9IDILx8eSPTlJB8pMBASN7YNkIyW5ZUp+9SFaqzkkGg5dvf/WnvIslWrKdJXERTIZTPN80QJLYf/JnDH/GRDClhOVV3n46jGcxgBhq4491aJBG+3DpnW9r34cdAYv2+rwHsyvhFV50oKc5sNfa29LqqD4FnH7QCsCd1h0MPH47Yf3i3qqjM8uZrJs68f97sB+f7g8XM3KV995n3z/vkhe8H9R55ODvtkxXvMXO3My/8YsbaVx/5xLRMKc1r775QlDh8C6F89dLGz2f83Ou8/gAOZqSqigaAmf/9whiEndD5kdnVRD4+bkXyvE8PAYDF/Zu7ASgCIcv2VsGMng1aeTUAqkJ9vkoH86HRLbotPAjgncvjBaHDR6kg+mVwEgTN3p4PwtJrGlsSF36WVmQwVDpvYdqQNu4/r2/GjIs/S2ODezd3TfwxC4ynzmsIouuWZ0DQCz0a9klySWZNFe/uKIQhh7Z2C4Xe+qMAEte0cAPYkhEAqE+SE8CI5RnQRIsILcalgIhm737i0jjzBFzcVVX9ettcAs0Y8UOpGTnPn8mAL5gvSJyVdOl13f5TdtwFYSHYOq7L2IuekmxtTVuzYMMzm1JXdmp6SWm1RJTjO8QsL20/tE/HUaXphlWbpVpR1H9NGw7QlRcNXv7zFwy+77mx0+6akxCXBEAIxY6eEOmKbNmkDQBB4oYHrnA53PENmzw8bjqAxrFNP3pm1Yj7L/f7i0rDIdt2VCnkhOvuX7H2q7AjDZCavl8VqqqoL0/+6NbHB/+6Y20183O8E2prJJc3c6tEDDAjKBnAe71ih7WJAqAKinp9ryF527CkBLeSb0hIRKjovvBgerEFi5tHKm3eS8kOSDCSPMp1y9LXZgRBQEgWjW+lK8SSByxJ//6gf+uIJID+yDVgctdYR8v3UmwbRVbAAqCp1Pzd/bZDn1BE+3kpEARTtm7gjHx9L1SBoNU6xnHDsoz5u30g3NIxAoD6yh6Y/GC3aOPEvNxtK9Hu9M3NY8+0xWm0K45ZmtIEkaLotWvdilCYWVMcFc9zU3GwiAGPI/rYe5KVm26ahqKod454aODF142fet2utD80Vatp18SwDGJIlg+MLT3xC29EdCDodzrcb3026x+9rwdgSav/v84BICUTkdsVaZoGgHH/HaQq2rP3vJEQmySlBQHJUlQ80nJMqCovEXo0cixN869ILf7hYPHdP2VvyjFsa+bdP2Vf3zpyyYHigUszGFg5MLFttG5J1gRBoQZvpbDFHofwAXFvpzCzroiQ5DMXpAH4tF/8raszs4DIN/ZTOPgUPu8X3z5GB6AKmLqgOXvtDjR0iCd+zXtyUx4AyexWRTEEvbzHrRIBrAt6eXe4rw6FXt4DQAiSzJPX505en4uQTB3b/AQhZZjmgE63rdzx/uvfh91/77z85ThvMwDMFoF+TVn+a8q3ACRbA7vc1iP5artgSvYfCzc8n1WUlpLzh2GFRvaYYpTz8SWQ3ygQJJZsfX3J1rkATCv0/LCVteyqEWjbrs2apifFtzAtq0l88+KAT7L0B4pVtfqNMsMICUUFo33LM8pqJghFIaI9B/8szVmqMDHzSw/OB2CYhv3FgHYtzrSkFRuTkJOfecujg9547PPyTYjjtWQsvirBqxMEXbo4fVO2MaCZi8e3cgnKCrB4bd+ApRlscfqNzWx7NwOrr0mEBFucM7bFNwMSIJlNmXpjsx+uTYDFsHjrkMYDmrszb2reyCnsT1WCkTqyaf8WHgCGKce0j4REtEaJbgXAgr7xQ1q5JcOjkXFbq1s6RkIiwaX4bm4xsm0EJKI0weNbXdvcbccb+vyKRtb4lpAAI0oj4/bkeNeJn9jmXh2GP37NF80bdLCkBeIZKyd8ufnlUqO2KjSPHuXRo2JcjS5uM7jsicrgL6nLD+TuiItqOn3oqppEm6Y67eLJcV1q1/GEEA+/fAeA1Iz9A+7ods2dPdyuCEWIR16p8UMPmqpZbBJhw/Yfy6db0mLmnl0uDddMYslLv34xY+27074G4aYpA1RF27n/N/uTO/1vP3fgxPNyCrIAZOYcrtTEcc+vZGSObmExgyGIiGBIzhvbwmL7A2ukVNzyS/KowXHhgI7dGzmD41rZv+NdavC2VqW2VcNC2o3N7Rms5Ps6+6LYWRfG7swzOn+UCpN7JbkuSnS+z7C52rM9Gj5zfkMiGBJzL417/ZI4EAyLF1wRz7aHKcEwOTiupV1zPRqDhFBvueRZBhcHCh5dNOj7PxcOPvdOIsHgzk0vGXT23bZkNGQZdJLjuoy98KlNB1Z8vPG5uWvuv+miaeVfWgY7NI9k2afDDT1bX2snmrUqVTn52ZrNk8q//0Rp6SmqolZ72EFTdTCIxMx5/33z8fAatqi40I6k1f+iwXmFOSUDJCFElNtrWZaiKET49/NjNVXj8MLDbooY9k5l2UDqaF9WiJRykcOJoAqhCqFUt4tcHiU1/S5NqdadWteo9+LDIPrun00Mi2uvk8qnl+thPTpqq4q2ft/SkqMaFO2JldKyG3Brkcwy13ek2m/LEIiIurXsa0nz98Pr1Ip5mGWit6Ug2p+9vdp29x3cdfBISiBQ/NKHTwJQFSUzN13XHBGuyG/mbF40a/2iWevffPxLyzIzczNq8kyXLOc9tYyZM3MzJjxxnWEZGdmHB99zkSKU6IgYwzTtKZQsn3zzgc9Wzrvmrh6qohJISmlj6OuXf7HbWjRrvb0UWLHuqwrzU4c5PcWkEHosPHTEb93cIeKiROdRXalOBTE2p3z75ebZ9kkgCenSI7o2622a5lnNL33np0f3ZW198JMrSx/PRW0Ht27UtbS0YRnX95jy4bon3/t56vDu95evuEPC+R+aT/1+6Ocpnw20i5vS+He/txp4EgCEjOAdT44gIofutCzz4dte3JO6k4iivbGmZdowauiNCxpBh+4MhoL2hyRFlc/ExTdoMnLguPcXv5aavn/QXRcA0FTNoTvnP7PCkpbbFREIBV0O5+oNS1dvWGp34+Jz+waNgB3BFOWCzzh0l2GG5i15tVf3/qX1/w18QW9ckbk2PTDprKg5l8SdFpACTGlc3+MhwwpIWBKWZHlGYs8h597LYMM0nr9uparokqUFy4IVsoJdki5rn9jNkKFSMdG12WWGFfz1wHJVVZs37GhYQXvN6HZEPXTVhxabpcUBxHub2qU6tOz8j94jiUSkx7to9vqG3rhuZ/Rs36rzRWf1Kq1ZUdQFz37XIbnLynVfAZDSWjx7Y4fks5LiW5QbAQ+94uaPn1sTFxMvWUZHNnz8X7M+fm516TbA8le3jB10V4ukNs0bt2qV1HbRrA33jZqqKtrw/rd0bNO1vNlz4fNrzjmjZ2xMfPn5oZARQp2o0r4D1fAbR0ssraSWDLLka99HtYkfS0/qi7gs5FU1gaPK6xn23ZKPalP5DGW3KkVDKFOS6s0r4ZRR3XnV3T9mlU7bVUvSS7nIDSsyVYUOF1fQE1MKTSGQVmQCAOHh9bm2Anbr6ky/ydkBC8B/1uY8uDankv/fy9sK7voxW1cA4PnN+XYpTaUNmUG7QU0Vqw4FPtjls79CdvN3mQErXKGmiqWp/pOHqnLn8arVJssonFIRfJVvVYq3UVb4bwYpnKAELB1utF723bYovfqXqyjISREqgL6L06N0svd5CBi5IrORSwHAwI48o/ITIrSIVMt9ZwkADJN7xDu2Z4fsrLpArJNKYX33j9kJnrC+KP6Oz+S0JD6eq+4S0H6KNmthhiz/m1Hpi51cDoKlm7sEWBwOvFjpd1nBcrYGycwguxVLQohwTkuWhV+QzESEEonJXJ9Lv787nTKl9P8BibgJ0gplbmRzdHJlYW0KZW5kb2JqCjEyIDAgb2JqCjw8IC9UeXBlIC9QYWdlCi9NZWRpYUJveCBbMC4wMDAgMC4wMDAgNTk1LjI4MCA4NDEuODkwXQovUGFyZW50IDMgMCBSCi9Db250ZW50cyAxMyAwIFIKPj4KZW5kb2JqCjEzIDAgb2JqCjw8IC9GaWx0ZXIgL0ZsYXRlRGVjb2RlCi9MZW5ndGggMzI2MiA+PgpzdHJlYW0KeJytWk1z28gRvftXzCFbJVfRMD4JYk9RZHpD19rUirSzVaschsBIgoMPegBwXfpJ+Qm5pXLOf7B3D1vaKp+cvaRyyOsZACLIEZxDbJdJkZjBdPfr168bemRbtm2z/f/l9aPjDy++wYdhwH5kNnvBfmDsz3iTPPrDmnm+ZTtTFnqe5UYhWydY4QY+W//Inj53WWTZbH3F2A8njuU//jNbv2h3xPfzNW3gB5Y7fWgDZ28D9oQt2Xqxfv3t6QVLxE7Ij2zLr7lknJVsx7NSsq0Uu7SqS1aULK1Fzt4sFlj3fHnx8pQ9m7Pz029OX85frZdYKTl71wi2LauKsyt+y942FbaKRVX9XOIGrKlKVm7eipp+qmphPH5nv+taUzug4w9PHZdFLXldWnq1XuRiVThz2TSKrGgW6lUuc2wraJc9W7LTs/lqhZclTn3x3ev5/gbtXach1nsRrXewkXPsdddip2RRyXjJzrmExV8b7XCcyPL98IEtB3FYKh+lZfFRpiUTrBJwXCK2okhEUYtqwgo4UIUGr7koKp6lCYcP4WzJmpxthfxUJsrJgc0uT+K0ePcfrOWXjxkvyoqVDXZ9y9nUtse8Pp1GluuHx16/PKlEWsXYsqywZy4qQUcELMgVMc9wVnV6Xjc8wwmupbguZYqbXz62TJ72IysIAg1PO3JNnnbG8G3e4AjfXAfrQ8XSoqp5xn/5jU5O7qTYwStAPW9qnPWWJ+VTeDJPE/JygsPXAgDmSIKKnPkLwZislbUGdLv55clznmXsjMsEvmmBnhZJuksTeGOCbHqH11HHezNrNvW0NY4bHFtT00F3beDpJo7bhqE1AieEzxs6ccwTTrBIEHkC/WL56u8Xi+UKpnwGFhSUcoolw3U1f8+ZeNekO4pirfa++J0T2BNbQUldJxhBqiEvjJrhziwndLQZvmMAuxQ8BYImLM2B3fqnIk5xd2KMpkhrQIjjKyKcu8noKVi7keadcj+DLk8I9nWTgcnGTWH9aWiXUcOc0PLDyEBHe67eS1kT5IMoBEl1jOwZIe+OQd68wQHkn6cxxTTf3OWMVxUQIYFr9oGdCXW0CSGzP2jeRZwACqdIMAXolV2VMu+wxpM0hmuR1oSt/kIs3paE7SSVIlWcTv4E6ddUQsa8GcxCpGyXu8HUgHYCJY591ufaqSnXeHaXq2QWkoJL1CNFxneKnRffnL+caOZr2CekY4xMaTZVjWyfIEew204UNxx+ogxi4n16nVIca5lucE2175dRc8Kp5dtt8gZOdGxOAVqU4pbjoBn2vS5RbImWrxATSQyBcsiJK5h4igPnyIU43dIXn+X1z5q/ETFF+ThUnFFksSonauKDg7L+Xll6DXBW5Ap8klY5rKbrRutuMA2s0OkyODLIBilinsJpVbmRgg0qOrgSHv0FKazMKBGMqslqwp9A3f5Xnsblk6u04EUsUknFgjz9aQhPUDEuSMonFQwtc8XUP+WiputBgGAI4mGoDBDWqCVBgNeoBZlriAqPmxwskSiktQCh+Dvu5UlS3goA7N9Zjg80z/Kyx7ciz2EmEZUmHC6gjAGbVmlbLkBECsCrz8gi9rpqVJ18k6IYfaJP5u/jrIEx5agxvm95rqEwr+5kKtgLCKLNRyPpuL419dpU82eBiXS8UdIxbnBYZytVFX/T8GzL4p7q29IHikBEZ23rGlCFqrYKnaiylMyyTDegHiQrqDVDXdYBJ8qRBBxgWm8IZQQU4odCub36Qpo6nhX5bZp6rndsCTB6lbaECY+ylCKE1xiVnA4fyzQHepGWlMdK7XIU2GcQwHMcMFFaYpuBgSVyOKN8KHuFXXSaOi4l8mJbtrjhkKlfgdcScauMVFXq8vGoJTa0feAcoyHp7lGXgJdW2axTzBN2hZORh4kbNiCeFqEUoXtFhMtbwk/U+bfybpcONIMq18o+E+L8mQdh1uVdYCxzo52LeYMDxM1zzeCq6KRQEcmvJCWoHnUOn7OzZft+vhrqIAAJppf3qJWCEl+x1iYr4QZOP6so72lrcPzlSS1/rcbD44cuxFxbp0OTNFWEgrOSBALXqzJb6Nq6h6iuimtEAVotqNqmjPdNGQlVkAqqbgxkxZQ7qhP4Cs3KINT3BhNby4+jVkyhwENzBzYEyL6a1CcEikQmNu1tBfk7V2/i9Fet+JhOgYpvUi0zjFDyAZWZ1wke2wSlYBRKxg0OoPRHKloU4IarQptDEw5ARZHqs6jLc1IMytlwBqUUBEPOY64FFYDTh5FoLb8vz3tqaZupd0oTjEbCcwAjQ7oPMC3UfYCNt82nW7U/Sey2DFGntuuSlr3SvID80a3lDVfNP8ypm+76/sCaUPhBK2EMl+NC1kVd970fpen+5V1w9i9/ICaFUMK+63lEnuphAmfuX9kuVThv+zHVBMUQJQqWuq3RqZN0mVIwQFohT8Twhmod+i37xq4XmCYbvQiIssNOH3kmSIZjkDRv8DC7od4kCGSm8+Y4MAm4INEg6phvss9slaK6ITz3KK4rCTuRUNUr2+I9BkdvBjg6rSJwI0NSgRT+xJHz2pXzWE1K/sIuRAW+mxzhVAUNslERlChw8msi33b0VAEE+2XMuu/qOVX+Skde0xxBBkDXZqpud1QjeqEDaegdQxACru7Jq6Rz4Z9yOHFnTsoV8TECJHAsz+sE9NTIWbNRgBg3eGiwMepq7ZlupNF6i/qOm1KSClVq7aopFJlrCudX6XsFDOXYhnddrSZCRnhUvWEyTlmeb0M1GnIbvqN2jAqfEigk8anbIWcb3enaEG1hp+JnJndGo+40bnCsXwdcmgi0WBJNTluvJiR6cNi3HydK9ZUjPm/rgyqwaPDiG5VX1A2R4W3YkNFC1Q3cieRgMT4N9Rya4RpqcaJpnPp1UHetbkQxLSXSCYWslF/q91t5x5FrBzNVP7Q89E8umvWpZ56prvYlliF67jS0gpmCARSra9CCnrW/xUOjVN8K/eCB3QahXCm2A1WgZig6qAYisCpbZoDpmZJ9GddKhhBPWlf8lG90w7bPOfTdYj1/yRY0/h6LlBtMrVlkaNT6Y1yezFfoLKlcD0TQrYKbbjSqkkQRWt1eTsCoBt1+2klwYiXq7cmGa6kyU+kyPd4cEqYpMF5ouXbQzRsNjxe88fGreYODtFrd0w+VZD186QTGflwIm1I3IZLrouDZSmuneoidEPloPr/vsiEM1LCDHzU63Zyzl+6jIXOnFnrDti80DS1NZxmxptJiilNMSRJ3o2TT4DURBxt5aAZH27hRU5zAmrkGpUiNZX9EEyCcaIowtk2X7xuefHjjw0nzBgeAOB3xGoykKp6j8Oq+Iv/4PtVdg+1Sf1yqee8ANvBoxpGb0OFldgM+nfQpPpDpbSjGXOfMAsv3DIn7fw7fkGOnvhV4PnPQa82cyMixnaozBQ3tTajH7Y7lmFpt32IHGxxYHwVWEIYP7DSInqQR3g30uKYuaLb0+rD/M4kl5ahezvFDOUf1SY+EBPtAtIwr9BiigaAjqTUaNQ89RNjNCmaG6o5Cl1a68xoWA/JM91ytC2rVHpZKJJoEPVqFvubVQGBTlR3uqx7Z7UOTJLvq2kdP70LqzQyYK/Rj075rb5vG6t7Dout3+krH2sdUQj3pko22CT1OrKZsXR9BVxgJwHasaTeTDzwDAfjjFcG8wbHQ6v2thHR8I+BEgsfdEyJ27cyjIr636ANTOKLpN7tJt59rWM14dt3kXCe97gWhi4oYaMLqCdij4tmO9vwCniL0A90k3yHVaBgRQrAl+rlV0jf59Ayposlw0j5sbQCfoupmSKT8VKNJeoyUYaF6LaWCEzUSzIcPUqhbk1TdiX0IfjHffNqJtNJN61aWX3gSN2tL2fHwpu21RJt3v+mGpn3OQFMJWdaCgIfUjuVdklKOXvYLcfV7ekIEMdzQGKh9gIZ0UP06TRPKgnrwyvTUF12B0z4L972pCWOjRca4/qg1eiir/7dUzkW+kWVrZnWfyOzLSfmFMU5kRaYRvnms4qg99v+X14+6X46YgqQB0wD8EUKE+VNF3hLC/9G7R44LmUy/aYK/7TcH6+KcPV247Fn56DvD76bgPiS6I+S7E7IQ3X7g+31p8vrSdH66Wp2eLy/Wc/ZmsT799p9niyWbf3/27evV4s1yP/pOSAqL7h9Zs8DUSixerdYXr/VvkpyfXqwXZyo4z+aqL/vHkt49W1zMF+vloM9wwf+BPVOWhV5/yrDfeHV69jXSL5aiJj39ez3khv7ndRqXViFq9hTodiJIC9/23SdTezobDKtmre+iyPKiwHD2V39TTyrbevb1cHGknBfOZpbf6bLB4vM3L558T3+6Zf8FunvilAplbmRzdHJlYW0KZW5kb2JqCjE0IDAgb2JqCjw8IC9UeXBlIC9QYWdlCi9NZWRpYUJveCBbMC4wMDAgMC4wMDAgNTk1LjI4MCA4NDEuODkwXQovUGFyZW50IDMgMCBSCi9Db250ZW50cyAxNSAwIFIKPj4KZW5kb2JqCjE1IDAgb2JqCjw8IC9GaWx0ZXIgL0ZsYXRlRGVjb2RlCi9MZW5ndGggMjkzNyA+PgpzdHJlYW0KeJytWU1v3EYSvetX9CVAgpUYfnOY0yry2FBgW1pp7A2Q5NAie0bt5bDH3eTE8U/bW7CHPe1xf4Dgg+EAPgV7WexhXzXJ+VKLToDYhjWa4TSrXr2qelU88j3f99nu/3pxdP/Nqyd4M0vYj8xn37DvGPsBL8qjr2csij0/SFkWRV6YZ2xW4huJn7DZj+zLxyHLPZ/N5ox993nsRV/8wGbf9Cfi8+mMDogTL0wfOiDYOYCdsFO2VJoz1TJZ81IuV9UvdSE5KwV73fLqdSs0W2lhGv7+nWL0uSy4vmM1Z4W60bx+b69dtlVjX4SfMcFetVoZ+i34jHHFlr8Y9v3nK62Y5g3//gv6hDeaG3XMePVhid+dfgxAhKGXkvnlgfm3qlb6Tkvci5drVfCCXgocZ1bCcAPDVSGMabk0zOCeW5NVobSGa3DjTgsOi0sJtyuvM2T//n7o5UHU4RhMfFcg4tFAOA84CMS1YCuhy1ZzDUP3g7FSmkU+MGy0rDsEJdwrFbnVGrYWuGwp6kYZIMrOpo+mz2dTfK0UCFWhaiPxCgcPx+JSwZQNrH0pa9Po1p5wPBaKNA+9MAzuh8IIRFFqIRtF0ZV1KWr51nKGjF9xjbuQvWfT6+vzi+c/X51fXLvATrPQS8Kc7hDgjYkL7GQMbPcBB2BfsNn57MXT0yvgB4QAwwog3a1FhSBUsJkvuEWDnGlUydlOOvT0wk9LIsIPb4FfABqsBoTwv6haI9f0icW/XcL3W76WhEGtRjFOA28SZfcxBoi4P6VqyWtl2U2kpxO3McennDVCF0JqYkPvGr+RFeJRl+oEhlIcLnoEptdk41zpJWdGVbJEQnFnZOLQC+KkAzaKnPUoHY2M84CDyMwU+YN/a14pGG8DwN8Q21GEthhT4EAu5O6rFsXJglAjQksbDwSR4wR40jEQoUC8FDt/cnnyDPCxx09esj9RebJ4FVo2H1BH8MloZKLAi5PofmSI+Y3C3VCHlrKWSCa+5sdkLAFLLKjkDTKQrMHdl8Is8TElzYZV4IahjPywlsoJfxB4WRr01TwOXfBno/A7D7jXDjZEmgstCsoO8EIs2q5ugksNLGawHGXV2MLBK/7+PwJcU4z4WcNH8QbliB2kO+rXkHVin3/j+eAjj9O8s9uPgvt2owayVYWc+P6LY+ILqAH7VrotiQzGGktlktv6eINfC7W0qf0WPLHXEl+2XlKCFx/n6HSIliF60Nv4LqUvnYH85iv+tqPnJoQ1b1ot3o5yKMl9L8oc2U2kNUZR11KaCK0t5/EPdkjbB/ZoEaYIazJhSZpBRuTdgSELENv+xK+nz6eP/3UG5B10SmJ8LQiGr23tSDx2YYi51Dmlqrv+itz5K0dZYY95VbFpodgl139jV8LA2D2zohTm+Pvn7/p5jOq0BID/XQoSCTeiFtS2KVmWRLWWkkiYd6iiDfVtCtVXLgfCCX72tAhzR6NIvGAsH9wHPNgoGkqFocVp200XKEStbHhXc/wUBDdCGrRnWS80RRPA8Z9OWiPGAbQ9Evw9tsnDixZyiq8JFNIDtlePcirIvCh0dQyhP6KeEo3WcjEIu90y6qo0cZ55aZT0wASBC9lwDFn3AYfIHhSHxtbzyP9sI3MsKgV14U4ywnIyWyHPDLih5Rw/b3hVdEVVC3sNu1XI3pIvLMsasbAAPsTgMVjjSerlcS/bwkl2340ueseskktJKQv+1pC7d6h+ioVwpESNhPFtLUsitfWINJdec6tTEWul8b2O+6WkXi2pVdPldNY2gka8wh08NkP13SLxjhoho5DW4yI6zlKUC0c+cqvUl12q9UJFvCF13ltYWWVpWxcMulWNcKrkOEm9JOnTKU6crBkdV9wH/CbW2HIOJBFn6sEkjWC0JB+oBYuC+hMxAKNL8051wFN+IkSWDmdcl4jT+g7Id4o1CKlLC5JW0F2aCMZRD22JHy3wMdyZpI5ktGEeybow9YKsT5qccLiP3+iU4T7gN+GX2KwrZP36f2I88QjqFeZFyqlCrnjJO7k/lLtH/Cf24sFyN4pbAP8mDnE1JBkvX7dSdwKamnUBzUUKj+7VSeOdRETy+xP4pKR1ghyiKRTX8U4LwKE1ZZkyrmBEeeJlea+VojR2BWN0CnEf8EcHg4QxvddW/axV2lpAc3A9zC+KveSVsDrmd0YkmiSen+cPRaQDc1PucGvfljxlO+BafCzaSnUlr5QPDRURVEzs22wJ3bN1Mj5UuA/4o4HmoJ6RPcJbtnd0ulU/Uq0UazuA00hC4eh4akYBTiDZA8dioxQr1HPbrz8hvZyYRohbGLmkXbZ7+YDg7uV/NHAVBtQeto4EnaC+bTWKM1LW1ujf7yFqRRQ5xevE5eHu5YcDT9cHujG/mzz3POY7+fPzgkae2a3ArGw6G1FnLuFDgVHhhtMW59JhbohikEa5y9zcYe7e5QfmTt8UmDRp5CCAYZwkNY3vHbMdMU2LHYyTjd01bNo7Lq0NMzQQ20lDEmsldaTaYNj7uIZ23R8xoszmVphFYEjgGDEuvr46f3L6z39jiDu7ePbiuWvSCJPQyzMHHdO9iydecnjxge+PkGHaCh7QrUUbkhQU2s4Y6vlFddca6GZD4xt+0tsgpRa7ARXDfHtModMY+4idwLEFCQRbqLeqA68X9Vafke5yOUb71YmDhekweOyHdffyfddOTbchI9M3+sQKQ7vwsTKv83hT1Dd7EA5NYzuh3clyu5/tM65byvJDSm+2Ej17Jl7gdC+IvGTSL9Ji1xiQjo8B7gMeXDjQXupGywUsZkvSF5oNjZ1idQOJLOymZ9ipkYq26x2qwjvxO1wz7oz8nM0xteuxohz6oTfJHfptKapb2vEYEuXy1xI49x2g+4QZbubWoN2GDFto2+OWGcEElPAHyeZHLohHNbP7gDGIrX5TS0HcdsE8b+sd9WCrh7SjwO2wal/pDycUiBtRodiUNKUaXq2t5gIkinaJNBYTDnj5flQtB7StHVbjYeAQrShdSg/PCWDJrVz92lhlbrdn9h4MZQ8lzfYX61WLUtfBv3GtWwxB+Qn08hUftuWIKPWwGlce5sm2yIJco07Qxta1FaebombR7EGjXV+QUXYWfSLTgKprZ3UJaFva7bFDjEOOfV86Pg+4D/hEg6edl62x7StadBjyfrsMn/OCSsraztuzXnye0jMhuwEEyM+GJDnuUsM+ggB+7VxDvDM71K7VqCoKaMsa9YrOzxzSeT+CqPb8PXXulqF81Ah2txHvtoBUKBrdfqT38CvuDg7RIx+zQw7Iu7sCs/UZ0feQBmrVdBtCW4dHLQ99L4v7bIwShxbdea7waQDn3ZO2PhSMb2E0qutOtvOhDdjvkiPVbTcArPmy3ybYrm43CVq9GqRD+alNd4Ae7yd9WsaBIwY7injnOdL2CQhZg3IzJw/s9CXkULgbrSphBu4bO1pv1ub7WdsFBjwlLMjsDRh7z2hGo5LnGMD6SSzI0vuuDHp+GF71tqMQwB1l6KkZpzUIQQ2qbbvBoPfx8mTvwYVihyf3Dy1opVvbQbZ/2LTj65gnk4mXpg5dKHrZsE1alMtG9LwwdhdOjxW6ZwybWhPYm+z+rxdHwzNPlLQA/SQJAy9Dg4lTL8sC+MrmR6+PgjDzEnqSjb/9JwffK5bsy/OQPVJHf3E8+8Z94FWQx14QZCybBF4Sxxt5GW3k5eXp9fXp5cUVWtfL89npU1pms+m3Z09fXJ+/vNgtmgis1Y9ZmnuTJHNI1fPn17OrF8/QBy/Y5enV7PzMrnUfTW22/+OCXj06v5qez/b35WGEDuVPrGdZtLEy2xx8fXr21c464s9dOBFN3kgUlVo07EuMS0GO6Sj24/Ak9dP9KWXSY0dMzROH7c//Tmw665Prq/0v5xa8DOSInRr98uU3J9/Sn+Fr/wfuiLBMCmVuZHN0cmVhbQplbmRvYmoKMTYgMCBvYmoKPDwgL1R5cGUgL1BhZ2UKL01lZGlhQm94IFswLjAwMCAwLjAwMCA1OTUuMjgwIDg0MS44OTBdCi9QYXJlbnQgMyAwIFIKL0NvbnRlbnRzIDE3IDAgUgo+PgplbmRvYmoKMTcgMCBvYmoKPDwgL0ZpbHRlciAvRmxhdGVEZWNvZGUKL0xlbmd0aCAyMDUwID4+CnN0cmVhbQp4nK1Yy24byRXd6yvuJsAYoMv9fngVhaICGo6oIWlngPEgKHWX5HKaXZzupmbgT8suyDofYWRheIBZzWSTVc6tblKkWCJmMbRMtEpdt+/jnHNv9ZknPM+j/e/m7ux4cf5nLKYx/UAevaJvib7DRXn2pyUFYSriKKQ09ESY+rQs6cVlQL4nYlreEn371XiyWPxrRhezBV1M55PpcrZ49h0tX9FkyQbCSHh+Qil2hEHI+3ERZ7T8wRrKhTfYSQWNVdv+x1Cp6EI3Snemfdmb6r3Elt6m78OpNHrCqL9nlM5JVp1q5OfeLjs7nV39cz6Fu2tTquYTtaqhRslKf5SlxE0t7vt+o6jGlvfyg6S1qsuf6kJLutW1rAulG0m1ajtFham7RnaGFMl1o1pVd8rp8pCGJM9FEg5p3He0NMVmhd3GPvrWNCt2CFYJ9uv2VjW9B9IQwmEXjKBzXcNj3mBuEMU9/G8JP/Cq1J//q9oR9o8nF5Or5WQbLf5WmKaUDZmNDbEwK9xV2NQLR+WSNBd5mPdJTsLYVTnfGXMUiyB5ysBBlZ7TZEWFbG2NbmWlCt0nA86tG4PADK1UqSXSS7JD6nkF9/5yA5SMyFZMVshEQ5sVlaY9qDSnodtUstGlxK3YWsimQ+xv8Sgay6Y8WbMkF0GUHtes5XxuywPTI0AJYWxadgmFKn6tP2zuFKkXSPV71ZRctfYgx0EYCD9OKYkSkQS5g17zyWI8ZYKNZ1fL+fnyzflrV5GCRMSZP+TYi46LlAmaq7bQTLBxj1pk7Al+BZHIk/AJqweVm7UOTlmu1RsGLGBGW2Ls2DJ6KGZtbnVh2QnnGt31cN5jpqrvNfMS36Sen6yTH4ssG3AWxfmxtyupK4a9hBf3X1qGjdl0DcOhlhX/Crxt6sGhUrdrU+sbbZUBYahqx6aRpU3i0TugoOXo5Ltn2CGt0XXz5V4bkve6ZWV4kBTWjA9yRWp1MhAvFn7uABzs2+e2GzzH3DT6TjLL92SpdTE4zmIRe3GfmDwIXOA4yWC3gUcMvpL0Xq9/ATlBUfDX0gHV34MHZJYpiqpKXA5gZBi0zMnuS7PSteHLdSM/9lqgS1VZ1vbWbMxABkRZ4oJWm6pjzabQ+8OplKJbiMwfOgWHdBTBu6+6RqOMwF4DNYT4cEEN3csKC53pGCBmD8I3zHWzMtaTXq0gVdhdaGPRBM2RP1rndM3YBqasUq1M2au8ecwdlgiQ52QgSST8wNFADByqoZs2bRqItBAefICryGi/gCffoH+5s+yETxSJqNcmiJWrAWQiOAkfp4GnGwD4gma4boYe0Iu7bq26c4crqk+bFnLeEusHOiWT7lE3RnhzdTdYmAJiTW0ZbGg5Xb55fT5nHWjVpj2Z7DAUaZgOipI7cD+eDeYmC0evLVWBpuPWQIBClnq1rnh1xApUQF/qvq1pq4+4ydCm7Rkh21YCXLBwEMXJaSMOQuFF8TFYGOMcPB36v64gfeyCtIOFnXxkNTTNrT7XclcAgm4ctrMsEFEaUuwhX0HqaGeXs/nMgbEo4/Fy0O4sTo4xlgsMhRDk1g42dIn0aQbApWlsyiaVYoY90dCyXIRQVPdjDhvaLrVD9SxVK8Vdg2V+Zau4V1CQu2v62W1Evcx3ZhjEyv/da76s3tuZTp6U/QhzRpI5ZB+ZhyPgNkyNuIdsYcLgQbF4nhvmuH1yYBk+ooWV7KezM0QRRrN8EPaQC3ac9pOdwW3gRGfYn9S2ro54pIWQgpHlUGI7QRxQmmeBoSKAZm236Vrx9PCRd+L6R3SXn+9VBXvQX9wyNI7+tk88PpvNyQqEgIkXHldgMG5nAcsGHpzlreq4F/EIsZ/4IZx2Px6G7GFAo37QwZ0Ssm1nJqh0X9F7fQeCYly45UOQs3A+sOJvJ7M8dBXupCa7DTwq3CWSS6piJ4D424FpC8ltcs5aANhdQ5gMfb2RPEc9p8U1pIrbi4Z864aDbLs+eovHvtnzyLSXCQ68UR82P6MdyQd82NlsxA35ZNG8TOT+0F2iyBHJipUC7eReV2gJcui+LSYxQZOBTSgg/Gbn2BnV2MxvqaVwDkRFaw3MIVxIz+oJBWB17Nc/284fYEAsMa29e3YqhDBHBw0czOeTjsJE+p5Rtd6KEcaMcvNR8vxgRbxUUBnDYoj4rCpa752MD9MYk7zroHG1ePNyf0OcidgPDjf4+xvom6PP0dJuweVKHPTHwSPLx4b5MyL+j6T2loeLhyB9m9v97+bubHiWn4YiCxMKkhDnrIj8KBUpGnoDXXa8D8HGBz8DW52dKvjBrjx/+80fR/gB5D71fYfZv6LTNHQpq4omBTOs+Tuf3dD8XWZ8HL/z/Pf2zs+y/Wa0ZxaHR8hcZ1iO6a3CoNCeLkGQpyKJPApizOA4Mm1rkCQiTbLTJdjt/Z1rsLP7ZBGW2r4x+E3oShNf+OgbceCLFOckHObT1O8j+/7MD1KcnhAX/g1/ebSvWNGLaUAX5uzrJzPh5xj8/ZTSzBcYqHcEDnesuT5fLM6vZ3PMn2+ny/PX/x7jxDX5Zvz6zWL69mDo8lOc6+3zc0xBrjFterVYzt/8BcPsjK7P58vp2I5EFxPavu6bON/28fuM2MtsZGm48zLdGV6cj19CtYqGe6eWf4SoQdIkNL/ThRG16ugFNNPPcfqKvCh4nnhJtv+EKBtyl/NIF7uE7B/cl4Z3HObl4ebcJi8FuqPA9Tbz+u2r5weC9X+hRib9CmVuZHN0cmVhbQplbmRvYmoKeHJlZgowIDE4CjAwMDAwMDAwMDAgNjU1MzUgZiAKMDAwMDAwMDAwOSAwMDAwMCBuIAowMDAwMDAwMDc0IDAwMDAwIG4gCjAwMDAwMDAxMjAgMDAwMDAgbiAKMDAwMDAwMDM0MyAwMDAwMCBuIAowMDAwMDAwMzgwIDAwMDAwIG4gCjAwMDAwMDA1MjkgMDAwMDAgbiAKMDAwMDAwMDYzMiAwMDAwMCBuIAowMDAwMDA0NzQzIDAwMDAwIG4gCjAwMDAwMDQ4NTIgMDAwMDAgbiAKMDAwMDAwNDk2MCAwMDAwMCBuIAowMDAwMDA1MzEzIDAwMDAwIG4gCjAwMDAwMTc1NjYgMDAwMDAgbiAKMDAwMDAxNzY3MSAwMDAwMCBuIAowMDAwMDIxMDA3IDAwMDAwIG4gCjAwMDAwMjExMTIgMDAwMDAgbiAKMDAwMDAyNDEyMyAwMDAwMCBuIAowMDAwMDI0MjI4IDAwMDAwIG4gCnRyYWlsZXIKPDwKL1NpemUgMTgKL1Jvb3QgMSAwIFIKL0luZm8gNSAwIFIKL0lEWzw2NGY1MjdiNGRiNDBiZGNlODU3NGNlNjhkZThkM2YxOD48NjRmNTI3YjRkYjQwYmRjZTg1NzRjZTY4ZGU4ZDNmMTg+XQo+PgpzdGFydHhyZWYKMjYzNTIKJSVFT0YK";

$data = [
  "open_id"=> 5,
  "token"=> "943f8622-e750-457c-bd64-6414ee5936f15e3b555b-2007-439b-9c8c-f8a415bac415",
  "status"=> "pending",
  "name"=> "Contrato Clique",
  "original_file"=> "https://luizaotenisclub.com.br/Teste123.pdf",
  "base64_pdf"=> $pdf,
  "signed_file"=> null,
  "created_at"=> "2020-04-16T03:33:46.241747Z",
  "last_update_at"=> "2020-04-16T03:33:46.241775Z",
  "signers"=> [
          "token"=> "943f8622-e750-457c-bd64-6414ee5936f15e3b555b-2007-439b-9c8c-f8a415bac415",
          "sign_url"=> "https://app.zapsign.com.br/verificar/943f8622-e750-457c-bd64-6414ee5936f15e3b555b-2007-439b-9c8c-f8a415bac415",
          "status"=> "new",
          "name"=> "Abdo Teste",
          "email"=> "abdo@cliqueresponde.com.br",
          "phone_country"=> "",
          "phone_number"=> "19992664779",
          "send_automatic_whatsapp"=> true,
          "times_viewed"=> 0,
          "last_view_at"=> null,
          "signed_at"=> null
      ,
          "token"=> "943f8622-e750-457c-bd64-6414ee5936f15e3b555b-2007-439b-9c8c-f8a415bac415",
          "sign_url"=> "https://app.zapsign.com.br/verificar/943f8622-e750-457c-bd64-6414ee5936f15e3b555b-2007-439b-9c8c-f8a415bac415",
          "status"=> "new",
          "name"=> "Zeze PDF",
          "email"=> "amdmustafa@hotmail.com",
          "phone_country"=> "",
          "phone_number"=> "19984586867",
          "send_automatic_whatsapp"=> true,
          "times_viewed"=> 0,
          "last_view_at"=> null,
          "signed_at"=> null
      
  ]
];

$dataheader = [
  'Content-type' => 'application/json',
  'Authorization' => 'Bearer 943f8622-e750-457c-bd64-6414ee5936f15e3b555b-2007-439b-9c8c-f8a415bac415'
];    

// API URL
$url = 'https://sandbox.api.zapsign.com.br/api/v1/docs/';
//$authorization = "Authorization: Bearer 080042cad6356ad5dc0a720c18b53b8e53d4c274";

$payload = json_encode($data);
$payloadheader = json_encode($dataheader);
//print_r($payloadheader);
//exit;

$curl = curl_init();
curl_setopt_array($curl, [
CURLOPT_URL => $url,
CURLOPT_RETURNTRANSFER => true,
CURLOPT_POSTFIELDS=>$payload,
CURLOPT_ENCODING => "",
CURLOPT_MAXREDIRS => 10,
CURLOPT_TIMEOUT => 30,
CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
CURLOPT_CUSTOMREQUEST => "POST",
CURLOPT_HTTPHEADER => [
  "Content-type: application/json",
  "Authorization: Bearer 943f8622-e750-457c-bd64-6414ee5936f15e3b555b-2007-439b-9c8c-f8a415bac415"
],
]);

$response = curl_exec($curl);
$err = curl_error($curl);
print_r($err);
exit;

$datax = json_decode($response);

if(isset($datax->token) && !empty($datax->token)){
  $token = $datax->token;
 // $grava = (new Orm('leads'))->set(['id_subscriber'=>$id_subscriber])->where(['id_lead', $id])->update();
 }


				//exit;

}

}