<?php
use Core\Controller;
use Models\Users;
use Models\Permissao;
use Models\Orm;
use Models\Validate;
use Models\Email;
use Models\Leads;
use Models\Financeiro;
use Dompdf\Dompdf;
use Dompdf\Exception;
use Dompdf\Options;
use Models\ReportFinanceiro;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\IOFactory;

class LeadsController extends Controller {

  private $user;
  private $arr;
  private $permissao;

    public function __construct() {              
        $this->user = new Users();
        $this->permissao = new Permissao(); 

        if($this->user->isLogged() == false){                  
         header("Location: ".BASE_URL."login");        
         exit;         
        }

       
        $permissoes = $this->permissao->getPermissoes();
        $modulo_boleto = $this->permissao->getPermissoesBoleto();
        
         $this->arr = array(
          'user'=>$this->user,
          'menuActive'=>'home',
          'permissao'=>$permissoes,
          'modulo_boleto'=>$modulo_boleto
         );          

}

public function index() {   
$this->arr['list_js'] = array(
'plugins/sweetalert2',
'helpers',
'system',
'functions_js'
);  

$this->arr['usuario_logado'] = $this->user->getId();

//$this->permissao->temPermissao('crm', 'crm-meus-leads');
$this->arr['tipo'] = $this->user->getTipo();
$tab = new Orm('leads');
$id_usuario = $this->user->getId();
$this->arr['origens'] = (new Orm('origem_venda'))->select('*')->order(['nome_origem asc'])->get();
$this->arr['produtos'] = (new Orm('produtos'))->select('*')->order(['nome_produto asc'])->get();
$this->arr['funis'] = (new Orm('funil'))->select('*')->order(['nome_funil asc'])->get();
$this->arr['produtores'] = (new Orm('usuarios'))
->select(['id_usuario, nome'])->where(['tipo','Produtor'])->order(['nome asc'])->get();
$l = new Leads();
$teste = $l->getCliente();
$cliente = $teste->nome;
$this->arr['cliente'] = $cliente;
$this->arr['iduser'] = $this->user->getId();
/*

switch($this->user->getTipo()){
case 'Super Admin':
$this->arr['lista'] = $tab->select('*')->order(['id_lead desc'])->paginate('50')
->get();
$this->arr['paginacao'] = $tab->render("leads");
break;

case 'Produtor':
$this->arr['lista'] = $tab->select('*')
->where(['para',$id_usuario])
->order(['id_lead desc'])->paginate('50')->get();
$this->arr['paginacao'] = $tab->render("leads");
break;
}
*/

switch($this->user->getTipo()){
  case 'Super Admin':
    $tab = new Orm('leads');
    $this->arr['lista'] = $tab->select('*')->wherecustom("origem != 'V ONLINE' and para = '0'")->order(['data_entrada desc'])->paginate('50')->get();
    $this->arr['paginacao'] = $tab->render("leads");

    // $l = new Leads();
    // $this->arr['lista'] = $l->getVOnlinef(); 
   



    //$this->arr['paginacao'] = $tab->render("leads");
    /*
    $this->arr['lista'] = $tab->select('*')
  ->where(['para',0])
  ->order(['id_lead desc'])->paginate('50')
  ->get();
  $this->arr['paginacao'] = $tab->render("leads");*/
  break;
  
  case 'Produtor':
    $vendedor = $this->user->getId();
   /* $tab = new Orm('leads');
    $this->arr['lista'] = $tab->select('*')
    ->wherecustom("origem != 'V ONLINE' AND ORIGEM != 'INATIVO' AND para = '$vendedor'")->order(['data_entrada desc'])->paginate('10')->get();
    $this->arr['paginacao'] = $tab->render("leads");*/
    
/*
    $sql = $this->db->prepare("SELECT * FROM leads join usuario_produto on leads.para = usuario_produto.id_usuario and leads.produto = usuario_produto.produto where origem != 'V ONLINE' AND para = '$vendedor' order by data_entrada DESC");
     $sql->execute();
     if($sql->rowCount()>0){
       $array = $sql->fetchall();
     }*/

   // aqui funciona
   $l = new Leads();
    $vendedor = $this->user->getId();
    //if($cliente == 'Apae Piracicaba' || $cliente == 'Clique Responde' ){
      $this->arr['lista'] = $tab->select('*')->wherecustom("para = '$vendedor'")->order(['data_entrada desc'])->paginate('10')->get();
      $this->arr['paginacao'] = $tab->render("leads");
    //}else{
    //  $this->arr['lista'] = $l->getProdutorf($vendedor);
    //}

    
  

   // $this->arr['paginacao'] = $tab->render("leads");
    /*
  $this->arr['lista'] = $tab->select('*')
  ->where(['para',$id_usuario])
  ->order(['id_lead desc'])->paginate('50')->get();
  $this->arr['paginacao'] = $tab->render("leads");*/
  break;
  }
  
//$this->arr['paginacao'] = $tab->render("leads");
$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);


if(isset($_GET['nome']) || isset($_GET['produto']) || isset($_GET['origem']) || isset($_GET['status']) || isset($_GET['codsocio']) || isset($_GET['codsistema']) || isset($_GET['vendedor']) || isset($_GET['funil'])){
$nome    = $_GET['nome'];
$produto = $_GET['produto'];
$origem  = $_GET['origem'];
$status  = $_GET['status'];
$codsocio  = $_GET['codsocio'];
$codsistema  = $_GET['codsistema'];
$funil  = $_GET['funil'];
$telefone  = $_GET['telefone'];


switch($this->user->getTipo()){
case 'Super Admin':
$vendedor  = $_GET['vendedor'];

/* atualizar aqui os ids q irao ver o V ONLINE */
$l = new Leads();
$teste = $l->getCliente();
$cliente = $teste->nome;
$this->arr['cliente'] = $cliente;
$this->arr['iduser'] = $this->user->getId();
//echo $cliente;
//exit;
//$vonline = 'V ONLINE';
//$this->user->getId() == 27 && $cliente == 'Clique Responde'
if($this->user->getId() == 33 && $cliente == 'Cartao de Todos Piracicaba' || $this->user->getId() == 27 && $cliente == 'Clique Responde' ){
  $lista = (new Orm('leads'))->select('*')
  ->orSearch(
    ['nome', $nome],
    ['produto', $produto],
    ['origem', $origem],
    ['status', $status],
    ['codsocio', $codsocio],
    ['codsistema', $codsistema],
    ['para', $vendedor],
    ['funil_id', $funil],
    ['telefone', $telefone])
  ->order(['data_entrada desc'])->paginate('50')
  ->get();
 // $this->arr['paginacao'] = $lista->render("leads");
}else{
  $l = new Leads();
  $lista = $l->getVOnline($nome,$produto,$origem,$status,$codsocio,$codsistema,$vendedor,$funil,$telefone);

 //echo '<pre>';
 //print_r($vonlineget);
//exit;

}

break;

case 'Produtor':
$id_usuario = $this->user->getId();
$l = new Leads();
$teste = $l->getCliente();
$cliente = $teste->nome;
$this->arr['cliente'] = $cliente;

$l = new Leads();
if($cliente == 'Apae Piracicaba' || $cliente == 'Clique Responde' ){
  $lista = $l->getProdutorApae($nome,$produto,$origem,$status,$codsocio,$codsistema,$id_usuario,$funil,$telefone);
}else{
  $lista = $l->getProdutor($nome,$produto,$origem,$status,$codsocio,$codsistema,$id_usuario,$funil,$telefone);
  
}
 //echo '<pre>';
 //print_r($lista);
 //exit;
/*
$lista = (new Orm('leads'))->select('*')
->orSearch(
  ['nome', $nome],
  ['produto', $produto],
  ['origem', $origem],
  ['status', $status],
  ['funil_id', $funil])
->e(['para',$id_usuario])
->join(['usuario_produto'])
->on(['leads.para','=','usuario_produto.id_usuario']) 
->get();*/
//echo 'aqui';
//exit;
break;
}//switch

$this->arr['lista'] = $lista;
}

$this->loadTemplate('leads/listar', $this->arr);
}//function index  

public function confere_importar() {  
  $this->arr['usuario_logado'] = $this->user->getId();

  //$this->permissao->temPermissao('crm', 'crm-meus-leads');
  $this->arr['tipo'] = $this->user->getTipo();
  $tab = new Orm('leads');
  $id_usuario = $this->user->getId();
  $this->arr['origens'] = (new Orm('origem_venda'))->select('*')->order(['nome_origem asc'])->get();
  $this->arr['produtos'] = (new Orm('produtos'))->select('*')->order(['nome_produto asc'])->get();
  $this->arr['funis'] = (new Orm('funil'))->select('*')->order(['nome_funil asc'])->get();
  $this->arr['produtores'] = (new Orm('usuarios'))
  ->select(['id_usuario, nome'])->where(['tipo','Produtor'])->order(['nome asc'])->get();
  $l = new Leads();
  $teste = $l->getCliente();
  $cliente = $teste->nome;
  $this->arr['cliente'] = $cliente;
  $this->arr['iduser'] = $this->user->getId();
  /*
  
  switch($this->user->getTipo()){
  case 'Super Admin':
  $this->arr['lista'] = $tab->select('*')->order(['id_lead desc'])->paginate('50')
  ->get();
  $this->arr['paginacao'] = $tab->render("leads");
  break;
  
  case 'Produtor':
  $this->arr['lista'] = $tab->select('*')
  ->where(['para',$id_usuario])
  ->order(['id_lead desc'])->paginate('50')->get();
  $this->arr['paginacao'] = $tab->render("leads");
  break;
  }
  */
  
  switch($this->user->getTipo()){
    case 'Super Admin':
      $tab = new Orm('leads');
      $this->arr['lista'] = $tab->select('*')->wherecustom("origem != 'V ONLINE' and para = '0'")->order(['data_entrada desc'])->paginate('50')->get();
      $this->arr['paginacao'] = $tab->render("leads");
  
      // $l = new Leads();
      // $this->arr['lista'] = $l->getVOnlinef(); 
     
  
  
  
      //$this->arr['paginacao'] = $tab->render("leads");
      /*
      $this->arr['lista'] = $tab->select('*')
    ->where(['para',0])
    ->order(['id_lead desc'])->paginate('50')
    ->get();
    $this->arr['paginacao'] = $tab->render("leads");*/
    break;
    
    case 'Produtor':
      $vendedor = $this->user->getId();
      $tab = new Orm('leads');
      $this->arr['lista'] = $tab->select('*')
      ->wherecustom("origem != 'V ONLINE' AND ORIGEM != 'INATIVO' AND para = '$vendedor'")->order(['data_entrada desc'])->paginate('10')->get();
      $this->arr['paginacao'] = $tab->render("leads");
      
  /*
      $sql = $this->db->prepare("SELECT * FROM leads join usuario_produto on leads.para = usuario_produto.id_usuario and leads.produto = usuario_produto.produto where origem != 'V ONLINE' AND para = '$vendedor' order by data_entrada DESC");
       $sql->execute();
       if($sql->rowCount()>0){
         $array = $sql->fetchall();
       }*/
  
     /* aqui funciona
     $l = new Leads();
      $vendedor = $this->user->getId();
      $this->arr['lista'] = $l->getProdutorf($vendedor);
    */
  
     // $this->arr['paginacao'] = $tab->render("leads");
      /*
    $this->arr['lista'] = $tab->select('*')
    ->where(['para',$id_usuario])
    ->order(['id_lead desc'])->paginate('50')->get();
    $this->arr['paginacao'] = $tab->render("leads");*/
    break;
    }
    
  //$this->arr['paginacao'] = $tab->render("leads");
  $this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
  
  
  if(isset($_GET['nome']) || isset($_GET['produto']) || isset($_GET['origem']) || isset($_GET['status']) || isset($_GET['codsocio']) || isset($_GET['codsistema']) || isset($_GET['vendedor']) || isset($_GET['funil'])){
  $nome    = $_GET['nome'];
  $produto = $_GET['produto'];
  $origem  = $_GET['origem'];
  $status  = $_GET['status'];
  $codsocio  = $_GET['codsocio'];
  $codsistema  = $_GET['codsistema'];
  $funil  = $_GET['funil'];
  $telefone  = $_GET['telefone'];
  
  
  switch($this->user->getTipo()){
  case 'Super Admin':
  $vendedor  = $_GET['vendedor'];
  
  /* atualizar aqui os ids q irao ver o V ONLINE */
  $l = new Leads();
  $teste = $l->getCliente();
  $cliente = $teste->nome;
  $this->arr['cliente'] = $cliente;
  $this->arr['iduser'] = $this->user->getId();
  //echo $cliente;
  //exit;
  //$vonline = 'V ONLINE';
  //$this->user->getId() == 27 && $cliente == 'Clique Responde'
  if($this->user->getId() == 33 && $cliente == 'Cartao de Todos Piracicaba' || $this->user->getId() == 27 && $cliente == 'Clique Responde' ){
    $lista = (new Orm('leads'))->select('*')
    ->orSearch(
      ['nome', $nome],
      ['produto', $produto],
      ['origem', $origem],
      ['status', $status],
      ['codsocio', $codsocio],
      ['codsistema', $codsistema],
      ['para', $vendedor],
      ['funil_id', $funil],
      ['telefone', $telefone])
    ->order(['data_entrada desc'])->paginate('50')
    ->get();
   // $this->arr['paginacao'] = $lista->render("leads");
  }else{
    $l = new Leads();
    $lista = $l->getVOnline($nome,$produto,$origem,$status,$codsocio,$codsistema,$vendedor,$funil,$telefone);
   //echo '<pre>';
   //print_r($vonlineget);
  //exit;
  
  }
  
  break;
  
  case 'Produtor':
  $id_usuario = $this->user->getId();
  $l = new Leads();
  $teste = $l->getCliente();
  $cliente = $teste->nome;
  $this->arr['cliente'] = $cliente;
  
  $l = new Leads();
  $lista = $l->getProdutor($nome,$produto,$origem,$status,$codsocio,$codsistema,$id_usuario,$funil,$telefone);
   //echo '<pre>';
   //print_r($lista);
   //exit;
  /*
  $lista = (new Orm('leads'))->select('*')
  ->orSearch(
    ['nome', $nome],
    ['produto', $produto],
    ['origem', $origem],
    ['status', $status],
    ['funil_id', $funil])
  ->e(['para',$id_usuario])
  ->join(['usuario_produto'])
  ->on(['leads.para','=','usuario_produto.id_usuario']) 
  ->get();*/
  //echo 'aqui';
  //exit;
  break;
  }//switch
  
  $this->arr['lista'] = $lista;
  }

  $this->loadTemplate('leads/listar_confere_importacao', $this->arr);
}

public function add(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'helpers',
'functions_js',
'plugins/sweetalert2',
'system'
);
$this->arr['usuario_logado'] = $this->user->getId();
$this->arr['bairros'] = (new Orm('financeiro_bairro'))->select('*')->get();
$this->arr['produtos'] = (new Orm('produtos'))->select('*')->order(['nome_produto asc'])->get();
$this->arr['origens']  = (new Orm('origem_venda'))->select('*')->get();
$l = new Leads();
$teste = $l->getCliente();
$cliente = $teste->nome;
$this->arr['cliente'] = $cliente;

$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('leads/adicionar', $this->arr);
}//add

public function addProdutor(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'helpers',
'functions_js',
'plugins/sweetalert2',
'system'
);

$this->arr['id_produtor'] = $this->user->getId();
$this->arr['bairros'] = (new Orm('financeiro_bairro'))->select('*')->get();
$this->arr['produtos'] = (new Orm('produtos'))->select('*')->order(['nome_produto asc'])->get();
$this->arr['origens']  = (new Orm('origem_venda'))->select('*')->get();
$l = new Leads();
$teste = $l->getCliente();
$cliente = $teste->nome;
$this->arr['cliente'] = $cliente;

$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('leads/adicionar_produtor', $this->arr);
}//addProdutor

public function distribuir_atendimento(){
  $this->arr['list_js'] = array(
  'plugins/jquery.mask.min',
  'plugins/parsley/parsley.min',
  'plugins/parsley/pt-br',
  'mask_init',
  'plugins/sweetalert2',
  'system'
  );

  $l = new Leads();
  $teste = $l->getCliente();
  $cliente = $teste->nome;
  $this->arr['cliente'] = $cliente;
  $this->arr['atendentes'] = (new Orm('usuarios'))->select('*')->where(['tipo', 'produtor'])->get();
  $this->arr['tipos'] = (new Orm('produtos'))->select('*')->get();

  $tipo = $this->user->getTipo();
  
  if($tipo == 'Super Admin'){
    if(isset($_POST['atendente']) && !empty($_POST['atendente'])){
      $tipon = explode(';',$_POST['tipo']);
      $tiponum = $tipon[0];
      $tipoprod = $tipon[1];
      //echo $tiponum.'-'.$tipoprod;
      //exit;
      if(isset($_POST['funcionario']) && !empty($_POST['funcionario'])){
      $l->distribuir_leadsfuncionario($_POST['atendente'],$_POST['qtde'],$tiponum,$tipoprod,$_POST['funcionario']);
      }else{
      $l->distribuir_leads($_POST['atendente'],$_POST['qtde'],$tiponum,$tipoprod);
      }
    }

  }



  $this->loadTemplate('leads/distribuir_atendimento', $this->arr);
}//edit

public function relatorioprod(){
  $data = array();
  $idusuario = $this->user->getId();

  $this->arr['lista_atendente'] = (new Orm('usuarios'))->select('*')->where(['id_usuario', $idusuario])->get();

  if( isset($_POST['data_inicial']) && !empty($_POST['data_inicial']) && isset($_POST['data_final']) && !empty($_POST['data_final'])){
    $tipo = $_POST['tipo'];
    $data_inicial = $_POST['data_inicial'];
    $data_final = $_POST['data_final'];
    $aten = explode(';',$_POST['atendente']);
    $atendente = $aten[0];
    $data['atendente'] = $aten[1];
    $data['data_inicial'] = $data_inicial;
    $data['data_final'] = $data_final;

    if($tipo == 'recebimento_resumo'){
      $data['consulta'] = (new Orm('vw_report_resumorecebidonatendente'))
      ->select(['*'])
      ->wherecustom("id_user = '$atendente' and data_recebimento >= '$data_inicial' and data_recebimento <= '$data_final'")
      ->get();       
     
      ob_start();
      $this->loadview("leads/financeiro_report_recebimentoresumoatendente_pdf", $data);      
      //exit;
      $html = ob_get_contents();
      ob_end_clean();      
      $options = new Options();
      $options->set('isRemoteEnabled',true);
      $dompdf = new Dompdf($options);
      //$dompdf = new Dompdf();
      $dompdf->loadHtml($html);
      // Render the HTML as PDF
      $dompdf->setPaper('A4', 'portrait');
      $dompdf->render();
      $dompdf->stream("Letter",["Attachment" => false]);  
      }
  
      if($tipo == 'recebimento_detalhe'){
            
        $filtroatendimento = (new Orm('financeiro_faturamento'))
        ->select(['financeiro_faturamento.*, leads.id_importacao,leads.nome, leads.produto, usuarios.nome as agente, leads.cobranca as lcobranca'])
        ->join(['leads'],['usuarios'])
        ->on(
          ['financeiro_faturamento.id_lead','=','leads.id_lead'],
          ['financeiro_faturamento.id_user','=','usuarios.id_usuario'])
        ->wherecustom("financeiro_faturamento.id_user = '$atendente' and financeiro_faturamento.tipo like 'extra_esporadico%' and financeiro_faturamento.recebido = 'SIM' and data_recebimento >= '$data_inicial' and data_recebimento <= '$data_final'")
        ->get();
  
        $this->exportarboletos($filtroatendimento);    

        }

        if($tipo == 'faturamento_resumo'){
          $data['consulta'] = (new Orm('vw_report_resumofaturadonatendente'))
          ->select(['*'])
          ->wherecustom("id_user = '$atendente' and data_agendada >= '$data_inicial' and data_agendada <= '$data_final'")
          ->get();       
         // print_r($data);
         // exit;
         
          ob_start();
          $this->loadview("leads/financeiro_report_faturamentoresumoatendente_pdf", $data);      
          //exit;
          $html = ob_get_contents();
          ob_end_clean();      
          $options = new Options();
          $options->set('isRemoteEnabled',true);
          $dompdf = new Dompdf($options);
          //$dompdf = new Dompdf();
          $dompdf->loadHtml($html);
          // Render the HTML as PDF
          $dompdf->setPaper('A4', 'portrait');
          $dompdf->render();
          $dompdf->stream("Letter",["Attachment" => false]);  
          }

        if($tipo == 'faturamento_detalhe'){
            
          $filtroatendimento = (new Orm('financeiro_faturamento'))
          ->select(['financeiro_faturamento.*, leads.id_importacao,leads.nome, leads.produto, usuarios.nome as agente, leads.cobranca as lcobranca'])
          ->join(['leads'],['usuarios'])
          ->on(
            ['financeiro_faturamento.id_lead','=','leads.id_lead'],
            ['financeiro_faturamento.id_user','=','usuarios.id_usuario'])
          ->wherecustom("financeiro_faturamento.id_user = '$atendente'  and financeiro_faturamento.tipo like 'extra_esporadico%' and data_agendada >= '$data_inicial' and data_agendada <= '$data_final'")
          ->get();
    
          $this->exportarboletos($filtroatendimento);    
  
          }

          if($tipo == 'atendimento_resumo'){

            echo 'relatorio ainda nao disponivel';
            exit;
            $data['consulta'] = (new Orm('vw_report_resumofaturadonatendente'))
            ->select(['*'])
            ->wherecustom("id_user = '$atendente' and data_agendada >= '$data_inicial' and data_agendada <= '$data_final'")
            ->get();       
           // print_r($data);
           // exit;
           
            ob_start();
            $this->loadview("leads/financeiro_report_faturamentoresumoatendente_pdf", $data);      
            //exit;
            $html = ob_get_contents();
            ob_end_clean();      
            $options = new Options();
            $options->set('isRemoteEnabled',true);
            $dompdf = new Dompdf($options);
            //$dompdf = new Dompdf();
            $dompdf->loadHtml($html);
            // Render the HTML as PDF
            $dompdf->setPaper('A4', 'portrait');
            $dompdf->render();
            $dompdf->stream("Letter",["Attachment" => false]);  
            }          

          if($tipo == 'atendimento_detalhe'){
            
            $filtroatendimentoapae = (new Orm('vw_leadsatendimentoapae'))
            ->select('*')
            ->where(['para', $atendente])
            ->between(['data','>=',$data_inicial],['data','<=', $data_final])
            ->get();  
            $this->exportarexcelatendimentoapae($filtroatendimentoapae);  
    
            }



  }
  



$this->loadTemplate('leads/relatorio_prod', $this->arr);
}

public function exportarexcelatendimentoapae($dadosatendimentoapae){
  // echo '<pre>';
  // print_r($dadosatendimentoapae);
  // exit;
 
 //Aqui começa a exportação
 $formato = 'Xlsx';//Xlsx - Xls - Csv
 $file = new Spreadsheet();
 $active_sheet = $file->getActiveSheet();
 
 $active_sheet->setCellValue('a1', 'Data');
 $active_sheet->setCellValue('b1', 'Vendedor');
 $active_sheet->setCellValue('c1', 'Funil');
 $active_sheet->setCellValue('d1', 'Data Entrada');
 $active_sheet->setCellValue('e1', 'Data Comentario');
 $active_sheet->setCellValue('f1', 'Data Fechamento');
 $active_sheet->setCellValue('g1', 'Nome');
 $active_sheet->setCellValue('h1', 'Telefone');
 $active_sheet->setCellValue('i1', 'E-mail');
 $active_sheet->setCellValue('j1', 'Produto');
 $active_sheet->setCellValue('k1', 'Origem');
 $active_sheet->setCellValue('l1', 'Cidade');
 $active_sheet->setCellValue('m1', 'Tipo');
 $active_sheet->setCellValue('n1', 'Texto');
 $active_sheet->setCellValue('o1', 'recebido');
 $active_sheet->setCellValue('p1', 'fpagamento');
 $active_sheet->setCellValue('q1', 'valor');
 $active_sheet->setCellValue('r1', 'valor_pago');
 $active_sheet->setCellValue('s1', 'valor_cancelado');
 $active_sheet->setCellValue('t1', 'data_agendada');
 $active_sheet->setCellValue('u1', 'funcionario');
 
 
 $count = 2;
 foreach($dadosatendimentoapae as $row){
 $produtor = (new Orm('usuarios'))->select(['nome'])
 ->where(['id_usuario', $row->para])->first()->get();
 
 if(!empty($produtor)){
   $prod = $produtor->nome;
 }else{
   $prod = 'Sem Produtor';
 }
 //echo $prod.'<br>';
 //exit;
 $active_sheet->setCellValue('a'.$count, $row->data ?? '');
 $active_sheet->setCellValue('b'.$count, $row->vendedor ?? '');
 $active_sheet->setCellValue('c'.$count, $row->nome_funil ?? '');
 $active_sheet->setCellValue('d'.$count, $row->data_entrada ?? '');
 $active_sheet->setCellValue('e'.$count, $row->data_comentario ?? '');
 $active_sheet->setCellValue('f'.$count, $row->data_fechamento ?? '');
 $active_sheet->setCellValue('g'.$count, $row->nome ?? '');
 $active_sheet->setCellValue('h'.$count, $row->telefone ?? '');
 $active_sheet->setCellValue('i'.$count, $row->email ?? '');
 $active_sheet->setCellValue('j'.$count, $row->produto ?? '');
 $active_sheet->setCellValue('k'.$count, $row->origem ?? '');
 $active_sheet->setCellValue('l'.$count, $row->cidade ?? '');
 $active_sheet->setCellValue('m'.$count, $row->tipo ?? '');
 $active_sheet->setCellValue('n'.$count, $row->texto ?? '');
 $active_sheet->setCellValue('o'.$count, $row->recebido ?? '');
 $active_sheet->setCellValue('p'.$count, $row->fpagamento ?? '');
 $active_sheet->setCellValue('q'.$count, $row->valor ?? '');
 $active_sheet->setCellValue('r'.$count, $row->valor_pago ?? '');
 $active_sheet->setCellValue('s'.$count, $row->valor_cancelado ?? '');
 $active_sheet->setCellValue('t'.$count, $row->data_agendada ?? '');
 $active_sheet->setCellValue('u'.$count, $row->funcionario ?? '');
 
 $count = $count +1;
 }
 
 $writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($file, $formato);
 
 $file_name = time().'.'.strtolower(($formato));
 $writer->save($file_name);
 header("Content-Type: application/x-www-form-urlencoded");
 header("Content-Transfer-Encoding:Binary");
 header("Content-disposition:attachment;filename=\"".$file_name."\"");
 readfile($file_name);
 unlink($file_name);
 exit;
 
 }//exportar atendimento apae

public function exportarboletos($dadosatendimento){
  $rl = new ReportFinanceiro();
 // echo '<pre>';
 // print_r($dadosatendimento);
 // exit;

//Aqui começa a exportação
$formato = 'Xlsx';//Xlsx - Xls - Csv
$file = new Spreadsheet();
$active_sheet = $file->getActiveSheet();

$active_sheet->setCellValue('a1', 'Cod Recibo');
$active_sheet->setCellValue('b1', 'Nome');
$active_sheet->setCellValue('c1', 'Produto');
$active_sheet->setCellValue('d1', 'Agente');
$active_sheet->setCellValue('e1', 'Anomes');
$active_sheet->setCellValue('f1', 'Data Agendada');
$active_sheet->setCellValue('g1', 'Valor a Receber');
$active_sheet->setCellValue('h1', 'Valor Recebido');
$active_sheet->setCellValue('i1', 'Valor Cancelado');
$active_sheet->setCellValue('j1', 'Valor Desconto');
$active_sheet->setCellValue('k1', 'Endereco');
$active_sheet->setCellValue('l1', 'Bairro');
$active_sheet->setCellValue('m1', 'Cidade');
$active_sheet->setCellValue('n1', 'Estado');
$active_sheet->setCellValue('o1', 'Cpf Cnpj');
$active_sheet->setCellValue('p1', 'Setor');
$active_sheet->setCellValue('q1', 'Funcionario');
$active_sheet->setCellValue('r1', 'Recebido');
$active_sheet->setCellValue('s1', 'Data Recebimento');
$active_sheet->setCellValue('t1', 'Data Faturamento');
$active_sheet->setCellValue('u1', 'Cobranca');
$active_sheet->setCellValue('v1', 'Impresso');
$active_sheet->setCellValue('w1', 'Confirmar Doacao');
$active_sheet->setCellValue('x1', 'Cod Antigo');


$count = 2;
foreach($dadosatendimento as $row){
/*$produtor = (new Orm('usuarios'))->select(['nome'])
->where(['id_usuario', $row->para])->first()->get();

if(!empty($produtor)){
  $prod = $produtor->nome;
}else{
  $prod = 'Sem Produtor';
}*/
//echo $prod.'<br>';
//exit;
$active_sheet->setCellValue('a'.$count, $row->nrecibo ?? '');
$active_sheet->setCellValue('b'.$count, $row->nome ?? '');
$active_sheet->setCellValue('c'.$count, $row->produto ?? '');
$active_sheet->setCellValue('d'.$count, $row->agente ?? '');
$active_sheet->setCellValue('e'.$count, $row->anomes ?? '');
$active_sheet->setCellValue('f'.$count, $row->data_agendada ?? '');
$active_sheet->setCellValue('g'.$count, $row->valor ?? '');
$active_sheet->setCellValue('h'.$count, $row->valor_pago ?? '');
$active_sheet->setCellValue('i'.$count, $row->valor_cancelado ?? '');
$active_sheet->setCellValue('j'.$count, $row->desconto ?? '');
$active_sheet->setCellValue('k'.$count, $row->endereco ?? '');
$active_sheet->setCellValue('l'.$count, $row->bairro ?? '');
$active_sheet->setCellValue('m'.$count, $row->cidade ?? '');
$active_sheet->setCellValue('n'.$count, $row->estado ?? '');
$active_sheet->setCellValue('o'.$count, $row->cpf_cnpj ?? '');
$active_sheet->setCellValue('p'.$count, $row->setor ?? '');
$active_sheet->setCellValue('q'.$count, $row->funcionario ?? '');
$active_sheet->setCellValue('r'.$count, $row->recebido ?? '');
$active_sheet->setCellValue('s'.$count, $row->data_recebimento ?? '');
$active_sheet->setCellValue('t'.$count, $row->data_faturamento ?? '');
$active_sheet->setCellValue('u'.$count, $row->cobranca ?? '');
$active_sheet->setCellValue('v'.$count, $row->impresso ?? '');
$active_sheet->setCellValue('w'.$count, $row->confirmardoacao ?? '');
$active_sheet->setCellValue('x'.$count, $row->id_importacao ?? '');

$count = $count +1;
}

$writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($file, $formato);

$file_name = time().'.'.strtolower(($formato));
$writer->save($file_name);
header("Content-Type: application/x-www-form-urlencoded");
header("Content-Transfer-Encoding:Binary");
header("Content-disposition:attachment;filename=\"".$file_name."\"");
readfile($file_name);
unlink($file_name);
exit;

}//exportar boletos

public function edit($id){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'plugins/sweetalert2',
'system'
);

$this->arr['tipo'] = $this->user->getTipo();
$this->arr['produtos'] = (new Orm('produtos'))->select('*')->get();
$this->arr['bairros'] = (new Orm('financeiro_bairro'))->select('*')->get();
$this->arr['origens']  = (new Orm('origem_venda'))->select('*')->get();


$this->arr['usuario_logado'] = $this->user->getId();
$l = new Leads();
$this->arr['colunas'] = $l->listaColunas();
$teste = $l->getCliente();
$cliente = $teste->nome;
$this->arr['cliente'] = $cliente;
$this->arr['id_lead'] = $id;

//$this->arr['info'] = (new Orm('leads'))->select('*')->where(['id_lead', $id])
//->first()->get();

$this->arr['info'] = $l->getLead($id);


$this->loadTemplate('leads/editar', $this->arr);
}//edit

public function pegacel(){
  $cel = $_POST['cel'];
 /*
  $celret = (new Orm('leads'))->select('*')
  ->join(['usuarios'])
  ->on(['leads.para','=','usuarios.id_usuario'])  
  ->where(['telefone', $cel])->first()->get();*/
  $l = new Leads();
  $celret = $l->pegacel($cel);

  echo json_encode($celret); 
  exit;
}

public function pegacpf(){
  $cpf = $_POST['cpf'];
 /*
  $celret = (new Orm('leads'))->select('*')
  ->join(['usuarios'])
  ->on(['leads.para','=','usuarios.id_usuario'])  
  ->where(['telefone', $cel])->first()->get();*/
  $l = new Leads();
  $celret = $l->pegacpf($cpf);

  echo json_encode($celret); 
  exit;
}

public function pegamatricula(){
  $matricula = $_POST['matricula'];
 /*
  $celret = (new Orm('leads'))->select('*')
  ->join(['usuarios'])
  ->on(['leads.para','=','usuarios.id_usuario'])  
  ->where(['telefone', $cel])->first()->get();*/
  $l = new Leads();
  $celret = $l->pegamatricula($matricula);

  echo json_encode($celret); 
  exit;
}

public function edit_action(){
$validator = new Validate();

if(isset($_POST)){

$nome = $_POST['nome'];
$produto = $_POST['produto'];

if(isset($_POST['email']) && !empty($_POST['email'])){
  $email = $_POST['email'];
}else{
  $email = '';
}

if(isset($_POST['telefone']) && !empty($_POST['telefone'])){
  $telefone = $_POST['telefone'];
}else{
  echo 'preencher numero de telefone';
  exit;
}

$obsn = $_POST['obsn'];
$cidade = $_POST['cidade'];
if(isset($_POST['codsocio']) && !empty($_POST['codsocio'])){
  $codsocio = $_POST['codsocio'];
}else{
  $codsocio = '';
}

//$codsocio = $_POST['codsocio'];
$codsistema = $_POST['codsistema'];
$id = $_POST['id_webform'];
$origem = $_POST['origem'];

$l = new Leads();
$teste = $l->getCliente();
$cliente = $teste->nome;
$this->arr['cliente'] = $cliente;
$l = new Leads();
//echo $_POST['telefone'];
//exit;
$pegacel = $l->getcel($_POST['telefone']);
$modulo_boleto = $this->permissao->getPermissoesBoleto();
$modulo_whatsapp = $modulo_boleto->modulo_whatsapp;
$chave_botconversa = $modulo_boleto->chave_botconversa;
if( $modulo_whatsapp == 1){
  $telwhats = '+55'.str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$_POST['telefone']))));
  $nome = $_POST['nome'];
  $produto = $_POST['produto'];
  $data = [
    'phone' => $telwhats,
    'first_name' => $nome,
    'last_name' => $produto
  ];
  $dataheader = [
    'API-KEY' => $chave_botconversa,
    'Content-type' => 'application/json'
  ];    

// API URL
$url = 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/';

$payload = json_encode($data);
$payloadheader = json_encode($dataheader);
//print_r($payloadheader);
//exit;
$curl = curl_init();
curl_setopt_array($curl, [
  CURLOPT_URL => $url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POSTFIELDS=>$payload,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "POST",
  CURLOPT_HTTPHEADER => [
    "API-KEY: $chave_botconversa", 
    //"API-KEY: 00134073-cce6-4897-bcc1-42d6fb9f00fc", 
    //"API-KEY: 00134073-cce6-4897-bcc1-42d6fb9f00fc", 
    //"API-KEY: 7c33c5f1-8a21-4147-8d84-37b03f1cc98c",  
    "Content-type: application/json"
  ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);

$datax = json_decode($response);

 if(isset($datax->id) && !empty($datax->id)){
  $id_subscriber = $datax->id;
  $grava = (new Orm('leads'))->set(['id_subscriber'=>$id_subscriber])->where(['id_lead', $id])->update();
 }

 $telefoneget = '+55'.str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$_POST['telefone']))));
 // /subscriber/get_by_phone/{phone}/
 $data = [
  'phone' => $telefoneget
];
$dataheader = [
  'API-KEY' => $chave_botconversa,
  'Content-type' => 'application/json'
];    

// API URL
$url = 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/get_by_phone/'.$telefoneget.'/';

$payload = json_encode($data);
$payloadheader = json_encode($dataheader);
//print_r($payloadheader);
//exit;
$curl = curl_init();
curl_setopt_array($curl, [
CURLOPT_URL => $url,
CURLOPT_RETURNTRANSFER => true,
CURLOPT_POSTFIELDS=>$payload,
CURLOPT_ENCODING => "",
CURLOPT_MAXREDIRS => 10,
CURLOPT_TIMEOUT => 30,
CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
CURLOPT_CUSTOMREQUEST => "GET",
CURLOPT_HTTPHEADER => [
  "API-KEY: $chave_botconversa", 
  //"API-KEY: 00134073-cce6-4897-bcc1-42d6fb9f00fc", 
  //"API-KEY: 7c33c5f1-8a21-4147-8d84-37b03f1cc98c",  
  "Content-type: application/json"
],
]);

$responseg = curl_exec($curl);
$err = curl_error($curl);

$dataxg = json_decode($responseg);

if(isset($dataxg->id) && !empty($dataxg->id)){
$id_lead = $id;
$id_subscriber = $dataxg->id;
$id_whats = $dataxg->id;
$grava = (new Orm('leads'))->set(['id_subscriber'=>$id_subscriber])->where(['id_lead', $id_lead])->update();
}else{
$id_whats = $_POST['id_whats'];
}

}

if($pegacel['total'] >1 ){
  //print_r($pegacel);
  echo 'Telefone ja cadastrado verifique com o Coordenador.';
  exit;
}else{

if($cliente == 'Apae Piracicaba'){ 
  $l = new Leads();
  $vlr = $_POST['vlr'];
  $dia = $_POST['dia'];

  $tipo = $this->user->getTipo();
  
  if($tipo == 'Super Admin' || $tipo == 'Produtor'){
  $cpf_cnpj = $_POST['cpf_cnpj'];
  $cobranca = $_POST['cobranca'];
  $end_cli = $_POST['end_cli'];
  $n_cli = $_POST['n_cli'];
  $bairro_cli = $_POST['bairro_cli'];
  $complemento_cli = $_POST['complemento_cli'];
  $cep_cli = $_POST['cep_cli'];
  $dsc_localidade = $_POST['dsc_localidade'];
  $dsc_sigla = $_POST['dsc_sigla'];
  $nme_funcionario = $_POST['nme_funcionario'];
  $dsc_setor = $_POST['dsc_setor'];
  $cdg_setor = $_POST['cdg_setor'];
  $telefone2 = $_POST['telefone2'];
  $telefone3 = $_POST['telefone3'];
  $update = $l->editapaeadmin($id,$nome,$produto,$email,$telefone,$obsn,$cidade,$codsocio,$codsistema,$origem,$vlr,$cobranca,$end_cli,$n_cli,$bairro_cli,$complemento_cli,$cep_cli,$dsc_localidade,$dsc_sigla,$nme_funcionario,$dsc_setor,$cdg_setor,$telefone2,$telefone3,$dia,$cpf_cnpj);
  }else{
  $update = $l->editapae($id,$nome,$produto,$email,$telefone,$obsn,$cidade,$codsocio,$codsistema,$origem,$vlr);
  };
  
}else{

  if($cliente == 'FIP Corp'){ 
    $l = new Leads();
   // $vlr = $_POST['vlr'];
   // $dia = $_POST['dia'];
  
    $tipo = $this->user->getTipo();
    //if($tipo == 'Super Admin' || $tipo == 'Produtor'){
    $cpf_cnpj = $_POST['cpf_cnpj'];
    $resp_empresa = $_POST['resp_empresa'];
    $resp_empresa_cpf = $_POST['resp_empresa_cpf'];
    $resp_empresa_email = $_POST['resp_empresa_email'];
    $resp_tecnico = $_POST['resp_tecnico'];
    $resp_tecnico_cpf = $_POST['resp_tecnico_cpf'];
    $resp_tecnico_email = $_POST['resp_tecnico_email'];
    $telefone2 = $_POST['telefone2'];
    $end_cli = $_POST['end_cli'];
    $n_cli = $_POST['n_cli'];
    $bairro_cli = $_POST['bairro_cli'];
    $dsc_localidade = $_POST['cidade'];
    $dsc_sigla = $_POST['dsc_sigla'];
    $complemento_cli = $_POST['complemento_cli'];
    $cep_cli = $_POST['cep_cli'];

    $update = $l->editfipadmin($id,$nome,$produto,$telefone,$obsn,$cidade,$codsistema,$origem,$resp_empresa,$resp_empresa_cpf,$end_cli,$n_cli,$bairro_cli,$complemento_cli,$cep_cli,$dsc_localidade,$dsc_sigla,$resp_empresa_email,$resp_tecnico,$resp_tecnico_cpf,$resp_tecnico_email,$telefone2,$cpf_cnpj);
    //}else{
    //$update = $l->editapae($id,$nome,$produto,$email,$telefone,$obsn,$cidade,$codsocio,$codsistema,$origem,$vlr);
    //};
  }else{
    $telefone2 = $_POST['telefone2'];
    $telefone3 = $_POST['telefone3'];
  $l = new Leads();
  $update = $l->edit($id,$nome,$produto,$email,$telefone,$telefone2,$telefone3,$obsn,$cidade,$codsocio,$codsistema,$origem);  
  }
}



//exit;
/*$p = $_POST;
$form = [];

foreach($p as $key=>$input){
  if($key != 'id_webform'){
    @$form[$key] .= 'required';
  }
}

$validate = $validator->validate($form,true);
$grava = (new Orm('leads'))->set($validate)
->where(['id_lead', $p['id_webform']])->update();
*/

$_SESSION['msg'] = ['type'=>'success','msg'=>'Lead Atualizado com sucesso!'];
header("Location:".BASE_URL."leads");
exit;
}
}
}//edit_ action

public function atribuir_lead(){
  $modulo_boleto = $this->permissao->getPermissoesBoleto();
  $chave_botconversa = $modulo_boleto->chave_botconversa;
  $modulo_whatsapp = $modulo_boleto->modulo_whatsapp;
  if($modulo_whatsapp == 1){
    $id_manager = $_POST['id_manager'];
    $id_subscriber = $_POST['id_subscriber'];
    $enviawhats = $_POST['enviawhats'];
    $nome = $_POST['nome'];
    $produto = $_POST['produto'];

    $telwhats = '+55'.str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$_POST['enviawhats']))));
    $nome = $_POST['nome'];
    $produto = $_POST['produto'];
    $data = [
      'phone' => $telwhats,
      'first_name' => $nome,
      'last_name' => $produto
    ];
    $dataheader = [
      'API-KEY' => $chave_botconversa,
      'Content-type' => 'application/json'
    ];    
  
  // API URL
  $url = 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/';
  
  $payload = json_encode($data);
  $payloadheader = json_encode($dataheader);
  //print_r($payloadheader);
  //exit;
  $curl = curl_init();
  curl_setopt_array($curl, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POSTFIELDS=>$payload,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_HTTPHEADER => [
      "API-KEY: $chave_botconversa", 
      //"API-KEY: 00134073-cce6-4897-bcc1-42d6fb9f00fc", 
      //"API-KEY: 7c33c5f1-8a21-4147-8d84-37b03f1cc98c",  
      "Content-type: application/json"
    ],
  ]);
  
  $response = curl_exec($curl);
  $err = curl_error($curl);
  
  $datax = json_decode($response);
  
   if(isset($datax->id) && !empty($datax->id)){
    $id_lead = $_POST['id_lead'];
    $id_subscriber = $datax->id;
    $id_whats = $datax->id;
    $grava = (new Orm('leads'))->set(['id_subscriber'=>$id_subscriber])->where(['id_lead', $id_lead])->update();
   }else{
    $id_whats = $_POST['enviawhats'];
    $id_subscriber = $_POST['id_subscriber'];
   }
   $telefoneget = '+55'.str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$_POST['enviawhats']))));
   // /subscriber/get_by_phone/{phone}/
   $data = [
    'phone' => $telefoneget
  ];
  $dataheader = [
    'API-KEY' => $chave_botconversa,
    'Content-type' => 'application/json'
  ];    

// API URL
$url = 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/get_by_phone/'.$telefoneget.'/';

$payload = json_encode($data);
$payloadheader = json_encode($dataheader);
//print_r($payloadheader);
//exit;
$curl = curl_init();
curl_setopt_array($curl, [
  CURLOPT_URL => $url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POSTFIELDS=>$payload,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "GET",
  CURLOPT_HTTPHEADER => [
    "API-KEY: $chave_botconversa", 
    //"API-KEY: 00134073-cce6-4897-bcc1-42d6fb9f00fc", 
    //"API-KEY: 7c33c5f1-8a21-4147-8d84-37b03f1cc98c",  
    "Content-type: application/json"
  ],
]);

$responseg = curl_exec($curl);
$err = curl_error($curl);

$dataxg = json_decode($responseg);

 if(isset($dataxg->id) && !empty($dataxg->id)){
  $id_lead = $_POST['id_lead'];
  $id_subscriber = $dataxg->id;
  $id_whats = $dataxg->id;
  $grava = (new Orm('leads'))->set(['id_subscriber'=>$id_subscriber])->where(['id_lead', $id_lead])->update();
 }else{
  $id_whats = $_POST['enviawhats'];
  $id_subscriber = $_POST['id_subscriber'];
 }


    
  // API URL /subscriber/{subscriber_id}/change_conversation_status/
  $data = [
    'open_conversation' => true,
    'manager' => $id_manager
  ];
  $dataheader = [
    'API-KEY' => $chave_botconversa,
    'Content-type' => 'application/json'
  ];    
  //echo $id_subscriber;
  //exit;
// API URL
$url = 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/'.$id_subscriber.'/change_conversation_status/';

$payload = json_encode($data);
$payloadheader = json_encode($dataheader);

//print_r($payload);
//exit;
$curl = curl_init();
curl_setopt_array($curl, [
  CURLOPT_URL => $url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POSTFIELDS=>$payload,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "POST",
  CURLOPT_HTTPHEADER => [
    "API-KEY: $chave_botconversa", 
    //"API-KEY: 00134073-cce6-4897-bcc1-42d6fb9f00fc", 
    //"API-KEY: 7c33c5f1-8a21-4147-8d84-37b03f1cc98c",  
    "Content-type: application/json"
  ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);
print_r($response);
exit; 
  }

}

public function add_coment(){
$validator = new Validate();
$validates = array();
//echo 'tipo='.$_POST['id_lead'];
//exit;
//echo '<pre>';
//echo 'aqui';
//exit;
//$id_lead = $_POST['id_lead'];
//echo $id_lead;
$modulo_boleto = $this->permissao->getPermissoesBoleto();
$chave_botconversa = $modulo_boleto->chave_botconversa;
$modulo_whatsapp = $modulo_boleto->modulo_whatsapp;

//echo $modulo_whatsapp;
//exit;

if($modulo_whatsapp == 1){
  if(isset($_POST['campanha_whats']) && !empty($_POST['campanha_whats'])){
    $telwhats = '+55'.str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$_POST['enviawhats']))));
    $nome = $_POST['nome'];
    $produto = $_POST['produto'];
    $data = [
      'phone' => $telwhats,
      'first_name' => $nome,
      'last_name' => $produto
    ];
    $dataheader = [
      'API-KEY' => $chave_botconversa,
      'Content-type' => 'application/json'
    ];    
  
  // API URL
  $url = 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/';
  
  $payload = json_encode($data);
  $payloadheader = json_encode($dataheader);
  //print_r($payloadheader);
  //exit;
  $curl = curl_init();
  curl_setopt_array($curl, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POSTFIELDS=>$payload,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_HTTPHEADER => [
      "API-KEY: $chave_botconversa", 
      //"API-KEY: 00134073-cce6-4897-bcc1-42d6fb9f00fc", 
      //"API-KEY: 7c33c5f1-8a21-4147-8d84-37b03f1cc98c",  
      "Content-type: application/json"
    ],
  ]);
  
  $response = curl_exec($curl);
  $err = curl_error($curl);
  
  $datax = json_decode($response);
  
   if(isset($datax->id) && !empty($datax->id)){
    $id_lead = $_POST['id_lead'];
    $id_subscriber = $datax->id;
    $id_whats = $datax->id;
    $grava = (new Orm('leads'))->set(['id_subscriber'=>$id_subscriber])->where(['id_lead', $id_lead])->update();
   }else{
    $id_whats = $_POST['id_whats'];
   }
   $telefoneget = '+55'.str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$_POST['enviawhats']))));
   // /subscriber/get_by_phone/{phone}/
   $data = [
    'phone' => $telefoneget
  ];
  $dataheader = [
    'API-KEY' => $chave_botconversa,
    'Content-type' => 'application/json'
  ];    

// API URL
$url = 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/get_by_phone/'.$telefoneget.'/';

$payload = json_encode($data);
$payloadheader = json_encode($dataheader);
//print_r($payloadheader);
//exit;
$curl = curl_init();
curl_setopt_array($curl, [
  CURLOPT_URL => $url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POSTFIELDS=>$payload,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "GET",
  CURLOPT_HTTPHEADER => [
    "API-KEY: $chave_botconversa", 
    //"API-KEY: 00134073-cce6-4897-bcc1-42d6fb9f00fc", 
    //"API-KEY: 7c33c5f1-8a21-4147-8d84-37b03f1cc98c",  
    "Content-type: application/json"
  ],
]);

$responseg = curl_exec($curl);
$err = curl_error($curl);

$dataxg = json_decode($responseg);

 if(isset($dataxg->id) && !empty($dataxg->id)){
  $id_lead = $_POST['id_lead'];
  $id_subscriber = $dataxg->id;
  $id_whats = $dataxg->id;
  $grava = (new Orm('leads'))->set(['id_subscriber'=>$id_subscriber])->where(['id_lead', $id_lead])->update();
 }else{
  $id_whats = $_POST['id_whats'];
 }



    $campanha = $_POST['campanha_whats'];
    //$id_whats = $_POST['id_whats'];
    $data = [
      'flow' => $campanha
    ];
    $dataheader = [
      'API-KEY' => $chave_botconversa,
      'Content-type' => 'application/json'
    ];    
  $payload = json_encode($data);
  $headerjson = json_encode($dataheader);

  // print_r($payload);
  // print_r($headerjson);
  // exit;
    //echo $id_whats;
   // exit;/subscriber/{subscriber_id}/send_flow/
    $curl = curl_init();

    curl_setopt_array($curl, array(
    CURLOPT_URL => 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/'.$id_whats.'/send_flow/',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'POST',
    CURLOPT_POSTFIELDS =>$payload,
    CURLOPT_HTTPHEADER => [
      "API-KEY: $chave_botconversa", 
      //"API-KEY: 7c33c5f1-8a21-4147-8d84-37b03f1cc98c",  
      "Content-type: application/json"
    ],
    ));

    $response = curl_exec($curl);
    curl_close($curl);

  }

}

if(isset($_POST['texto']) && !empty($_POST['texto'])){

  if($_POST['tipo'] == 'mensagem'){
    //echo 'aqui mensagem';
    //exit;
    $modulo_boleto = $this->permissao->getPermissoesBoleto();
    $chave_botconversa = $modulo_boleto->chave_botconversa;
    $modulo_whatsapp = $modulo_boleto->modulo_whatsapp;
    //echo $modulo_whatsapp;
    //exit;
    if($modulo_whatsapp == 1){
   //echo 'aqui mensagem';
   //exit;
  
    $telwhats = '+55'.str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$_POST['enviawhats']))));
    $nome = $_POST['nome'];
    $produto = $_POST['produto'];
    $data = [
      'phone' => $telwhats,
      'first_name' => $nome,
      'last_name' => $produto
    ];
    $dataheader = [
      'API-KEY' => $chave_botconversa,
      'Content-type' => 'application/json'
    ];    
  
  // API URL
  $url = 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/';
  
  $payload = json_encode($data);
  $payloadheader = json_encode($dataheader);
  //print_r($payloadheader);
  //exit;
  $curl = curl_init();
  curl_setopt_array($curl, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POSTFIELDS=>$payload,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_HTTPHEADER => [
      "API-KEY: $chave_botconversa", 
      //"API-KEY: 00134073-cce6-4897-bcc1-42d6fb9f00fc", 
      //"API-KEY: 7c33c5f1-8a21-4147-8d84-37b03f1cc98c",  
      "Content-type: application/json"
    ],
  ]);
  
  $response = curl_exec($curl);
  $err = curl_error($curl);
  
  $datax = json_decode($response);
  
   if(isset($datax->id) && !empty($datax->id)){
    $id_lead = $_POST['id_lead'];
    $id_subscriber = $datax->id;
    $id_whats = $datax->id;
    $grava = (new Orm('leads'))->set(['id_subscriber'=>$id_subscriber])->where(['id_lead', $id_lead])->update();
   }else{
    $id_whats = $_POST['id_whats'];
   }

    $texto = $_POST['texto'];
    //$id_whats = $_POST['id_whats'];
    $data = [
      'type' => 'text',
      'value' => $texto
    ];
    $dataheader = [
      'API-KEY' => $chave_botconversa,
      'Content-type' => 'application/json'
    ];    
  $payload = json_encode($data);
  $headerjson = json_encode($dataheader);

   //print_r($payload);
  // print_r($headerjson);
  // exit;
   // echo $id_whats;
   // exit;
    $curl = curl_init();

    curl_setopt_array($curl, array(
    CURLOPT_URL => 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/'.$id_whats.'/send_message/',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'POST',
    CURLOPT_POSTFIELDS =>$payload,
    CURLOPT_HTTPHEADER => [
      "API-KEY: $chave_botconversa", 
      //"API-KEY: 00134073-cce6-4897-bcc1-42d6fb9f00fc", 
      //"API-KEY: 7c33c5f1-8a21-4147-8d84-37b03f1cc98c",  
      "Content-type: application/json"
    ],
    ));

    $response = curl_exec($curl);
    curl_close($curl);
    };
    }
    //echo $response;
    //echo 'aqui';
    //exit;
}

if(isset($_POST['texto']) && !empty($_POST['texto'])){
$user = $this->user->getId();
$stt = 'definido:agendada';
if($_POST['tipo'] == 'comentario'){
$stt = 'null';
}

$validate = $validator->validate([
'id_lead'=>'definido:'.$_POST['id_lead'],
'id_user'=>'definido:'.$user,
'tipo'=>'null',
'texto'=>'required',
'status_tarefa'=>$stt,
'data_agendamento'=>'null|data',
'hora_agendamento'=>'null|hora',
'finalizado'=>'definido:N'
//'anexos'=>'null|anexos',
],true);

/*if(!$validate){
$_SESSION['msg'] = ['type'=>'error','msg'=>'Ooops... Alguns campos estão inválidos, tente novamente'];
 unset($_SESSION['flash']);
 unset($_SESSION['old']);
 if(isset($_GET['f']) && !empty($_GET['f'])){
  header("Location:".BASE_URL."leads/view/".$_POST['id_lead']/"?f=s");
  exit;   
  }else{
  header("Location:".BASE_URL."leads/view/".$_POST['id_lead']);
  exit;   
 }
}*/
//echo '<pre>';
//print_r($_POST['mutiplo_upload']);
//exit;
if($_POST['anexos'] != '' && $_POST['anexos'] != NULL){
  $id_lead = $_POST['id_lead'];
  $files = '';
  $anexos = $_POST['anexos'];
  $anexosname = $_POST['mutiplo_upload'];
  //print_r($anexosname);
  //exit;
  $dados = array();
  //$anexos = (isset($_POST[$field])) ? $_POST[$field] : '';
  
   //if($anexos != '' && $_POST[$param] == null){
    if($_POST['anexosview'] != ''){
      $old = (new Orm('leads'))->select(['anexos'])
      ->where(['id_lead', $id_lead])->first()->get(); 
      $arquivo = json_decode($old->anexos, true);
      foreach($arquivo as $arq){
        array_push($dados, $arq);  
      }
      $novos = $this->gravaAnexos($anexos,$anexosname);
      $files = json_decode($novos['files'], true);
      foreach($files as $file){
        array_push($dados, $file);
      }
      
       $dados = json_encode($dados);     
       $files = $dados;
      // print_r($dados);
      // exit;
      //$files = $this->atualizaAnexos($id_lead, $anexos);  
    }else{
      $files = $this->gravaAnexos($anexos,$anexosname);  
      $files = $files['files'];
    };
    
    
    //return $files;
  // }
  
    //if($anexos != '' && $_POST[$param] != null){ 
    
    //return $files;
    //}*/


  $grava = (new Orm('leads'))->set(['anexos'=>$files])->where(['id_lead', $id_lead])->update();
 // exit;
};
//echo '<pre>';
//echo $_POST['motivos'][0].'<br>';
//print_r($_POST);
//exit;

if($_POST['motivos'][0] != '' && $_POST['motivos'][0] != NULL){
$idel = 1;
  foreach($_POST['motivos'] as $motivos){
    $l = new Leads();
    $motivose = explode(";",$motivos);
    $id_lead = $_POST['id_lead'];
    $motivosn = $motivose[1];
    $motivosnid = $motivose[0];  
    if($idel == 1){
      //echo 'aqui';
      //exit;
      $l->deletemotivos($motivosn,$motivosnid,$id_lead);
      $idel++;
    }
    if($_POST['funil'] != 0){
      $l->updatemotivos($motivosn,$motivosnid,$id_lead);
    }
  }
  //print_r($_POST['motivos']);
  //exit;
}else{
  //echo 'ss';
  //exit;
}
$grava = (new Orm('leads_comentarios'))->set($validate)->save(); 
$id_comentario = $grava;
//echo $id_comentario;
//error_reporting(0);
//ini_set(“display_errors”, 0 );
//exit;
$todos = array();
$todos['lista'] = (new Orm('vw_atualizacalendario'))->select('*')->get();
//echo '<pre>';
//print_r($todos['lista']);
//exit;
foreach($todos['lista'] as $atualiza){
$validator = new Validate();
if($atualiza->finalizado == 'S'){
  
  $validates = $validator->validate([
    'event_type'=>'definido:'. $atualiza->id_comentario,
    'color'=>'definido:'. '#37d84f',    
    'subject'=>'definido:'. $atualiza->nome.' - '. $atualiza->produto.' - '. $atualiza->telefone ,
    'date_time'=>'definido:'. $atualiza->data_agendamento.' '.$atualiza->hora_agendamento,
    'from_date_time'=>'definido:'. $atualiza->data_agendamento.' '.$atualiza->hora_agendamento,
    'client'=>'definido:'. $atualiza->id_lead,
    'team_member'=>'definido:'. $atualiza->id_user,
    'location'=>'definido:'. $atualiza->status_tarefa,
    'remark'=>'definido:'. $atualiza->finalizado,
    ],true);
}else{
  
  //exit;
  //echo $atualiza->id_lead;
  //exit;
  if(isset($atualiza->id_user) && !empty($atualiza->id_user) && isset($atualiza->data_agendamento) && !empty($atualiza->data_agendamento) && isset($atualiza->hora_agendamento) && !empty($atualiza->hora_agendamento)){
  $validates = $validator->validate([
    'event_type'=>'definido:'. $atualiza->id_comentario,
    'color'=>'definido:'. '#3788d8',    
    'subject'=>'definido:'. $atualiza->nome.' - '. $atualiza->produto.' - '. $atualiza->telefone ,
    'date_time'=>'definido:'. $atualiza->data_agendamento.' '.$atualiza->hora_agendamento,
    'from_date_time'=>'definido:'. $atualiza->data_agendamento.' '.$atualiza->hora_agendamento,
    'client'=>'definido:'. $atualiza->id_lead,
    'team_member'=>'definido:'. $atualiza->id_user,
    'location'=>'definido:'. $atualiza->status_tarefa,
    'remark'=>'definido:'. $atualiza->finalizado,
    ],true);
    //echo 'aqui';
    //exit;
  }else{
   // echo 'user:'.$atualiza->data_agendamento.' '.$atualiza->hora_agendamento.'<br>';
   // $validate = $validator->validate([
   //  'event_type'=>'definido:'. $atualiza->id_comentario,
   //   'color'=>'definido:'. '#3788d8',    
   //   'subject'=>'definido:'. $atualiza->nome.' - '. $atualiza->produto.' - '. $atualiza->telefone ,
   //   'date_time'=>'definido:'. $atualiza->data_agendamento.' '.$atualiza->hora_agendamento,
   //   'from_date_time'=>'definido:'. $atualiza->data_agendamento.' '.$atualiza->hora_agendamento,
   //   'client'=>'definido:'. $atualiza->id_lead,
   //   'team_member'=>'definido:'. 0,
   //   'location'=>'definido:'. $atualiza->status_tarefa,
   //   'remark'=>'definido:'. $atualiza->finalizado,
   //   ],true);    
  }
}
if(isset($validates) && !empty($validates)){
$grava = (new Orm('shedules'))->set($validates)->save(); 
//echo 'aquin';
//exit;
}
}
//echo '<pre>';
//print_r($validates);
//exit;

  if($_POST['funil'] != 0 ){
    $id_lead = $_POST['id_lead'];
    $id_funil = $_POST['funil'];
    //$validate = $validator->validate($form,true);
    $grava = (new Orm('leads'))->set(['funil_id'=>$id_funil])
    ->where(['id_lead', $id_lead])->update();
   // exit;
  };

  if($_POST['codsocio'] != '' ){
    $id_lead = $_POST['id_lead'];
    $codsocio = $_POST['codsocio'];
    //$validate = $validator->validate($form,true);
    $grava = (new Orm('leads'))->set(['codsocio'=>$codsocio])
    ->where(['id_lead', $id_lead])->update();
   // exit;
  };

  if($_POST['codsistema'] != '' ){
    $id_lead = $_POST['id_lead'];
    $codsistema = $_POST['codsistema'];
    //$validate = $validator->validate($form,true);
    $grava = (new Orm('leads'))->set(['codsistema'=>$codsistema])
    ->where(['id_lead', $id_lead])->update();
   // exit;
  };

  if(isset($_POST['vlrr']) && !empty($_POST['vlrr']) && $_POST['vlrr'] != '' && $_POST['vlrr'] != 0){
    //echo $_POST['id_lead'];
    //exit;
    $id_lead = $_POST['id_lead'];
    $vlr = $_POST['vlrr'];
    //echo 'aqui';
    //exit;
    //$codsistema = $_POST['codsistema'];
    //$validate = $validator->validate($form,true);
    $grava = (new Orm('leads'))->set(['vlr'=>$vlr])
    ->where(['id_lead', $id_lead])->update();
   // exit;
  };

  if($_POST['datafechamento'] != '' && $_POST['datafechamento'] != NULL){
    $id_lead = $_POST['id_lead'];
    $datafechamento = $_POST['datafechamento'];
    //$validate = $validator->validate($form,true);
    $grava = (new Orm('leads'))->set(['data_fechamento'=>$datafechamento])
    ->where(['id_lead', $id_lead])->update();
   // exit;
  };  

  if($_POST['data_agendada'] != '' && $_POST['data_agendada'] != NULL){
    $modulo_boleto = $this->permissao->getPermissoesBoleto();
    $modulo_boleton = $modulo_boleto->modulo_boleto;
    if($modulo_boleton == 1){
    $id_lead = $_POST['id_lead'];
    $data_agendada = $_POST['data_agendada'];
    $periodo = $_POST['periodo'];
    $valor = $_POST['valor'];
    $cep = $_POST['cep'];
    $endereco = $_POST['endereco'];
    $bairro = $_POST['bairro'];
    $cidade = $_POST['cidade'];
    $cpf_cnpj = $_POST['cpf_cnpj'];
    $obsfat = $_POST['obsfat'];
    $fpagamento = $_POST['fpagamento'];
    $estado = $_POST['estado'];

    $fin = new Financeiro();
    $fin->gerafaturamento($id_comentario, $id_lead, $user,$data_agendada,$periodo,$valor,$cep,$endereco,$bairro,$cidade,$cpf_cnpj,$obsfat,$fpagamento,$estado);
    }
  //echo 'aqui';
 //exit;
  }
  $_SESSION['msg'] = ['type'=>'success','msg'=>'Comentário Cadastrado com sucesso!'];
 //$id_lead = $_POST['id_lead'];

  if(isset($_GET['f']) && !empty($_GET['f'])){ 
    header("Location:".BASE_URL."leads/view/".$_POST['id_lead']."?f=s");
    exit;
  }else{
    header("Location:".BASE_URL."leads/view/".$id_lead);
    exit;
  
 }

}


}//add coment


public function save(){
$validator = new Validate();
$validate = '';
//$l = new Leads();


if(isset($_POST['nome']) && !empty($_POST['produto'])){

$status = 'novo';
$tem = (new Orm('leads'))->select(['telefone'])->where(['telefone', $_POST['telefone']])->first()->get();
if($tem){
$status = 'repetido';
}

$l = new Leads();
$teste = $l->getCliente();
$cliente = $teste->nome;
$this->arr['cliente'] = $cliente;
$l = new Leads();
$pegacel = $l->pegacel($_POST['telefone']);
//echo '<pre>';
$modulo_boleto = $this->permissao->getPermissoesBoleto();
$modulo_whatsapp = $modulo_boleto->modulo_whatsapp;
$chave_botconversa = $modulo_boleto->chave_botconversa;
if( $modulo_whatsapp == 1){
  $telwhats = '+55'.str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$_POST['telefone']))));
  $nome = $_POST['nome'];
  $produto = $_POST['produto'];
  
  $data = [
    'phone' => $telwhats,
    'first_name' => $nome,
    'last_name' => $produto
  ];
  $dataheader = [
    'API-KEY' => $chave_botconversa,
    'Content-type' => 'application/json'
  ];    

// API URL
$url = 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/';

$payload = json_encode($data);
$payloadheader = json_encode($dataheader);
//print_r($payloadheader);
//exit;

$curl = curl_init();
curl_setopt_array($curl, [
  CURLOPT_URL => $url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POSTFIELDS=>$payload,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "POST",
  CURLOPT_HTTPHEADER => [
    "API-KEY: $chave_botconversa", 
    //"API-KEY: 00134073-cce6-4897-bcc1-42d6fb9f00fc", 
    //"API-KEY: 7c33c5f1-8a21-4147-8d84-37b03f1cc98c",  
    "Content-type: application/json"
  ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);

//url_close($curl);


}


if(isset($pegacel) && !empty($pegacel)){
  //print_r($pegacel);
  echo 'Telefone ja cadastrado verifique com o Coordenador.';
  exit;
}else{

if($cliente == 'Cartao de Todos Americana'){ 

  $validate = $validator->validate([
  'id_lead'=>'null',
  'nome'=>'required',
  'produto'=>'required',
  //'email'=>'required',
  'telefone'=>'required',
  'origem'=>'required',
  'codsocio'=>'definido:'.$_POST['codsocio'],
  'codsistema'=>'definido:'.$_POST['codsistema'],
  //'data_entrada'=>'null|datetime',
  'status'=>'definido:'.$status
  ],true);

}else{

  if($cliente == 'Clique Responde' || $cliente == 'Apae Piracicaba'){ 
    $validate = $validator->validate([
      'id_lead'=>'null',
      'nome'=>'required',
      'produto'=>'required',
      //'email'=>'required',
      'telefone'=>'required',
      'origem'=>'required',
      'cobranca'=>'definido:'.$_POST['cobranca'],
      'end_cli'=>'definido:'.$_POST['end_cli'],
      'n_cli'=>'definido:'.$_POST['n_cli'],
      'bairro_cli'=>'definido:'.$_POST['bairro_cli'],
      'complemento_cli'=>'definido:'.$_POST['complemento_cli'],
      'cep_cli'=>'definido:'.$_POST['cep_cli'],
      'cidade_cli'=>'definido:'.$_POST['dsc_localidade'],
      'estado_cli'=>'definido:'.$_POST['dsc_sigla'],
      'funcionario'=>'definido:'.$_POST['nme_funcionario'],
      'setor'=>'definido:'.$_POST['dsc_setor'],
      'codsetor'=>'definido:'.$_POST['cdg_setor'],
      //'codsocio'=>'required',
      //'codsistema'=>'required',
      //'data_entrada'=>'null|datetime',
      'status'=>'definido:'.$status
      ],true);
  }else{
    if($cliente == 'i9 Doctor Prime'){ 
    $validate = $validator->validate([
    'id_lead'=>'null',
    'nome'=>'required',
    'produto'=>'required',
    //'email'=>'required',
    'telefone'=>'required',
    'origem'=>'required',
    'codsocio'=>'definido:'.$_POST['codsocio'],
    'codsistema'=>'definido:'.$_POST['codsistema'],
    'vlr'=>'definido:'.$_POST['vlr'],
    //'data_entrada'=>'null|datetime',
    'status'=>'definido:'.$status
    ],true);
  }else{
    $validate = $validator->validate([
      'id_lead'=>'null',
      'nome'=>'required',
      'produto'=>'required',
      //'email'=>'required',
      'telefone'=>'required',
      'origem'=>'required',
      //'codsocio'=>'required',
      //'codsistema'=>'required',
      //'data_entrada'=>'null|datetime',
      'status'=>'definido:'.$status
      ],true);    
  }
  }

}

if(!$validate){
$_SESSION['msg'] = ['type'=>'error','msg'=>'Ooops... Alguns campos estão inválidos, tente novamente'];
 unset($_SESSION['flash']);
 unset($_SESSION['old']);
 header("Location:".BASE_URL."leads/add");
 exit;   
}


if($validate['id_lead'] == null){
  //grava no banco
 // print_r($validate);
  //exit;
  $grava = (new Orm('leads'))->set($validate)->save(); 
 // print_r($grava);
 // exit;
// Depois de salvar enviar notificação antes de mostrar msg de alerta
//mando para o push em json a quantidade e a lista para exibir no icone
//atualização PUSH
/*
$options = array(
  'cluster' => 'sa1',
  'useTLS' => true
);
$pusher = new Pusher\Pusher(
    'f9824928d137cc25989b',
    '5b73861e45d1ff6efe08',
    '1481742',
    $options
);

$total = (new Orm('leads'))->select('*')->where(['status','novo'])->total()->get();
$lista = (new Orm('leads'))->select('*')->where(['status','novo'])->get();

$data = json_encode(['qtde'=>$total,'lista'=>$lista]);
$pusher->trigger('my-channel', 'my-event', $data);
*/
//fim da atualização PUSH


  $_SESSION['msg'] = ['type'=>'success','msg'=>'Lead Cadastrado com sucesso!'];
  header("Location:".BASE_URL."leads");
  exit;
}else{
 $grava = (new Orm('leads'))->set($validate)->where(['id_lead', $validate['id_lead']])->update(); 
 $_SESSION['msg'] = ['type'=>'success','msg'=>'Lead atualizado com sucesso!'];
  header("Location:".BASE_URL."leads");
  exit; 
}

}
}
}//save

public function saveProdutor(){
$validator = new Validate();

if(isset($_POST['nome']) && !empty($_POST['produto'])){
$id_produtor = (isset($_POST['id_produtor'])) ? $_POST['id_produtor'] : 0;
$l = new Leads();
$teste = $l->getCliente();
$cliente = $teste->nome;
$this->arr['cliente'] = $cliente;

$pegacel = $l->pegacel($_POST['telefone']);
//echo '<pre>';

if(isset($pegacel) && !empty($pegacel)){
  //print_r($pegacel);
  echo 'Telefone ja cadastrado verifique com o Coordenador.';
  exit;
}else{
  //echo 'ok pode cadastrar';

$hoje = date('Y-m-d H:i:s');
if($cliente == 'Cartao de Todos Americana'){ 
$validate = $validator->validate([
'id_lead'=>'null',
'nome'=>'required',
'produto'=>'required',
//'email'=>'required',
'telefone'=>'required',
'origem'=>'required',
'codsocio'=>'definido:'.$_POST['codsocio'],
'codsistema'=>'definido:'.$_POST['codsistema'],
//'tipo_cotacao'=>'required',
//'qtde_vidas'=>'required',
//'data_entrada'=>'definido:'.$hoje,
'status'=>'definido:entregue',
'para'=>'definido:'.$id_produtor
],true);
}else{
  if($cliente == 'Clique Responde' || $cliente == 'Apae Piracicaba'){ 
    $validate = $validator->validate([
      'id_lead'=>'null',
      'nome'=>'required',
      'produto'=>'required',
      //'email'=>'required',
      'telefone'=>'required',
      'origem'=>'required',
      'cobranca'=>'definido:'.$_POST['cobranca'],
      'end_cli'=>'definido:'.$_POST['end_cli'],
      'n_cli'=>'definido:'.$_POST['n_cli'],
      'bairro_cli'=>'definido:'.$_POST['bairro_cli'],
      'complemento_cli'=>'definido:'.$_POST['complemento_cli'],
      'cep_cli'=>'definido:'.$_POST['cep_cli'],
      'cidade_cli'=>'definido:'.$_POST['dsc_localidade'],
      'estado_cli'=>'definido:'.$_POST['dsc_sigla'],
      'funcionario'=>'definido:'.$_POST['nme_funcionario'],
      'setor'=>'definido:'.$_POST['dsc_setor'],
      'codsetor'=>'definido:'.$_POST['cdg_setor'],
      'para'=>'definido:'.$id_produtor,
      //'codsocio'=>'required',
      //'codsistema'=>'required',
      //'data_entrada'=>'null|datetime',
      'status'=>'definido:entregue',
      ],true);
  }else{
    $validate = $validator->validate([
    'id_lead'=>'null',
    'nome'=>'required',
    'produto'=>'required',
    //'email'=>'required',
    'telefone'=>'required',
    'origem'=>'required',
    //'codsocio'=>'required',
    //'codsistema'=>'required',
    //'data_entrada'=>'null|datetime',
    'status'=>'definido:entregue',
    'para'=>'definido:'.$id_produtor
    ],true);
  }
  /*
  $validate = $validator->validate([
    'id_lead'=>'null',
    'nome'=>'required',
    'produto'=>'required',
    //'email'=>'required',
    'telefone'=>'required',
    'origem'=>'required',
    //'codsocio'=>'required',
    //'codsistema'=>'required',
    //'data_entrada'=>'null|datetime',
    'status'=>'definido:'.$status
    ],true);*/


}

if(!$validate){
$_SESSION['msg'] = ['type'=>'error','msg'=>'Ooops... Alguns campos estão inválidos, tente novamente'];
 unset($_SESSION['flash']);
 unset($_SESSION['old']);
 header("Location:".BASE_URL."leads/add");
 exit;   
}


if($validate['id_lead'] == null){
  //grava no banco
 // echo '<pre>';
 // print_r($validate);
  $grava = (new Orm('leads'))->set($validate)->save(); 
 // echo $grava;
 // exit;
  $_SESSION['msg'] = ['type'=>'success','msg'=>'Lead Cadastrado com sucesso!'];
  header("Location:".BASE_URL."leads");
  exit;
}else{
 $grava = (new Orm('leads'))->set($validate)->where(['id_lead', $validate['id_lead']])->update(); 
 $_SESSION['msg'] = ['type'=>'success','msg'=>'Lead atualizado com sucesso!'];
  header("Location:".BASE_URL."leads");
  exit; 
}
}

}
}//save

public function getmotivos(){
$array = array();
  //echo 'aqui';
//exit;
$funil = $_POST['motivo'];
$array['motivos'] = (new Orm('funil_motivo'))->select('*')->where(['id_funil', $funil])->order(['nome_motivo asc'])->get();
//echo '<pre>';
//print_r($this->arr['motivos']);
//exit;
echo json_encode($array['motivos']);
//return $this->arr['motivos'];

}

public function viewn($id){
  $this->arr['list_js'] = array(
  'plugins/sweetalert2',
  'plugins/jquery.mask.min',
  'plugins/parsley/parsley.min',
  'plugins/parsley/pt-br',
  'mask_init', 
  'system',
  'flatpickr/flatpickr',
  'flatpickr/pt',
  'flatpickr/flatpickr_init',
  'multiuploads'
  ); 
  $this->atualizaleads($id);
  $this->arr['usuario_logado'] = $this->user->getId();
$this->arr['info'] = (new Orm('leads'))->select('*')->wherecustom("id_lead = $id")->first()->get();
$up = new Orm('leads_motivo');
$this->arr['infomotivos'] = $up->select('*')->where(['id_lead', $id])->get();
$l = new Leads();
$teste = $l->getCliente();
$cliente = $teste->nome;
$this->arr['cliente'] = $cliente;

$produtor = (new Orm('usuarios'))->select(['nome'])->where(['id_usuario', $this->arr['info']->para])->first()->get();
$this->arr['anexos'] = (new Orm('leads'))->select('anexos')->where(['id_lead', $id])
->first()->get();

$this->arr['info']->para = $produtor->nome ?? '';

$this->arr['notificacao'] = false;
$this->arr['funil'] = (new Orm('funil'))->select('*')->get();
$id_funil = $this->arr['info']->funil_id;
$this->arr['funil_nome'] = (new Orm('funil'))->select('*')->where(['id_funil', $id_funil])->first()->get();
if(isset($this->arr['info']->email) && $this->arr['info']->email != ''){
$email = $this->arr['info']->email;
$tem = (new Orm('leads'))->select('*')->wherecustom("email = '$email'")->total()->get();
  if($tem >1){
   $this->arr['notificacao'] = true;
  }
}
$this->arr['id_lead'] = $id;
$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);

$com = new Leads();
$this->arr['comentarios'] = $com->getcomentario($id); 

$this->loadTemplate('leads/visualiza', $this->arr);
//  echo '<pre>';
//  print_r($this->arr);
//  exit;
}

public function view($id){
$this->arr['list_js'] = array(
'plugins/sweetalert2',
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init', 
'system',
'flatpickr/flatpickr',
'flatpickr/pt',
'flatpickr/flatpickr_init',
'multiuploads'
); 

$this->atualizaleads($id);

$this->arr['usuario_logado'] = $this->user->getId();
//$this->arr['titulos'] = (new Orm('titulos'))->select('*')->get();
//->wherecustom("funil_id = $item->id_funil AND produto != 'INATIVO' AND para = $id_usuario AND data_entrada between $data_inicial and $data_final")
//$this->arr['info'] = (new Orm('leads'))->select('*')->where(['id_lead', $id])
$this->arr['info'] = (new Orm('leads'))->select('*')->wherecustom("id_lead = $id")->first()->get();
$up = new Orm('leads_motivo');
$this->arr['infomotivos'] = $up->select('*')->where(['id_lead', $id])->get();
$l = new Leads();
$teste = $l->getCliente();
$cliente = $teste->nome;
$this->arr['cliente'] = $cliente;

$modulo_boleto = $this->permissao->getPermissoesBoleto();
$modulo_whatsapp = $modulo_boleto->modulo_whatsapp;
if($modulo_whatsapp == 1){
  $this->arr['whats_flow']  = (new Orm('whats_flow'))->select('*')->get();
  $this->arr['id_manager'] = $this->user->id_manager();
  //echo '<pre>';
  //print_r($this->arr['id_manager']);
  //exit;
}

//$this->arr['montavw'] = (new Orm('leads'))->select(['Nome','Produto','Email','telefone','origem','data_entrada','status','para','curso_texto','cidade'])->where(['id_lead', $id])
//->first()->get();
$produtor = (new Orm('usuarios'))->select(['nome'])->where(['id_usuario', $this->arr['info']->para])->first()->get();
$this->arr['anexos'] = (new Orm('leads'))->select('anexos')->where(['id_lead', $id])
->first()->get();

$this->arr['info']->para = $produtor->nome ?? '';

$this->arr['notificacao'] = false;
$this->arr['funil'] = (new Orm('funil'))->select('*')->get();
$id_funil = $this->arr['info']->funil_id;
$this->arr['funil_nome'] = (new Orm('funil'))->select('*')->where(['id_funil', $id_funil])->first()->get();
if(isset($this->arr['info']->email) && $this->arr['info']->email != ''){

$email = $this->arr['info']->email;
$tem = (new Orm('leads'))->select('*')->wherecustom("email = '$email'")->total()->get();
//echo '<pre>';
//print_r($this->arr['info']);
  if($tem >1){
   $this->arr['notificacao'] = true;
  }
}

$this->arr['id_lead'] = $id;
$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);

$com = new Leads();
$this->arr['comentarios'] = $com->getcomentario($id); 
//$this->arr['comentarios'] = (new Orm('leads_comentarios'))->select(['leads_comentarios.*, usuarios.nome'])
//->join(['usuarios'])
//->on(['leads_comentarios.id_user','=','usuarios.id_usuario'])
//->where(['id_lead', $id])->order(['id_comentario desc'])->get();
//echo '<pre>';
//print_r($this->arr);
//exit;


$this->loadTemplate('leads/visualiza', $this->arr);
}//view

public function atualizaleads($id){
$tab = (new Orm('leads_comentarios'))->select('*')
->where(['id_lead', $id])->get();

if(empty($tab)){
  return '';
}

foreach($tab as $lead){

  if($lead->status_tarefa == 'agendada'){
    $inicio = date('Y-m-d');
    $dias = $this->calculoDias($inicio, $lead->data_agendamento);
    if($dias < 0){
      $up = (new Orm('leads_comentarios'))
      ->set(['status_tarefa'=>'atrasado'])
      ->where(['id_comentario', $lead->id_comentario])->update();
    }     
  }
}
}//atualizaleads


public function send($id){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'functions_js',
'plugins/sweetalert2',
'system'
);  

$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->arr['id_lead'] = $id;  
$this->arr['produtores'] = (new Orm('usuarios'))->select('*')->where(['tipo','Produtor'])->get();
$this->arr['titulos'] = (new Orm('titulos'))->select('*')->get();

if(isset($_POST['produtor']) && !empty($_POST['produtor'])){
$produtor = $this->limpaCampo($_POST['produtor']);
$id_lead = $this->limpaCampo($_POST['id_lead']);

//dados do produtor
$info = (new Orm('usuarios'))->select(['email'])->where(['id_usuario', $produtor])->first()->get();


if(empty($info)){
$_SESSION['msg'] = ['type'=>'info','msg'=>'Email não informado para esse produtor'];
header("Location:".BASE_URL."leads/send/".$id);
exit;
}


$up = (new Orm('leads'))->set(['status'=>'entregue', 'para'=>$produtor])
->where(['id_lead', $id_lead])->update();

//montando o corpo do email
$array = (new Orm('leads'))->select('*')->where(['id_lead', $id])
->first()->get();
$saida = '';

foreach($array as $key=>$item):  
 if($key != 'id_lead' && $key != 'para'){
$ind = $this->searcharray($key, 'indice_titulo', $this->arr['titulos']);


if($ind !== null){
$saida .= '<p><b>'.$this->arr['titulos'][$ind]->novo_titulo.'</b>: '.$item.'</p>';
}
else{
$arr_titulo = $key;
$titulo = ucfirst($arr_titulo);
$titulo = str_replace('_',' ',$titulo);

if($key === 'data_entrada'){
$saida .= '<p><b>'.$titulo.'</b>: '.date('d/m/Y', strtotime($item)).'</p>';
}else{
$saida .= '<p><b>'.$titulo.'</b>: '.$item.'</p>';
}
}
}
endforeach;
header("Location:".BASE_URL."leads");
exit;
/*
//aqui eu envio o email
$mail = new Email();
$mail->addAdress($info->email, 'PowerControl');
$info = array('assunto'=>'Lead Power Controle', 'corpo'=>$saida);
$mail->formatarEmail($info);

if($mail->enviarEmail()){
 $_SESSION['msg'] = ['type'=>'success','msg'=>'E-mail enviado com sucesso!'];
 header("Location:".BASE_URL."leads");
 exit;
}else{  
  $_SESSION['msg'] = ['type'=>'error','msg'=>'Ooopss, erro ao enviar E-mail tente novamente!'];
 header("Location:".BASE_URL."leads");
 exit;
} */
}

$this->loadTemplate('leads/send', $this->arr);
}

public function sendlodte(){
$produtor = $_POST['produtor'];  
$mail = new Email();
$this->arr['titulos'] = (new Orm('titulos'))->select('*')->get();


foreach($_POST['leads'] as $lead){
$item = (new Orm('leads'))->select(['email'])->where(['id_lead', $lead])
->first()->get();

//atualizar o status para entregue depois de enviado
$up = (new Orm('leads'))->set(['status'=>'entregue', 'para'=>$produtor])
->where(['id_lead', $lead])->update();


//montando o corpo do email
$array = (new Orm('leads'))->select('*')->where(['id_lead', $lead])
->first()->get();
$saida = '';

foreach($array as $key=>$item):  
 if($key != 'id_lead' && $key != 'para'){
$ind = $this->searcharray($key, 'indice_titulo', $this->arr['titulos']);


if($ind !== null){
$saida .= '<p><b>'.$this->arr['titulos'][$ind]->novo_titulo.'</b>: '.$item.'</p>';
}
else{
$arr_titulo = $key;
$titulo = ucfirst($arr_titulo);
$titulo = str_replace('_',' ',$titulo);

if($key === 'data_entrada'){
$saida .= '<p><b>'.$titulo.'</b>: '.date('d/m/Y', strtotime($item)).'</p>';
}else{
$saida .= '<p><b>'.$titulo.'</b>: '.$item.'</p>';
}
}
}
endforeach;


$dados_produtor = (new Orm('usuarios'))->select(['email'])->where(['id_usuario', $produtor])->where(['tipo','Produtor'])->first()->get();
/*
//aqui eu envio o email
$mail->addAdress($dados_produtor->email, 'PowerControl');
$info = array('assunto'=>'Lead Power Controle', 'corpo'=>$saida);
$mail->formatarEmail($info);
$mail->enviarEmail();
*/
}//foreach


echo json_encode('1');
exit;

}//sendlote

public function montaViewlead($array){
  $this->arr['titulos'] = (new Orm('titulos'))->select('*')->get();
  $saida = '';
  
  foreach($array as $key=>$item):  
    //if($key != 'id_lead' && $key != 'funil_id'){
    if($key != 'id_lead' && $key != 'qtde_vidas' && $key != 'tipo_cotacao' && $key != 'funil_id' && $key != 'anexos'){
  $ind = $this->searcharray($key, 'indice_titulo', $this->arr['titulos']);
  
  
  if($ind !== null){
  $saida .= '<p><b>'.$this->arr['titulos'][$ind]->novo_titulo.'</b>: '.$item.'</p>';
  }
  else{
  $arr_titulo = $key;
  $titulo = ucfirst($arr_titulo);
  $titulo = str_replace('_',' ',$titulo);
  
  if($key === 'data_entrada'){
  $saida .= '<p><b>'.$titulo.'</b>: '.date('d/m/Y', strtotime($item)).'</p>';
  }elseif($key == 'para'){
  $saida .= '<p><b>Produtor:</b> '.$item.'</p>';
  }else{
  $saida .= '<p><b>'.$titulo.'</b>: '.$item.'</p>';
  }
  }
  }
  endforeach;
  
  echo $saida;
  }//monta view

public function montaView($array){
$this->arr['titulos'] = (new Orm('titulos'))->select('*')->get();
$saida = '';

foreach($array as $key=>$item):  
  //if($key != 'id_lead' && $key != 'funil_id'){
  if($key != 'id_lead' && $key != 'qtde_vidas' && $key != 'tipo_cotacao' && $key != 'funil_id'){
$ind = $this->searcharray($key, 'indice_titulo', $this->arr['titulos']);


if($ind !== null){
$saida .= '<p><b>'.$this->arr['titulos'][$ind]->novo_titulo.'</b>: '.$item.'</p>';
}
else{
$arr_titulo = $key;
$titulo = ucfirst($arr_titulo);
$titulo = str_replace('_',' ',$titulo);

if($key === 'data_entrada'){
$saida .= '<p><b>'.$titulo.'</b>: '.date('d/m/Y', strtotime($item)).'</p>';
}elseif($key == 'para'){
$saida .= '<p><b>Produtor:</b> '.$item.'</p>';
}else{
$saida .= '<p><b>'.$titulo.'</b>: '.$item.'</p>';
}
}
}
endforeach;

echo $saida;
}//monta view

public function getProdutor($id){  
$vendedor = '';

//$prod = (new Orm('usuarios'))->select(['nome'])->where(['id_usuario', $id])->where(['tipo','Produtor'])->first()->get();
$prod = (new Orm('usuarios'))->select(['nome'])->where(['id_usuario', $id])->first()->get();
//print_r($prod);

if($prod){
$vendedor = $prod->nome;
}
return $vendedor;
//exit;
//echo '11';
}//getProdutor

public function finalizatarefa(){
$tarefa = addslashes($_POST['vlr']);

$up = (new Orm('leads_comentarios'))->set(['finalizado'=>'S'])
->where(['id_comentario', $tarefa])->update();

$grava = (new Orm('shedules'))->set(['color'=>'#37d84f','remark'=>'S'])
->where(['event_type', $tarefa])->update(); 


if($up){
echo json_encode('1');
exit;
}

echo json_encode('2');
exit;
}

public function cancelartarefa(){
  $tarefa = addslashes($_POST['vlr']);
  
  $up = (new Orm('financeiro_faturamento'))->set(['fpagamento'=>'CANCELADO'])
  ->where(['id_comentario', $tarefa])->update();
  /*
  $grava = (new Orm('shedules'))->set(['color'=>'#37d84f','remark'=>'S'])
  ->where(['event_type', $tarefa])->update(); 
  */
  
  if($up){
  echo json_encode('1');
  exit;
  }
  
  echo json_encode('2');
  exit;
  }

public function removetarefa($id, $lead){
$del = (new Orm('leads_comentarios'))->del(['id_comentario', $id]);
$_SESSION['msg'] = array('type'=>'success', 'msg'=>'Tarefa removida com sucesso!');
$this->redirect(BASE_URL."leads/view/".$lead);
}

public function del($id){

$del = (new Orm('leads'))->del(['id_lead', $id]);
$_SESSION['msg'] = array('type'=>'success', 'msg'=>'Lead removido com sucesso!');
$this->redirect(BASE_URL."leads");
}//remover

public function lendoAnexos($anexos){
  //echo '<script>alert("aqui");</script>';
  if($anexos != ''){
   $anexos = json_decode($anexos, true);
   
    foreach($anexos as $key=> $value){
      $rota = BASE_URL.$value;
  
      if(substr($value, -3) == 'png' || substr($value, -3) == 'jpg' || substr($value, -4) == 'jpeg'){
       echo ' <li>
                  <div class="img_resp">
                  <img src="'.$rota.'">
                  </div>
                   <p>'.mb_strimwidth($value, 0, 30, "...").'</p>                  
                  <button type="button">
                  <a href="'.$rota.'" download style="color:white;"><i class="fa fa-download"></i></a></button>  
                  <button type="button" temporario class="apagarArquivo2"><i class="fa fa-times"></i></button>              
                  </li>'; 
      }
  
  
      if(substr($value, -3) == 'pdf'){
        echo '<li>
              <div class="img_icon"><i class="fa fa-file-pdf-o"></i></div>
              <p>'.mb_strimwidth($value, 0, 30, "...").'</p>
               <button type="button"><a href="'.$rota.'" download style="color:white;"><i class="fa fa-download"></i></a></button> 
               <button type="button" temporario class="apagarArquivo2"><i class="fa fa-times"></i></button>           
        </li>';
      }
  
      if(substr($value, -3) == 'doc' || substr($value, -4) == 'docx'){
        echo '<li>
                   <div class="img_icon"><i class="fa fa-file-word-o"></i></div>   
                    <p>'.mb_strimwidth($value, 0, 30, "...").'</p>                
                   <button type="button"><a href="'.$rota.'" download style="color:white;"><i class="fa fa-download"></i></a></button> 
                   <button type="button" temporario class="apagarArquivo2"><i class="fa fa-times"></i></button>                
                   </li>';
      }
  
      if(substr($value, -3) == 'xls' || substr($value, -4) == 'xlsx'){
        echo '<li>
                   <div class="img_icon"><i class="fa fa-file-excel-o"></i></div>
                    <p>'.mb_strimwidth($value, 0, 30, "...").'</p>
                   <button type="button"><a href="'.$rota.'" download style="color:white;"><i class="fa fa-download"></i></a></button>  
                   <button type="button" temporario class="apagarArquivo2"><i class="fa fa-times"></i></button>                
                   </li>  ';
      }
  
  
    }
  }
  
  }//lendoAnexos 



public function disparo(){
$total = (new Orm('leads'))->select('*')->where(['status','novo'])->total()->get();
$lista = (new Orm('leads'))->select(['nome'])->where(['status','novo'])->order(['id_lead desc'])->limit('5')->get();


//mando para o push em json a quantidade e a lista para exibir no icone
//atualização PUSH
/*
$options = array(
  'cluster' => 'sa1',
  'useTLS' => true
);
$pusher = new Pusher\Pusher(
    'f9824928d137cc25989b',
    '5b73861e45d1ff6efe08',
    '1481742',
    $options
);

$data = json_encode(['qtde'=>$total]);
$pusher->trigger('my-channel', 'my-event', $data);
*/
//fim da atualização PUSH

}//disparo


}