<?php
use Core\Controller;
use Models\Users;
use Models\Funil;
use Models\Motivo;
use Models\Permissao;
use Models\Orm;

class MotivoController extends Controller {

  private $user;
  private $arr;
  private $permissao;

    public function __construct() {              
        $this->user = new Users();
        $this->permissao = new Permissao(); 

        if($this->user->isLogged() == false){                  
         header("Location: ".BASE_URL."login");        
         exit;         
        }

        $permissoes = $this->permissao->getPermissoes();
        $modulo_boleto = $this->permissao->getPermissoesBoleto();
        
         $this->arr = array(
          'user'=>$this->user,
          'menuActive'=>'home',
          'permissao'=>$permissoes,
          'modulo_boleto'=>$modulo_boleto
         );           
}

public function index() {   
$this->arr['list_js'] = array(
'plugins/sweetalert2',
'system'
);  

$tab = new Orm('motivo');
$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);

if(isset($_GET['nome']) && !empty($_GET['nome'])){
$nome = addslashes($_GET['nome']);
$this->arr['lista'] = $tab->select('*')->search(['nome_motivo', $nome])->get();
}else{
$this->arr['lista'] = $tab->select('*')->paginate('10')->get();
$this->arr['paginacao'] = $tab->render("motivo");
}


$this->loadTemplate('motivo/listar', $this->arr);
}//function index  


public function add(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'preview_imagem',
'uploadImage',
'functions_js',
'plugins/sweetalert2',
'system'
);


$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('motivo/adicionar', $this->arr);
}//add


public function edit($id){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'preview_imagem',
'uploadImage',
);

$this->arr['id_motivo'] = $id;
$this->arr['info'] = (new Orm('motivo'))->select('*')->where(['id_motivo', $id])
->first()->get();



$this->loadTemplate('motivo/editar', $this->arr);
}//edit

public function edit_action(){

  $this->arr['list_js'] = array(
    'plugins/jquery.mask.min',
    'plugins/parsley/parsley.min',
    'plugins/parsley/pt-br',
    'mask_init',
    'preview_imagem',
    'uploadImage',
    );
      
  $funil = new Funil();
  $up = new Motivo();
  $id = $_POST['id_funil'];
  $nome = $_POST['nome_funil'];

  $funil->edit_action($id,$nome);
  $del = $up->delsubmotivo($id);
//print_r($_POST['motivo']);
//exit;
if(isset($_POST['motivo']) && !empty($_POST['motivo'])){ 
  foreach($_POST['motivo'] as $mot){
  $gravamot = $up->addsubmotivo($id,$mot);

  }

}
$_SESSION['msg'] = array('type'=>'success', 'msg'=>'Funil Editado com sucesso!');
header("Location:".BASE_URL."funil");
exit;

}

public function save(){

if(isset($_POST['nome']) && !empty($_POST['nome'])){
 $id_motivo   = (isset($_POST['id_motivo'])) ? $this->limpaCampo($_POST['id_motivo']) : NULL; 
 $nome            = $this->limpaCampo($_POST['nome']);

 
$consulta = (new Orm('motivo'))->select('*')->where(['nome_motivo', $nome])->first()->get();

if(!empty($consulta)){
  $_SESSION['msg'] = array('type'=>'error', 'msg'=>'Ooppss, ja existe cadastro com esse número ou nome no sistema, por favor tente novamente!!!');
  header("Location:".BASE_URL."motivo");
  exit;  
}

$dados_form = [
'nome_motivo'=>$nome
];

if($id_motivo == null){
 $grv = (new Orm('motivo'))->set($dados_form)->save();
 $_SESSION['msg'] = array('type'=>'success', 'msg'=>'Motivo cadastrado com sucesso!');
 $this->redirect(BASE_URL."motivo"); 
}else{
 $grv = (new Orm('motivo'))->set($dados_form)->where(['id_motivo', $id_motivo])->update();
 $_SESSION['msg'] = array('type'=>'success', 'msg'=>'Motivo Editado com sucesso!');
 header("Location:".BASE_URL."motivo");
 exit;
}

}

}//save

public function remover($id){
$del = (new Orm('motivo'))->del(['id_origem', $id]);
$_SESSION['msg'] = array('type'=>'success', 'msg'=>'Motivo removido com sucesso!');
$this->redirect(BASE_URL."motivo");
}//remover

}