<?php
use Core\Controller;
use Models\Users;
use Models\Permissao;
use Models\Orm;
use Models\Leads;
use Models\Validate;

class PrevendaController extends Controller {

  private $user;
  private $arr;
  private $permissao;

    public function __construct() {              
        $this->user = new Users();
        $this->permissao = new Permissao(); 

        if($this->user->isLogged() == false){                  
         header("Location: ".BASE_URL."login");        
         exit;         
        }

       $usuario = $this->user->getId();       
       $permissoes = $this->permissao->getPermissoes();
       $modulo_boleto = $this->permissao->getPermissoesBoleto();
       
        $this->arr = array(
         'user'=>$this->user,
         'menuActive'=>'home',
         'permissao'=>$permissoes,
         'modulo_boleto'=>$modulo_boleto
        );        
}

public function index() {   
$this->arr['list_js'] = array(
'plugins/sweetalert2',
'system'
);  

$tab = new Orm('leads');
$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);

if(isset($_GET['nome']) && !empty($_GET['nome'])){
$nome = addslashes($_GET['nome']);
$this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')->search(['nome', $nome])
->join(['usuarios'])
->on(
  ['leads.para','=','usuarios.id_usuario'])->get();
  $this->arr['paginacao'] = $tab->render('prevenda/pendencias');  
}else{
  if(isset($_GET['situacao_pesquisa']) && !empty($_GET['situacao_pesquisa'])){
    $situacao_pesquisa = addslashes($_GET['situacao_pesquisa']);
    $this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')->search(['situacao_pv', $situacao_pesquisa])    
    ->join(['usuarios'])
    ->on(
      ['leads.para','=','usuarios.id_usuario'])->get();
      $this->arr['paginacao'] = $tab->render('prevenda/pendencias');      
    }else{
    $this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')      
    ->join(['usuarios'])
    ->on(
      ['leads.para','=','usuarios.id_usuario'])->wherecustom("situacao_pv = 'Pre-Venda Pendente' or situacao_pv = 'Não Atende POV' or situacao_pv = 'Não Atende AUT' or situacao_pv = 'Não Atende POV e AUT'")->order(['data_entrada desc'])->paginate('10')->get();
      $this->arr['paginacao'] = $tab->render('prevenda/pendencias');
    }
}


$this->loadTemplate('prevenda/prevenda_inicio', $this->arr);
}//function index  

public function add_action(){

  $validator = new Validate();
  $validate = '';
  //$l = new Leads();
  //echo '<pre>';
  //print_r($_POST);
  //exit;
  
  if(isset($_POST['nome']) && !empty($_POST['produto'])){
  
  $status = 'novo';
  $tem = (new Orm('leads'))->select(['telefone'])->where(['telefone', $_POST['telefone']])->first()->get();
  if($tem){
  $status = 'repetido';
  }
  
  $l = new Leads();
  $teste = $l->getCliente();
  $cliente = $teste->nome;
  $this->arr['cliente'] = $cliente;
  $l = new Leads();
  $pegacel = $l->pegacel($_POST['telefone']);
  $modulo_boleto = $this->permissao->getPermissoesBoleto();
  $modulo_whatsapp = $modulo_boleto->modulo_whatsapp;
  $chave_botconversa = $modulo_boleto->chave_botconversa;
  if( $modulo_whatsapp == 1){
    $telwhats = '+55'.str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$_POST['telefone']))));
    $nome = $_POST['nome'];
    $produto = $_POST['produto'];
    
    $data = [
      'phone' => $telwhats,
      'first_name' => $nome,
      'last_name' => $produto
    ];
    $dataheader = [
      'API-KEY' => $chave_botconversa,
      'Content-type' => 'application/json'
    ];    
  
  // API URL
  $url = 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/';
  
  $payload = json_encode($data);
  $payloadheader = json_encode($dataheader);
  $curl = curl_init();
  curl_setopt_array($curl, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POSTFIELDS=>$payload,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_HTTPHEADER => [
      "API-KEY: $chave_botconversa", 
      "Content-type: application/json"
    ],
  ]);
  
  $response = curl_exec($curl);
  $err = curl_error($curl);
  }
  $situacao_pv= $_POST['situacao_pv'];
  
  if($situacao_pv == 'Enviar Link Cartao'){
    $chave_botconversa = 'd239fdb6-33f4-4c67-aee5-f86cbb0effcd';
    $id = $_POST['id_webform'];
    $campanha = '4129394';
  }

  if($situacao_pv == 'Enviar Link Cartao Adimplencia'){
    $chave_botconversa = 'd239fdb6-33f4-4c67-aee5-f86cbb0effcd';
    $id = $_POST['id_webform'];
    $campanha = '4178885';
  }

  if($situacao_pv == 'Enviar Link Cartao' || $situacao_pv == 'Enviar Link Cartao Adimplencia'){
 
    //echo $id;
    //exit;

    $telwhats = '+55'.str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$_POST['telefone']))));
    $nome = $_POST['nome'];
    $produto = $_POST['produto'];
    $data = [
      'phone' => $telwhats,
      'first_name' => $nome,
      'last_name' => $produto
    ];
    $dataheader = [
      'API-KEY' => $chave_botconversa,
      'Content-type' => 'application/json'
    ];    
  
  // API URL
  $url = 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/';
  
  $payload = json_encode($data);
  $payloadheader = json_encode($dataheader);
  $curl = curl_init();
  curl_setopt_array($curl, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POSTFIELDS=>$payload,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_HTTPHEADER => [
      "API-KEY: $chave_botconversa", 
      "Content-type: application/json"
    ],
  ]);
  
  $response = curl_exec($curl);
  $err = curl_error($curl);
  
  $datax = json_decode($response);
  
   if(isset($datax->id) && !empty($datax->id)){
    $id_subscriber = $datax->id;
    $grava = (new Orm('leads'))->set(['id_subscriber'=>$id_subscriber])->where(['id_lead', $id])->update();
   }
  
   $telefoneget = '+55'.str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$_POST['telefone']))));
   // /subscriber/get_by_phone/{phone}/
   $data = [
    'phone' => $telefoneget
  ];
  $dataheader = [
    'API-KEY' => $chave_botconversa,
    'Content-type' => 'application/json'
  ];    
  
  // API URL
  $url = 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/get_by_phone/'.$telefoneget.'/';
  
  $payload = json_encode($data);
  $payloadheader = json_encode($dataheader);
  //print_r($payloadheader);
  //exit;
  $curl = curl_init();
  curl_setopt_array($curl, [
  CURLOPT_URL => $url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POSTFIELDS=>$payload,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "GET",
  CURLOPT_HTTPHEADER => [
    "API-KEY: $chave_botconversa", 
    "Content-type: application/json"
  ],
  ]);
  
  $responseg = curl_exec($curl);
  $err = curl_error($curl);
  
  $dataxg = json_decode($responseg);
  
  if(isset($dataxg->id) && !empty($dataxg->id)){
  $id_lead = $id;
  $id_subscriber = $dataxg->id;
  $id_whats = $dataxg->id;
  $grava = (new Orm('leads'))->set(['id_subscriber'=>$id_subscriber])->where(['id_lead', $id_lead])->update();
  }else{
  $id_whats = $_POST['id_whats'];
  }
    
    $data = [
      'flow' => $campanha
    ];
    $dataheader = [
      'API-KEY' => $chave_botconversa,
      'Content-type' => 'application/json'
    ];    
  $payload = json_encode($data);
  $headerjson = json_encode($dataheader);

   $curl = curl_init();

    curl_setopt_array($curl, array(
    CURLOPT_URL => 'https://backend.botconversa.com.br/api/v1/webhook/subscriber/'.$id_whats.'/send_flow/',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'POST',
    CURLOPT_POSTFIELDS =>$payload,
    CURLOPT_HTTPHEADER => [
      "API-KEY: $chave_botconversa", 
      //"API-KEY: 7c33c5f1-8a21-4147-8d84-37b03f1cc98c",  
      "Content-type: application/json"
    ],
    ));

    $response = curl_exec($curl);
    curl_close($curl);
  }

  $nome= $_POST['nome'];
  $produto= $_POST['produto'];
  $email= $_POST['email'];
  $telefone= $_POST['telefone'];
  $telefone2= '';
  $telefone3= '';
  $obsn= $_POST['obsn'];
  $cidade= '';
  $codsocio= $_POST['codsocio'];
  $codsistema= $_POST['codsistema'];
  $origem= 'PREVENDA ADD';


  $fp_agencia ='';
  $fp_conta = '';
  $fp_cartao_nome = '';
  $fp_cartao_numero = '';
  $fp_cartao_cseguranca = '';
  $fp_cartao_validade = '';
  $fp_cartao_bandeira = '';
  $fp_energia_uc ='';
  $fp_energia_pn = '';

  $acao = $_POST['acao'];
  $horario = $_POST['horario'];
  $data_nascimento = $_POST['data_nascimento'];
  $rg = $_POST['rg'];
  $estado_civil = $_POST['estado_civil'];
  $adesao = $_POST['adesao'];
 
  if(isset($_POST['Financeiro'])){
    $resp_nome = $_POST['nome'];
    $resp_cpf = $_POST['codsocio'];
    $resp_rg = $_POST['rg'];
    $resp_data_nascimento = $_POST['data_nascimento'];
    $resp_telefone = $_POST['telefone'];               
 
    //echo 'checked';
    //exit;
  }else{
    $resp_nome = $_POST['resp_nome'];
    $resp_cpf = $_POST['resp_cpf'];
    $resp_rg = $_POST['resp_rg'];
    $resp_data_nascimento = $_POST['resp_data_nascimento'];
    $resp_telefone = $_POST['resp_telefone']; 
    //echo 'unchecked';
    //exit;
  }
  if(isset($_POST['data_nascimento']) && !empty($_POST['data_nascimento'])){
    
  }else{
    $data_nascimento = '1900-01-01';
    $resp_data_nascimento = '1900-01-01';
  }

  //echo $data_nascimento;
  //echo $resp_data_nascimento;
  //exit;
  $cep_cli = $_POST['cep_cli'];
  $end_cli = $_POST['end_cli'];
  $n_cli = $_POST['n_cli'];
  $bairro_cli = $_POST['bairro_cli'];
  $complemento_cli = $_POST['complemento_cli'];
  $cidade_cli = $_POST['cidade_cli'];
  $estado_cli = $_POST['estado_cli'];
  $fp_anual_meio_pagamento = $_POST['fp_anual_meio_pagamento'];
  $forma_pagamento = $_POST['forma_pagamento'];
  if($forma_pagamento == 'Bradesco'){
    $fp_agencia = $_POST['fpbradesco_fp_agencia'];
    $fp_conta = $_POST['fpbradesco_fp_conta'];
  }
  if($forma_pagamento == 'Caixa Economica Federal'){
    $fp_agencia = $_POST['fpcaixa_fp_agencia'];
    $fp_conta = $_POST['fpcaixa_fp_conta'];
  }      
  if($forma_pagamento == 'Itau'){
    $fp_agencia = $_POST['fpitau_fp_agencia'];
    $fp_conta = $_POST['fpitau_fp_conta'];
  }       
  if($forma_pagamento == 'Santander'){
    $fp_agencia = $_POST['fpsantander_fp_agencia'];
    $fp_conta = $_POST['fpsantander_fp_conta'];
  }  
  if($forma_pagamento == 'Sicoob'){
    $fp_agencia = $_POST['fpssicoob_fp_agencia'];
    $fp_conta = $_POST['fpssicoob_fp_conta'];
  }  
  if($forma_pagamento == 'Sicoob - PJ'){
    $fp_agencia = $_POST['fpssicoobpj_fp_agencia'];
    $fp_conta = $_POST['fpssicoobpj_fp_conta'];
  }  
 
  if($forma_pagamento == 'Cartao de Credito'){
    $fp_cartao_nome = $_POST['fpcredito_fp_cartao_nome'];
    $fp_cartao_numero = $_POST['fpcredito_fp_cartao_numero'];
    $fp_cartao_cseguranca = $_POST['fpcredito_fp_cartao_cseguranca'];
    $fp_cartao_validade = $_POST['fpcredito_fp_cartao_validade'];
    $fp_cartao_bandeira = $_POST['fpcredito_fp_cartao_bandeira'];

  }
  if($forma_pagamento == 'Cartao de Debito'){
    $fp_cartao_nome = $_POST['fpdebito_fp_cartao_nome'];
    $fp_cartao_numero = $_POST['fpdebito_fp_cartao_numero'];
    $fp_cartao_cseguranca = $_POST['fpdebito_fp_cartao_cseguranca'];
    $fp_cartao_validade = $_POST['fpdebito_fp_cartao_validade'];
    $fp_cartao_bandeira = $_POST['fpdebito_fp_cartao_bandeira'];

  }

  if($forma_pagamento == 'CPFL'){
    $fp_energia_uc = $_POST['fpcpfl_fp_energia_uc'];
    $fp_energia_pn = $_POST['fpcpfl_fp_energia_pn'];
  }
  if($forma_pagamento == 'EDP'){
    $fp_energia_uc = $_POST['fpedp_fp_energia_uc'];
    $fp_energia_pn = $_POST['fpedp_fp_energia_pn'];
  }
  if($forma_pagamento == 'ELEKTRO'){
    $fp_energia_uc = $_POST['fpelektro_fp_energia_uc'];
  }

  if($forma_pagamento == 'ENEL'){
    $fp_energia_uc = $_POST['fpenel_fp_energia_uc'];
  }

  if($forma_pagamento == 'ENERGISA'){
    $fp_energia_pn = $_POST['fpenergisa_fp_energia_pn'];
  }
  if($forma_pagamento == 'Neoenergia'){
    $fp_energia_uc = $_POST['fpneoenergia_fp_energia_uc'];
    $fp_energia_pn = $_POST['fpneoenergia_fp_energia_pn'];
  }

  $fp_operacao = $_POST['fp_operacao'];
  $fp_cartao_tipo = $_POST['fp_cartao_tipo'];
  $fp_cartao_banco = $_POST['fp_cartao_banco'];
  $fp_razaosocial = $_POST['fp_razaosocial'];
  $fp_cnpj = $_POST['fp_cnpj'];
  $para = $this->user->getId();

  //echo $fp_agencia.$fp_conta;
  //exit;
  //$id_lead = $id;
/*
  echo '<pre>';
  echo 'anexos;';print_r($_POST['anexos']);
  echo 'multiplo;';print_r($_POST['mutiplo_upload']);
  echo 'anexoview;';print_r($_POST['anexosview']);
  print_r($this->arr['anexos']);
  exit;
*/

$add = $l->addcartaodetodos($para,$nome,$produto,$email,$telefone,$telefone2,$telefone3,$obsn,$cidade,$codsocio,$codsistema,$origem,$situacao_pv,$acao,$horario,$data_nascimento,$rg,$estado_civil,$adesao,$resp_nome,$resp_cpf,$resp_rg,$resp_data_nascimento,$resp_telefone,$cep_cli,$end_cli,$n_cli,$bairro_cli,$complemento_cli,$cidade_cli,$estado_cli,$fp_anual_meio_pagamento,$fp_operacao,$fp_agencia,$fp_conta,$fp_cartao_nome,$fp_cartao_numero,$fp_cartao_cseguranca,$fp_cartao_tipo,$fp_cartao_banco,$fp_energia_uc,$fp_energia_pn,$fp_razaosocial,$fp_cnpj,$forma_pagamento,$fp_cartao_validade,$fp_cartao_bandeira);  

$id_lead = $add['id'];

  if($_POST['anexos'] != '' && $_POST['anexos'] != NULL){
    //$id_lead = $id_lead;
    //$id_lead = $_POST['id_lead'];
    $files = '';
    $anexos = $_POST['anexos'];
    $anexosname = $_POST['mutiplo_upload'];
    $dados = array();


      if($_POST['anexosview'] != ''){
        $old = (new Orm('leads'))->select(['anexos'])
        ->where(['id_lead', $id_lead])->first()->get(); 
        $arquivo = json_decode($old->anexos, true);
       //print_r($arquivo);
       // exit;
        foreach($arquivo as $arq){
          array_push($dados, $arq);  
        }
        $novos = $this->gravaAnexos($anexos,$anexosname,$id_lead);
        $files = json_decode($novos['files'], true);
        foreach($files as $file){
          array_push($dados, $file);
        }
         $dados = json_encode($dados);     
         $files = $dados;
      }else{
        $files = $this->gravaAnexos($anexos,$anexosname,$id_lead);  
        $files = $files['files'];
      };   
 


      $grava = (new Orm('leads'))->set(['anexos'=>$files])->where(['id_lead', $id_lead])->update();
  };      



  $_SESSION['msg'] = ['type'=>'success','msg'=>'Pre-Venda Adicionada com sucesso!'];
  header("Location:".BASE_URL."prevenda/prevenda_add");
  exit;


  
  }

}

public function prevenda_add(){
  $this->arr['list_js'] = array(
    'plugins/sweetalert2',
    'plugins/jquery.mask.min',
    'plugins/parsley/parsley.min',
    'plugins/parsley/pt-br',
    'mask_init', 
    'system',
    'flatpickr/flatpickr',
    'flatpickr/pt',
    'flatpickr/flatpickr_init',
    'multiuploads'
    ); 
    $this->arr['tipo']  = $this->user->getTipo();
    $this->arr['usuario_logado'] = $this->user->getId();
    $this->arr['bairros'] = (new Orm('financeiro_bairro'))->select('*')->get();
    $this->arr['produtos'] = (new Orm('produtos'))->select('*')->order(['nome_produto asc'])->get();
    $this->arr['origens']  = (new Orm('origem_venda'))->select('*')->get();
    $l = new Leads();
    $teste = $l->getCliente();
    $cliente = $teste->nome;
    $this->arr['cliente'] = $cliente;
    
    $this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);

  $this->loadTemplate('prevenda/prevenda_add', $this->arr);
}

public function pendencias() {   
  $this->arr['list_js'] = array(
  'plugins/sweetalert2',
  'system'
  );  
  
  $tab = new Orm('leads');
  $this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
  
  if(isset($_GET['nome']) && !empty($_GET['nome'])){
  $nome = addslashes($_GET['nome']);
  $this->arr['lista'] = $tab->select('*')->search(['nome', $nome])->get();
  $this->arr['paginacao'] = $tab->render('prevenda/pendencias');  
  }else{
  $this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')      
  ->join(['usuarios'])
  ->on(
    ['leads.para','=','usuarios.id_usuario'])->wherecustom("situacao_pv != 'Pre-Venda Pendente' and situacao_pv != 'Concluído' and situacao_pv != '' and situacao_pv != 'Cancelar'")->order(['data_entrada desc'])->paginate('10')->get();
    $this->arr['paginacao'] = $tab->render('prevenda/pendencias');
  }
  
  
  $this->loadTemplate('prevenda/prevenda_pendencias', $this->arr);
  }//function index

  public function pendenciasprodutor() {   
    $this->arr['list_js'] = array(
    'plugins/sweetalert2',
    'system'
    );  
        
    $tab = new Orm('leads');
    $this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
    $id_usuario = $this->user->getId();

    if(isset($_GET['nome']) && !empty($_GET['nome'])){
    $nome = addslashes($_GET['nome']);
    $this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')
    ->join(['usuarios'])
    ->on(
      ['leads.para','=','usuarios.id_usuario'])->wherecustom("situacao_pv != '' and leads.nome like '%$nome%' and para = $id_usuario")->get();
    //$this->arr['paginacao'] = $tab->render('prevenda/pendencias');  
  }else{
    if(isset($_GET['situacao_pesquisa']) && !empty($_GET['situacao_pesquisa'])){
      //echo 'aqui';
      //exit;
      //echo $id_usuario;
      //exit;
      $situacao_pesquisa = addslashes($_GET['situacao_pesquisa']);
      //echo $situacao_pesquisa;
      //exit;
      $this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')->wherecustom("situacao_pv like '%$situacao_pesquisa%' and para = $id_usuario")
      ->join(['usuarios'])
      ->on(
        ['leads.para','=','usuarios.id_usuario'])->get();
        //$this->arr['paginacao'] = $tab->render('prevenda/arquivoprodutor');      
      //echo '<pre>';
      //print_r($this->arr['lista']);
      //exit;
      }else{
    $this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')      
    ->join(['usuarios'])
    ->on(
      ['leads.para','=','usuarios.id_usuario'])->wherecustom("para = $id_usuario and situacao_pv != 'Concluído' and situacao_pv != '' and situacao_pv != 'Cancelar'")->order(['data_entrada desc'])->paginate('10')->get();
      //$this->arr['paginacao'] = $tab->render('prevenda/pendencias');
    }
    }
    
    
    $this->loadTemplate('prevenda/prevenda_pendenciasprodutor', $this->arr);
    }//function index

  public function arquivoprodutor() {   
    $this->arr['list_js'] = array(
    'plugins/sweetalert2',
    'system'
    );  
    
    $tab = new Orm('leads');
    $this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
    /*
    if(isset($_GET['nome']) && !empty($_GET['nome'])){
    $nome = addslashes($_GET['nome']);
    $this->arr['lista'] = $tab->select('*')->search(['nome', $nome])->get();
    }else{
    $this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')      
    ->join(['usuarios'])
    ->on(
      ['leads.para','=','usuarios.id_usuario'])->wherecustom("situacao_pv != ''")->order(['data_entrada desc'])->paginate('10')->get();
    $this->arr['paginacao'] = $tab->render("origem");
    }*/
    $id_usuario = $this->user->getId();

    if(isset($_GET['nome']) && !empty($_GET['nome'])){
      $nome = addslashes($_GET['nome']);
      $this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')->wherecustom("situacao_pv != '' and leads.nome like '%$nome%' and para = $id_usuario")
      ->join(['usuarios'])
      ->on(
        ['leads.para','=','usuarios.id_usuario'])->get();
        //$this->arr['paginacao'] = $tab->render('prevenda/arquivoprodutor');        
      }else{
        if(isset($_GET['situacao_pesquisa']) && !empty($_GET['situacao_pesquisa'])){
          //echo 'aqui';
          //exit;
          //echo $id_usuario;
          //exit;
          $situacao_pesquisa = addslashes($_GET['situacao_pesquisa']);
          //echo $situacao_pesquisa;
          //exit;
          $this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')->wherecustom("situacao_pv like '%$situacao_pesquisa%' and para = $id_usuario")
          ->join(['usuarios'])
          ->on(
            ['leads.para','=','usuarios.id_usuario'])->get();
            //$this->arr['paginacao'] = $tab->render('prevenda/arquivoprodutor');      
          //echo '<pre>';
          //print_r($this->arr['lista']);
          //exit;
          }else{
          $this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')      
          ->join(['usuarios'])
          ->on(
            ['leads.para','=','usuarios.id_usuario'])->wherecustom("situacao_pv != '' and para = $id_usuario")->order(['data_entrada desc'])->paginate('10')->get();
          //$this->arr['paginacao'] = $tab->render('prevenda/arquivoprodutor');
          }
      }
    
    
    $this->loadTemplate('prevenda/prevenda_arquivoprodutor', $this->arr);
    }//function index

  public function arquivo() {   
    $this->arr['list_js'] = array(
    'plugins/sweetalert2',
    'system'
    );  
    
    $tab = new Orm('leads');
    $this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
    /*
    if(isset($_GET['nome']) && !empty($_GET['nome'])){
    $nome = addslashes($_GET['nome']);
    $this->arr['lista'] = $tab->select('*')->search(['nome', $nome])->get();
    }else{
    $this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')      
    ->join(['usuarios'])
    ->on(
      ['leads.para','=','usuarios.id_usuario'])->wherecustom("situacao_pv != ''")->order(['data_entrada desc'])->paginate('10')->get();
    $this->arr['paginacao'] = $tab->render("origem");
    }*/
    if(isset($_GET['nome']) && !empty($_GET['nome'])){
      $nome = addslashes($_GET['nome']);
      $this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')->search(['nome', $nome])
      ->join(['usuarios'])
      ->on(
        ['leads.para','=','usuarios.id_usuario'])->get();
       // $this->arr['paginacao'] = $tab->render('prevenda/arquivo');        
      }else{
        if(isset($_GET['situacao_pesquisa']) && !empty($_GET['situacao_pesquisa'])){
          $situacao_pesquisa = addslashes($_GET['situacao_pesquisa']);
          $this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')->search(['situacao_pv', $situacao_pesquisa])    
          ->join(['usuarios'])
          ->on(
            ['leads.para','=','usuarios.id_usuario'])->get();
          //  $this->arr['paginacao'] = $tab->render('prevenda/arquivo');            
          }else{
          $this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')      
          ->join(['usuarios'])
          ->on(
            ['leads.para','=','usuarios.id_usuario'])->wherecustom("situacao_pv != ''")->order(['data_entrada desc'])->paginate('10')->get();
         // $this->arr['paginacao'] = $tab->render('prevenda/arquivo');
          }
      }
    
    
    $this->loadTemplate('prevenda/prevenda_arquivo', $this->arr);
    }//function index

public function updatesituacao() {   
  $this->arr['list_js'] = array(
  'plugins/sweetalert2',
  'system'
  );  

  $id_lead = $_POST['lead'];
  $situacao = $_POST['situacao'];
  $grava = (new Orm('leads'))->set(['situacao_pv'=>$situacao])->where(['id_lead', $id_lead])->update();
  return 'ok';
  
  }//function index 

  public function updateobsn() {   
    $this->arr['list_js'] = array(
    'plugins/sweetalert2',
    'system'
    );  
  
    $id_lead = $_POST['lead'];
    $obsn = $_POST['obsn'];
    $grava = (new Orm('leads'))->set(['obsn'=>$obsn])->where(['id_lead', $id_lead])->update();
    return 'ok';
    
    }//function index   

public function updateacao() {   
  $this->arr['list_js'] = array(
  'plugins/sweetalert2',
  'system'
  );  

  $id_lead = $_POST['lead'];
  $acao = $_POST['acao'];
  $grava = (new Orm('leads'))->set(['acao'=>$acao])->where(['id_lead', $id_lead])->update();
  return 'ok';
  
  }//function index  

public function add(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'preview_imagem',
'uploadImage',
'functions_js',
'plugins/sweetalert2',
'system'
);


$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('origem/adicionar', $this->arr);
}//add


public function edit($id){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'preview_imagem',
'uploadImage',
);

$this->arr['id_origem'] = $id;
$this->arr['info'] = (new Orm('origem_venda'))->select('*')->where(['id_origem', $id])
->first()->get();
$this->loadTemplate('origem/editar', $this->arr);
}//edit


public function save(){

if(isset($_POST['nome']) && !empty($_POST['nome'])){
 $id_origem   = (isset($_POST['id_origem'])) ? $this->limpaCampo($_POST['id_origem']) : NULL; 
 $nome            = $this->limpaCampo($_POST['nome']);

 
$consulta = (new Orm('origem_venda'))->select('*')->where(['nome_origem', $nome])->first()->get();

if(!empty($consulta)){
  $_SESSION['msg'] = array('type'=>'error', 'msg'=>'Ooppss, ja existe cadastro com esse número ou nome no sistema, por favor tente novamente!!!');
  header("Location:".BASE_URL."origem");
  exit;  
}

$dados_form = [
'nome_origem'=>$nome
];

if($id_origem == null){
 $grv = (new Orm('origem_venda'))->set($dados_form)->save();
 $_SESSION['msg'] = array('type'=>'success', 'msg'=>'Origem cadastrada com sucesso!');
 $this->redirect(BASE_URL."origem"); 
}else{
 $grv = (new Orm('origem_venda'))->set($dados_form)->where(['id_origem', $id_origem])->update();
 $_SESSION['msg'] = array('type'=>'success', 'msg'=>'Origem Editada com sucesso!');
 header("Location:".BASE_URL."origem");
 exit;
}

}

}//save

public function remover($id){
$del = (new Orm('origem_venda'))->del(['id_origem', $id]);
$_SESSION['msg'] = array('type'=>'success', 'msg'=>'Origem removida com sucesso!');
$this->redirect(BASE_URL."origem");
}//remover

public function fotos($id){

  //echo $id;
  //exit;
  $this->arr['item'] = (new Orm('leads'))->select('*')
  ->where(['id_lead', $id])->first()->get(); 
//  $this->arr['item'] = json_decode($old->anexos, true);

  //$this->loadview('prevenda/prevenda_fotos', $this->arr);
  $this->loadview('prevenda/prevenda_fotos', $this->arr);
  //exit; 

  
}//lendoAnexos 


public function lendoAnexos($anexos){
  //echo '<script>alert("aqui");</script>';
  if($anexos != ''){
   $anexos = json_decode($anexos, true);
   
    foreach($anexos as $key=> $value){
      $rota = BASE_URL.$value;
  
      if(substr($value, -3) == 'png' || substr($value, -3) == 'jpg' || substr($value, -4) == 'jpeg'){
       echo ' <li>
                  <div class="img_resp">
                  <img src="'.$rota.'">
                  </div>
                   <p>'.mb_strimwidth($value, 0, 30, "...").'</p>                  
                  <button type="button">
                  <a href="'.$rota.'" download style="color:white;"><i class="fa fa-download"></i></a></button>  
                  <button type="button" temporario class="apagarArquivo2"><i class="fa fa-times"></i></button>              
                  </li>'; 
      }
  
  
      if(substr($value, -3) == 'pdf'){
        echo '<li>
              <div class="img_icon"><i class="fa fa-file-pdf-o"></i></div>
              <p>'.mb_strimwidth($value, 0, 30, "...").'</p>
               <button type="button"><a href="'.$rota.'" download style="color:white;"><i class="fa fa-download"></i></a></button> 
               <button type="button" temporario class="apagarArquivo2"><i class="fa fa-times"></i></button>           
        </li>';
      }
  
      if(substr($value, -3) == 'doc' || substr($value, -4) == 'docx'){
        echo '<li>
                   <div class="img_icon"><i class="fa fa-file-word-o"></i></div>   
                    <p>'.mb_strimwidth($value, 0, 30, "...").'</p>                
                   <button type="button"><a href="'.$rota.'" download style="color:white;"><i class="fa fa-download"></i></a></button> 
                   <button type="button" temporario class="apagarArquivo2"><i class="fa fa-times"></i></button>                
                   </li>';
      }
  
      if(substr($value, -3) == 'xls' || substr($value, -4) == 'xlsx'){
        echo '<li>
                   <div class="img_icon"><i class="fa fa-file-excel-o"></i></div>
                    <p>'.mb_strimwidth($value, 0, 30, "...").'</p>
                   <button type="button"><a href="'.$rota.'" download style="color:white;"><i class="fa fa-download"></i></a></button>  
                   <button type="button" temporario class="apagarArquivo2"><i class="fa fa-times"></i></button>                
                   </li>  ';
      }
  
  
    }
  }
  
  }//lendoAnexos 

  
public function lendoAnexosprevenda($anexos){
  //echo '<script>alert("aqui");</script>';
  if($anexos != ''){
   $anexos = json_decode($anexos, true);
   
    foreach($anexos as $key=> $value){
      $rota = BASE_URL.$value;
      //echo '<script>alert("aqui");</script>';
      if(substr($value, -3) == 'png' || substr($value, -3) == 'jpg' || substr($value, -4) == 'jpeg'){
        if(substr($value, -3) == 'png'){
        $rotadownload = substr($value, -3).'.pdf';
        }
        if(substr($value, -3) == 'jpg'){
          $rotadownload = substr($value, -3).'.pdf';
        }        
        if(substr($value, -4) == 'jpeg'){
          $rotadownload = substr($value, -3).'.pdf';
        }        
     

        echo ' <li>
                   <div class="img_resp">
                   <img src="'.$rota.'" width="50%" >
                   </div>
                    <p>'.mb_strimwidth($value, 0, 30, "...").'</p>                  
                   <button type="button">
                   <a href="'.$rota.'" download style="color:white;"><i class="fa fa-download"></i></a></button>  
                   <button type="button" temporario class="apagarArquivo2"><i class="fa fa-times"></i></button>              
                   </li>'; 
       }
   
   
       if(substr($value, -3) == 'pdf'){
         echo '<li>
               <div class="img_icon"><i class="fa fa-file-pdf-o"></i></div>
               <p>'.mb_strimwidth($value, 0, 30, "...").'</p>
                <button type="button"><a href="'.$rota.'" download style="color:white;"><i class="fa fa-download"></i></a></button> 
                <button type="button" temporario class="apagarArquivo2"><i class="fa fa-times"></i></button>           
         </li>';
       }
   
       if(substr($value, -3) == 'doc' || substr($value, -4) == 'docx'){
         echo '<li>
                    <div class="img_icon"><i class="fa fa-file-word-o"></i></div>   
                     <p>'.mb_strimwidth($value, 0, 30, "...").'</p>                
                    <button type="button"><a href="'.$rota.'" download style="color:white;"><i class="fa fa-download"></i></a></button> 
                    <button type="button" temporario class="apagarArquivo2"><i class="fa fa-times"></i></button>                
                    </li>';
       }
   
       if(substr($value, -3) == 'xls' || substr($value, -4) == 'xlsx'){
         echo '<li>
                    <div class="img_icon"><i class="fa fa-file-excel-o"></i></div>
                     <p>'.mb_strimwidth($value, 0, 30, "...").'</p>
                    <button type="button"><a href="'.$rota.'" download style="color:white;"><i class="fa fa-download"></i></a></button>  
                    <button type="button" temporario class="apagarArquivo2"><i class="fa fa-times"></i></button>                
                    </li>  ';
       }
  
  
    }
  }
  
  }//lendoAnexos 

}