<?php
use Core\Controller;
use Models\Users;
use Models\Permissao;
use Models\Orm;
use Models\Produtor;
use Models\Recibos;
use Models\Extrato;

class ProdutorController extends Controller {

 private $user;
  private $arr;
  private $permissao;

    public function __construct() {              
        $this->user = new Users();
        $this->permissao = new Permissao(); 

        if($this->user->isLogged() == false){                  
         header("Location: ".BASE_URL."login");        
         exit;         
        }

       $usuario = $this->user->getId();       
       $permissoes = $this->permissao->getPermissoes();
       $modulo_boleto = $this->permissao->getPermissoesBoleto();
       
        $this->arr = array(
         'user'=>$this->user,
         'menuActive'=>'home',
         'permissao'=>$permissoes,
         'modulo_boleto'=>$modulo_boleto
        );           
}

public function index() {   
$this->arr['list_js'] = array(
'plugins/sweetalert2',
'system'
);  

$produtor = new Orm('produtor');

if(isset($_GET['nome']) && !empty($_GET['nome'])){
$nome = addslashes($_GET['nome']);
$this->arr['lista'] = $produtor->select('*')->search(['nome', $nome])->get();
}else{
$this->arr['lista']     = $produtor->select('*')->where(['status','A'])->paginate('20')->get();
foreach($this->arr['lista'] as $key=>$item){
$this->arr['lista'][$key]->superior = (new Orm('produtor'))->select(['nome'])->where(['id_produtor', $item->superior])->first()->get()->nome ?? '';
}
$this->arr['paginacao'] = $produtor->render("produtor");
}

$this->arr['msg']       = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('produtor/listar', $this->arr);
}//function index 



public function lancamentos($produtor){
$this->arr['list_js'] = array(
'plugins/sweetalert2',
'system'
);  
$lancamentos = [];

$this->arr['lista'] = (new Orm('lanc_hist_comissoes'))->select('*')
->wherecustom("produtor_id = '$produtor' AND recibo IN('N','E') AND status_pago = 'N' AND valor != '0'")->get();

foreach($this->arr['lista'] as $key=>$value){

if(!is_null($value->id_lancamento)){ 

$info = (new Orm('lancamento_historico'))->select('*')
->wherecustom("id_historico = '$value->id_lancamento'")
->first()->get();

$this->arr['lista'][$key]->id_historico = $info->id_historico ?? '';
$this->arr['lista'][$key]->id_contrato = $info->id_contrato ?? '';
$this->arr['lista'][$key]->convenio_id = $info->convenio_id ?? '';
$this->arr['lista'][$key]->num_proposta = $info->num_proposta ?? '';
$this->arr['lista'][$key]->num_parcela = $info->num_parcela ?? '';
$this->arr['lista'][$key]->valor_parcela = $info->valor_parcela ?? '';
$this->arr['lista'][$key]->valor_baixa = $info->valor_baixa ?? '';
$this->arr['lista'][$key]->data_baixa = $info->data_baixa ?? '';
$this->arr['lista'][$key]->data_pagamento = $info->data_pagamento ?? '';
$this->arr['lista'][$key]->id_usuario = $info->id_usuario ?? '';
$this->arr['lista'][$key]->status_baixa = $info->status_baixa ?? '';


if($info->status_baixa != 'Cancelado'){
array_push($lancamentos, $this->arr['lista'][$key]);
}else{
//aqui a baixa foi cancelada
array_push($lancamentos, $this->arr['lista'][$key]);

}//se status diferente de cancelado

}else{
  array_push($lancamentos, $this->arr['lista'][$key]);
}
}


foreach($lancamentos as $key=>$item){
$p = new Produtor();
$lancamentos[$key] = $p->montaLista($item);
}

$this->arr['lista'] = $lancamentos;


$this->arr['nome_produtor'] = (new Orm('produtor'))->select(['nome'])->where(['id_produtor', $produtor])->first()->get();
$this->arr['id_produtor'] = $produtor;
$this->arr['msg']       = $this->flashMessage($_SESSION['msg'] ?? null);

$this->loadTemplate('produtor/lancamentos', $this->arr);
}//lancamentos


public function inativos() {   
$this->arr['list_js'] = array(
'plugins/sweetalert2',
'system'
);  

$produtor = new Orm('produtor');
$this->arr['lista']     = $produtor->select('*')->where(['status','I'])->paginate('10')->get();
$this->arr['paginacao'] = $produtor->render("produtor");
$this->arr['msg']       = $this->flashMessage($_SESSION['msg'] ?? null);


//$this->debug($this->arr['lista']);

foreach($this->arr['lista'] as $key=>$item){
$sup = (new Orm('produtor'))->select(['nome'])->where(['superior', $item->superior])->first()->get();
$this->arr['lista'][$key]->superior = 'teste';
}

// if(isset($_GET['nome']) && !empty($_GET['nome'])){
// $nome = addslashes($_GET['nome']);
// $this->arr['lista'] = $filial->select('*')->search(['nome', $nome])->get();
// }



$this->loadTemplate('produtor/inativos', $this->arr);
}//function index




public function getSaldo($produtor){
$credito = 0;
$despesa = 0;
$extorno = 0;
$total = 0;


$lancamentos = [];

$sql = (new Orm('lanc_hist_comissoes'))->select('*')
->wherecustom("produtor_id = {$produtor} AND recibo IN('N', 'E') AND status_pago = 'N'")->get();

foreach($sql as $key=>$item){

if(!is_null($item->id_lancamento)){ 
$lanc = (new Orm('lanc_hist_comissoes'))->select('*')
 ->wherecustom("id_historico_comissao = {$item->id_lancamento}")
 ->first()->get();

array_push($lancamentos, $sql[$key]);
}

// if(!empty($lanc) && $lanc->status_baixa != 'Cancelado'){
//  $sql[$key]->id_historico   = $lanc->id_historico ?? '';
//  $sql[$key]->id_contrato    = $lanc->id_contrato ?? '';
//  $sql[$key]->convenio_id    = $lanc->convenio_id ?? '';
//  $sql[$key]->num_proposta   = $lanc->num_proposta ?? '';
//  $sql[$key]->valor_contrato = $lanc->valor_contrato ?? '';
//  $sql[$key]->num_parcela    = $lanc->num_parcela ?? '';
//  $sql[$key]->valor_parcela  = $lanc->valor_parcela ?? '';
//  $sql[$key]->valor_baixa    = $lanc->valor_baixa ?? '';
//  $sql[$key]->data_baixa     = $lanc->data_baixa ?? '';
//  $sql[$key]->data_pagamento = $lanc->data_pagamento ?? '';
//  $sql[$key]->id_usuario     = $lanc->id_usuario ?? '';
//  $sql[$key]->status_baixa   = $lanc->status_baixa ?? '';

//  array_push($lancamentos, $sql[$key]);
// }
// }else{
//  array_push($lancamentos, $sql[$key]);
// }
}

if(!empty($lancamentos)){
foreach($lancamentos as $item){

switch($item->tipo){
case 'L':
case 'LM':
case 'LA':
case 'ED':
$credito += $item->valor;
break;

case 'D':
case 'DM':
case 'A':
case 'T':
case 'EC':
$despesa += $item->valor;
break;

// case 'ED':
// $extorno += $item->valor;
// break;

// case 'EC':
// $extorno -= $item->valor;

}//switch

}//foreach


$total = $credito - $despesa;

// if($extorno != 0){  
//   if($total == 0){
//    $total = $extorno;
//   }else{
//    $total = (float) $total - (float) $extorno;
//   }
// }

echo "R$ ".number_format($total,2,',','.');
}else{
echo "R$ ".number_format($total,2,',','.');
}
}//getSaldo


public function add(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'functions_js',
'plugins/sweetalert2',
'system',
'select_estado',
'consulta_cep'
);

$this->arr['grupos'] = (new Orm('grupoprodutor'))->select('*')->order(['grupo asc'])->get();
$this->arr['produtores'] = (new Orm('produtor'))->select('*')->order(['nome asc'])->get();
$this->arr['filiais'] = (new Orm('filiais'))->select('*')
->join(['cidade'])->on(['filiais.municipio','=','cidade.nome_cidade'])
->get();
$this->arr['bancos'] = (new Orm('bancos'))->select('*')->get();
$this->arr['estados'] = (new Orm('estado'))->select('*')->get();
$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);


$this->loadTemplate('produtor/adicionar', $this->arr);
}//add


public function edit($id){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'plugins/sweetalert2',
'system',
'select_estado',
'consulta_cep'
);

$this->arr['id_produtor'] = $id;
$this->arr['grupos'] = (new Orm('grupoprodutor'))->select('*')->get();
$this->arr['estados'] = (new Orm('estado'))->select('*')->get();
$this->arr['cidades'] = (new Orm('cidade'))->select('*')->get();
$this->arr['info'] = (new Orm('produtor'))->select('*')->where(['id_produtor', $id])
->first()->get();
$this->arr['info']->filiais = (new Orm('produtor_filiais'))->select('*')->where(['produtor_id', $id])->get();

$this->arr['produtores'] = (new Orm('produtor'))->select('*')->get();
$this->arr['bancos'] = (new Orm('bancos'))->select('*')->get();

// Pegando o estado e as cidades para editar
$estado = (new Orm('estado'))->select('*')->where(['uf_estado', $this->arr['info']->uf])->first()->get();


if(!empty($estado)){
$this->arr['cidades'] = (new Orm('cidade'))->select('*')->where(['id_estado',$estado->id_estado])->get();
}

$this->arr['filiais'] = (new Orm('filiais'))->select('*')
->join(['cidade'])->on(['filiais.municipio','=','cidade.nome_cidade'])
->get();

$this->arr['msg']       = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('produtor/editar', $this->arr);
}//edit

public function searcharray($value, $key, $array) {
   foreach ($array as $k => $val) {
       if ($val->$key == $value) {
           return $k;
       }
   }
   return null;
}

public function save(){

if(isset($_POST['nome']) && !empty($_POST['cnpj'])){


 $id_produtor      = (isset($_POST['id_produtor'])) ? $this->limpaCampo($_POST['id_produtor']) : NULL; 
 $nome             = $this->limpaCampo($_POST['nome']);
 $cnpj             = $this->limpaCampo($_POST['cnpj']);
 $grupo_produtor   = $this->limpaCampo($_POST['grupo_produtor']);
 $superior         = $this->limpaCampo($_POST['superior']);
 $email            = $this->limpaCampo($_POST['email']);
 $corretor                = isset($_POST['corretor']) ? 'S':'N'; 
 $possui_dados_bancarios  = isset($_POST['dadosBancarios']) ? 'S':'N';
 $acesso_canal_produtor   = isset($_POST['canal']) ? 'S':'N';

 $telefone        = $this->limpaCampo($_POST['telefone']);
 $celular         = $this->limpaCampo($_POST['celular']);
 $senha           = $this->limpaCampo($_POST['senha']);

 $filiais         = isset($_POST['filial']) ? $_POST['filial'] : NULL;
 $banco           = $this->limpaCampo($_POST['banco']);
 $chave_pix       = $this->limpaCampo($_POST['chave_pix']);
 $agencia         = $this->limpaCampo($_POST['agencia']);
 $agenciaDv       = $this->limpaCampo($_POST['agenciaDv']);
 $conta           = $this->limpaCampo($_POST['conta']);
 $contaDv         = $this->limpaCampo($_POST['contaDv']); 
 $cep             = $this->limpaCampo($_POST['cep']);
 $endereco        = $this->limpaCampo($_POST['endereco']);
 $numero          = $this->limpaCampo($_POST['numero']);
 $complemento     = $this->limpaCampo($_POST['complemento']);
 $bairro          = $this->limpaCampo($_POST['bairro']); 
 $uf              = $this->limpaCampo($_POST['uf']);
 $municipio       = $this->limpaCampo($_POST['municipio']); 
 $observacoes     = $this->limpaCampo($_POST['observacoes']);
 $data            = date('Y-m-d H:i:s');
 
if($acesso_canal_produtor == "S" && $senha == NULL && $id_produtor  == NULL){
$_SESSION['msg'] = array('type'=>'error', 'msg'=>'Ooppss, digite a senha de acesso!!!');
$url = ($id_produtor !== NULL) ? "produtor/edit/{$id_produtor}" : 'produtor/add';
  header("Location:".BASE_URL.$url);
  exit;  
}

if($id_produtor == null){
 $consulta = (new Orm('produtor'))->select('*')->where(['cnpj', $cnpj])->first()->get();
}else{
$consulta = (new Orm('produtor'))->select('*')
->wherecustom("cnpj = '$cnpj' AND id_produtor != $id_produtor" )->first()->get();
}

if(!empty($consulta)){
  $_SESSION['msg'] = array('type'=>'error', 'msg'=>'Ooppss, ja existe cadastro com esse CPF/CNPJ no sistema, por favor tente novamente!!!');
  header("Location:".BASE_URL."produtor");
  exit;  
}

$dados_form = [
'nome'=>$nome,
'cnpj'=>$cnpj,
'grupo_produtor'=>$grupo_produtor,
'superior'=>$superior,
'email'=>$email,
'corretor'=>$corretor,
'possui_dados_bancarios'=>$possui_dados_bancarios,
'acesso_canal_produtor'=>$acesso_canal_produtor,
'telefone'=>$telefone,
'celular'=>$celular,
'senha'=>$senha,
'banco'=>$banco,
'agencia'=>$agencia,
'agenciaDv'=>$agenciaDv,
'conta'=>$conta,
'contaDv'=>$contaDv,
'chave_pix'=>$chave_pix,
'cep'=>$cep,
'endereco'=>$endereco,
'numero'=>$numero,
'complemento'=>$complemento,
'bairro'=>$bairro,
'uf'=>$uf,
'municipio'=>$municipio,
'observacoes'=>$observacoes,
'data_cad'=>$data
];

if($id_produtor == null){
 $grava_produtor = (new Orm('produtor'))->set($dados_form)->save();

//se o produtor vai ter login no sistema
if($acesso_canal_produtor == 'S'){
$senha = password_hash($senha, PASSWORD_DEFAULT); 

$dados_produtor = [
'nome'=>$nome,
'slug'=>$this->Slug($nome),
'email'=>$email,
'email_crypt'=>md5($email),
'contato'=>$celular,
'imagem'=>NULL,
'senha'=>$senha,
'metodo_entrada'=>'site',
'tipo'=>'Produtor',
'data_cad'=>date('Y-m-d H:i:s'),
'lastactivity'=>date('Y-m-d H:i:s'),
'verificacao_usuario'=>1,
'status'=>'A',
'observacao'=>NULL,
'produtor_id'=>$grv
];

$cad_usuario = (new Orm('usuarios'))->set($dados_produtor)->save();
$this->gravaPermissoesDefault($cad_usuario);

}//se canal do produtor = S

 foreach($filiais as $filial){
  $form_filiais = [
   'filial_id'=>$filial,
   'produtor_id'=>$grava_produtor
  ];
  $cad = (new Orm('produtor_filiais'))->set($form_filiais)->save();
 }

 $_SESSION['msg'] = array('type'=>'success', 'msg'=>'Produtor Cadastrado com sucesso!');
 $this->redirect(BASE_URL."produtor");

}//se produtor é  null


//se caso estamos editando o cadastro
if($id_produtor !== NULL){
//atualiza a tabela de produtor    
$up_produtor = (new Orm('produtor'))->set($dados_form)->where(['id_produtor', $id_produtor])->update();

$tem = (new Orm('usuarios'))->select('*')->where(['produtor_id', $id_produtor])->first()->get();

if($tem){

//verifico se teve post da senha ou nao
if($_POST['senha'] != ''){
   $senha = password_hash($senha, PASSWORD_DEFAULT);
}else{
   $senha = $tem->senha;
}

$dados_produtor = [
'nome'=>$nome,
'slug'=>$this->Slug($nome),
'email'=>$email,
'email_crypt'=>md5($email),
'contato'=>$celular,
'imagem'=>NULL,
'senha'=>$senha,
'lastactivity'=>date('Y-m-d H:i:s'),
'verificacao_usuario'=>1,
'status'=>'A',
'observacao'=>$observacoes
];
  
$up_produtor = (new Orm('usuarios'))->set($dados_produtor)
->where(['produtor_id', $id_produtor])->update();

//atualizando as filiais
foreach($filiais as $key=>$filial){
  $tem = (new Orm('produtor_filiais'))->select('*')
  ->where(['id_produtor_filiais', $_POST['produtor_filial'][$key]])
  ->first()->get();

  if(empty($tem)){
  $form_filiais = [
   'filial_id'=>$filial,
   'produtor_id'=>$id_produtor
  ];
  $cad = (new Orm('produtor_filiais'))->set($form_filiais)->save();
  }
 }

 $_SESSION['msg'] = array('type'=>'success', 'msg'=>'Produtor atualizado com sucesso!');
 $this->redirect(BASE_URL."produtor");

}else{
$senha = password_hash($senha, PASSWORD_DEFAULT); 
$dados_produtor = [
'nome'=>$nome,
'slug'=>$this->Slug($nome),
'email'=>$email,
'email_crypt'=>md5($email),
'contato'=>$celular,
'imagem'=>NULL,
'senha'=>$senha,
'metodo_entrada'=>'site',
'tipo'=>'Produtor',
'data_cad'=>date('Y-m-d H:i:s'),
'lastactivity'=>date('Y-m-d H:i:s'),
'verificacao_usuario'=>1,
'status'=>'A',
'observacao'=>NULL,
'produtor_id'=>$id_produtor
];

$grava_produtor = (new Orm('usuarios'))->set($dados_produtor)->save();

foreach($filiais as $filial){
  $form_filiais = [
   'filial_id'=>$filial,
   'produtor_id'=>$grava_produtor
  ];
  $cad = (new Orm('produtor_filiais'))->set($form_filiais)->save();
 }
if($grava_produtor){
   $this->gravaPermissoesDefault($grava_produtor);
}


$_SESSION['msg'] = array('type'=>'success', 'msg'=>'Produtor Cadastrado com sucesso!');
 $this->redirect(BASE_URL."produtor"); 
}//se tem

}




}//se existe post nome cnpj

}//save


public function gravaPermissoesDefault($usuario){
$tab = new Orm('usuario_tabela_acao_cliente');
//tabela contratos
$cad = $tab->set(['id_tabela'=>1,'id_acao'=>5,'id_usuario'=>$usuario])->save();
$cad = $tab->set(['id_tabela'=>1,'id_acao'=>1,'id_usuario'=>$usuario])->save();
$cad = $tab->set(['id_tabela'=>1,'id_acao'=>6,'id_usuario'=>$usuario])->save();
$cad = $tab->set(['id_tabela'=>1,'id_acao'=>8,'id_usuario'=>$usuario])->save();
$cad = $tab->set(['id_tabela'=>1,'id_acao'=>9,'id_usuario'=>$usuario])->save(); //Tabela atendimentos
$cad = $tab->set(['id_tabela'=>2,'id_acao'=>5,'id_usuario'=>$usuario])->save();
//Tabela relatorios financeiro
$cad = $tab->set(['id_tabela'=>6,'id_acao'=>5,'id_usuario'=>$usuario])->save();
$cad = $tab->set(['id_tabela'=>6,'id_acao'=>13,'id_usuario'=>$usuario])->save();
//Tabela relatoriso comerciais
$cad = $tab->set(['id_tabela'=>7,'id_acao'=>5,'id_usuario'=>$usuario])->save();
$cad = $tab->set(['id_tabela'=>7,'id_acao'=>16,'id_usuario'=>$usuario])->save();
//Tabela Recibos
$cad = $tab->set(['id_tabela'=>8,'id_acao'=>5,'id_usuario'=>$usuario])->save();
$cad = $tab->set(['id_tabela'=>8,'id_acao'=>21,'id_usuario'=>$usuario])->save();
$cad = $tab->set(['id_tabela'=>8,'id_acao'=>23,'id_usuario'=>$usuario])->save();
//Tabela CRM
$cad = $tab->set(['id_tabela'=>10,'id_acao'=>5,'id_usuario'=>$usuario])->save();
$cad = $tab->set(['id_tabela'=>10,'id_acao'=>26,'id_usuario'=>$usuario])->save();
$cad = $tab->set(['id_tabela'=>10,'id_acao'=>28,'id_usuario'=>$usuario])->save();
$cad = $tab->set(['id_tabela'=>10,'id_acao'=>31,'id_usuario'=>$usuario])->save();

}//gravaPermissoesDefault


public function incluir($id){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'system',
'flatpickr/flatpickr',
'flatpickr/pt',
'flatpickr/flatpickr_init'
);

$this->arr['contratos'] = (new Orm('contratos'))->select('*')->get();
$this->arr['id_lancamento'] = $id;


$this->loadTemplate("produtor/incluir", $this->arr);
}//incluir


public function incluirlancamento(){
if(isset($_POST['parcela']) && !empty($_POST['valor'])){

$tipo = $this->limpaCampo($_POST['tipo']);
$id_lancamento = $this->limpaCampo($_POST['id_lancamento']);
$produtor_id = $this->limpaCampo($_POST['produtor_id']);
$data_recibo = $this->converterData($_POST['data_vencimento'],'/');
$parcela = $this->limpaCampo($_POST['parcela']);
$valor = $this->limpaCampo($_POST['valor']);
$descricao = $this->limpaCampo($_POST['descricao']);

$dados = [
'id_lancamento'=>null, 
'tipo'=>$tipo,
'produtor_id'=>$produtor_id,
'data_recibo'=>$data_recibo,
'porc'=>0,
'valor'=>$this->valor($valor),
'descricao'=>$descricao
];

$cad = (new Orm('lanc_hist_comissoes'))->set($dados)->save();

$_SESSION['msg'] = ['type'=>'success','msg'=>'Lançamento realizado com sucesso!'];
$this->redirect(BASE_URL."produtor/lancamentos/".$id_lancamento);
}

}//incluirlancamento



public function extrato($produtor){
$r = new Extrato(); 

if($produtor == ''){
$_SESSION['msg'] = ['type'=>'error','msg'=>'Produtor não informado!'];
header("Location:".BASE_URL."produtor/");
exit;
}

$dados = (new Orm('produtor'))->select('*')->where(['id_produtor', $produtor])->first()->get();

$lancs = (new Orm('lanc_hist_comissoes'))->select('*')
->where(['produtor_id', $produtor])->get();

foreach($lancs as $key=>$value){
$info = (new Orm('lancamento_historico'))
->select([
'lancamento_historico.id_contrato, lancamento_historico.convenio_id, lancamento_historico.num_proposta,
  contratos.nome_cliente,
  contratos.produtor as produtor_contrato,
  convenios.nome_convenio'
])
->join(['contratos'],['convenios'])
->on(['lancamento_historico.id_contrato','=','contratos.id_contrato'],['lancamento_historico.convenio_id','=','convenios.id_convenio'])
->where(['id_historico',$value->id_lancamento])
->first()->get(); 

$vendedor = (new Orm('produtor'))->select('*')->where(['id_produtor', $info->produtor_contrato])->first()->get();

$lancs[$key]->convenio = $info->nome_convenio ?? '';
$lancs[$key]->proposta = $info->num_proposta ?? '';
$lancs[$key]->cliente  = $info->nome_cliente ?? '';
$lancs[$key]->vendedor = $vendedor->nome ?? '';
}

$dados->lancs = $lancs;

$r->gerar($dados);
}//extrato




public function remover($id){

$up = (new Orm('produtor'))->set(['status'=>'I'])
->where(['id_produtor', $id])->update();

//$del = (new Orm('produtor'))->del(['id_produtor', $id]);
$_SESSION['msg'] = array('type'=>'success', 'msg'=>'Produtor inativado com sucesso!');
$this->redirect(BASE_URL."produtor");
}//remover

}