<?php
use Core\Controller;
use Models\Users;
use Models\Permissao;
use Models\Orm;

class ProdutosController extends Controller {

  private $user;
  private $arr;
  private $permissao;

    public function __construct() {              
        $this->user = new Users();
        $this->permissao = new Permissao(); 

        if($this->user->isLogged() == false){                  
         header("Location: ".BASE_URL."login");        
         exit;         
        }

       $usuario = $this->user->getId();       
       $permissoes = $this->permissao->getPermissoes();
       $modulo_boleto = $this->permissao->getPermissoesBoleto();
       
        $this->arr = array(
         'user'=>$this->user,
         'menuActive'=>'home',
         'permissao'=>$permissoes,
         'modulo_boleto'=>$modulo_boleto
        );          
}

public function index() {   
$this->arr['list_js'] = array(
'plugins/sweetalert2',
'system'
);  

$tab = new Orm('produtos');

$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);

if(isset($_GET['nome']) && !empty($_GET['nome'])){
$nome = addslashes($_GET['nome']);
$this->arr['lista'] = $tab->select('*')->search(['nome_produto', $nome])->get();
}else{
$this->arr['lista'] = $tab->select('*')->paginate('10')->get();
$this->arr['paginacao'] = $tab->render("produtos");
}


$this->loadTemplate('produtos/listar', $this->arr);
}//function index 


public function listarplano($id_produto){
$this->arr['list_js'] = array(
'plugins/sweetalert2',
'system'
);

$plano = new Orm('planos');
$this->arr['lista'] = $plano->select('*')
->join(['regiao'])->on(['planos.regiao','=','regiao.id_regiao'])
->paginate('10')->get();
$this->arr['paginacao'] = $plano->render("produtos/listarplano/".$id_produto);
$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->arr['id_produto'] = $id_produto;

if(isset($_GET['nome']) && !empty($_GET['nome'])){
$nome = addslashes($_GET['nome']);
$this->arr['lista'] = $plano->select('*')->search(['nome', $nome])->get();
}


$this->loadTemplate('produtos/listarplano', $this->arr);
}//listarPlano

public function plano($id_produto){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'functions_js',
'plugins/sweetalert2',
'system',
'multiuploads',
'helpers'
);

$this->arr['regioes'] = (new Orm('regiao'))->select('*')->get();
$this->arr['id_produto'] = $id_produto;

$this->loadTemplate('produtos/planos', $this->arr);
} 


public function add(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'functions_js',
'plugins/sweetalert2',
'system',
'multiuploads',
'helpers'
);

$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('produtos/adicionar', $this->arr);
}//add


public function edit($id){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'multiuploads',
'helpers'
);

$this->arr['id_produto'] = $id;
$this->arr['info'] = (new Orm('produtos'))->select('*')->where(['id_produto', $id])->first()->get();
$this->loadTemplate('produtos/editar', $this->arr);
}//edit




public function save(){

if(isset($_POST['nome']) && !empty($_POST['nome'])){
 $id_produto       = (isset($_POST['id_produto'])) ? $this->limpaCampo($_POST['id_produto']) : NULL; 
 $nome           = $this->limpaCampo($_POST['nome']);
 


if($id_produto == NULL){
$consulta = (new Orm('produtos'))->select('*')->where(['nome_produto', $nome])->first()->get();

if(!empty($consulta)){
  $_SESSION['msg'] = array('type'=>'error', 'msg'=>'Ooppss, ja existe cadastro com esse número ou nome no sistema, por favor tente novamente!!!');
  header("Location:".BASE_URL."produtos");
  exit;  
}
}// se é cadastro novo verificar se ja existe


$dados_form = [
'nome_produto'=>$nome
];


if($id_produto == null){
 $grv = (new Orm('produtos'))->set($dados_form)->save();
 $_SESSION['msg'] = array('type'=>'success', 'msg'=>'Produto cadastrado com sucesso!');
 $this->redirect(BASE_URL."produtos"); 
}else{
 $grv = (new Orm('produtos'))->set($dados_form)->where(['id_produto', $id_produto])->update();
 $_SESSION['msg'] = array('type'=>'success', 'msg'=>'Produto Editado com sucesso!');
 header("Location:".BASE_URL."produtos");
 exit;
}

}

}//save




public function remover($id){
$del = (new Orm('produtos'))->del(['id_produto', $id]);
$_SESSION['msg'] = array('type'=>'success', 'msg'=>'Produto removido com sucesso!');
$this->redirect(BASE_URL."produtos");
}//remover




}