<?php
use Core\Controller;
use Models\Users;
use Models\Permissao;
use Models\Orm;
use Models\Search;
use Models\Atendimento;
use Models\Report;
use Models\ReportLancamentos;
use Models\ReportLancamento;
use Models\ReportLancamentoRecibo;

use Models\ReportBaixa;
use Models\ReportProdutor;
use Models\ReportFilial;
use Models\ReportGrupo;
use Models\ReportFinanceiro;
use Models\ReportProdutores;
use Models\ReportProdutoresGrupo;

use Models\ReportProducao;
use Models\ReportProducao2;
use Models\ReportProducao3;
use Models\ReportProducao4;
use Models\ReportProducao5;
use Models\ReportProducao6;
use Models\ReportProducao7;

use Models\ReportRanking;
use Models\ReportRankingSuperior;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\IOFactory;

class RelatoriosController extends Controller {

  private $user;
  private $arr;
  private $permissao;

    public function __construct() {              
        $this->user = new Users();
        $this->permissao = new Permissao(); 

        if($this->user->isLogged() == false){                  
         header("Location: ".BASE_URL."login");        
         exit;         
        }

       $permissoes = $this->permissao->getPermissoes();
       $this->permissao->temPermissao('relatorios-financeiros', 'acesso');
       //$permissoes = $this->permissao->getPermissoes();
       $modulo_boleto = $this->permissao->getPermissoesBoleto();
       
        $this->arr = array(
         'user'=>$this->user,
         'menuActive'=>'home',
         'permissao'=>$permissoes,
         'modulo_boleto'=>$modulo_boleto
        );         
}


public function index(){
$this->arr['list_js'] = array(
'sweetalert2.all.min',
'parsley/parsley.min',
'parsley/pt-br',
'jquery.mask.min',
'mask_init',
'confirm_atendimento',
'manager_atendimento'
);

$this->arr['grupos'] = (new Orm('grupos'))->select('*')->get();
$this->arr['empresas'] = (new Orm('unidade'))->select('*')->get();
$this->arr['motoristas'] = (new Orm('veiculos'))->select('*')->get();

$s = new Search();

$filter = array('voucher'=>'','grupo'=>'','empresa'=>'','motorista'=>'','data_ini'=>'', 'data_fim'=>'');

if(isset($_POST['empresa']) || isset($_POST['num_voucher']) || isset($_POST['grupo']) || isset($_POST['motorista'])){

$num_voucher = $this->limpaCampo($_POST['num_voucher']);
$grupo = $this->limpaCampo($_POST['grupo']);
$empresa = $this->limpaCampo($_POST['empresa']);
$motorista = $this->limpaCampo($_POST['motorista']);
$data_ini = $this->limpaCampo($_POST['data_ini']);
$data_fim = $this->limpaCampo($_POST['data_fim']);

if($num_voucher != null){  $filter['voucher'] = $num_voucher;}
if($grupo != null){  $filter['grupo'] = $grupo;}
if($empresa != null){  $filter['empresa'] = $empresa;}
if($motorista != null){  $filter['motorista'] = $motorista;}
if($data_ini != null){  $filter['data_ini'] = $this->converterData($data_ini,'/');}
if($data_fim != null){  $filter['data_fim'] = $this->converterData($data_fim,'/');}

$this->arr['dados'] = $s->getAllSearch('atendimentos', $filter, null);
$a = new Atendimento();
$this->arr['list'] = $a->atendimentos($this->arr['dados']);


echo $this->debug($this->arr['list']);
}

$this->loadTemplate('relatorios/atendimentos', $this->arr);
}//index


public function baixas(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'plugins/sweetalert2',
'system',
'flatpickr/flatpickr',
'flatpickr/pt',
'flatpickr/flatpickr_init'
);

$this->arr['tipo'] = $this->user->getTipo();
$this->arr['id_usuario'] = $this->user->getIdProdutor();


$this->arr['convenios'] = (new Orm('convenios'))->select('*')->get();
$this->arr['filiais'] = (new Orm('filiais'))->select('*')->get();
$this->arr['produtores'] = (new Orm('produtor'))->select('*')->get();
$this->arr['grupos'] = (new Orm('grupoprodutor'))->select('*')->get();
$this->arr['origens'] = (new Orm('origem_venda'))->select('*')->get();

$this->loadTemplate('relatorios/baixas', $this->arr);
}//producao


public function producao(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'plugins/sweetalert2',
'system',
'flatpickr/flatpickr',
'flatpickr/pt',
'flatpickr/flatpickr_init'
);

$this->permissao->temPermissao('relatorios-comerciais', 'relatorios-comerciais-producao');

$this->arr['tipo'] = $this->user->getTipo();
$this->arr['id_usuario'] = $this->user->getIdProdutor();

$this->arr['convenios'] = (new Orm('convenios'))->select('*')->get();
$this->arr['filiais'] = (new Orm('filiais'))->select('*')->get();
$this->arr['produtores'] = (new Orm('produtor'))->select('*')->get();
$this->arr['grupos'] = (new Orm('grupoprodutor'))->select('*')->get();
$this->arr['origens'] = (new Orm('origem_venda'))->select('*')->get();

$this->loadTemplate('relatorios/producao', $this->arr);
}//producao

public function ranking(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'plugins/sweetalert2',
'system',
'flatpickr/flatpickr',
'flatpickr/pt',
'flatpickr/flatpickr_init'
);

$this->arr['convenios'] = (new Orm('convenios'))->select('*')->get();
$this->arr['filiais'] = (new Orm('filiais'))->select('*')->get();
$this->arr['produtores'] = (new Orm('produtor'))->select('*')->get();
$this->arr['grupos'] = (new Orm('grupoprodutor'))->select('*')->get();
$this->arr['origens'] = (new Orm('origem_venda'))->select('*')->get();

$this->loadTemplate('relatorios/ranking', $this->arr);
}//ranking

public function tv(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'plugins/sweetalert2',
'system',
'flatpickr/flatpickr',
'flatpickr/pt',
'flatpickr/flatpickr_init'
);

$this->arr['convenios'] = (new Orm('convenios'))->select('*')->get();
$this->arr['filiais'] = (new Orm('filiais'))->select('*')->get();
$this->arr['produtores'] = (new Orm('produtor'))->select('*')->get();
$this->arr['grupos'] = (new Orm('grupoprodutor'))->select('*')->get();
$this->arr['origens'] = (new Orm('origem_venda'))->select('*')->get();

$this->loadTemplate('relatorios/tv', $this->arr);
}//ranking

public function produtores(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'plugins/sweetalert2',
'system',
'flatpickr/flatpickr',
'flatpickr/pt',
'flatpickr/flatpickr_init'
);

$this->arr['convenios'] = (new Orm('convenios'))->select('*')->get();
$this->arr['filiais'] = (new Orm('filiais'))->select('*')->get();
$this->arr['produtores'] = (new Orm('produtor'))->select('*')->get();
$this->arr['grupos'] = (new Orm('grupoprodutor'))->select('*')->get();
$this->arr['superiores'] = (new Orm('produtor'))->select(['id_produtor, nome, superior'])
->wherecustom("superior >=1 GROUP BY superior")->get();

foreach($this->arr['superiores'] as $key=>$superior){
$superior = (new Orm('produtor'))->select(['nome'])->where(['id_produtor', $superior->superior])->first()->get();  
$this->arr['superiores'][$key]->nome_superior = $superior->nome ?? '';
}


$this->loadTemplate('relatorios/produtores', $this->arr);
}//produtores


public function financeiro(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'plugins/sweetalert2',
'system',
'flatpickr/flatpickr',
'flatpickr/pt',
'flatpickr/flatpickr_init'
);

$this->arr['tipo'] = $this->user->getTipo();
$this->arr['id_usuario'] = $this->user->getIdProdutor();

$this->arr['convenios'] = (new Orm('convenios'))->select('*')->get();
$this->arr['filiais'] = (new Orm('filiais'))->select('*')->get();
$this->arr['produtores'] = (new Orm('produtor'))->select('*')->get();
$this->arr['grupos'] = (new Orm('grupoprodutor'))->select('*')->get();
$this->arr['origens'] = (new Orm('origem_venda'))->select('*')->get();

$this->loadTemplate('relatorios/financeiro', $this->arr);
}//producao



public function lancamentos(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'plugins/sweetalert2',
'system',
'flatpickr/flatpickr',
'flatpickr/pt',
'flatpickr/flatpickr_init'
);

$this->permissao->temPermissao('relatorios-financeiros', 'relatorios-financeiros-lancamentos');

$this->arr['tipo'] = $this->user->getTipo();
$this->arr['id_usuario'] = $this->user->getIdProdutor();

$this->arr['convenios'] = (new Orm('convenios'))->select('*')->get();
$this->arr['filiais'] = (new Orm('filiais'))->select('*')->get();
$this->arr['produtores'] = (new Orm('produtor'))->select('*')->get();
$this->arr['grupos'] = (new Orm('grupoprodutor'))->select('*')->get();
$this->arr['origens'] = (new Orm('origem_venda'))->select('*')->get();

$this->loadTemplate('relatorios/lancamentos', $this->arr);
}//producao


public function exportar(){

if(isset($_POST['cov']) || isset($_POST['filial'])){

$convenios = $this->convertArrayToString($_POST['conv']);
$filiais   = $this->convertArrayToString($_POST['filial']);
$status    = $_POST['status_report'];

$relatorio = $this->limpaCampo($_POST['relatorio']);
$data_ass_inicial = $this->limpaCampo($_POST['data_ass_inicial']);
$data_ass_final = $this->limpaCampo($_POST['data_ass_final']);
$data_baixa_inicial = $this->limpaCampo($_POST['data_baixa_inicial']);
$data_baixa_final = $this->limpaCampo($_POST['data_baixa_final']);
$data_pagamento_inicial = $this->limpaCampo($_POST['data_pag_inicial']);
$data_pagamento_final = $this->limpaCampo($_POST['data_pag_final']);
$parcela_inicial = $this->limpaCampo($_POST['parcela_inicial']);
$parcela_final = $this->limpaCampo($_POST['parcela_final']);
$produtor = $this->limpaCampo($_POST['produtor']);
$grupo = $this->limpaCampo($_POST['grupo']);
$origem = $this->limpaCampo($_POST['origem']);

if($data_ass_inicial != null)
  $data_ass_inicial = $this->converterData($data_ass_inicial,'/');

if($data_ass_final != null)
  $data_ass_final = $this->converterData($data_ass_final,'/');

if($data_pagamento_inicial != null)
  $data_pagamento_inicial = $this->converterData($data_pagamento_inicial,'/');

if($data_pagamento_final != null)
  $data_pagamento_final = $this->converterData($data_pagamento_final,'/');

if($data_baixa_inicial != null)
  $data_baixa_inicial = $this->converterData($data_baixa_inicial,'/');

if($data_baixa_final != null)
  $data_baixa_final = $this->converterData($data_baixa_final,'/');

$r  = new Report();
$rb = new ReportBaixa();
$rp = new ReportProdutor();
$rf = new ReportFilial();
$rg = new ReportGrupo();

/////////////////////////
//informações do cabecalho
$data_inicial = (isset($data_baixa_inicial)) ? $data_baixa_inicial : '';
$data_final = (isset($data_baixa_final)) ?  $data_baixa_final : '';

$data_baixas = $data_inicial." - ".$data_final;
$statuses = '';
foreach($status as $st){  
$statuses .= $st.',';
}
$filtro = [
'data_baixa'=>$data_baixas,
'filiais'=>$this->getFiliais($filiais),
'status'=>$statuses,
'parcela_inicial'=>$parcela_inicial,
'parcela_final'=>$parcela_final
];

/***************************/
//pegando o tipo de relatorio

switch($relatorio){
case 1:
$dados = $r->gerarBaixas($convenios, $filiais, $status, $data_ass_inicial, $data_ass_final, $data_pagamento_inicial, $data_pagamento_final, $data_baixa_inicial, $data_baixa_final, $parcela_inicial, $parcela_final, $produtor, $grupo, $origem, $relatorio);
$rb->gerar($dados, $filtro);
break;

case 2;
$dados = $r->gerarBaixas($convenios, $filiais, $status, $data_ass_inicial, $data_ass_final, $data_pagamento_inicial, $data_pagamento_final, $data_baixa_inicial, $data_baixa_final, $parcela_inicial, $parcela_final, $produtor, $grupo, $origem, $relatorio);

$rp->gerar($dados, $filtro);
break;

case 3:
$dados = $r->gerarBaixas($convenios, $filiais, $status, $data_ass_inicial, $data_ass_final, $data_pagamento_inicial, $data_pagamento_final, $data_baixa_inicial, $data_baixa_final, $parcela_inicial, $parcela_final, $produtor, $grupo, $origem, $relatorio);

$rf->gerar($dados, $filtro);
break;

case 4:
$dados = $r->gerarBaixas($convenios, $filiais, $status, $data_ass_inicial, $data_ass_final, $data_pagamento_inicial, $data_pagamento_final, $data_baixa_inicial, $data_baixa_final, $parcela_inicial, $parcela_final, $produtor, $grupo, $origem, $relatorio);

$rg->gerar($dados, $filtro);
break;

case 7:
$dados = $r->gerarBaixas($convenios, $filiais, $status, $data_ass_inicial, $data_ass_final, $data_pagamento_inicial, $data_pagamento_final, $data_baixa_inicial, $data_baixa_final, $parcela_inicial, $parcela_final, $produtor, $grupo, $origem, $relatorio);
$this->montabaixasexcel($dados);
break;


}//switch pegando tipo de relatorio


}//verifica se teve post

}//exportar


public function exportarlancamentos(){

if(isset($_POST['tipo'])){
$tipo    = $_POST['tipo'];
$relatorio = $this->limpaCampo($_POST['relatorio']);
$data_venc_inicial = $this->limpaCampo($_POST['data_venc_inicial']);
$data_venc_final = $this->limpaCampo($_POST['data_venc_final']);
$produtor = $this->limpaCampo($_POST['produtor']);
$grupo = $this->limpaCampo($_POST['grupo']);
$status = $this->limpaCampo($_POST['status']);

if($data_venc_inicial != null)
  $data_venc_inicial = $this->converterData($data_venc_inicial,'/');

if($data_venc_final != null)
  $data_venc_final = $this->converterData($data_venc_final,'/');


/////////////////////////
$tipos = [
'L'=>"Lançamento",
'LM'=>"Lançamento Manual",
'D'=>"Débito",
'DM'=>"Débito Manual",
'A'=>"Taxa de Adesão",
'T'=>"Taxa Administrativa"
];
//informações do cabecalho
$ini = (isset($data_venc_inicial)) ? date('d/m/Y',strtotime($data_venc_inicial)) : '';
$fim = (isset($data_venc_final)) ? date('d/m/Y',strtotime($data_venc_final)) : '';
$data_baixas = $ini." - ".$fim;
$statuses = '';
foreach($tipo as $st){  
$statuses .= $tipos[$st].',';
}
$filtro = [
'data_vencimento'=>$data_baixas,
'tipo'=>$statuses
];

$r  = new ReportLancamentos();
$rl = new ReportLancamento();
$rr = new ReportLancamentoRecibo();


switch($relatorio){
case 1:
$dados = $r->gerarLancamentos($tipo, $data_venc_inicial, $data_venc_final, $produtor, $grupo, $status, $relatorio);

$rl->gerar($dados, $filtro);
break;

case 2:
$dados = $r->gerarLancamentos($tipo, $data_venc_inicial, $data_venc_final, $produtor, $grupo, $status, $relatorio);

$rr->gerar($dados, $filtro);
break;

case 3:
$dados = $r->gerarLancamentos($tipo, $data_venc_inicial, $data_venc_final, $produtor, $grupo, $status, $relatorio);

$this->exportalancamentosexcel($dados);
}


}//se teve post

}//exportarlancamentos


public function exportarprodutores(){

if(isset($_POST['relatorio'])){
$filiais   = $this->convertArrayToString($_POST['filial']);  
$relatorio = $this->limpaCampo($_POST['relatorio']);
$superior  = $this->limpaCampo($_POST['superior']);
$grupo = $this->limpaCampo($_POST['grupo']);
$saldo = $this->limpaCampo($_POST['saldo']);
$data_inc_inicial = $this->limpaCampo($_POST['data_inc_inicial']);
$data_inc_final = $this->limpaCampo($_POST['data_inc_final']);

if($data_inc_inicial != null)
  $data_inc_inicial = $this->converterData($data_inc_inicial,'/');

if($data_inc_final != null)
  $data_inc_final = $this->converterData($data_inc_final,'/');

//informações do cabecalho
$ini = (isset($data_inc_inicial)) ? date('d/m/Y',strtotime($data_inc_inicial)) : '';
$fim = (isset($data_inc_final)) ? date('d/m/Y',strtotime($data_inc_final)) : '';
$data_baixas = $ini." - ".$fim;
$filtro = [
'filiais'=>$this->getFiliais($filiais),
];

$r  = new ReportLancamentos();
$rl = new ReportLancamento();
$rr = new ReportLancamentoRecibo();
$rp = new ReportProdutores();
$rg = new ReportProdutoresGrupo();


switch($relatorio){
case 1:
$dados = $r->gerarProdutores($filiais, $data_inc_inicial, $data_inc_final, $superior, $grupo,$saldo, $relatorio);

$rp->gerar($dados, $filtro);
break;

case 2:
$dados = $r->gerarProdutores($filiais, $data_inc_inicial, $data_inc_final, $superior, $grupo,$saldo, $relatorio);

$rg->gerar($dados, $filtro);
break;

case 3:
$dados = $r->gerarProdutores($filiais, $data_inc_inicial, $data_inc_final, $superior, $grupo,$saldo, $relatorio);

$this->exportaprodutoresexcel($dados);
}

}//se teve post

}//exportarlancamentos



public function exportarfinanceiro(){

if(isset($_POST['cov']) || isset($_POST['filial']) || isset($_POST['status_report'])){
$convenios = $this->convertArrayToString($_POST['conv']);
$filiais   = $this->convertArrayToString($_POST['filial']);
$status    = $_POST['status_report'];

$relatorio = $this->limpaCampo($_POST['relatorio']);
$data_ass_inicial = $this->limpaCampo($_POST['data_ass_inicial']);
$data_ass_final = $this->limpaCampo($_POST['data_ass_final']);
$data_vigencia_inicial = $this->limpaCampo($_POST['data_vigencia_inicial']);
$data_vigencia_final = $this->limpaCampo($_POST['data_vigencia_final']);
$produtor = $this->limpaCampo($_POST['produtor']);
$grupo = $this->limpaCampo($_POST['grupo']);

if($data_ass_inicial != null)
  $data_ass_inicial = $this->converterData($data_ass_inicial,'/');

if($data_ass_final != null)
  $data_ass_final = $this->converterData($data_ass_final,'/');

if($data_vigencia_inicial != null)
  $data_vigencia_inicial = $this->converterData($data_vigencia_inicial,'/');

if($data_vigencia_final != null)
  $data_vigencia_final = $this->converterData($data_vigencia_final,'/');


$r  = new Report();
$rb = new ReportBaixa();
$rp = new ReportProdutor();
$rf = new ReportFilial();
$rg = new ReportGrupo();
$rf = new ReportFinanceiro();

/////////////////////////
//informações do cabecalho
$data_ini = ($data_ass_inicial != null) ? date('d/m/Y',strtotime($data_ass_inicial)) : '';
$data_fim = ($data_ass_final != null) ? date('d/m/Y',strtotime($data_ass_final)) : ''; 
$data_baixas = $data_ini." - ".$data_fim;

$statuses = '';
foreach($status as $st){  
$statuses .= $st.',';
}
$filtro = [
'data_baixa'=>$data_baixas,
'filiais'=>$this->getFiliais($filiais),
'status'=>$statuses
];

/***************************/
//pegando o tipo de relatorio

switch($relatorio){
case 1:
$dados = $r->gerarFinanceiro($convenios, $filiais, $status, $data_ass_inicial, $data_ass_final, $data_vigencia_inicial, $data_vigencia_final, $produtor, $grupo, $relatorio);

$rf->gerar($dados, $filtro);
break;

case  2:
case  3:
case  4:
case  5:
case  6:
case  7:
case  8:
case  9:
case  10:
$dados = $r->gerarFinanceiro($convenios, $filiais, $status, $data_ass_inicial, $data_ass_final, $data_vigencia_inicial, $data_vigencia_final, $produtor, $grupo, $relatorio);
break;

}//switch pegando tipo de relatorio
}//verifica se teve post

}//exportar



public function exportarproducao(){

if(isset($_POST['cov']) || isset($_POST['filial']) || isset($_POST['status_report'])){

$convenios = $this->convertArrayToString($_POST['conv']);
$filiais   = $this->convertArrayToString($_POST['filial']);
$status    = $_POST['status_report'];

$relatorio = $this->limpaCampo($_POST['relatorio']);
$data_inicial = $this->limpaCampo($_POST['data_inicial']);
$data_final = $this->limpaCampo($_POST['data_final']);
$produtor = $this->limpaCampo($_POST['produtor']);
$grupo = $this->limpaCampo($_POST['grupo']);
$origem = $this->limpaCampo($_POST['origem']);

if($data_inicial != null)
  $data_inicial = $this->converterData($data_inicial,'/');

if($data_final != null)
  $data_final = $this->converterData($data_final,'/');


$r   = new Report();
$rb  = new ReportBaixa();
$rp  = new ReportProdutor();
$rf  = new ReportFilial();
$rp  = new ReportProducao();
$rp2 = new ReportProducao2();
$rp3 = new ReportProducao3();
$rp4 = new ReportProducao4();
$rp5 = new ReportProducao5();
$rp6 = new ReportProducao6();
$rp7 = new ReportProducao7();


/////////////////////////
//informações do cabecalho
$data_baixas = date('d/m/Y',strtotime($data_inicial))." - ".date('d/m/Y',strtotime($data_final));
$statuses = '';
foreach($status as $st){  
$statuses .= $st.',';
}
$filtro = [
'data_baixa'=>$data_baixas,
'filiais'=>$this->getFiliais($filiais),
'status'=>$statuses
];

$dados = $r->gerarProducao($convenios, $filiais, $status, $data_inicial, $data_final, $produtor, $grupo, $origem, $relatorio);

/***************************/
//pegando o tipo de relatorio
switch($relatorio){

case 1:
$rp->gerar($dados, $filtro);
break;

case 2;
$rp2->gerar($dados, $filtro);
break;

case 3:
$rp3->gerar($dados, $filtro);
break;

case 4:
$rp4->gerar($dados, $filtro);
break;

case 5:
$rp5->gerar($dados, $filtro);
break;

case 6:
$rp6->gerar($dados, $filtro);
break;

case 7:
$this->exportaproducaoexcel($dados);
break;

case 8:
$rp7->gerar($dados, $filtro);
break;

}//switch pegando tipo de relatorio
}//verifica se teve post
}//exportar

public function exportarranking(){

if(isset($_POST['cov']) || isset($_POST['filial']) || isset($_POST['status_report'])){

$convenios = $this->convertArrayToString($_POST['conv']);
$filiais   = $this->convertArrayToString($_POST['filial']);
$grupo     = $this->convertArrayToString($_POST['grupo']);
$status    = $_POST['status_report'];
$grupos    = $_POST['grupo'];
$limite    = $this->limpaCampo($_POST['qtde']);

$relatorio = $this->limpaCampo($_POST['relatorio']);
$data_inicial = $this->limpaCampo($_POST['data_inicial']);
$data_final = $this->limpaCampo($_POST['data_final']);

if($data_inicial != null)
  $data_inicial = $this->converterData($data_inicial,'/');

if($data_final != null)
  $data_final = $this->converterData($data_final,'/');



$r   = new Report();
$rb  = new ReportBaixa();
$rp  = new ReportProdutor();
$rf  = new ReportFilial();
$rk  = new ReportRanking();
$rks  = new ReportRankingSuperior();

/////////////////////////
//informações do cabecalho
$data_baixas = date('d/m/Y',strtotime($data_inicial))." - ".date('d/m/Y',strtotime($data_final));
$statuses = '';
foreach($status as $st){  
$statuses .= $st.',';
}
$filtro = [
'data_baixa'=>$data_baixas,
'filiais'=>$this->getFiliais($filiais),
'status'=>$statuses
];



$dados = $r->gerarRanking($convenios, $filiais, $grupos, $status, $data_inicial, $data_final,$limite, $relatorio);


if($relatorio == 1){
$rk->gerar($dados, $filtro);
}else if($relatorio == 2){
$rks->gerar($dados, $filtro);
}
//$this->debug($dados);



}//verifica se teve post
}//exportar


public function exportartv(){

if(isset($_POST['cov']) || isset($_POST['filial']) || isset($_POST['status_report'])){

$convenios = $this->convertArrayToString($_POST['conv']);
$filiais   = $this->convertArrayToString($_POST['filial']);
$grupo     = $this->convertArrayToString($_POST['grupo']);
$status    = $_POST['status_report'];
$grupos    = $_POST['grupo'];
$limite    = $this->limpaCampo($_POST['qtde']);

$data_inicial = $this->limpaCampo($_POST['data_inicial']);
$data_final = $this->limpaCampo($_POST['data_final']);

if($data_inicial != null)
  $data_inicial = $this->converterData($data_inicial,'/');

if($data_final != null)
  $data_final = $this->converterData($data_final,'/');


$r   = new Report();
$rk  = new ReportRanking();
$rks  = new ReportRankingSuperior();


$dados = $r->gerarRanking($convenios, $filiais, $grupos, $status, $data_inicial, $data_final,$limite, 1);


$this->arr['lista'] = $dados;

}//verifica se teve post


$this->loadView("relatorios/listar_tv", $this->arr);
}//exportar



public function getFiliais($filiais){
$saida = '';
$filiais = explode(',',$filiais);

foreach($filiais as $filial){
$item = (new Orm('filiais'))->select(['nome_filial'])->where(['id_filial', $filial])->first()->get();

$saida .= $item->nome_filial.",";
}

rtrim($saida,',');

return $saida;
}//filiais


public function exportaproducaoexcel($dados){
//Aqui começa a exportação
$formato = 'Xlsx';//Xlsx - Xls - Csv
$file = new Spreadsheet();
$active_sheet = $file->getActiveSheet();

$active_sheet->setCellValue('a1', 'Nome do cliente');
$active_sheet->setCellValue('b1', 'CPF/CNPJ');
$active_sheet->setCellValue('c1', 'Num Contrato');
$active_sheet->setCellValue('d1', 'Num Proposta');
$active_sheet->setCellValue('e1', 'Data Assinatura');
$active_sheet->setCellValue('f1', 'Data Vigencia');
$active_sheet->setCellValue('g1', 'Filial');
$active_sheet->setCellValue('h1', 'Convenio');
$active_sheet->setCellValue('i1', 'Plano');
$active_sheet->setCellValue('j1', 'Status do contrato');
$active_sheet->setCellValue('k1', 'Produtor');
$active_sheet->setCellValue('l1', 'Superior');
$active_sheet->setCellValue('m1', 'Origem de venda');
$active_sheet->setCellValue('n1', 'Qtde de vidas');
$active_sheet->setCellValue('o1', 'Valor do contrato');
$active_sheet->setCellValue('p1', 'Endereço');
$active_sheet->setCellValue('q1', 'Numero');
$active_sheet->setCellValue('r1', 'Complemento');
$active_sheet->setCellValue('s1', 'Bairro');
$active_sheet->setCellValue('t1', 'Municipio');
$active_sheet->setCellValue('u1', 'UF');
$active_sheet->setCellValue('v1', 'Cep');
$active_sheet->setCellValue('w1', 'Telefone');
$active_sheet->setCellValue('x1', 'celular');
$active_sheet->setCellValue('y1', 'Email');
$active_sheet->setCellValue('z1', 'Observação');

$count = 2;
foreach($dados as $row){

$active_sheet->setCellValue('a'.$count, $row->nome_cliente ?? '');
$active_sheet->setCellValue('b'.$count, $row->cpf ?? '');
$active_sheet->setCellValue('c'.$count, $row->id_contrato ?? '');
$active_sheet->setCellValue('d'.$count, $row->numero_proposta ?? '');
$active_sheet->setCellValue('e'.$count, $row->data_assinatura ?? '');
$active_sheet->setCellValue('f'.$count, $row->data_vigencia ?? '');
$active_sheet->setCellValue('g'.$count, $row->nome_filial ?? '');
$active_sheet->setCellValue('h'.$count, $row->nome_convenio ?? '');
$active_sheet->setCellValue('i'.$count, $row->plano ?? '');
$active_sheet->setCellValue('j'.$count, $row->status ?? '');
$active_sheet->setCellValue('k'.$count, $row->produtor ?? '');
$active_sheet->setCellValue('l'.$count, $row->nome_superior ?? '');
$active_sheet->setCellValue('m'.$count, $row->origem_venda ?? '');
$active_sheet->setCellValue('n'.$count, $row->vidas ?? '');
$active_sheet->setCellValue('o'.$count, $row->valor_contrato ?? '');
$active_sheet->setCellValue('p'.$count, $row->endereco ?? '');
$active_sheet->setCellValue('q'.$count, $row->numero ?? '');
$active_sheet->setCellValue('r'.$count, $row->complemento ?? '');
$active_sheet->setCellValue('s'.$count, $row->bairro ?? '');
$active_sheet->setCellValue('t'.$count, $row->municipio ?? '');
$active_sheet->setCellValue('u'.$count, $row->uf ?? '');
$active_sheet->setCellValue('v'.$count, $row->cep ?? '');
$active_sheet->setCellValue('w'.$count, $row->telefone ?? '');
$active_sheet->setCellValue('x'.$count, $row->celular ?? '');
$active_sheet->setCellValue('y'.$count, $row->email ?? '');
$active_sheet->setCellValue('z'.$count, $row->observacao ?? '');
$count = $count +1;
}

$writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($file, $formato);

$file_name = time().'.'.strtolower(($formato));
$writer->save($file_name);
header("Content-Type: application/x-www-form-urlencoded");
header("Content-Transfer-Encoding:Binary");
header("Content-disposition:attachment;filename=\"".$file_name."\"");
readfile($file_name);
unlink($file_name);
exit;
}//

public function exportaprodutoresexcel($dados){
//Aqui começa a exportação
$formato = 'Xlsx';//Xlsx - Xls - Csv
$file = new Spreadsheet();
$active_sheet = $file->getActiveSheet();

$active_sheet->setCellValue('a1', 'Nome do Produtor');
$active_sheet->setCellValue('b1', 'CPF/CNPJ');
$active_sheet->setCellValue('c1', 'Data inclusão');
$active_sheet->setCellValue('d1', 'Superior');
$active_sheet->setCellValue('e1', 'Corretor?');
$active_sheet->setCellValue('f1', 'Grupo Produtor');
$active_sheet->setCellValue('g1', 'Endereço');
$active_sheet->setCellValue('h1', 'Número');
$active_sheet->setCellValue('i1', 'Complemento');
$active_sheet->setCellValue('j1', 'Bairro');
$active_sheet->setCellValue('k1', 'Municipio');
$active_sheet->setCellValue('l1', 'UF');
$active_sheet->setCellValue('m1', 'Cep');
$active_sheet->setCellValue('n1', 'Telefone');
$active_sheet->setCellValue('o1', 'Celular');
$active_sheet->setCellValue('p1', 'Email');
$active_sheet->setCellValue('q1', 'Saldo');
$active_sheet->setCellValue('r1', 'Filial');
$count = 2;
foreach($dados as $row){

$active_sheet->setCellValue('a'.$count, $row->produtor ?? '');
$active_sheet->setCellValue('b'.$count, $row->cpf ?? '');
$active_sheet->setCellValue('c'.$count, $row->data_cad ?? '');
$active_sheet->setCellValue('d'.$count, $row->superior ?? '');
$active_sheet->setCellValue('e'.$count, $row->corretor ?? '');
$active_sheet->setCellValue('f'.$count, $row->grupo_produtor ?? '');
$active_sheet->setCellValue('g'.$count, $row->endereco ?? '');
$active_sheet->setCellValue('h'.$count, $row->numero ?? '');
$active_sheet->setCellValue('i'.$count, $row->complemento ?? '');
$active_sheet->setCellValue('j'.$count, $row->bairro ?? '');
$active_sheet->setCellValue('k'.$count, $row->municipio ?? '');
$active_sheet->setCellValue('l'.$count, $row->uf ?? '');
$active_sheet->setCellValue('m'.$count, $row->cep ?? '');
$active_sheet->setCellValue('n'.$count, $row->telefone ?? '');
$active_sheet->setCellValue('o'.$count, $row->celular ?? '');
$active_sheet->setCellValue('p'.$count, $row->email ?? '');
$active_sheet->setCellValue('q'.$count, $row->saldo ?? '');
$active_sheet->setCellValue('r'.$count, $row->filial_id ?? '');

$count = $count +1;
}

$writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($file, $formato);

$file_name = time().'.'.strtolower(($formato));
$writer->save($file_name);
header("Content-Type: application/x-www-form-urlencoded");
header("Content-Transfer-Encoding:Binary");
header("Content-disposition:attachment;filename=\"".$file_name."\"");
readfile($file_name);
unlink($file_name);
exit;
}//

public function exportalancamentosexcel($dados){
//Aqui começa a exportação
$formato = 'Xlsx';//Xlsx - Xls - Csv
$file = new Spreadsheet();
$active_sheet = $file->getActiveSheet();

$active_sheet->setCellValue('a1', 'Cliente');
$active_sheet->setCellValue('b1', 'Contrato');
$active_sheet->setCellValue('c1', 'Proposta');
$active_sheet->setCellValue('d1', 'Data Assinatura');
$active_sheet->setCellValue('e1', 'Data de inclusão');
$active_sheet->setCellValue('f1', 'Filial');
$active_sheet->setCellValue('g1', 'Convenio');
$active_sheet->setCellValue('h1', 'Status Contrato');
$active_sheet->setCellValue('i1', 'Produtor');
$active_sheet->setCellValue('j1', 'Grupo produtor');
$active_sheet->setCellValue('k1', 'Cpf/Cnpj');
$active_sheet->setCellValue('l1', 'Origem da venda');
$active_sheet->setCellValue('m1', 'Valor Contrato');
$active_sheet->setCellValue('n1', 'Valor da baixa');
$active_sheet->setCellValue('o1', 'Status da baixa');
$active_sheet->setCellValue('p1', 'Data da baixa');
$active_sheet->setCellValue('q1', 'Grupo Produtor');
$active_sheet->setCellValue('r1', 'Tipo de lançamento');
$active_sheet->setCellValue('s1', 'Descrição');
$active_sheet->setCellValue('t1', 'Número da parcela');
$active_sheet->setCellValue('u1', 'Valor da parcela');
$active_sheet->setCellValue('v1', 'Valor do lançamento');


$count = 2;

foreach($dados as $row){

$active_sheet->setCellValue('a'.$count, $row->cliente ?? '');
$active_sheet->setCellValue('b'.$count, $row->contrato ?? '');
$active_sheet->setCellValue('c'.$count, $row->proposta ?? '');
$active_sheet->setCellValue('d'.$count, $row->data_assinatura ?? '');
$active_sheet->setCellValue('e'.$count, $row->data_cad ?? '');
$active_sheet->setCellValue('f'.$count, $row->filial ?? '');
$active_sheet->setCellValue('g'.$count, $row->convenio ?? '');
$active_sheet->setCellValue('h'.$count, $row->status_contrato ?? '');
$active_sheet->setCellValue('i'.$count, $row->produtor ?? '');
$active_sheet->setCellValue('j'.$count, $row->grupo_produtor ?? '');
$active_sheet->setCellValue('k'.$count, $row->cpf ?? '');
$active_sheet->setCellValue('l'.$count, $row->origem_venda ?? '');
$active_sheet->setCellValue('m'.$count, $row->valor_contrato ?? '');
$active_sheet->setCellValue('n'.$count, $row->valor_baixa ?? '');
$active_sheet->setCellValue('o'.$count, $row->status_baixa ?? '');
$active_sheet->setCellValue('p'.$count, $row->data_baixa ?? '');
$active_sheet->setCellValue('q'.$count, $row->grupo_produtor ?? '');
$active_sheet->setCellValue('r'.$count, $row->tipo ?? '');
$active_sheet->setCellValue('s'.$count, $row->descricao ?? '');
$active_sheet->setCellValue('t'.$count, $row->numero_parcela ?? '');
$active_sheet->setCellValue('u'.$count, $row->valor_parcela ?? '');
$active_sheet->setCellValue('v'.$count, $row->valor_lancamento ?? '');

$count = $count +1;
}

$writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($file, $formato);

$file_name = time().'.'.strtolower(($formato));
$writer->save($file_name);
header("Content-Type: application/x-www-form-urlencoded");
header("Content-Transfer-Encoding:Binary");
header("Content-disposition:attachment;filename=\"".$file_name."\"");
readfile($file_name);
unlink($file_name);
exit;

}//


public function montabaixasexcel($dados){
//Aqui começa a exportação
$formato = 'Xlsx';//Xlsx - Xls - Csv
$file = new Spreadsheet();
$active_sheet = $file->getActiveSheet();

$active_sheet->setCellValue('a1', 'Cliente');
$active_sheet->setCellValue('b1', 'Contrato');
$active_sheet->setCellValue('c1', 'Proposta');
$active_sheet->setCellValue('d1', 'Data Assinatura');
$active_sheet->setCellValue('e1', 'Data de inclusão');
$active_sheet->setCellValue('f1', 'Filial');
$active_sheet->setCellValue('g1', 'Convenio');
$active_sheet->setCellValue('h1', 'Status Contrato');
$active_sheet->setCellValue('i1', 'Produtor');
$active_sheet->setCellValue('j1', 'Grupo produtor');
$active_sheet->setCellValue('k1', 'Origem da venda');
$active_sheet->setCellValue('l1', 'Valor Contrato');
$active_sheet->setCellValue('m1', 'Data da baixa');
$active_sheet->setCellValue('n1', 'Data do pagamento');
$active_sheet->setCellValue('o1', 'Número da parcela');
$active_sheet->setCellValue('p1', 'Valor da parcela');
$active_sheet->setCellValue('q1', 'Valor da baixa');

$active_sheet->setCellValue('r1', 'Percentual');
$active_sheet->setCellValue('s1', 'Total de lançamentos');
$active_sheet->setCellValue('t1', 'Total de comissão');

$count = 2;
foreach($dados as $row){

$porc = ($row->valor_baixa / $row->valor_parcela) * 100;
$active_sheet->setCellValue('a'.$count, $row->nome_cliente ?? '');
$active_sheet->setCellValue('b'.$count, $row->id_contrato ?? '');
$active_sheet->setCellValue('c'.$count, $row->numero_proposta ?? '');
$active_sheet->setCellValue('d'.$count, $row->data_assinatura ?? '');
$active_sheet->setCellValue('e'.$count, $row->data_cad ?? '');
$active_sheet->setCellValue('f'.$count, $row->nome_filial ?? '');
$active_sheet->setCellValue('g'.$count, $row->nome_convenio ?? '');
$active_sheet->setCellValue('h'.$count, $row->status ?? '');
$active_sheet->setCellValue('i'.$count, $row->produtor ?? '');
$active_sheet->setCellValue('j'.$count, $row->grupoprodutor ?? '');
$active_sheet->setCellValue('k'.$count, $row->origem_venda ?? '');
$active_sheet->setCellValue('l'.$count, number_format($row->valor_contrato,2) ?? '');
$active_sheet->setCellValue('m'.$count, $row->data_baixa ?? '');
$active_sheet->setCellValue('n'.$count, $row->data_pagamento ?? '');
$active_sheet->setCellValue('o'.$count, $row->num_parcela ?? '');
$active_sheet->setCellValue('p'.$count, number_format($row->valor_parcela,2) ?? '');
$active_sheet->setCellValue('q'.$count, number_format($row->valor_baixa,2) ?? '');

$active_sheet->setCellValue('r'.$count,  $porc);
$active_sheet->setCellValue('s'.$count, $this->totalcomissoes($row->id_historico));
$active_sheet->setCellValue('t'.$count, $this->totallancamentos($row->id_historico));

$count = $count +1;
}

$writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($file, $formato);

$file_name = time().'.'.strtolower(($formato));
$writer->save($file_name);
header("Content-Type: application/x-www-form-urlencoded");
header("Content-Transfer-Encoding:Binary");
header("Content-disposition:attachment;filename=\"".$file_name."\"");
readfile($file_name);
unlink($file_name);
exit;
}//

private function totallancamentos($id_lancamento){
$total = 0;
$lista = (new Orm('lanc_hist_comissoes'))->select('*')->where(['id_lancamento', $id_lancamento])->get();

foreach($lista as $item){
  if($item->tipo == 'L' OR $item->tipo == 'LD' OR $item->tipo == 'LA'){
    $total += $item->valor;
  }
}

return $total;
}//totallancamentos

private function totalcomissoes($id_lancamento){
$total  = 0;
$saidas = 0;

$lista = (new Orm('lanc_hist_comissoes'))->select('*')
->where(['id_lancamento', $id_lancamento])->get();

foreach($lista as $item){
  if($item->tipo == 'L' OR $item->tipo == 'LD' OR $item->tipo == 'LA'){
    $total += $item->valor;
  }else{
   $saidas += $item->valor; 
  }

}

return $total - $saidas;
}//total Comissoes


}