<?php
use Core\Controller;
use Models\Users;
use Models\Permissao;
use Models\Financeiro;
use Models\Orm;
use Models\ReportFinanceiro;
use Dompdf\Dompdf;
use Dompdf\Exception;
use Dompdf\Options;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\IOFactory;

class SmsController extends Controller {

  private $user;
  private $arr;
  private $permissao;

    public function __construct() {              
        $this->user = new Users();
        $this->permissao = new Permissao(); 

        if($this->user->isLogged() == false){                  
         header("Location: ".BASE_URL."login");        
         exit;         
        }

       $usuario = $this->user->getId();       
       $permissoes = $this->permissao->getPermissoes();
       $modulo_boleto = $this->permissao->getPermissoesBoleto();
       
        $this->arr = array(
         'user'=>$this->user,
         'menuActive'=>'home',
         'permissao'=>$permissoes,
         'modulo_boleto'=>$modulo_boleto
        );            
}

public function relatorio() {   
  $data = array();
  
  if( isset($_POST['data_inicial']) && !empty($_POST['data_inicial']) && isset($_POST['data_final']) && !empty($_POST['data_final'])){
  $data = []; 
  $tiporelatorio = $_POST['tiporelatorio'];
  $data_inicial = $_POST['data_inicial'];
  $data_final = $_POST['data_final'];

  $data['tiporelatorio'] = $tiporelatorio;
  $data['data_inicial'] = $data_inicial;
  $data['data_final'] = $data_final;

  if($tiporelatorio == 'envio_resumo'){
  $data['consulta'] = (new Orm('vw_smsenviados_resumo'))
  ->select(['*'])
  ->wherecustom("data >= '$data_inicial' and data <= '$data_final'")
  ->get();       
            
  ob_start();
  $this->loadview("sms/sms_report_enviadosresumo_pdf", $data);      
  //exit;
  $html = ob_get_contents();
  ob_end_clean();      
  $options = new Options();
  $options->set('isRemoteEnabled',true);
  $dompdf = new Dompdf($options);
  //$dompdf = new Dompdf();
  $dompdf->loadHtml($html);
  // Render the HTML as PDF
  $dompdf->setPaper('A4', 'portrait');
  $dompdf->render();
  $dompdf->stream("Letter",["Attachment" => false]);  
  }

  if($tiporelatorio == 'envio_detalhe'){
    $data['consulta'] = (new Orm('sms_enviados  '))
    ->select(['*'])
    ->wherecustom("data >= '$data_inicial' and data <= '$data_final'")
    ->get();       
              
    ob_start();
    $this->loadview("sms/sms_report_enviadosdetalhe_pdf", $data);      
    exit;
    $html = ob_get_contents();
    ob_end_clean();      
    $options = new Options();
    $options->set('isRemoteEnabled',true);
    $dompdf = new Dompdf($options);
    //$dompdf = new Dompdf();
    $dompdf->loadHtml($html);
    // Render the HTML as PDF
    $dompdf->setPaper('A4', 'landscape');
    $dompdf->render();
    $dompdf->stream("Letter",["Attachment" => false]);  
    }

}
$this->loadTemplate('sms/sms_relatorios', $this->arr);

}//function index 

public function index(){
  $this->arr['list_js'] = array(
    'import_csv_leads',
    'plugins/sweetalert2',
    'system'
    );
  
  $this->permissao = new Permissao(); 
  $cliente = $this->permissao->getPermissoesBoleto();
  
  $smssaldo = $cliente->sms_saldo;
  $this->arr['saldo'] = $smssaldo;
  $externalkey = $cliente->sms_externalkey;
  $user = $cliente->sms_user;
  $password = $cliente->sms_password;
  $flashsms = '1';
//echo '<pre>';
//echo $_FILES['import_leads']['name'];
//echo $_POST['mensagem'];
//exit;

  if( isset($_POST['mensagem']) && !empty($_POST['mensagem']) && isset($_FILES['import_leads']) && $_FILES['import_leads']['name'] != ''){
    //echo 'aqui';
    //exit;
  if($smssaldo > 0){
    $msg = $_POST['mensagem'];
    
    $permitidas = array('xls', 'csv', 'xlsx');
    $file_array = explode('.', $_FILES['import_leads']['name']);
    $file_extension = end($file_array);
    
    if(in_array($file_extension, $permitidas)){
    
    $file_name = time().'.'.$file_extension;
    move_uploaded_file($_FILES['import_leads']['tmp_name'], $file_name);
    
    $file_type = \PhpOffice\PhpSpreadsheet\IOFactory::identify($file_name);
    $reader    = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($file_type);
    
    $spreadsheet = $reader->load($file_name);
    unlink($file_name);
    $data = $spreadsheet->getActivesheet()->toArray();
    $saida = array();
    $arrayduplicado = array();
    //echo '<pre>';
    //print_r($data);
    //exit;
    $acertos = 0;
    $errors = 0;
    $duplicado = 0;
    $smssaldo_m = $smssaldo;
    foreach($data as $key=> $row){
      
    //'tipo_cotacao'=>$row[5],
    //'qtde_vidas'=>$row[6],
        if($row[0] != '' && isset(($row[0])) ){
          if($key >0){
            $cel = str_replace(" ", "",str_replace(")", "",str_replace("(", "",str_replace("-", "", $row[0]))));
            $count = strlen($cel);
            $countm = strlen($msg);
            //$l = new Leads();
            //$sql = $l->getcel($cel);
            //echo '<pre>';
            //print_r($sql['total']);
            //exit;
            if($count>11 || $count<10 || $countm > 170){
                $arrayduplicado[] = $row[0];
                $duplicado += 1;
                $errors += 1;
            }else{

              if($smssaldo_m <= $smssaldo){
                $smssaldo_m = $smssaldo_m-1; 
               // echo $smssaldo_m;
               // exit;
                $destinatario = $cel;
                $usern = $this->user->getUid();  
                date_default_timezone_set('America/Sao_Paulo');
                $dt1 = date("Y-m-d");

                $tab = new Orm('sms_enviados');
                $grava = $tab->set([
                'cel'=>$destinatario,
                'mensagem'=>$msg,
                'data'=>$dt1,                
                'id_user'=>$usern
                ])->save();
                //echo $grava;
                $externalkey = $grava;
                //exit;
                if($grava){
                  $acertos += 1;
                /*$day = '00';
                $month = '00';
                $year = '00';
                $formHour = '00';
                $formMinute = '00';*/
                
                
                $msgEncoded = urlencode($msg);
                $urlChamada = "http://api.facilitamovel.com.br/api/simpleSend.ft?user=".$user."&password=".$password."&flashsms=".$flashsms."&externalkey=".$externalkey."&destinatario=".$destinatario."&msg=".$msgEncoded;
                echo file_get_contents($urlChamada);

                }else{
                  $errors += 1;
                  $arrayduplicado[] = $row[0];
                }
              }else{
                $errors += 1;
                $arrayduplicado[] = $row[0];
                //echo 'Saldo insuficiente.';
                //exit;
              }
            }
          }
        }
      
      
    }//foreach
    //echo '<pre>';
    //print_r($arrayduplicado);
    $i = 0;
    $texto = '';
    for($i = 0;$i < $duplicado;$i++){
    $texto = $texto.$arrayduplicado[$i];
    }
    //echo $texto;
    //exit;
    //exit;

   // echo $smssaldo;
   // echo $smssaldo_m;
   // exit;
   $smssaldo_atu = $smssaldo-$acertos;
   //echo $smssaldo_atu;
   //exit;
    $tabn = new Orm('clientes');
    $gravan = $tabn->set([
    'sms_saldo'=>$smssaldo_atu
    ])->update();
    //echo $gravan;
    //exit;

    //$_SESSION['msg'] = ['type'=>'success','msg'=>"Foram enviados {$acertos} números com sucesso e {$errors} números com erro! Duplicados {$duplicado}:  {$texto} "];
    $_SESSION['msg'] = ['type'=>'success','msg'=>"Foram enviados {$acertos} números com sucesso e Não enviados {$errors} números com erro! {$texto}"];
    echo '<script>window.location.href = "https://cartaodetodos.crmd.com.br/sms";</script>';
      //header("Location:".BASE_URL."sms");
      //exit;
    }else{
      $_SESSION['msg'] = ['type'=>'error','msg'=>'Apenas xlx, csv ou xlsx tipos permitidos'];
      echo '<script>window.location.href = "https://cartaodetodos.crmd.com.br/sms";</script>';
      //header("Location:".BASE_URL."sms");
      //exit; 
    }

  }else{
    echo 'Saldo insuficiente.';
    exit;
  }
  
}//se tve posto do arquivo de excel
        
    $this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);

    $this->loadTemplate('sms/importar_sms',$this->arr);
 // exit;
}

}