<?php
use Core\Controller;
use Models\Users;
use Models\Permissao;
use Models\Orm;
use Models\Validate;
use Models\Leads;

class WebformsController extends Controller {

  private $user;
  private $arr;
  private $permissao;

    public function __construct() {              
        $this->user = new Users();
        $this->permissao = new Permissao(); 

        if($this->user->isLogged() == false){                  
         header("Location: ".BASE_URL."login");        
         exit;         
        }
           
        $permissoes = $this->permissao->getPermissoes();
        $modulo_boleto = $this->permissao->getPermissoesBoleto();
        
         $this->arr = array(
          'user'=>$this->user,
          'menuActive'=>'home',
          'permissao'=>$permissoes,
          'modulo_boleto'=>$modulo_boleto
         );           
}

public function index() {   
$this->arr['list_js'] = array(
'plugins/sweetalert2',
'system'
);  

$tab = new Orm('webforms');

if(isset($_GET['nome']) && !empty($_GET['nome'])){
$nome = addslashes($_GET['nome']);
$this->arr['lista'] = $tab->select('*')->search(['nome',$nome])->get();
}else{
$this->arr['lista'] = $tab->select('*')->paginate('10')->get();
$this->arr['paginacao'] = $tab->render("webforms");
}

$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);


$this->loadTemplate('webforms/listar', $this->arr);
}//function index  


public function add(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'functions_js',
'plugins/sweetalert2',
'system',
'plugins/sortable.min'
);

$l = new Leads();
$this->arr['colunas'] = $l->listaColunas();
$this->arr['produtos'] = (new Orm('produtos'))->select('*')->get();
$this->arr['origens'] = (new Orm('origem_venda'))->select('*')->get();


$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('webforms/adicionar', $this->arr);
}//add


public function organizar(){
$data = $_POST['data'];
$tareasOrdenadas = json_decode($data);

echo "<pre>";
print_r($tareasOrdenadas);
exit;

foreach($tareasOrdenadas as $tarea){
 $sql = "UPDATE tareas SET ordem = $tarea->ordem WHERE id = $tarea->id";
 echo $sql.PHP_EOL; 
}

}//organizar


public function novo(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'functions_js',
'plugins/sweetalert2',
'system'
);

$l = new Leads();
$this->arr['colunas'] = $l->listaColunas();

if(isset($_POST['campo']) && !empty($_POST['campo'])){
$campo = $this->Slug($_POST['campo']);
$campo = str_replace('-','_', $campo);

if(in_array($campo, $this->arr['colunas'])){
  $_SESSION['msg'] = ['type'=>'error', 'msg'=>"Coluna já existe!"];
  header("Location:".BASE_URL."webforms/novo");
  exit;

}else{
$insere = $l->novaColuna($campo);
$_SESSION['msg'] = ['type'=>'success', 'msg'=>"Coluna cadastrada com sucesso!"];
  header("Location:".BASE_URL."webforms/novo");
  exit;
}

}

$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('webforms/novo', $this->arr);
}//add


public function saveform(){
$id_webform = (isset($_POST['id_webform'])) ? $_POST['id_webform'] : NULL;  
$nome = addslashes($_POST['nome']);
$form = $_POST['form'];
$formulario = '';

$last_id = $id_webform;


if($last_id  == null){
$last = (new Orm('webforms'))
->select(['id_webform'])
->order(['id_webform desc'])
->limit('1')->first()->get();

if(empty($last)){
  $last_id = 1;
}else{
  $last_id = $last->id_webform + 1;
}
}

$produto = $_POST['produto'];
$status  = $_POST['status'];
$origem  = $_POST['origem'];
$tipo    = $_POST['tipo'];
$config  = $_POST['config'];


$formulario .= '<link href="'.BASE_URL.'webforms.css" rel="stylesheet"/>';
$formulario .= '<form method="post" action="'.BASE_URL.'formulario/grava">';

foreach($form as $frm){
$label = $this->customLabel($frm['id']);
  
  if($frm['id'] != 'id_webform'){
  $formulario .= '<div class="group-form">';
  $formulario .= '<label>'.$label.'</label>';
  $formulario .= '<input type="'.$frm['tipo'].'" name="'.$frm['id'].'" required="'.$frm['obrigatorio'].'">';
  $formulario .= '</div>';
}
}

$formulario .= '<div class="group-form w100">
 <input type="hidden" name="id_webform" value="'.$last_id.'"/>
 <button type="submit" id="monta_formulario" class="btn btn-success"><i class="far fa-save"></i> Enviar</button>     
</div>';
$formulario .= '</form>';



if($id_webform !== null){

$cad = (new Orm('webforms'))->set([
'nome'=>$nome,
'form'=>$formulario,
'status'=>'A',
'produto'=>$produto,
'status_lead'=>$status,
'origem'=>$origem,
'tipo'=>$tipo,
'config'=>$config
])->where(['id_webform', $id_webform])->update();


if($cad){
echo json_encode(1);
exit;
}else{
echo json_encode(2);
exit;
}

}else{

$cad = (new Orm('webforms'))->set([
'nome'=>$nome,
'data_criado'=>date('Y-m-d'),
'form'=>$formulario,
'status'=>'A',
'produto'=>$produto,
'status_lead'=>$status,
'origem'=>$origem,
'tipo'=>$tipo,
'config'=>$config
])->save();

if($cad){
echo json_encode(1);
exit;
}else{
echo json_encode(2);
exit;
}
}
}


public function customLabel($label){
$item = (new Orm('titulos'))->select('*')->where(['indice_titulo', $label])->first()->get();

if(!empty($item)){
  return $item->novo_titulo;
}

$titulo = $label;
$titulo = ucfirst($titulo);
$titulo = str_replace('_',' ',$titulo);

return $titulo;
}//customLabel

public function incorporar($id){
$this->arr['html'] = (new Orm('webforms'))->select(['form'])
->where(['id_webform', $id])->first()->get();


$this->loadTemplate('webforms/incorporar', $this->arr);
}//incorporar


public function edit($id){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'plugins/sweetalert2',
'system',
'plugins/sortable.min'
);

$l = new Leads();
$this->arr['colunas'] = $l->listaColunas();
$this->arr['produtos'] = (new Orm('produtos'))->select('*')->get();
$this->arr['origens'] = (new Orm('origem_venda'))->select('*')->get();

$this->arr['id_lead'] = $id;
$this->arr['info'] = (new Orm('webforms'))->select('*')->where(['id_webform', $id])
->first()->get();
$this->loadTemplate('webforms/editar', $this->arr);
}//edit


public function clonar($id){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'plugins/sweetalert2',
'system',
'plugins/sortable.min'
);

$l = new Leads();
$this->arr['colunas'] = $l->listaColunas();
$this->arr['produtos'] = (new Orm('produtos'))->select('*')->get();
$this->arr['origens'] = (new Orm('origem_venda'))->select('*')->get();

$this->arr['id_lead'] = '';
$this->arr['info'] = (new Orm('webforms'))->select('*')->where(['id_webform', $id])
->first()->get();
$this->loadTemplate('webforms/clonar', $this->arr);
}//edit



public function grava(){
$validator = new Validate();

if(isset($_POST['id_webform']) && $_POST['id_webform'] != ''){
$dados = (new Orm('webforms'))->select([
  'produto, status_lead, origem, tipo, config'])
   ->where(['id_webform', $_POST['id_webform']])->first()->get();
}

if(isset($_POST)){
$p = $_POST;
$form = [];

foreach($p as $key=>$input){

if($dados->config == 'N'){
  if($key != 'id_webform'){
    @$form[$key] .= 'required';
  }
}else if($dados->config == 'S'){

if($key != 'produto' && $key != 'status' && $key != 'origem' &&$key != 'tipo_cotacao' && $key != 'id_webform'){
 @$form[$key] .= 'required';
}
}
}

//preencher com o padrao
if($dados->config == 'S'){
@$form['produto']      .= 'definido:'.$dados->produto;
@$form['status']       .= 'definido:'.$dados->status_lead;
@$form['origem']       .= 'definido:'.$dados->origem;
@$form['tipo_cotacao'] .= 'definido:'.$dados->tipo;
}

$validate = $validator->validate($form,true);
$grava = (new Orm('leads'))->set($validate)->save(); 
$_SESSION['msg'] = ['type'=>'success','msg'=>'Lead Cadastrado com sucesso!'];
  header("Location:".BASE_URL."leads");
  exit;
}
}//grava


public function save(){
$validator = new Validate();

if(isset($_POST['nome']) && !empty($_POST['produto'])){

$validate = $validator->validate([
'id_lead'=>'null',
'nome'=>'required',
'produto'=>'required',
'email'=>'required',
'telefone'=>'required',
'origem'=>'required',
'tipo_cotacao'=>'required',
'qtde_vidas'=>'required',
'data_entrada'=>'data',
'status'=>'definido:novo'
],true);


if(!$validate){
$_SESSION['msg'] = ['type'=>'error','msg'=>'Ooops... Alguns campos estão inválidos, tente novamente'];
 unset($_SESSION['flash']);
 unset($_SESSION['old']);
 header("Location:".BASE_URL."leads/add");
 exit;   
}


if($validate['id_lead'] == null){
  //grava no banco
  $grava = (new Orm('leads'))->set($validate)->save(); 
  $_SESSION['msg'] = ['type'=>'success','msg'=>'Lead Cadastrado com sucesso!'];
  header("Location:".BASE_URL."leads");
  exit;
}else{
 $grava = (new Orm('leads'))->set($validate)->where(['id_lead', $validate['id_lead']])->update(); 
 $_SESSION['msg'] = ['type'=>'success','msg'=>'Lead atualizado com sucesso!'];
  header("Location:".BASE_URL."leads");
  exit; 
}


}
}//save

public function view($id){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'plugins/sweetalert2',
'system'
);

$this->arr['form'] = (new Orm('webforms'))->select('*')
->where(['id_webform', $id])->first()->get();
$this->arr['id_webform'] = $id;

$this->loadTemplate('webforms/visualizar', $this->arr);
}



public function remover($id){

$del = (new Orm('webforms'))->del(['id_webform', $id]);
$_SESSION['msg'] = array('type'=>'success', 'msg'=>'Formulário removido com sucesso!');
$this->redirect(BASE_URL."webforms");
}//remover



}