<?php

class Baixaboleto extends model
{

	public function __construct()
	{
		parent::__construct();
	}

	public function getList($id_company)
	{
		$array = array();

		$sql = $this->db->prepare("SELECT * FROM claro_movel WHERE id_company = :id_company ORDER BY nome");
		$sql->bindValue(':id_company', $id_company);
		$sql->execute();

		if ($sql->rowCount() > 0) {
			$array = $sql->fetchAll();
		}

		return $array;
	} 

	public function getListareceberQtde($id_company, $nnumero, $cc, $dtrec, $valor, $uc, $dc)
	{
		$array = array();

		$sql = $this->db->prepare("SELECT * FROM vw_baixaboleto WHERE id_company = :id_company and nnumero = '$nnumero' ");
		$sql->bindValue(':id_company', $id_company);
		//$sql->bindValue(':nnumero', $nnumero);
		$sql->execute();

		if ($sql->rowCount() > 0) {
			$array['registro'] = $sql->fetch();
		}
		return $array;
	}

	public function getListarecebersicredi($id_company, $nnumero, $cc, $dtrec, $valor, $uc, $dc)
	{
		$array = array();

		$sql = $this->db->prepare("SELECT * FROM vw_baixaboleto WHERE id_company = :id_company and nnumero = '$nnumero' ");
		$sql->bindValue(':id_company', $id_company);
		//$sql->bindValue(':nnumero', $nnumero);
		$sql->execute();

		if ($sql->rowCount() > 0) {
			$array = $sql->fetch();

			//echo ;
			//exit;

			$sql = $this->db->prepare("INSERT INTO recebimento SET id_company = :id_company, conta = :conta, data_pagamento = :data_pagamento, tipo = :tipo, obs = :obs, situacao = :situacao");

			$sql->bindValue(':id_company', $id_company);
			$sql->bindValue(':conta', $cc);
			$sql->bindValue(':data_pagamento', $dtrec);
			$sql->bindValue(':tipo', '1');
			$sql->bindValue(':obs', 'BAIXA BOLETO ' . $nnumero);
			$sql->bindValue(':situacao', 'Liquidado');

			$sql->execute();

			//aqui pego o ultimo id 
			$idpag = $this->db->lastInsertId();

			$sqlp = $this->db->prepare("INSERT INTO recebimento_itens SET id_company = :id_company, id_pagamento = :id_pagamento, fornecedor = :fornecedor, valor = :valor, juros = :juros, desconto = :desconto, valor_pago = :valor_pago, data_lancamento = :data_lancamento, descricao = :descricao, nome = :nome, vencimento = :vencimento, valor_parcial = :valor_parcial, saldotmp = :saldotmp, idp = :idp, uc = :uc, dc = :dc");
			$sqlp->bindValue(':id_company', $id_company);
			$sqlp->bindValue(':id_pagamento', $idpag);
			$sqlp->bindValue(':idp', $array['id']);
			$sqlp->bindValue(':fornecedor', $array['cliente']);
			$sqlp->bindValue(':valor', $array['saldo_credor']);
			$sqlp->bindValue(':juros', 0);
			$sqlp->bindValue(':desconto', 0);
			$sqlp->bindValue(':valor_pago', $valor);
			$sqlp->bindValue(':data_lancamento', $dtrec);
			$sqlp->bindValue(':descricao', $array['obsr']);
			$sqlp->bindValue(':nome', $array['nome_razao_social']);
			$sqlp->bindValue(':valor_parcial', 0);
			$sqlp->bindValue(':vencimento', $array['data']);
			$sqlp->bindValue(':saldotmp',  0);
			$sqlp->bindValue(':uc', $uc);
			$sqlp->bindValue(':dc', $dc);
			$sqlp->execute();


			$sqlU = $this->db->prepare("UPDATE areceber_parcelas SET fpgto = 'BOLETO', situacaos  = 'LIQUIDADO', saldo_credor = 0, data_rbto = :data_rbto, ua = :ua, da = :da, vpago = :vpago WHERE id = :id and id_company = :id_company");
			$sqlU->bindValue(':id', $array['id']);
			$sqlU->bindValue(':id_company', $id_company);
			$sqlU->bindValue(':data_rbto', $dtrec);
			$sqlU->bindValue(':ua', $uc);
			$sqlU->bindValue(':da', $dc);
			$sqlU->bindValue(':vpago', $valor);

			//data_pgto  = $data_pagamento, 
			$sqlU->execute();
			return '- BAIXA AUTOMATICA COM SUCESSO';
		} else {
			return '- NOSSO NUMERO JA BAIXADO OU NAO ENCONTRADO';
		}


		////////


		/////////
		//return $array;
	}

	public function updateNumeroInter($id_company, $id_parcela, $banco_inter_numero)
	{
		$sql = $this->db->prepare("UPDATE areceber_parcelas SET banco_inter_numero = :banco_inter_numero WHERE id = :id and id_company = :id_company");
		$sql->bindValue(':id', $id_parcela);
		$sql->bindValue(':id_company', $id_company);
		$sql->bindValue(':banco_inter_numero', $banco_inter_numero);
		$sql->execute();
	}

	public function getListareceberid($id_company, $nnumero, $cc, $dtrec, $valor, $uc, $dc)
	{
		$array = array();

		$sql = $this->db->prepare("SELECT * FROM vw_baixaboleto WHERE id_company = :id_company and id = '$nnumero' ");
		$sql->bindValue(':id_company', $id_company);
		//$sql->bindValue(':nnumero', $nnumero);
		$sql->execute();

		if ($sql->rowCount() > 0) {
			$array = $sql->fetch();

			//echo ;
			//exit;

			$sql = $this->db->prepare("INSERT INTO recebimento SET id_company = :id_company, conta = :conta, data_pagamento = :data_pagamento, tipo = :tipo, obs = :obs, situacao = :situacao");

			$sql->bindValue(':id_company', $id_company);
			$sql->bindValue(':conta', $cc);
			$sql->bindValue(':data_pagamento', $dtrec);
			$sql->bindValue(':tipo', '1');
			$sql->bindValue(':obs', 'BAIXA BOLETO ' . $nnumero);
			$sql->bindValue(':situacao', 'Liquidado');

			$sql->execute();

			//aqui pego o ultimo id 
			$idpag = $this->db->lastInsertId();

			$sqlp = $this->db->prepare("INSERT INTO recebimento_itens SET id_company = :id_company, id_pagamento = :id_pagamento, fornecedor = :fornecedor, valor = :valor, juros = :juros, desconto = :desconto, valor_pago = :valor_pago, data_lancamento = :data_lancamento, descricao = :descricao, nome = :nome, vencimento = :vencimento, valor_parcial = :valor_parcial, saldotmp = :saldotmp, idp = :idp, uc = :uc, dc = :dc");
			$sqlp->bindValue(':id_company', $id_company);
			$sqlp->bindValue(':id_pagamento', $idpag);
			$sqlp->bindValue(':idp', $array['id']);
			$sqlp->bindValue(':fornecedor', $array['cliente']);
			$sqlp->bindValue(':valor', $array['saldo_credor']);
			$sqlp->bindValue(':juros', 0);
			$sqlp->bindValue(':desconto', 0);
			$sqlp->bindValue(':valor_pago', $valor);
			$sqlp->bindValue(':data_lancamento', $dtrec);
			$sqlp->bindValue(':descricao', $array['obsr']);
			$sqlp->bindValue(':nome', $array['nome_razao_social']);
			$sqlp->bindValue(':valor_parcial', 0);
			$sqlp->bindValue(':vencimento', $array['data']);
			$sqlp->bindValue(':saldotmp',  0);
			$sqlp->bindValue(':uc', $uc);
			$sqlp->bindValue(':dc', $dc);
			$sqlp->execute();


			$sqlU = $this->db->prepare("UPDATE areceber_parcelas SET fpgto = 'BOLETO', situacaos  = 'LIQUIDADO', saldo_credor = 0, data_rbto = :data_rbto, ua = :ua, da = :da, vpago = :vpago WHERE id = :id and id_company = :id_company");
			$sqlU->bindValue(':id', $array['id']);
			$sqlU->bindValue(':id_company', $id_company);
			$sqlU->bindValue(':data_rbto', $dtrec);
			$sqlU->bindValue(':ua', $uc);
			$sqlU->bindValue(':da', $dc);
			$sqlU->bindValue(':vpago', $valor);

			//data_pgto  = $data_pagamento, 
			$sqlU->execute();
			return '- BAIXA AUTOMATICA COM SUCESSO';
		} else {
			return '- NOSSO NUMERO JA BAIXADO OU NAO ENCONTRADO';
		}


		////////


		/////////
		//return $array;
	} 

	public function getListareceberidSicoob($id_company, $nnumero, $cc, $dtrec, $valor, $uc, $dc)
	{
		$array = array();

		$sql = $this->db->prepare("SELECT * FROM vw_baixaboleto WHERE id_company = :id_company AND ABS(nnumero) = :nnumero");
		$sql->bindValue(':id_company', $id_company);
		$sql->bindValue(':nnumero', $nnumero, PDO::PARAM_INT);
		$sql->execute();

		if ($sql->rowCount() > 0) {
			$array = $sql->fetch();

			//echo ;
			//exit;

			$sql = $this->db->prepare("INSERT INTO recebimento SET id_company = :id_company, conta = :conta, data_pagamento = :data_pagamento, tipo = :tipo, obs = :obs, situacao = :situacao");

			$sql->bindValue(':id_company', $id_company);
			$sql->bindValue(':conta', $cc);
			$sql->bindValue(':data_pagamento', $dtrec);
			$sql->bindValue(':tipo', '1');
			$sql->bindValue(':obs', 'BAIXA BOLETO ' . $nnumero);
			$sql->bindValue(':situacao', 'Liquidado');

			$sql->execute();

			//aqui pego o ultimo id 
			$idpag = $this->db->lastInsertId();

			$sqlp = $this->db->prepare("INSERT INTO recebimento_itens SET id_company = :id_company, id_pagamento = :id_pagamento, fornecedor = :fornecedor, valor = :valor, juros = :juros, desconto = :desconto, valor_pago = :valor_pago, data_lancamento = :data_lancamento, descricao = :descricao, nome = :nome, vencimento = :vencimento, valor_parcial = :valor_parcial, saldotmp = :saldotmp, idp = :idp, uc = :uc, dc = :dc");
			$sqlp->bindValue(':id_company', $id_company);
			$sqlp->bindValue(':id_pagamento', $idpag);
			$sqlp->bindValue(':idp', $array['id']);
			$sqlp->bindValue(':fornecedor', $array['cliente']);
			$sqlp->bindValue(':valor', $array['saldo_credor']);
			$sqlp->bindValue(':juros', 0);
			$sqlp->bindValue(':desconto', 0);
			$sqlp->bindValue(':valor_pago', $valor);
			$sqlp->bindValue(':data_lancamento', $dtrec);
			$sqlp->bindValue(':descricao', $array['obsr']);
			$sqlp->bindValue(':nome', $array['nome_razao_social']);
			$sqlp->bindValue(':valor_parcial', 0);
			$sqlp->bindValue(':vencimento', $array['data']);
			$sqlp->bindValue(':saldotmp',  0);
			$sqlp->bindValue(':uc', $uc);
			$sqlp->bindValue(':dc', $dc);
			$sqlp->execute();


			$sqlU = $this->db->prepare("UPDATE areceber_parcelas SET fpgto = 'BOLETO', situacaos  = 'LIQUIDADO', saldo_credor = 0, data_rbto = :data_rbto, ua = :ua, da = :da, vpago = :vpago WHERE id = :id and id_company = :id_company");
			$sqlU->bindValue(':id', $array['id']);
			$sqlU->bindValue(':id_company', $id_company);
			$sqlU->bindValue(':data_rbto', $dtrec);
			$sqlU->bindValue(':ua', $uc);
			$sqlU->bindValue(':da', $dc);
			$sqlU->bindValue(':vpago', $valor);

			//data_pgto  = $data_pagamento, 
			$sqlU->execute();
			return '- BAIXA AUTOMATICA COM SUCESSO';
		} else {
			return '- NOSSO NUMERO JA BAIXADO OU NAO ENCONTRADO';
		}

	}
	
	public function getListareceber($id_company, $nnumero, $cc, $dtrec, $valor, $uc, $dc)
	{
		$array = array();

		$sql = $this->db->prepare("SELECT * FROM vw_baixaboleto WHERE id_company = :id_company and nnumero = '$nnumero' ");
		$sql->bindValue(':id_company', $id_company);
		//$sql->bindValue(':nnumero', $nnumero);
		$sql->execute();

		if ($sql->rowCount() > 0) {
			$array = $sql->fetch();

			//echo ;
			//exit;

			$sql = $this->db->prepare("INSERT INTO recebimento SET id_company = :id_company, conta = :conta, data_pagamento = :data_pagamento, tipo = :tipo, obs = :obs, situacao = :situacao");

			$sql->bindValue(':id_company', $id_company);
			$sql->bindValue(':conta', $cc);
			$sql->bindValue(':data_pagamento', $dtrec);
			$sql->bindValue(':tipo', '1');
			$sql->bindValue(':obs', 'BAIXA BOLETO ' . $nnumero);
			$sql->bindValue(':situacao', 'Liquidado');

			$sql->execute();

			//aqui pego o ultimo id 
			$idpag = $this->db->lastInsertId();

			$sqlp = $this->db->prepare("INSERT INTO recebimento_itens SET id_company = :id_company, id_pagamento = :id_pagamento, fornecedor = :fornecedor, valor = :valor, juros = :juros, desconto = :desconto, valor_pago = :valor_pago, data_lancamento = :data_lancamento, descricao = :descricao, nome = :nome, vencimento = :vencimento, valor_parcial = :valor_parcial, saldotmp = :saldotmp, idp = :idp, uc = :uc, dc = :dc");
			$sqlp->bindValue(':id_company', $id_company);
			$sqlp->bindValue(':id_pagamento', $idpag);
			$sqlp->bindValue(':idp', $array['id']);
			$sqlp->bindValue(':fornecedor', $array['cliente']);
			$sqlp->bindValue(':valor', $array['saldo_credor']);
			$sqlp->bindValue(':juros', 0);
			$sqlp->bindValue(':desconto', 0);
			$sqlp->bindValue(':valor_pago', $valor);
			$sqlp->bindValue(':data_lancamento', $dtrec);
			$sqlp->bindValue(':descricao', $array['obsr']);
			$sqlp->bindValue(':nome', $array['nome_razao_social']);
			$sqlp->bindValue(':valor_parcial', 0);
			$sqlp->bindValue(':vencimento', $array['data']);
			$sqlp->bindValue(':saldotmp',  0);
			$sqlp->bindValue(':uc', $uc);
			$sqlp->bindValue(':dc', $dc);
			$sqlp->execute();


			$sqlU = $this->db->prepare("UPDATE areceber_parcelas SET fpgto = 'BOLETO', situacaos  = 'LIQUIDADO', saldo_credor = 0, data_rbto = :data_rbto, ua = :ua, da = :da, vpago = :vpago WHERE id = :id and id_company = :id_company");
			$sqlU->bindValue(':id', $array['id']);
			$sqlU->bindValue(':id_company', $id_company);
			$sqlU->bindValue(':data_rbto', $dtrec);
			$sqlU->bindValue(':ua', $uc);
			$sqlU->bindValue(':da', $dc);
			$sqlU->bindValue(':vpago', $valor);

			//data_pgto  = $data_pagamento, 
			$sqlU->execute();
			return '- BAIXA AUTOMATICA COM SUCESSO';
		} else {
			return '- NOSSO NUMERO JA BAIXADO OU NAO ENCONTRADO';
		}


		////////


		/////////
		//return $array;
	} 

	public function getInfo($id, $id_company)
	{
		$array = array();

		$sql = $this->db->prepare("SELECT * FROM claro_movel WHERE id = :id AND id_company = :id_company ORDER BY nome");
		$sql->bindValue(':id', $id);
		$sql->bindValue(':id_company', $id_company);
		$sql->execute();

		if ($sql->rowCount() > 0) {
			$array = $sql->fetch();
		}

		return $array;
	}

	public function getCount($id_company)
	{
		$r = 0;

		$sql = $this->db->prepare("SELECT COUNT(*) as c FROM claro_movel WHERE id_company = :id_company ORDER BY nome");
		$sql->bindValue(':id_company', $id_company);
		$sql->execute();
		$row = $sql->fetch();

		$r = $row['c'];

		return $r;
	}

	public function add($id_company, $tel, $secao, $novaData, $hora, $origem, $numero, $duracao, $tarifa, $valor, $valor_c, $nome, $cc, $matricula, $subsecao, $imposto, $descricao, $cargo, $local_origem, $local_destino, $cod_origem, $cod_destino)
	{

		$sql = $this->db->prepare("INSERT INTO claro_movel SET id_company = :id_company, tel = :tel, secao = :secao, data = :data, hora = :hora, origem = :origem, numero = :numero, duracao = :duracao, tarifa = :tarifa, valor = :valor, valor_c = :valor_c, nome = :nome, cc = :cc, matricula = :matricula, subsecao = :subsecao, imposto = :imposto, descricao = :descricao, cargo = :cargo, local_origem = :local_origem, local_destino = :local_destino, cod_origem = :cod_origem, cod_destino = :cod_destino");

		$sql->bindValue(':id_company', $id_company);
		$sql->bindValue(':tel', $tel);
		$sql->bindValue(':secao', $secao);
		$sql->bindValue(':data', $novaData);
		$sql->bindValue(':hora', $hora);
		$sql->bindValue(':origem', $origem);
		$sql->bindValue(':numero', $numero);
		$sql->bindValue(':duracao', $duracao);
		$sql->bindValue(':tarifa', $tarifa);
		$sql->bindValue(':valor', $valor);
		$sql->bindValue(':valor_c', $valor_c);
		$sql->bindValue(':nome', $nome);
		$sql->bindValue(':cc', $cc);
		$sql->bindValue(':matricula', $matricula);
		$sql->bindValue(':subsecao', $subsecao);
		$sql->bindValue(':imposto', $imposto);
		$sql->bindValue(':descricao', $descricao);
		$sql->bindValue(':cargo', $cargo);
		$sql->bindValue(':local_origem', $local_origem);
		$sql->bindValue(':local_destino', $local_destino);
		$sql->bindValue(':cod_origem', $cod_origem);
		$sql->bindValue(':cod_destino', $cod_destino);
		$sql->execute();
	}

	public function edit($id, $id_company, $nome)
	{

		$sql = $this->db->prepare("UPDATE claro_movel SET nome = :nome WHERE id = :id AND id_company = :id_company");

		$sql->bindValue(':id', $id);
		$sql->bindValue(':id_company', $id_company);
		$sql->bindValue(':nome', $nome);
		$sql->execute();
	}

	public function delete($id, $id_company, $id_user)
	{
		$sql = $this->db->prepare("DELETE FROM claro_movel WHERE id =:id AND id_company = :id_company");
		$sql->bindValue(':id', $id);
		$sql->bindValue(':id_company', $id_company);
		$sql->execute();
	}
}
