<?php
namespace Models;
use Core\Model;
use PDO;

class ReportLead extends Model {

public function __construct(){	
 //criando pdf object
  $this->pdf = new \Fpdf("L", "mm", array(210,297));
  $this->pdf->SetMargins(5,5,5,5);
}

public function gerar($campos, $header){

$this->cabecalho();
$this->conteudo($campos, $header);
$this->rodape();
}//gerar


public function cabecalho(){
$this->pdf->AddPage();

//setando a fonte b negrito, i italico, u sublinhado
$this->pdf->setFont('Arial', 'B', 16);

$this->pdf->Cell(285,10, utf8_decode('Relatório de Leads'),0,1,'C');
$this->pdf->setFont('Arial', '', 10);

$this->pdf->Ln(5); // line break
}//cabecalho


public function conteudo($dados, $filtro){
//echo '<pre>';
//print_r($dados);
//exit;

$this->pdf->SetFont('Arial', 'B', 6);

$this->pdf->MultiCell(285,5, utf8_decode('Origens:'.$filtro['origem']),0,'C',false);
//$this->pdf->Ln(5); // line break
$this->pdf->MultiCell(285,5, utf8_decode('Produtos:'.$filtro['produto']),0,'C',false);
$this->pdf->MultiCell(285,5, utf8_decode('Funil:'.$filtro['funil']),0,'C',false);
//$this->pdf->Ln(5); // line break
$this->pdf->Cell(285,5, utf8_decode('Data:'.$filtro['datas']),0,1,'C');
$this->pdf->Cell(285,5, utf8_decode("Emissão: ".date('d/m/Y H:i')),0,1,'C');
$total_geral = 0;

foreach($dados as $key=>$linhas){

$this->pdf->SetFont('Arial', 'B', 10);
$this->pdf->SetFillColor(0,0,0);
$this->pdf->SetTextColor(255,255,255);
$this->pdf->Cell(285, 10, utf8_decode($key), 1,1, 'L', true);
$this->pdf->SetFont('Arial', 'B', 8);
$this->pdf->SetTextColor(0,0,0);

$this->pdf->SetFont('Arial', 'B', 10);
$this->pdf->SetTextColor(0,0,0);
$this->pdf->Cell(40, 10, utf8_decode('Nome'), 1,0, 'L', false);
$this->pdf->Cell(35, 10, utf8_decode('Produto'), 1,0, 'L', false);
//$this->pdf->Cell(50, 10, utf8_decode('E-mail'), 1,0, 'L', false);
$this->pdf->Cell(25, 10, utf8_decode('Telefone'), 1,0, 'L', false);
$this->pdf->Cell(30, 10, utf8_decode('Origem'), 1,0, 'L', false);
$this->pdf->Cell(50, 10, utf8_decode('Funil'), 1,0, 'L', false);
$this->pdf->Cell(25, 10, utf8_decode('Data entrada'), 1,0, 'L', false);
$this->pdf->Cell(25, 10, utf8_decode('Status'), 1,1, 'L', false);

$conta = 0;
foreach($linhas as $linha){

$this->pdf->SetFont('Arial', '', 7);
$this->pdf->SetTextColor(0,0,0);
$this->pdf->Cell(40, 10, utf8_decode($this->limitaTexto($linha->nome,'25')), 1,0, 'L', false);
$this->pdf->Cell(35, 10, utf8_decode($this->limitaTexto($linha->produto,'25')), 1,0, 'L', false);
//$this->pdf->Cell(50, 10, utf8_decode($linha->email), 1,0, 'L', false);
$this->pdf->Cell(25, 10, utf8_decode($linha->telefone), 1,0, 'L', false);
$this->pdf->Cell(30, 10, utf8_decode($linha->origem), 1,0, 'L', false);
$this->pdf->Cell(50, 10, utf8_decode($linha->nome_funil), 1,0, 'L', false);
$this->pdf->Cell(25, 10, utf8_decode(date('d/m/Y',strtotime($linha->data_entrada))), 1,0, 'L', false);
$this->pdf->Cell(25, 10, utf8_decode($linha->status), 1,1, 'L', false);
$conta++;
}
$total_geral += $conta;

$this->pdf->SetFillColor(220,220,220);
$this->pdf->SetFont('Arial', 'B', 11);
$this->pdf->Cell(285,10,'Quantidade: '.$conta,1,1,'L',true);
}

$this->pdf->Ln(10); // line break
$this->pdf->SetFillColor(220,220,220);
$this->pdf->SetFont('Arial', 'B', 11);
$this->pdf->Cell(285,10,'Quantidade geral: '.$total_geral,1,1,'L',true);
}//conteudo

function limitaTexto($string, $words = '100'){
$string = strip_tags($string);
$count = strlen($string);

if($count <= $words){
    return $string;
    }else{
        $strpos = strrpos(substr($string, 0, $words), ' ');
        return substr($string,0, $strpos).'...';
        }   
}

public function rodape(){
$path = "recibos/".time()."recibo.pdf";
$this->pdf->Output($path, 'F');
$this->pdf->Output();
}//rodape

}