<?php
namespace Models;
use Core\Model;
use Models\Permissao;
use PDO;

/** Classe para Usuários */
class Users extends Model {

	/**Guarda os dados(informação) do usuário*/
	private $info;
	private $uid;	
	private $userName;
	private $slug;	
	private $userImage;
	private $tipo;
	private $produtor_id;
	private $ramal;

public function isLogged(){

if(!empty($_SESSION['token'])){
	$token = $_SESSION['token'];
	$sql = "SELECT id_manager,id_usuario, nome, slug, tipo, ramal, campanha, equipe FROM usuarios WHERE loginhash = :token";
	$sql = $this->db->prepare($sql);
	$sql->bindValue(":token", $token);
	$sql->execute();

	if($sql->rowCount() >0){
       $p = new Permissao();

		$data = $sql->fetch();
		$this->uid       = $data->id_usuario;
		$this->userName  = $data->nome;
		$this->slug      = $data->slug;
		$this->tipo      = $data->tipo;		
		$this->ramal     = $data->ramal;
		$this->campanha     = $data->campanha;
		$this->equipe     = $data->equipe;
		$this->id_manager     = $data->id_manager;

		return true;
	}
}

return false;
}//isLogged



public function getUid(){

if(!empty($_SESSION['token'])){
$token = $_SESSION['token'];
$sql = "SELECT id_usuario FROM usuarios WHERE loginhash = :token";

$sql = $this->db->prepare($sql);
$sql->bindValue(":token", $token);
$sql->execute();

if($sql->rowCount() >0){
	$data = $sql->fetch();
	return $data->id_usuario;
}

}
}//getUid



public function validateLogin($email, $senha){	

$sql = "SELECT id_usuario, senha FROM usuarios WHERE email = :email";

$sql = $this->db->prepare($sql);
$sql->bindValue(':email', $email);
$sql->execute();

if($sql->rowCount() >0){
 $data = $sql->fetch();

 if(password_verify($senha, $data->senha)){ 	
  $token = md5(time().rand(0,999).$data->id_usuario.time());

  $sql = "UPDATE usuarios SET loginhash = :token WHERE id_usuario = :id";
  $sql = $this->db->prepare($sql);
  $sql->bindValue(":token", $token);
  $sql->bindValue(":id", $data->id_usuario);
  $sql->execute();

  $_SESSION['token'] = $token;
 return true; 
 }//verifica a senha 
}

return false;
}//validateLogin


public function getName(){
   return $this->userName;
}//getName

public function getSlug(){
   return $this->slug;
}//getName

public function getImg(){
	return $this->userImage;
}
public function getTipo(){
	return $this->tipo;
}

public function getImage(){
return $this->userImage;
}//getImage

public function getId(){
 return $this->uid;
}//getId

public function id_manager(){
	return $this->id_manager;
   }//getId

public function campanha(){
	return $this->campanha;
   }//getcampanha

public function equipe(){
	return $this->equipe;
}//getcampanha

public function getramal(){
	return $this->ramal;
}//getramal

public function getIdProdutor(){
 return $this->produtor_id;
}//getId


public function userExists($u){

$sql = "SELECT * FROM usuarios WHERE email = :u";
$sql = $this->db->prepare($sql);
$sql->bindValue(":u",$u);
$sql->execute();

if($sql->rowCount() >0){
   return true;
}else{
   return false;
}

}//userExists

public function getInfo($id){
 $array = array();

$sql = $this->db->prepare("SELECT * FROM usuarios WHERE email = :email ");
$sql->bindValue(':email', $id);
$sql->execute();

if($sql->rowCount()>0){
	$array = $sql->fetch();
}

  return $array;
}// function getInfo


}