<?php
namespace Models;
use \Core\Model;
use Models\Flashmessage;
use PDO;

class Validate extends Model{

private $flash;

public function __construct(){
  $this->flash = new Flashmessage();

} 

public function validate(array $validations, $persistInputs = false){
$result = [];
$param = '';
foreach($validations as $field =>$validate){

$result[$field] = (!mb_strpos($validate, '|')) ?
   $this->singleValidation($validate, $field, $param) : 
   $this->multipleValidations($validate, $field, $param);
}

if ($persistInputs) {
      $_SESSION['old'] = $_POST ?? [];
    }

if(in_array(false, $result, true)){
  return false;
}

return $result;
}//validate

function singleValidation($validate, $field, $param){

if(mb_strpos($validate, ':')){
  [$validate, $param] = explode(":", $validate);
}
  return $this->$validate($field, $param);
}//singleValidation


function multipleValidations($validate, $field, $params){
$explodePipeValidate = explode("|", $validate);
$result = [];
foreach($explodePipeValidate as $validate){
  if(mb_strpos($validate, ':')){
       [$validate, $params] = explode(":", $validate);
  } 

    $result[$field] = $this->$validate($field, $params);

    if(isset($result[$field]) and $result[$field] === false){
      break;
  }
}

return $result[$field];
}//multipleValidations




function required($field){
$field = addslashes(trim($_POST[$field]));

if(isset($_POST[$field]) && empty($_POST[$field])){
$this->flash->setFlash($field, "O campo é obrigatório");
return false;
}

return $field;
}//required

function email($field){  
$emailIsValid = addslashes(trim($_POST[$field]));
if(!$emailIsValid){
$this->flash->setFlash($field, "O campo tem que ser um email valido");
return false;
}

return $emailIsValid;
}//email



function unique($field, $param){
$data = strip_tags(trim($_POST[$field]));


if(strpos($param,'-')){
  $explode = explode('-', $param);
  $tabela = $explode[0];
  $campo = $explode[1];
}

if(isset($_POST[$campo])){
 $item = (new Orm($tabela))->select('*')
->wherecustom("$field = '$data' AND {$campo} != $_POST[$campo]")
->first()->get();
}else{
$item = (new Orm($tabela))->select('*')
->wherecustom("$field = '$data'")
->first()->get();
}

if(!empty($item)){
$this->flash->setFlash($field, "Esse valor já está cadastrado!");
return false;
}

return $data;
}//unique

function maxlen($field, $param){
$data = filter_input(INPUT_POST, $field, FILTER_SANITIZE_STRING);

if(strlen($data) > $param){
$this->flash->setFlash($field, "Esse campo não pode passar de {$param} caracteres");
return false;
}

return $data;
}//maxlen

public function senha($field, $param){
$data = addslashes(trim($_POST[$field]));


if(isset($_POST[$field]) && !empty($_POST[$field])){
  return $data;
// $senha = password_hash($data, PASSWORD_DEFAULT);
// return $senha;
}

if(strpos($param,'-')){
  $explode = explode('-', $param);
  $tabela = $explode[0];
  $campo = $explode[1];
  $valor = $explode[2];

$reg = (new Orm($tabela))->select([$field])
->where([$campo, $valor])->first()->get();

if(!empty($reg)){
return $reg->$field; 
}
}


return null;
}//senha


function minlen($field, $param){
$data = filter_input(INPUT_POST, $field, FILTER_SANITIZE_STRING);

if(strlen($data) <= $param){
$this->flash->setFlash($field, "Esse campo não pode ter menos de {$param} caracteres");
return false;
}

return $data;
}//minlen


function slug($field, $param){

if(strpos($param,'-')){
  $explode = explode('-', $param);
  $tabela = $explode[0];
  $campo = $explode[1];

  if($campo == 'decode'){
   $valor = urldecode($_POST[$tabela]);
   $slug = $this->makeSlug($valor);
   return $slug;
  }
}


$slug = $this->makeSlug($_POST[$param]);
return $slug;
}//slug

function md5($field){
$data = addslashes(trim($_POST[$field]));
return md5($data);
}


public function makeSlug($Name){
$this->Format = array();
$this->Format['a'] = 'ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜüÝÞßàáâãäåæçèéêëìíîïðñòóôõöøùúûýýþÿRr"!@#$%&*()_-+={[}]/?;:.,\\\'<>°ºª';  
$this->Format['b'] = 'aaaaaaaceeeeiiiidnoooooouuuuuybsaaaaaaaceeeeiiiidnoooooouuuyybyRr                                 ';
$this->Data = strtr(utf8_decode($Name), utf8_decode($this->Format['a']), utf8_decode($this->Format['b']));  
$this->Data = strip_tags(trim($this->Data));

$this->Data = str_replace(' ','-', $this->Data);
$this->Data = str_replace(array('-----', '----', '---','--'),'-', $this->Data);

return strtolower(utf8_encode($this->Data));
}//fim function name


function data($field, $param){

if(!isset($_POST[$field]) && $param == null){
  return date('Y-m-d');
}

if(isset($_POST[$field]) && $_POST[$field] == ''){
   return null;
}

if(!isset($_POST[$field]) && $param !== null){
if(strpos($param,'-')){
  $explode = explode('-', $param);
  $tabela = $explode[0];
  $coluna = $explode[1];
}

$item = (new Orm($tabela))->select([$field])
->wherecustom("$coluna = $_POST[$coluna]")
->first()->get();
return $item->$field;
}

if(isset($_POST[$field]) && $param == null){
  $novaData = explode('/', $_POST[$field]);
  $novaData = $novaData[2].'-'.$novaData[1].'-'.$novaData[0];

  return $novaData;
}
}//data

public function hora($field, $param){

//quando a data vem por ajax
if(isset($_POST[$field]) && $param == 'decode'){
$dt = urldecode($_POST[$field]);
$novaData = explode(':', $dt);
$novaData = $novaData[0].':'.$novaData[1];
return $novaData;
}

if(isset($_POST[$field]) && $_POST[$field] == ''){
  return null;
}

return date('H:i', strtotime($_POST[$field]));
}

public function converterData($data, $pattern = '-'){  
     if($data == NULL){
       return NULL;
     }   
       $novaData = explode($pattern, $data);
       $novaData = $novaData[2].'-'.$novaData[1].'-'.$novaData[0];
       return $novaData;
}//converterData


public function valor($valor) {
       $verificaPonto = ".";
       if(strpos("[".$valor."]", "$verificaPonto")):      
           $valor = str_replace('.','', $valor);
           $valor = str_replace(',','.', $valor);
           else:            
             $valor = str_replace(',','.', $valor);   
       endif;

       return $valor;
}//valor

function definido($field,$param){
  return $param;
}//definido


public function decode($field, $param){
$conteudo = urldecode($_POST[$field]);

return strip_tags(trim($conteudo));
}//decode


public function null($field){

if(!isset($_POST[$field]) || empty($_POST[$field])){
 return null;
}

return strip_tags(trim($_POST[$field]));

}//null


public function anexos($field, $param){
$files = '';

$anexos = (isset($_POST[$field])) ? $_POST[$field] : '';

 if($anexos != '' && $_POST[$param] == null){
  $files = $this->gravaAnexos($anexos);  
  $files = $files['files'];
  return $files;
 }

  if($anexos != '' && $_POST[$param] != null){ 
  $files = $this->atualizaAnexos($_POST[$param], $anexos);  
  return $files;
  }
}//anexos

public function gravaAnexos($anexo){
$retorno = '';

if($anexo !== ""){
$diretorio = 'medias';

$anexos_array = array();
$anexos = json_decode($anexo, true);

foreach($anexos as $key=>$value){

$separarAnexo = explode(';', $value);
$separarBase64 = explode(",", $separarAnexo[1]);

switch($separarAnexo[0]){
 case 'data:application/vnd.openxmlformats-officedocument.spreadsheetml.sheet':
 case 'data:application/vnd.ms-excel':

 $aleatorio = time()."_".md5(mt_rand(10000,99999));
 $rota = $diretorio."/".$aleatorio.".xlsx";
 $arquivo = base64_decode($separarBase64[1]);
 file_put_contents($rota, $arquivo);

 array_push($anexos_array, $rota);

 break;

 case 'data:application/vnd.openxmlformats-officedocument.wordprocessingml.document':
 case 'data:application/msword':
 $aleatorio = time()."_".md5(mt_rand(10000,99999));
 $rota = $diretorio."/".$aleatorio.".docx";
 $arquivo = base64_decode($separarBase64[1]);
 file_put_contents($rota, $arquivo);

 array_push($anexos_array, $rota);
 break;

 case 'data:application/pdf':
 $aleatorio = time()."_".md5(mt_rand(10000,99999));
 $rota = $diretorio."/".$aleatorio.".pdf";
  $arquivo = base64_decode($separarBase64[1]);
 file_put_contents($rota, $arquivo);

 array_push($anexos_array, $rota);
 break;

 case 'data:image/jpeg':
 case 'data:image/jpg':
 $aleatorio = time()."_".md5(mt_rand(10000,99999));
 $rota = $diretorio."/".$aleatorio.".jpeg";
  $arquivo = base64_decode($separarBase64[1]);
 file_put_contents($rota, $arquivo);

 array_push($anexos_array, $rota);
 break;

 case 'data:image/png':
 $aleatorio = time()."_".md5(mt_rand(10000,99999));
 $rota = $diretorio."/".$aleatorio.".png";
  $arquivo = base64_decode($separarBase64[1]);
 file_put_contents($rota, $arquivo);

 array_push($anexos_array, $rota);
 break;

 default:
 $retorno = array(
'error'=>1,
'msg'=>'Não se permitem formatos diferentes a JPG, PNG, Word, Excel, Pdf',
'files'=>NULL
 );

 return $retorno;
 break;

}//switch
}//finaliza o foreach

$retorno = array(
'error'=>0,
'msg'=>"Upload feito com sucesso",
'files'=>json_encode($anexos_array)
);

return $retorno;
}
}//gravaAnexos


public function atualizaAnexos($ref, $anexos){
$dados = array();
$old = (new Orm('veiculos'))->select(['anexos'])
->where(['id_veiculo', $ref])->first()->get(); 

//editando anexo
if(!empty($anexos)){

//pegando as imagens anteriores
if(!empty($old->anexos)){
$arquivo = json_decode($old->anexos, true);

  foreach($arquivo as $arq){
      array_push($dados, $arq);  
  }
}

//agora pegando as novas imagens
$novos = $this->gravaAnexos($anexos);
$files = json_decode($novos['files'], true);
foreach($files as $file){
  array_push($dados, $file);
}

 $dados = json_encode($dados);
}else{//se teve post de imagens
  $dados = $old->anexos;
}

return $dados;
}//atualizaAnexos

public function imagem($field, $param){

if(isset($_FILES[$field]) && $_FILES[$field]['name'] != ''){
  if($this->imagemValida($_FILES[$field])){
   $imagem =  $this->gravarImagem($_FILES[$field], array(680,400), DIR);
   $imagem = BASE.$imagem;
   return $imagem;
  }else{
   $this->flash->setFlash($field, "Imagem Inválida!");
   return false;
  }  
}
//se nao teve post da imagem busco a imagem do registro e trago
if(strpos($param,'-')){
  $explode = explode('-', $param);
  $tabela  = $explode[0];
  $indice  = $explode[1];
  $valor   = $explode[2];

$reg = (new Orm($tabela))->select([$field])
->where([$indice, $valor])->first()->get();

if(!empty($reg)){
return $reg->$field; 
}

return null; 
}

}//imagem


public function imagemValida($imagem){
 
if($imagem['type'] == 'image/jpeg' ||
    $imagem['type'] == 'imagem/jpg' ||
    $imagem['type'] == 'imagem/png' ||
    $imagem['type'] == 'image/png' ||
    $imagem['type'] == 'imagem/gif'){

$tamanho = intval($imagem['size']/1024);

if($tamanho < 2097152){
 return true;
}else{
  return false;
}   

}else{
   return false;
 }
}//imagemValida

public function gravarImagem($imagem, $dimensoes, $path){
//criamos a pasta caso ela n exista ainda
if(!file_exists($path)){
  mkdir($path, 0755);
}

$image = $imagem['tmp_name'];
$ext = pathinfo($imagem['name'], PATHINFO_EXTENSION);
//criamos o nome da imagem
$aleatorio = time()."_".md5(mt_rand(10000,99999));
$rota = $path.$aleatorio.'.'.$ext;

list($largura_original, $altura_original) = getimagesize($image);
$ratio = $largura_original / $altura_original;
// $novaLagura = 680;
// $novaAltura = 400;
$largura = $dimensoes[0];
$altura = $dimensoes[1];

if($largura / $altura > $ratio){
  $largura = $altura* $ratio;
}else{
  $altura = $largura / $ratio;
}

//verificando os tipos de imagens
switch($ext){
case 'jpeg':
case 'jpg':
$origem = imagecreatefromjpeg($image);
$destino = imagecreatetruecolor($largura, $altura);
imagecopyresized($destino, $origem, 0, 0, 0, 0, $largura, $altura, $largura_original, $altura_original);
imagejpeg($destino, $rota); 

imagedestroy($destino);

return $aleatorio.".".$ext;
break;

case 'png':
$origem = imagecreatefrompng($image);
$destino = imagecreatetruecolor($largura, $altura);
imagealphablending($destino, FALSE);
imagesavealpha($destino, TRUE);
imagecopyresampled($destino, $origem, 0, 0, 0, 0, $largura, $altura, $largura_original, $altura_original);
imagepng($destino, $rota);

imagedestroy($destino);
return $aleatorio.".".$ext;
break;

case 'gif':
$nomeImagem = md5(mt_rand(100,999).time()).'.gif';
move_uploaded_file($image,  $dir.$nomeImagem);
return $nomeImagem;   
break;
}

}//gravarImagem


}