<?php
$nome = $info->nome ?? '';
$email = $info->email ?? '';
$contato = $info->contato ?? '';
$tipo   = $info->tipo ?? '';
$status = $info->status ?? '';
$observacao = $info->observacao ?? '';
?>
<section class="page">  

<div class="page-header">
<div class="page-header-title">
<h2>Editar usuário</h2>

<div class="botoes">
   <button type="button" class="btn btn-info"><a href="<?php echo BASE_URL;?>usuarios"><i class="fa fa-chevron-left"></i> Voltar</a></button>
</div><!-- botoes -->
</div><!-- page header title-->
</div><!-- page header -->

<div class="page-body">


<form method="post" id="form" enctype="multipart/form-data" class="form" action="<?php echo BASE_URL."usuarios/edit_action/".$id_usuario;?>">
    
<div class="group-form w30">
  <label>Nome:</label>
  <input type="text" name="nome" placeholder="Informe o nome completo" value="<?php echo $nome;?>" />
</div><!-- input wrapper--> 

<div class="group-form w30">
  <label>E-mail:</label>
  <input type="email" name="email" required="required" placeholder="example@example.com" value="<?php echo $email;?>" />
</div><!-- input wrapper--> 

<div class="group-form w30">
  <label>Contato:</label>
  <input type="text" name="contato" class="phone" placeholder="(99) 9999-9999" value="<?php echo $contato;?>" />
</div><!-- input wrapper-->

<div class="group-form w30">
  <label>Senha:</label>
  <input type="password" name="senha" minlength="4" maxlength="12" placeholder="******" />
</div><!-- input wrapper-->

<div class="group-form w30">
<label>Perfil:</label>
<select name="tipo">
 <option value="<?php echo $tipo;?>"><?php echo $tipo;?></option> 

 <option value="Super Admin" <?php echo ($tipo == 'Super Admin') ? 'selected':'';?>>Super Admin</option> 
 <option value="Produtor" <?php echo ($tipo == 'Produtor') ? 'selected':'';?>>Produtor</option> 
 <option value="Prevenda" <?php echo ($tipo == 'Prevenda') ? 'selected':'';?>>Prevenda</option> 
 <option value="Externo" <?php echo ($tipo == 'Externo') ? 'selected':'';?>>Externo</option> 
</select>
</div>


<div class="group-form w30">
<label>Status:</label>
<select name="status">
  <option value="A" <?php echo ($status == 'A') ? 'selected':'';?>>Ativo</option>
  <option value="I" <?php echo ($status == 'I') ? 'selected':'';?>>Inativo</option>
</select>
</div>

<div class="box-container"> 
<div class="box-header">
<h2>Produtos</h2>

<div class="inputall">
  <label><input name="produtos" class="marcarTodos3" onclick="selectAll3()" type="checkbox" value="s">Marcar</label>  
  <label><input name="produtos" class="desmarcarTodos3" onclick="deselectAll3()" type="checkbox" value="n">Desmarcar</label>
</div>

</div><!-- box header-->

<div class="box-content" style="flex-wrap: wrap;max-height: 300px;overflow-y: auto;">

<?php foreach($produtos as $produto):?>
<div class="group-form w25" style="flex-wrap: wrap;">
<label style="font-size:.7em;">
<input style="margin-right: 3px;vertical-align: top;" type="checkbox" name="produto[]" class="inputCheck3" value="<?php echo $produto->nome_produto;?>">
<?php echo $produto->nome_produto;?></label> 
</div>
<?php endforeach;?>
</div><!-- box content-->  


</div><!-- box container -->


</div>

<div class="group-form w100">
<label>Observações:</label>
<textarea name="observacao"><?php echo $observacao;?></textarea>
</div><!-- input wrapper--> 
<h2>Permisões</h2>
<?php foreach($infoproduto as $produto):?>
<div class="group-form w25" style="flex-wrap: wrap;">
<label style="font-size:.7em;">
<?php echo $produto->produto;?></label> 
</div>
<?php endforeach;?>

<div class="group-form w100">
  <input type="hidden" name="id_usuario" value="<?php echo $id_usuario;?>">
  <input type="submit" name="submit" class="btn" value="Atualizar" />
</div><!-- input wrapper-->  
   
</form>
</div><!-- page body -->
</section><!--  page -->

<script>
 $(document).ready(function(){   
  $('#form').parsley();
 }); 
</script>

<script>
function selectAll3(){
  document.querySelector('.desmarcarTodos3').checked = false;  
  let inputCheck = document.querySelectorAll(".inputCheck3");
  let inputCheckTamanho = inputCheck.length;
  for(var x = 0;x <inputCheckTamanho;x++){
  inputCheck[x].checked = true;
  }
}

function deselectAll3(){
  document.querySelector('.marcarTodos3').checked = false;
  let inputCheck = document.querySelectorAll(".inputCheck3");
  let inputCheckTamanho = inputCheck.length;
  for(var x = 0;x <inputCheckTamanho;x++){
  inputCheck[x].checked = false;
  }
}
</script>