var form_contrato = `
<form name="beneficiarioForm" class="form" method="post" id="form_beneficiario">

<input type="hidden" name="idBeneficiario" value="0">
<input type="hidden" name="idConvenio" value="1438">
<input type="hidden" name="ativo" value="0">
<input type="hidden" name="index" value="0">
<input type="hidden" name="migracao" value="0">

<div class="group-form w50">
<label>Nome do Beneficiário*</label>
<input type="text" name="nome" id="nome" required maxlength="200" class="input" autocomplete="off">
</div>

<div class="group-form w50">
<label>Tipo de Beneficiário*</label>
<select name="idTipoBeneficiario" required class="input" id="idTipoBeneficiarioSelect">
<option value=""></option>
<option value="Titular">Titular</option>
<option value="Dependente">Dependente</option>
<option value="Agregado">Agregado</option></select>
</div>

<div class="group-form w30">
<label>Data de Nascimento*</label>
<input type="text" name="dataNascimento" onkeyup="maskData(this)" id="data_nasc" maxlength="10" class="input" autocomplete="off">
</div>

<div class="group-form w30">
<label>CPF</label>
<input type="text" onkeyup="maskCpf(this)" name="cpf" maxlength="11" id="cpf" class="cpf input" autocomplete="off">
</div>

<div class="group-form w30">
<label>Estado Civil*</label>
<select name="idEstadoCivil" id="idEstadoCivil" class="input">
<option value=""></option>
<option value="Casado">Casado</option>
<option value="Divorciado">Divorciado</option>
<option value="Separado">Separado</option>
<option value="Solteiro">Solteiro</option>
<option value="Viúvo">Viúvo</option></select>
</div>

<div class="group-form w50">
<label>Sexo*</label>
<select name="idSexo" id="sexo" class="input">
<option value=""></option>
<option value="Masculino">Masculino</option>
<option value="Feminino">Feminino</option></select>
</div>


<div class="group-form w50">
<label>Prentesco*</label>    
<select name="idParentesco" id="idParentesco" class="input" required>
<option value=""></option>
<option value="Titular">Titular</option>
<option value="Agregado">Agregrado</option>
<option value="Companheiro">Companheiro</option>
<option value="Cônjugue">Cônjugue</option>
<option value="Filho(a)">Filho(a)</option>
<option value="Filho(a) Adotivo">Filho Adotivo</option>
<option value="Irmão">Irmão</option>
<option value="Mãe">Mãe</option>
<option value="Pai">Pai</option>
<option value="Neto">Neto</option>
<option value="Sobrinho">Sobrinho</option>
<option value="Sogro">Sogro</option>
<option value="Enteado">Enteado</option>
<option value="Tutelado">Tutelado</option>
<option value="Sogra">Sogra</option></select>
</div>


<div class="group-form w50">
<label>Marca Óptica</label>
<input type="text" name="marcaOptica"id="marcaOptica" maxlength="30" class="input" autocomplete="off">
</div>

        
<div class="group-form w50">
<label>Carência</label>
<input type="text" name="carencia" id="carencia" maxlength="100" class="input" autocomplete="off">
</div>
            
</form>
`;

$('.btn_beneficiario').click(function(){
showModal("Incluir Beneficiário", `${form_contrato}`, 
  [{
    label: "Cadastrar", 
    form:"form-checkout",
    onClick: (modal) => {

      var form = $('#form_beneficiario').serialize();
      var vazios = 0;
      let inputs = $('.input');


      for(var i = 0;i<inputs.length;i++){
        let required = $(inputs[i]).attr('required');     
        let vlr      = $(inputs[i]).val();       
      
        if(required == 'required' && vlr == ''){
          $(inputs[i]).css({'border':'1px solid tomato','background':'#ffdddd'});
          vazios += 1;
        }
      }

      if(vazios >0){
        console.log('existem campos obrigatorios a serem preenchidos');
        return;
      }

     let nome        = $("#nome").val(); 
     let tipo        = $('#idTipoBeneficiarioSelect').val(); 
     let nasc        = $('#data_nasc').val();
     let cpf         = $('#cpf').val();   
     let estadoCivil = $('#idEstadoCivil').val();
     let sexo        = $('#sexo').val();
     let parentesco  = $('#idParentesco').val();
     let marcaOptica = $('#marcaOptica').val();
     let carencia    = $('#carencia').val();
    
     let template = `
       <tr>
       <td><input type="text" name="nome_b[]" value="${nome}" readonly/></td>
       <td><input type="text" name="tipo_b[]" value="${tipo}" readonly/></td>
       <td><input type="text" name="parentesco_b[]" value="${parentesco}" readonly/></td>
       <td>
       <input type="hidden" name="nasc_b[]" value="${nasc}"/>
       <input type="hidden" name="cpf_b[]" value="${cpf}"/>
       <input type="hidden" name="estadoCivil_b[]" value="${estadoCivil}"/>
       <input type="hidden" name="sexo_b[]" value="${sexo}"/>   
       <input type="hidden" name="marcaOptica_b[]" value="${marcaOptica}"/>
       <input type="hidden" name="carencia_b[]" value="${carencia}"/>
       <button type="button" onclick="removerTr(this)" class="btn btn-error">Excluir</button>
       </td>
       </tr>
     `;

     $('#table_beneficiario').append(template);
     setTimeout(function(){
       $('div.modal').remove();  
     },250);     
     
    },
    triggerClose: false
  },
  {
    label: "Cancelar",
    onClick: (modal) => {
      console.log("DECLINED.");
    },
    triggerClose: true
  }]);
});

function removerTr(obj){
  $(obj).closest('tr').remove();
}

function maskCpf(obj){
$(obj).mask('000.000.000-00');
}

function maskData(obj){
$(obj).mask('00/00/0000');
}

function maskMoney(obj){
$(obj).mask('000.000.000.000.000,00', {reverse: true}); 
}