<?php
namespace models;
use Core\Model;
use Models\Ormbuilder;
use Models\Selectpaginatebuilder;
use PDO;

Class Orm extends Model{

private $tabela;
private $sql;
private $dados = array();
private $error = array();
private $debug;

private $select;
private $del;
private $save;
private $set;

private $first;
private $where;
private $wherecustom;
private $in;
private $isNull;
private $isNotNull;
private $e;
private $between;
private $ou;
private $join;
private $on;
private $search;
private $orSearch;
private $order;
private $group;
private $limit;
private $total;
private $paginate;
private $selectToPaginate;
private $conditionsPaginate;
private $selectPaginateBuilder;
private $isSerch;


public function __construct($tabela){
  $this->tabela = $tabela;
  parent::__construct();	
}//construtor

public function select($select){
$this->select = $select;

return $this;
}//select

public function search(...$search){	

	if($search[0][1] != '' ){
		$this->search = $search;
	}	
	return $this;
}//search


public function orSearch(...$orSearch){
$retorno = [];

foreach($orSearch as $key=>$orsearch){
   if($orsearch[1] != ''){
    $retorno[] = $orsearch;
   }
}	

$this->orSearch = $retorno;
return $this;
}//orSearch

public function where(...$where){
	$this->where = $where;
	return $this;
}//where


public function in(...$in){
$this->in = $in;
return $this;
}//in


public function wherecustom($where){
	$this->wherecustom = $where;
	return $this;
}//wherecustom

public function isnull($isnull){	
	$this->isNull = $isnull;
	return $this;
}

public function isnotnull($isnotnull){
	$this->isNotNull = $isnotnull;
	return $this;
}

public function e(...$and){
$retorno = [];

foreach($and as $key=>$an){
if(count($an) == 3){
  $indice = $an[0];
  $sinal = $an[1];
  $valor = $an[2];
}else{
  $indice = $an[0];
  $sinal = '=';
  $valor = $an[1];
}

$novo_array = [$indice, $sinal, $valor];
array_push($retorno, $novo_array);
}//foreach


$this->e = $retorno;
return $this;
}//and

public function between(...$between){
$this->between = $between;
return $this;
}//between

public function ou(...$or){
	$this->ou = $or;
	return $this;
}//or

public function group(...$group){
	$this->group = $group;
	return $this;
}//group


public function order(...$order){
	$this->order = $order;
	return $this;
}//order

public function limit(...$limit){
	$this->limit = $limit;
	return $this;
}//limit

public function join(...$join){
	$this->join = $join;
	return $this;
}//join

public function on(...$on){

if(count($on[0]) <=2 ){
	throw new \Exception("O método on precisa de 3 parametros");		
}
	$this->on = $on;
	return $this;
}//on

public function first(){
 $this->first = true;
 return $this;
}//first

public function debug(){
$this->debug = true;

return $this;
}//debug



public function total(){
	$this->total = true;
	return $this;
}//rowCount

public function paginate(...$paginate){
 $this->paginate = $paginate;
 return $this;
}//paginate


/***************************************/
/*Monta a estrutura e mostra ao usuario*/
/***************************************/

public function get(){
$ob = new Ormbuilder();
$this->sql = $ob->selectCamposTabela($this->select, $this->tabela);

$conditionsPaginate = (object) array(
'isSearch'=>false,
'select'=>'',
'where'=>'',
'and'=>'',
'search'=>'',
'orSearch'=>''
);


if(isset($this->join)){
  $this->sql .= $this->montaJoin($this->join, $this->on);
}//join


if(isset($this->search)){
 $this->sql .=$this->montaSearch($this->search);
 $conditionsPaginate->isSearch = true;
}//Search

if(isset($this->orSearch)){
  $this->sql .= $this->montaOrSearch($this->orSearch);
  $conditionsPaginate->isSearch = true;
}//orSearch


//aqui começo a verificar se existe os outros comandos
if(isset($this->where)){	
 $this->sql .= $this->montaWhere($this->where);	
  $conditionsPaginate->isSearch = true;
}//se existe o where

if(isset($this->wherecustom)){	
 $this->sql .= $this->montaWhereCustom($this->wherecustom);	
}//se existe o where


if(isset($this->in)){
$this->sql .= $this->montaIn($this->in);
}

if(isset($this->e)){
  $this->sql .= $this->montaAnd($this->e);
   $conditionsPaginate->isSearch = true;
}//se existe o and

if(isset($this->isNull)){
	$this->sql .= $this->montaIsNull($this->isNull);
}//isNull

if(isset($this->isNotNull)){
	$this->sql .= $this->montaIsNotNull($this->isNotNull);
}

if(isset($this->between)){
	$this->sql .= $this->montaBetween($this->between);
}

if(isset($this->ou)){
  $this->sql .= $this->montaOr($this->ou);
}//se existe or

if(isset($this->group)){
  $this->sql .= $this->montaGroup($this->group);
}//group

if(isset($this->order)){
  $this->sql .= $this->montaOrder($this->order);
}//se existe order

if(isset($this->limit)){
 $this->sql .= $this->montalimit($this->limit);
}//limit

/*******************************/
/*Preparar o ORM para paginação*/
/*******************************/
// se existe a paginação
if(isset($this->paginate)){
$conditionsPaginate->select = $this->sql;

if(isset($this->where)){
  $conditionsPaginate->where = $this->where; 
}  

if(isset($this->e)){	
	$conditionsPaginate->and = $this->e;
}

if(isset($this->search)){
  $conditionsPaginate->search = $this->search;   
}  

if(isset($this->orSearch)){		
  $conditionsPaginate->orSearch = $this->orSearch;  
}

//caso nao ha search, orSearch ou where
if(!isset($this->search) && !isset($this->orSearch) && !isset($this->where) && !isset($this->e)){	
 $query = $this->sqlToPaginate($this->paginate, $conditionsPaginate);  
 $this->sql .= $query; 	
}

if(isset($this->where) && !empty($this->where)){	
 $query = $this->sqlToPaginate($this->paginate, $conditionsPaginate);
 $this->sql .= $query;
}
if(isset($this->e) && !empty($this->e)){
$query = $this->sqlToPaginate($this->paginate, $conditionsPaginate);
$this->sql .= $query;
}


//caso exista search, orSearch ou where
if(isset($this->search) && !isset($this->orSearch)){		
 $query = $this->sqlToPaginate($this->paginate, $conditionsPaginate);
 $this->sql .= $query;
}else if(isset($this->search) && isset($this->orSearch)){
 $query = $this->sqlToPaginate($this->paginate, $conditionsPaginate);
 $this->sql .= $query;
}
// $conditionsPaginate->isSearch = true;	
}//se existe a paginação

if(isset($this->debug)){
	var_dump($this->sql);
	exit;		
}

/************************/
//preparando para executar


$select = $this->db->prepare($this->sql);

if(isset($this->where)){ 
  $ob = new Ormbuilder();
  $select = $ob->whereBind($this->where, $select);
}//where

if(isset($this->e)){ 
  $ob = new Ormbuilder();
  $select = $ob->andBind($this->e, $select);
}//and

if(isset($this->ou)){ 
  $ob = new Ormbuilder();
  $select = $ob->orBind($this->ou, $select);
}//or

if(isset($this->search)){
$ob = new Ormbuilder();
$select = $ob->searchBind($this->search, $select);

if(isset($selectPaginate)):
  $selectPaginate = $searchBind->search($this->search, $selectPaginate);
endif;
}//se existe o search

if(isset($this->orSearch)){
$ob = new Ormbuilder();

$select = $ob->orSearchBind($this->orSearch, $select);


if(isset($selectPaginate)):	
//$selectPaginate = $orSearchBind->orSearch($this->orSearch, $selectPaginate);
endif;
}//se existe o orSearch

/*********************/
/*executando o codigo*/
/*********************/

try{
$select->execute();

if(isset($this->first)){	
  $this->dados =  $select->fetch();
}else{
  $this->dados =  $select->fetchAll();
}

if(isset($this->total)){	 
 return $select->rowCount();
}

return $this->dados;
}catch(\Exception $e){
	var_dump($e->getMessage().' no arquivo '.$e->getFile().' na linha: '.$e->getLine());
}//bloco try cacth

}//get


/************************/
/*Instrução para deletar*/
/************************/
public function del($del, $e = null){	
$this->sql = "delete from {$this->tabela} where {$del[0]} = :{$del[0]}";

if($e !== null){
	$this->sql .= " and {$e[0]} = :{$e[0]}";
}

$delete = $this->db->prepare($this->sql);
$delete->bindValue(":{$del[0]}", $del[1]);
if($e !== null){
 $delete->bindValue(":{$e[0]}", $e[1]);
}
	
return $delete->execute();
}//del

/*******************************/
/*comando para inserir no banco*/
/*******************************/
public function set($set){
$campos = new \stdClass();

foreach($set as $key=>$item){
  $campos->$key = $item;	
}

$this->set = $campos;	
return $this;
}//set

public function save(){
if($this->set != ''){

$array = json_decode(json_encode($this->set), true);
$campos = implode(", ", array_keys($array));
$valores = ":".implode(", :", array_keys($array));

$this->sql = "insert into {$this->tabela} ({$campos}) VALUES ({$valores}) ";
$stmt = $this->db->prepare($this->sql);
foreach($this->set as $chave => $valor):
$tipo = (is_int($valor)) ? PDO::PARAM_INT : PDO::PARAM_STR;
$stmt->bindValue(":$chave", $valor, $tipo);
endforeach;

try{

if($stmt->execute()){
	return $this->db->lastInsertId();
}

}catch(\Exception $e){
	echo "Erro: ".$e->getMessage().' linha '.$e->getLine();
}


}else{
	echo "Primeiro é preciso setar os campos";exit;
}

}//save
/****************************/
/*Fim Instrução para insert*/
/****************************/

public function update(){
if($this->set != ''){

$this->sql = "update {$this->tabela} set";

foreach($this->set as $key => $value){
	$this->sql .= " {$key} = :{$key},";
}
$this->sql = rtrim($this->sql,',');

if(!empty($this->where)){
  $this->sql .= " where ".$this->where[0][0]."= :".$this->where[0][0];
}

if(!empty($this->e)){
$this->sql .= " and ".$this->e[0][0]."= :".$this->e[0][0];
}

if(!empty($this->wherecustom)){
 $this->sql .= " where $this->wherecustom";
}

/*Preparando a query*/
$update = $this->db->prepare($this->sql);
foreach ($this->set as $key => $value) {
	$update->bindValue(":".$key, $value);
}

if(!empty($this->where)){
  $update->bindValue(":".$this->where[0][0], $this->where[0][1]);
}


try{
if($update->execute()){
	return $update->rowCount();
}

}catch(\Exception $e){
	echo "Erro: ".$e->getMessage().' linha '.$e->getLine();
}

}else{
	echo "Primeiro é preciso setar os campos";exit;
}
}//update



/****************************/
/*Fim Instrução para deletar*/
/****************************/

public function montaWhere($wheres){

if(count($wheres) > 1){
$sql = null;

foreach($wheres as $key => $value):

$paramSql = $value[0];

$valueSql = $value[0];

$sinalSql = $value[1];

if(count($value) == 2){
$sinalSql = '=';
}

$sql .= " {$paramSql} {$sinalSql} :{$valueSql}";
$sql .= ' and';
endforeach;

$sql = trim($sql, 'and');

return " where {$sql}";
}

if(count($wheres[0]) == 2){
	foreach($wheres as $where){
       $param = $where[0];
       $sinal = '=';
       $value = $where[0];	
     }
    }

if(count($wheres[0]) == 3){
	foreach($wheres as $where){
       $param = $where[0];
       $sinal = $where[1];
       $value = $where[0];	
     }
    }

return " where {$param} {$sinal} :{$value}";
}//montaWhere

public function montaWhereCustom($where){
 return " where $where";
}//montawherecustom

public function montaIn($in){
$qr = '';
$operador = 'WHERE';
$contador = 0;

foreach($in as $ind){
$string = '';
if(is_array($ind[1]) && !empty($ind[1])){

foreach($ind[1] as $item){
  $string .= "'{$item}'".",";
}//foreach

if($contador > 0){
  $operador = 'AND';
}

$string = rtrim($string,',');
$qr .= " $operador {$ind[0]} IN($string)";
$contador++;
}//is_array

}//foreach in

return $qr;
}//montaIn


public function montaBetween($between){
$sinal = '=';
$retorno = '';

$operador = 'and';
if($this->search == '' && $this->where == ''){
  $operador = 'where';	
}	

if(isset($this->in) && $this->in != ''){
foreach($this->in as $in){
	if($in[1] != ''){
    $operador = 'and';
	}
}
}

if(COUNT($between) > 1){
	foreach($between as $data){ 
	  if(array_key_exists('2', $data)){
      $sinal = $data[1];
    } 

		$retorno .= " {$operador} {$data[0]} {$sinal} '$data[2]'";
		if($operador == 'where'){
     $operador = 'and';
		}
	}

return $retorno;
}


$value = $between[0][1];
if(array_key_exists('2', $between[0])){
  $sinal = $between[0][1];
} 
if(array_key_exists('2', $between[0])){
  $value = $between[0][2];
}


return " {$operador} {$between[0][0]} {$sinal} '{$value}'";
}//montaBetween


public function montaIsNull($isnull){
	return " and {$isnull} IS NULL";
}//montaIsNull

public function montaIsNotNull($isnotnull){
	return " and {$isnotnull} IS NOT NULL";
}//montaIsnotnull


public function montaAnd($ands){
$operador = 'and';

if($this->search == '' && $this->orSearch == '' && $this->where == '' && $this->in == '' && $this->wherecustom == ''){
  $operador = 'where';	
}	

$conta = COUNT($ands);
$saida = '';

if($conta >= 1){

foreach($ands as $and){
$parametros = COUNT($and);	

if($parametros == 2){
 $param = $and[0];
 $sinal = '=';
 $value = $and[0];

 $saida .= " ".$operador." {$param} {$sinal} :{$value}";
 if($operador == 'where'){
 	$operador = 'and';
 }
}//quando tem 2 parametros

if($parametros == 3){	
 $param = $and[0];
 $sinal = $and[1];
 $value = $and[0];

if(strpos($value,'.')){	    
   $value = str_replace('.','', $value);
}

 $saida .= " ".$operador." {$param} {$sinal} :{$value}";
 if($operador == 'where'){
 	$operador = 'and';
 }
}

}

return $saida;

}else{

if(!empty($ands)){
//se teve apenas um AND	
if(count($ands[0]) == 2){
	foreach($ands as $and){
	   $param = $and[0];
	   $sinal = '=';
	   $value = $and[0];	
	 }

	 return " ".$operador." {$param} {$sinal} :{$value}";
}

if(count($ands[0]) == 3){
		foreach($ands as $and){
	       $param = $and[0];
	       $sinal = $and[1];
	       $value = $and[0];	
	     }
return " ".$operador." {$param} {$sinal} :{$value}";
}
}

return "";
}
}//montaAnd

public function montaOr($ors){

if(count($ors[0]) == 2){
 foreach($ors as $or){
	$param = $or[0];
	$sinal = '=';
	$value = $or[0];	
  }
}

if(count($ors[0]) == 3){
		foreach($ors as $or){
	       $param = $or[0];
	       $sinal = $or[1];
	       $value = $or[0];	
	     }
     }

	return " or {$param} {$sinal} :{$value}";

}//montaOr
public function montaJoin($joins, $on = null){
$sql = null;

foreach($joins as $key => $join):

$sql .= " inner join {$join['0']}";

if(!is_null($on)){
	$sql .= " on ";
	$sql .= implode(" ", $on[$key])." ";
}

endforeach;

return $sql;

}//join


public function montaOrder($order){
  return " order by ".implode(" ", $order[0]);
}//montaOrder


public function montaGroup($group){
  return " group by {$group[0][0]}";
}//montaGroup

public function montaLimit($limit){
   return " limit {$limit[0][0]}";	
}//montalimit

public function montaSearch($search){
  if($search[0][1] != ''){	
    return " where ".$search[0][0]." LIKE :".$search[0][0];
  }
}//search


public function montaOrSearch($orsearch){
$operador = 'or';

if($this->search == ''){
  $operador = 'where';	
}	

$qr = '';

foreach ($orsearch as $key => $value) {	
 $qr .= " ".$operador." ".$value[0]." LIKE :".$value[0];
 if($operador == 'where'){
		$operador = 'or';
	}
}

return $qr;
}//orsearch



/********************************/
/*começando a parte de paginação*/
/********************************/
public function sqlToPaginate($perPage, $conditionsPaginate){
$this->selectPaginateBuilder = new SelectPaginateBuilder($conditionsPaginate);
$this->selectPaginateBuilder->perPage($perPage);

return $this->selectPaginateBuilder->sqlToPaginate();
}//sqlToPaginate

public function render($link){	
	return $this->selectPaginateBuilder->render($link);
}//render


}