<?php
use Core\Controller;
use Models\Users;
use Models\Funil;
use Models\Motivo;
use Models\Permissao;
use Models\Orm;

class ContratosfController extends Controller {

  private $user;
  private $arr;
  private $permissao;

    public function __construct() {              
        $this->user = new Users();
        $this->permissao = new Permissao(); 

        if($this->user->isLogged() == false){                  
         header("Location: ".BASE_URL."login");        
         exit;         
        }

        $permissoes = $this->permissao->getPermissoes();
        $modulo_boleto = $this->permissao->getPermissoesBoleto();
        
         $this->arr = array(
          'user'=>$this->user,
          'menuActive'=>'home',
          'permissao'=>$permissoes,
          'modulo_boleto'=>$modulo_boleto
         );           
}

public function index() {   
$this->arr['list_js'] = array(
'plugins/sweetalert2',
'system'
);  

$tab = new Orm('contratof');
$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);

if(isset($_GET['serie']) && !empty($_GET['serie'])){
$serie = addslashes($_GET['serie']);
$this->arr['lista'] = $tab->select('*')->search(['serie', $serie])->get();
}else{
$this->arr['lista'] = $tab->select('*')->paginate('10')->get();
$this->arr['paginacao'] = $tab->render("contratof");
}


$this->loadTemplate('contratosf/listar', $this->arr);
}//function index  


public function add(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'preview_imagem',
'uploadImage',
'functions_js',
'plugins/sweetalert2',
'system'
);
//echo 'aqui';
//exit;

$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('contratosf/adicionar', $this->arr);
}//add


public function edit($id){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'preview_imagem',
'uploadImage',
);

$this->arr['id'] = $id;
$this->arr['info'] = (new Orm('contratof'))->select('*')->where(['id', $id])
->first()->get();



$this->loadTemplate('contratosf/editar', $this->arr);
}//edit

public function edit_action(){

  $this->arr['list_js'] = array(
    'plugins/jquery.mask.min',
    'plugins/parsley/parsley.min',
    'plugins/parsley/pt-br',
    'mask_init',
    'preview_imagem',
    'uploadImage',
    );
      
  $funil = new Funil();
  $up = new Motivo();
  $id = $_POST['id_funil'];
  $nome = $_POST['nome_funil'];

  $funil->edit_action($id,$nome);
  $del = $up->delsubmotivo($id);
//print_r($_POST['motivo']);
//exit;
if(isset($_POST['motivo']) && !empty($_POST['motivo'])){ 
  foreach($_POST['motivo'] as $mot){
  $gravamot = $up->addsubmotivo($id,$mot);

  }

}
$_SESSION['msg'] = array('type'=>'success', 'msg'=>'Funil Editado com sucesso!');
header("Location:".BASE_URL."funil");
exit;

}

public function save(){

if(isset($_POST['serie']) && !empty($_POST['serie'])){
 $id_contrato   = (isset($_POST['id_contrato'])) ? $this->limpaCampo($_POST['id_contrato']) : NULL;   
 $serie   = (isset($_POST['serie'])) ? $this->limpaCampo($_POST['serie']) : NULL; 
 $ultimo_numero    = (isset($_POST['ultimo_numero'])) ? $this->limpaCampo($_POST['ultimo_numero']) : NULL; 
 $descricao    = (isset($_POST['descricao'])) ? $this->limpaCampo($_POST['descricao']) : NULL; 
 $valor    = (isset($_POST['valor'])) ? $this->limpaCampo($_POST['valor']) : NULL; 
 

 
$consulta = (new Orm('contratosf'))->select('*')->where(['serie', $serie])->first()->get();

if(!empty($consulta)){
  $_SESSION['msg'] = array('type'=>'error', 'msg'=>'Ooppss, ja existe cadastro com essa série no sistema, por favor tente novamente!!!');
  header("Location:".BASE_URL."contratosf");
  exit;  
}

$dados_form = [
'serie'=>$serie,
'ultimo_numero'=>$ultimo_numero,
'descricao'=>$descricao,
'valor'=>$valor
];

if($id_contrato == null){
 $grv = (new Orm('contratof'))->set($dados_form)->save();
 $_SESSION['msg'] = array('type'=>'success', 'msg'=>'Contrato cadastrado com sucesso!');
 $this->redirect(BASE_URL."contratosf"); 
}else{
 $grv = (new Orm('contratof'))->set($dados_form)->where(['id', $id_contrato])->update();
 $_SESSION['msg'] = array('type'=>'success', 'msg'=>'Contrato Editado com sucesso!');
 header("Location:".BASE_URL."contratosf");
 exit;
}

}

}//save

public function remover($id){
$del = (new Orm('contratos'))->del(['id_origem', $id]);
$_SESSION['msg'] = array('type'=>'success', 'msg'=>'Motivo removido com sucesso!');
$this->redirect(BASE_URL."contratos");
}//remover

}