<?php
use Core\Controller;
use Models\Users;
use Models\Permissao;
use Models\Financeiro;
use Models\Orm;
use Models\ReportFinanceiro;
use Dompdf\Dompdf;
use Dompdf\Exception;
use Dompdf\Options;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\IOFactory;

class FinanceiroController extends Controller {

  private $user;
  private $arr;
  private $permissao;

    public function __construct() {              
        $this->user = new Users();
        $this->permissao = new Permissao(); 

        if($this->user->isLogged() == false){                  
         header("Location: ".BASE_URL."login");        
         exit;         
        }

       $usuario = $this->user->getId();       
       $permissoes = $this->permissao->getPermissoes();
       $modulo_boleto = $this->permissao->getPermissoesBoleto();
       
        $this->arr = array(
         'user'=>$this->user,
         'menuActive'=>'home',
         'permissao'=>$permissoes,
         'modulo_boleto'=>$modulo_boleto
        );            
}

public function teste(){
$data = [];

  ob_start();
  $this->loadview("codigobarras/index_codigobarras", $data);       
  exit;
  $html = ob_get_contents();
  ob_end_clean();    



  $dompdf = new Dompdf();
  $dompdf->loadHtml($html);
  // Render the HTML as PDF
  $dompdf->render();
  $dompdf->stream("Letter",["Attachment" => false]);   
}

public function index() {   
/*$this->arr['list_js'] = array(
'plugins/sweetalert2',
'system'
);  

$tab = new Orm('origem_venda');
$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);

if(isset($_GET['nome']) && !empty($_GET['nome'])){
$nome = addslashes($_GET['nome']);
$this->arr['lista'] = $tab->select('*')->search(['nome_origem', $nome])->get();
}else{
$this->arr['lista'] = $tab->select('*')->paginate('10')->get();
$this->arr['paginacao'] = $tab->render("origem");
}


$this->loadTemplate('origem/listar', $this->arr);*/
}//function index 

public function cancelarecebimentoSIM() {   
  $this->arr['list_js'] = array(
  'plugins/sweetalert2',
  'system'
  );  
  $nrecibo = $_POST['nrecibo'];
  $motivo = $_POST['motivo'];
  $nvalor = $_POST['nvalor'];
  $data_recebimento = $_POST['data_recebimento'];



  date_default_timezone_set('America/Sao_Paulo');
  //$dt1 = date("Y-m-d");

  $dados_form = [
    'recebido'=>'NAO',
    'data_recebimento'=>NULL,
    'metodo_pagamento'=>NULL,
    'valor_pago'=>'0',
    'valor_cancelado'=>'0',
    'desconto'=>'0'
  ];
  
  $grv = (new Orm('financeiro_faturamento'))->set($dados_form)->where(['nrecibo', $nrecibo,'recebido', 'SIM'])->update();
  //$_SESSION['msg'] = array('type'=>'success', 'msg'=>'Empresa Editada com sucesso!');

 // return '1';
  
  
}//function index 

public function relatorios() {   
  $data = array();
  
  if( isset($_POST['data_inicial']) && !empty($_POST['data_inicial']) && isset($_POST['data_final']) && !empty($_POST['data_final'])){
  $data = []; 
  $tipo = $_POST['tipo'];
  $tiporelatorio = $_POST['tiporecibo'];
  $funcionario = $_POST['funcionario'];
  $data_inicial = $_POST['data_inicial'];
  $data_final = $_POST['data_final'];
  $data['tipo'] = $tipo;
  $data['funcionario'] = $funcionario;
  $data['data_inicial'] = $data_inicial;
  $data['data_final'] = $data_final;

  if($tiporelatorio == 'recebimento_resumo'){
  $data['consulta'] = (new Orm('vw_report_resumorecebidon'))
  ->select(['*'])
  ->wherecustom("cobranca = '$tipo' and funcionario like '$funcionario%' and data_recebimento >= '$data_inicial' and data_recebimento <= '$data_final'")
  ->get();       
            
  ob_start();
  $this->loadview("financeiro/financeiro_report_recebimentoresumo_pdf", $data);      
  exit;
  $html = ob_get_contents();
  ob_end_clean();      
  $options = new Options();
  $options->set('isRemoteEnabled',true);
  $dompdf = new Dompdf($options);
  //$dompdf = new Dompdf();
  $dompdf->loadHtml($html);
  // Render the HTML as PDF
  $dompdf->setPaper('A4', 'portrait');
  $dompdf->render();
  $dompdf->stream("Letter",["Attachment" => false]);  
  }



}
$this->loadTemplate('financeiro/financeiro_relatorios', $this->arr);

}//function index 

public function fecharcaixaSIM() {   
  //echo "<script>alert('teste')</srcipt>";
  $nimpressao = $_POST['nimpressao'];
  $tipo = $_POST['tipo'];
  $valor_pago = $_POST['valor_pago'];
  $valor = $_POST['valor'];
  $desconto = $_POST['desconto'];
  $funcionario = $_POST['funcionario'];
  $valor_cancelado = $_POST['valor_cancelado'];
  $qtde_recebido = $_POST['qtde_recebido'];
  //$data_recebimento = $_POST['data_recebimento'];
  $user = $this->user->getId();
  date_default_timezone_set('America/Sao_Paulo');
  $dt = date("Y-m-d");
  
$f = new Financeiro();
$f->fecharcaixaSIM($nimpressao,$tipo,$valor_pago,$valor,$desconto,$funcionario,$valor_cancelado,$qtde_recebido,$user,$dt);

  
}//function index 

public function baixarecebimentoSIM() {   
  $this->arr['list_js'] = array(
  'plugins/sweetalert2',
  'system'
  );  
  $nrecibo = $_POST['nrecibo'];
  $motivo = $_POST['motivo'];
  $nvalor = $_POST['nvalor'];
  $valor = $_POST['valor'];
  $desconto = $_POST['desconto'];
  $id_lead = $_POST['id_lead'];

  $data_recebimento = $_POST['data_recebimento'];
  date_default_timezone_set('America/Sao_Paulo');
  //$dt1 = date("Y-m-d");

  if($motivo == 'JA_DOOU' || $motivo == 'CANCELOU' || $motivo == 'DUPLICIDADE' || $motivo == 'OUTROS' || $motivo == 'CONFIRMACAO' || $motivo == 'DEVOLUCAO' ){
    $dados_form = [
    'recebido'=>'SIM',
    'data_recebimento'=>$data_recebimento,
    'metodo_pagamento'=>$motivo,
    'valor_pago'=>$nvalor,
    'valor_cancelado'=>$valor,
    'desconto'=>0
    ];
  }else{
    $dados_form = [
      'recebido'=>'SIM',
      'data_recebimento'=>$data_recebimento,
      'metodo_pagamento'=>$motivo,
      'valor_pago'=>$nvalor,
      'valor_cancelado'=>'0',
      'desconto'=>$desconto
    ];
  }

  if($motivo == 'CONFIRMACAO'){

  $dados_forml = [
    'funil_id'=>'29'
  ];

  $up = (new Orm('leads'))->set($dados_forml)->where(['id_lead', $id_lead])->update();

  }
  //exit;
  $grv = (new Orm('financeiro_faturamento'))->set($dados_form)->where(['nrecibo', $nrecibo,'recebido', 'NAO'])->update();
  
}//function index 

public function resumorecebimento() {   
  $this->arr['list_js'] = array(
  'plugins/sweetalert2',
  'system'
  );  

  
  if(isset($_GET['codimpressao']) && !empty($_GET['codimpressao']) && isset($_GET['funcionario']) && !empty($_GET['funcionario']) && isset($_GET['tiporecibo']) && !empty($_GET['tiporecibo'])){
    $codimpressao = $_GET['codimpressao'];
    $funcionario = $_GET['funcionario'];
    //$data_recebimento = $_GET['data_recebimento'];
    $tiporecibo = $_GET['tiporecibo'];


    $this->arr['lista'] = (new Orm('vw_resumorecebimenton'))->select('*')->wherecustom("tipo = '$tiporecibo' AND funcionario = '$funcionario' AND nimpressao = '$codimpressao'")->order(['nimpressao asc'])->get();

  }else{
    if(isset($_GET['funcionario']) && !empty($_GET['funcionario']) && isset($_GET['tiporecibo']) && !empty($_GET['tiporecibo'])){
      $funcionario = $_GET['funcionario'];
      $tiporecibo = $_GET['tiporecibo'];

      $this->arr['lista'] = (new Orm('vw_resumorecebimenton'))->select('*')->wherecustom("tipo = '$tiporecibo' AND funcionario = '$funcionario'")->order(['nimpressao asc'])->get();
    }else{
      if(isset($_GET['funcionario']) && !empty($_GET['funcionario'])){
        $funcionario = $_GET['funcionario'];
       $this->arr['lista'] = (new Orm('vw_resumorecebimenton'))->select('*')->wherecustom("funcionario = '$funcionario'")->order(['nimpressao asc'])->get();
      //echo '<pre>';
      //print_r($this->arr['lista']);
      //exit;
      }else{
        
        if(isset($_GET['tiporecibo']) && !empty($_GET['tiporecibo'])){
          $tiporecibo = $_GET['tiporecibo'];
        $this->arr['lista'] = (new Orm('vw_resumorecebimenton'))->select('*')->wherecustom("tipo = '$tiporecibo'")->order(['nimpressao asc'])->get();
        }
      }
    }

  }
  
  $this->loadTemplate('financeiro/financeiro_resumo_recebimento', $this->arr);
}//function index 

public function detalheresumocaixa($nimpressao,$tipo,$funcionario) {

  $filtroatendimento = (new Orm('financeiro_faturamento'))
  ->select(['financeiro_faturamento.*, leads.nome, leads.produto, usuarios.nome as agente, leads.cobranca as lcobranca'])
  ->join(['leads'],['usuarios'])
  ->on(
    ['financeiro_faturamento.id_lead','=','leads.id_lead'],
    ['financeiro_faturamento.id_user','=','usuarios.id_usuario'])
  ->wherecustom("financeiro_faturamento.tipo = '$tipo' and financeiro_faturamento.funcionario = '$funcionario' and financeiro_faturamento.nimpressao = '$nimpressao'")
  ->get();

  $this->exportarboletos($filtroatendimento);
  
}

public function cancelarrecebimento() {   
  $this->arr['list_js'] = array(
  'plugins/sweetalert2',
  'system'
  );  

  
  if(isset($_GET['recibo']) && !empty($_GET['recibo'])){
    $recibo = $_GET['recibo'];
    $this->arr['lista'] = (new Orm('financeiro_faturamento'))->select(['financeiro_faturamento.metodo_pagamento,financeiro_faturamento.data_recebimento,financeiro_faturamento.valor_pago,financeiro_faturamento.nimpressao,financeiro_faturamento.valor,financeiro_faturamento.cobranca,nrecibo, leads.nome, vlr'])
    ->join(['leads'])
    ->on(['financeiro_faturamento.id_lead','=','leads.id_lead']) 
    ->wherecustom("nrecibo > 0 and recebido = 'SIM' and nrecibo = '$recibo'")->order(['nrecibo asc'])->get();
//    print_r( $this->arr['baixar']);
//    exit;
  }else{
    if(isset($_GET['data_recebimento']) && !empty($_GET['data_recebimento']) or isset($_GET['codimpressao']) && !empty($_GET['codimpressao'])){

      if(isset($_GET['data_recebimento']) && !empty($_GET['data_recebimento'])){
        $data_recebimento = $_GET['data_recebimento'];

        $this->arr['lista'] = (new Orm('financeiro_faturamento'))->select(['financeiro_faturamento.metodo_pagamento,financeiro_faturamento.data_recebimento,financeiro_faturamento.valor_pago,financeiro_faturamento.nimpressao,financeiro_faturamento.valor,financeiro_faturamento.cobranca,nrecibo, leads.nome, vlr'])
        ->join(['leads'])
        ->on(['financeiro_faturamento.id_lead','=','leads.id_lead']) 
        ->wherecustom("nrecibo > 0 and recebido = 'SIM' and data_recebimento = '$data_recebimento'")->order(['nrecibo asc'])->get();

      }

      if(isset($_GET['codimpressao']) && !empty($_GET['codimpressao'])){
        $codimpressao = $_GET['codimpressao'];

        $this->arr['lista'] = (new Orm('financeiro_faturamento'))->select(['financeiro_faturamento.metodo_pagamento,financeiro_faturamento.data_recebimento,financeiro_faturamento.valor_pago,financeiro_faturamento.nimpressao,financeiro_faturamento.valor,financeiro_faturamento.cobranca,nrecibo, leads.nome, vlr'])
        ->join(['leads'])
        ->on(['financeiro_faturamento.id_lead','=','leads.id_lead']) 
        ->wherecustom("nrecibo > 0 and recebido = 'SIM' and nimpressao = '$codimpressao'")->order(['nrecibo asc'])->get();
        
      }



    }else{
      $this->arr['lista'] = (new Orm('financeiro_faturamento'))->select(['financeiro_faturamento.metodo_pagamento,financeiro_faturamento.data_recebimento,financeiro_faturamento.valor_pago,financeiro_faturamento.nimpressao,financeiro_faturamento.valor,financeiro_faturamento.cobranca,nrecibo, leads.nome, vlr'])
      ->join(['leads'])
      ->on(['financeiro_faturamento.id_lead','=','leads.id_lead']) 
      ->wherecustom("nrecibo > 0 and recebido = 'SIM'")->order(['nrecibo asc'])->get();
  //    print_r( $this->arr['baixar']);
  //    exit;
    }

  }

  
  $this->loadTemplate('financeiro/financeiro_cancelar_recebimento', $this->arr);
  }//function index 

public function baixarecebimento() {   
  $this->arr['list_js'] = array(
  'plugins/sweetalert2',
  'system'
  );  

  
  if(isset($_GET['recibo']) && !empty($_GET['recibo'])){
    $recibo = $_GET['recibo'];
    $this->arr['lista'] = (new Orm('financeiro_faturamento'))->select(['leads.id_lead,financeiro_faturamento.nimpressao,financeiro_faturamento.valor,financeiro_faturamento.cobranca,nrecibo, leads.nome, vlr'])
    ->join(['leads'])
    ->on(['financeiro_faturamento.id_lead','=','leads.id_lead']) 
    ->wherecustom("nrecibo > 0 and recebido = 'NAO' and nrecibo = '$recibo'")->order(['nrecibo asc'])->get();
//    print_r( $this->arr['baixar']);
//    exit;
  }else{
    if(isset($_GET['data_faturamento']) && !empty($_GET['data_faturamento']) or isset($_GET['codimpressao']) && !empty($_GET['codimpressao'])){

      if(isset($_GET['data_faturamento']) && !empty($_GET['data_faturamento'])){
        $data_faturamento = $_GET['data_faturamento'];

        $this->arr['lista'] = (new Orm('financeiro_faturamento'))->select(['leads.id_lead,financeiro_faturamento.nimpressao,financeiro_faturamento.valor,financeiro_faturamento.cobranca,nrecibo, leads.nome, vlr'])
        ->join(['leads'])
        ->on(['financeiro_faturamento.id_lead','=','leads.id_lead']) 
        ->wherecustom("nrecibo > 0 and recebido = 'NAO' and data_faturamento = '$data_faturamento'")->order(['nrecibo asc'])->get();

      }

      if(isset($_GET['codimpressao']) && !empty($_GET['codimpressao'])){
        $codimpressao = $_GET['codimpressao'];

        $this->arr['lista'] = (new Orm('financeiro_faturamento'))->select(['leads.id_lead,financeiro_faturamento.nimpressao,financeiro_faturamento.valor,financeiro_faturamento.cobranca,nrecibo, leads.nome, vlr'])
        ->join(['leads'])
        ->on(['financeiro_faturamento.id_lead','=','leads.id_lead']) 
        ->wherecustom("nrecibo > 0 and recebido = 'NAO' and nimpressao = '$codimpressao'")->order(['nrecibo asc'])->get();
        
      }



    }else{
      $this->arr['lista'] = (new Orm('financeiro_faturamento'))->select(['leads.id_lead,financeiro_faturamento.nimpressao,financeiro_faturamento.valor,financeiro_faturamento.cobranca,nrecibo, leads.nome, vlr'])
      ->join(['leads'])
      ->on(['financeiro_faturamento.id_lead','=','leads.id_lead']) 
      ->wherecustom("nrecibo > 0 and recebido = 'NAO'")->order(['nrecibo asc'])->get();
  //    print_r( $this->arr['baixar']);
  //    exit;
    }

  }

  
  $this->loadTemplate('financeiro/financeiro_baixar_recebimento', $this->arr);
  }//function index 

  public function imprimirrecibo_devolucao($nimp,$tiporecibo,$funcionario){
            $data = array();
  
            $data = []; 
            $data['consulta'] = (new Orm('financeiro_faturamento'))
            ->select(['financeiro_faturamento.*, leads.dia,leads.telefone, leads.id_importacao,leads.nome, leads.produto, usuarios.nome as agente, leads.cobranca as lcobranca'])
            ->join(['leads'],['usuarios'])
            ->on(
              ['financeiro_faturamento.id_lead','=','leads.id_lead'],
              ['financeiro_faturamento.id_user','=','usuarios.id_usuario'])
            //->wherecustom("financeiro_faturamento.cobranca = '$cobranca' and impresso = 'N' and data_faturamento >= '$data_inicial' and data_faturamento <= '$data_final' and financeiro_faturamento.funcionario like '$funcionario%' and financeiro_faturamento.tipo like '$tiporecibo%' ")
            ->wherecustom("financeiro_faturamento.nimpressao = '$nimp' and financeiro_faturamento.funcionario like '$funcionario%' and financeiro_faturamento.tipo like '$tiporecibo%' and financeiro_faturamento.valor_pago = '0' and financeiro_faturamento.desconto = '0' and financeiro_faturamento.valor_cancelado = '0'")
            ->get();       
                      
            ob_start();
            $this->loadview("financeiro/financeiro_report_recibos_devolucao_pdf", $data);      
            exit; 
            $html = ob_get_contents();
            ob_end_clean();      
            $options = new Options();
            $options->set('isRemoteEnabled',true);
            $dompdf = new Dompdf($options);
            //$dompdf = new Dompdf();
            $dompdf->loadHtml($html);
            // Render the HTML as PDF
            $dompdf->setPaper('A4', 'landscape');
            $dompdf->render();
            $dompdf->stream("Letter",["Attachment" => false]);     
           
   
  }//imprimir recibo devolucao

public function imprimirrecibo(){
  $this->arr['list_js'] = array(
  'plugins/jquery.mask.min',
  'plugins/parsley/parsley.min',
  'plugins/parsley/pt-br',
  'mask_init',
  'preview_imagem',
  'uploadImage',
  'functions_js',
  'plugins/sweetalert2',
  'system'
  );
  $data = array();

  if(isset($_POST['tipo']) && !empty($_POST['tipo'])){
    $cobranca = $_POST['tipo'];
    $data_inicial = $_POST['data_inicial'];
    $data_final = $_POST['data_final'];
    $funcionario = $_POST['funcionario'];
    $tiporecibo = $_POST['tiporecibo'];
    $data_inicial_agendada = $_POST['data_inicial_agendada'];
    $data_final_agendada = $_POST['data_final_agendada'];

    switch ($_POST['tipo']) {
      case 'RECIBO':
        $reimprimir1 = $_POST['reimprimir1'];
        $reimprimir2 = $_POST['reimprimir2'];
        $reimprimir3 = $_POST['reimprimir3'];
        if(isset($_POST['reimprimir1']) && !empty($_POST['reimprimir1']) or isset($_POST['reimprimir2']) && !empty($_POST['reimprimir2']) or isset($_POST['reimprimir3']) && !empty($_POST['reimprimir3'])){

        if(isset($_POST['reimprimir1']) && !empty($_POST['reimprimir1'])){
          $data = []; 
          $data['consulta'] = (new Orm('financeiro_faturamento'))
          ->select(['financeiro_faturamento.*, leads.dia,leads.telefone, leads.id_importacao,leads.nome, leads.produto, usuarios.nome as agente, leads.cobranca as lcobranca'])
          ->join(['leads'],['usuarios'])
          ->on(
            ['financeiro_faturamento.id_lead','=','leads.id_lead'],
            ['financeiro_faturamento.id_user','=','usuarios.id_usuario'])
          ->wherecustom("recebido = 'NAO' and financeiro_faturamento.nrecibo = '$reimprimir1'")
          ->get();         
        }

        if(isset($_POST['reimprimir1']) && !empty($_POST['reimprimir1']) and isset($_POST['reimprimir2']) && !empty($_POST['reimprimir2'])){
          $data = []; 
          $data['consulta'] = (new Orm('financeiro_faturamento'))
          ->select(['financeiro_faturamento.*, leads.dia,leads.telefone, leads.id_importacao,leads.nome, leads.produto, usuarios.nome as agente, leads.cobranca as lcobranca'])
          ->join(['leads'],['usuarios'])
          ->on(
            ['financeiro_faturamento.id_lead','=','leads.id_lead'],
            ['financeiro_faturamento.id_user','=','usuarios.id_usuario'])
          ->wherecustom("recebido = 'NAO' and financeiro_faturamento.nrecibo = '$reimprimir1' or recebido = 'NAO' and financeiro_faturamento.nrecibo = '$reimprimir2'")
          ->get();           
        }

        if(isset($_POST['reimprimir1']) && !empty($_POST['reimprimir1']) and isset($_POST['reimprimir2']) && !empty($_POST['reimprimir2']) and isset($_POST['reimprimir3']) && !empty($_POST['reimprimir3'])){
          $data = []; 
          $data['consulta'] = (new Orm('financeiro_faturamento'))
          ->select(['financeiro_faturamento.*, leads.dia,leads.telefone, leads.id_importacao,leads.nome, leads.produto, usuarios.nome as agente, leads.cobranca as lcobranca'])
          ->join(['leads'],['usuarios'])
          ->on(
            ['financeiro_faturamento.id_lead','=','leads.id_lead'],
            ['financeiro_faturamento.id_user','=','usuarios.id_usuario'])
          ->wherecustom("recebido = 'NAO' and financeiro_faturamento.nrecibo = '$reimprimir1' or recebido = 'NAO' and financeiro_faturamento.nrecibo = '$reimprimir2' or recebido = 'NAO' and financeiro_faturamento.nrecibo = '$reimprimir3'")
          ->get();      
        }
      }else{

        if(isset($_POST['data_inicial_agendada']) && !empty($_POST['data_inicial_agendada']) && isset($_POST['data_final_agendada']) && !empty($_POST['data_final_agendada'])){
          $data = []; 
          $data['consulta'] = (new Orm('financeiro_faturamento'))
          ->select(['financeiro_faturamento.*, leads.dia,leads.telefone, leads.id_importacao,leads.nome, leads.produto, usuarios.nome as agente, leads.cobranca as lcobranca'])
          ->join(['leads'],['usuarios'])
          ->on(
            ['financeiro_faturamento.id_lead','=','leads.id_lead'],
            ['financeiro_faturamento.id_user','=','usuarios.id_usuario'])
          //->wherecustom("financeiro_faturamento.cobranca = '$cobranca' and impresso = 'N' and data_faturamento >= '$data_inicial' and data_faturamento <= '$data_final' and financeiro_faturamento.funcionario like '$funcionario%' and financeiro_faturamento.tipo like '$tiporecibo%' ")
          ->wherecustom("recebido = 'NAO' and financeiro_faturamento.cobranca = '$cobranca' and data_agendada >= '$data_inicial_agendada' and data_agendada <= '$data_final_agendada' and data_faturamento >= '$data_inicial' and data_faturamento <= '$data_final' and financeiro_faturamento.funcionario like '$funcionario%' and financeiro_faturamento.tipo like '$tiporecibo%' ")
          ->get();       
          
          foreach($data['consulta'] as $imprimir){

            $dados_form = [
              'impresso'=>'S'
              ];
            $grv = (new Orm('financeiro_faturamento'))->set($dados_form)->where(['nrecibo', $imprimir->nrecibo])->update();
            
          }

        }else{
          $data = []; 
          $data['consulta'] = (new Orm('financeiro_faturamento'))
          ->select(['financeiro_faturamento.*, leads.dia,leads.telefone, leads.id_importacao,leads.nome, leads.produto, usuarios.nome as agente, leads.cobranca as lcobranca'])
          ->join(['leads'],['usuarios'])
          ->on(
            ['financeiro_faturamento.id_lead','=','leads.id_lead'],
            ['financeiro_faturamento.id_user','=','usuarios.id_usuario'])
          //->wherecustom("financeiro_faturamento.cobranca = '$cobranca' and impresso = 'N' and data_faturamento >= '$data_inicial' and data_faturamento <= '$data_final' and financeiro_faturamento.funcionario like '$funcionario%' and financeiro_faturamento.tipo like '$tiporecibo%' ")
          ->wherecustom("recebido = 'NAO' and financeiro_faturamento.cobranca = '$cobranca' and data_faturamento >= '$data_inicial' and data_faturamento <= '$data_final' and financeiro_faturamento.funcionario like '$funcionario%' and financeiro_faturamento.tipo like '$tiporecibo%' ")
          ->get();       
          
          foreach($data['consulta'] as $imprimir){

            $dados_form = [
              'impresso'=>'S'
              ];
            $grv = (new Orm('financeiro_faturamento'))->set($dados_form)->where(['nrecibo', $imprimir->nrecibo])->update();
            
          }

        }
        }

        
          ob_start();
          $this->loadview("financeiro/financeiro_report_recibos_pdf", $data);      
          exit; 
          $html = ob_get_contents();
          ob_end_clean();      
          $options = new Options();
          $options->set('isRemoteEnabled',true);
          $dompdf = new Dompdf($options);
          //$dompdf = new Dompdf();
          $dompdf->loadHtml($html);
          // Render the HTML as PDF
          $dompdf->setPaper('A4', 'landscape');
          $dompdf->render();
          $dompdf->stream("Letter",["Attachment" => false]);     
         
        /*
        
      
      */
      /*
         $options = new Dompdf\Options();
         $options->set('isRemoteEnabled', true);
      
         $dompdf  = new Dompdf\Dompdf($options);
         $dompdf->set_option('isHtml5ParserEnabled', true);
         $dompdf->loadHtml($html);
         $dompdf->setPaper('A4', 'portrait');
         ini_set('xdebug.max_nesting_level', 2000);
         ini_set('memory_limit', '256M');
         $dompdf->render();
         $dompdf->stream("RECIBO",array("Attachment"=>0));*/
        break;
      case 'BOLETO':
        $filtroatendimento = (new Orm('financeiro_faturamento'))
        ->select(['financeiro_faturamento.*, leads.id_importacao,leads.nome, leads.produto, usuarios.nome as agente, leads.cobranca as lcobranca'])
        ->join(['leads'],['usuarios'])
        ->on(
          ['financeiro_faturamento.id_lead','=','leads.id_lead'],
          ['financeiro_faturamento.id_user','=','usuarios.id_usuario'])
        ->wherecustom("financeiro_faturamento.cobranca = '$cobranca' and data_agendada >= '$data_inicial' and data_agendada <= '$data_final'")
        ->get();
        $this->exportarboletos($filtroatendimento);
        break;
      case 'DEPOSITO':
        $filtroatendimento = (new Orm('financeiro_faturamento'))
        ->select(['financeiro_faturamento.*, leads.id_importacao,leads.nome, leads.produto, usuarios.nome as agente, leads.cobranca as lcobranca'])
        ->join(['leads'],['usuarios'])
        ->on(
          ['financeiro_faturamento.id_lead','=','leads.id_lead'],
          ['financeiro_faturamento.id_user','=','usuarios.id_usuario'])
        ->wherecustom("financeiro_faturamento.cobranca = '$cobranca' and data_agendada >= '$data_inicial' and data_agendada <= '$data_final'")
        ->get();
        $this->exportarboletos($filtroatendimento);
        break;
    }
  }
  $this->loadTemplate('financeiro/financeiro_imprimirrecibo', $this->arr);
}//imprimir recibo

public function exportarboletos($dadosatendimento){
  $rl = new ReportFinanceiro();
 // echo '<pre>';
 // print_r($dadosatendimento);
 // exit;

//Aqui começa a exportação
$formato = 'Xlsx';//Xlsx - Xls - Csv
$file = new Spreadsheet();
$active_sheet = $file->getActiveSheet();

$active_sheet->setCellValue('a1', 'Cod Recibo');
$active_sheet->setCellValue('b1', 'Nome');
$active_sheet->setCellValue('c1', 'Produto');
$active_sheet->setCellValue('d1', 'Agente');
$active_sheet->setCellValue('e1', 'Anomes');
$active_sheet->setCellValue('f1', 'Data Agendada');
$active_sheet->setCellValue('g1', 'Valor a Receber');
$active_sheet->setCellValue('h1', 'Valor Recebido');
$active_sheet->setCellValue('i1', 'Valor Cancelado');
$active_sheet->setCellValue('j1', 'Valor Desconto');
$active_sheet->setCellValue('k1', 'Endereco');
$active_sheet->setCellValue('l1', 'Bairro');
$active_sheet->setCellValue('m1', 'Cidade');
$active_sheet->setCellValue('n1', 'Estado');
$active_sheet->setCellValue('o1', 'Cpf Cnpj');
$active_sheet->setCellValue('p1', 'Setor');
$active_sheet->setCellValue('q1', 'Funcionario');
$active_sheet->setCellValue('r1', 'Recebido');
$active_sheet->setCellValue('s1', 'Data Recebimento');
$active_sheet->setCellValue('t1', 'Data Faturamento');
$active_sheet->setCellValue('u1', 'Cobranca');
$active_sheet->setCellValue('v1', 'Impresso');
$active_sheet->setCellValue('w1', 'Confirmar Doacao');
$active_sheet->setCellValue('x1', 'Cod Antigo');


$count = 2;
foreach($dadosatendimento as $row){
/*$produtor = (new Orm('usuarios'))->select(['nome'])
->where(['id_usuario', $row->para])->first()->get();

if(!empty($produtor)){
  $prod = $produtor->nome;
}else{
  $prod = 'Sem Produtor';
}*/
//echo $prod.'<br>';
//exit;
$active_sheet->setCellValue('a'.$count, $row->nrecibo ?? '');
$active_sheet->setCellValue('b'.$count, $row->nome ?? '');
$active_sheet->setCellValue('c'.$count, $row->produto ?? '');
$active_sheet->setCellValue('d'.$count, $row->agente ?? '');
$active_sheet->setCellValue('e'.$count, $row->anomes ?? '');
$active_sheet->setCellValue('f'.$count, $row->data_agendada ?? '');
$active_sheet->setCellValue('g'.$count, $row->valor ?? '');
$active_sheet->setCellValue('h'.$count, $row->valor_pago ?? '');
$active_sheet->setCellValue('i'.$count, $row->valor_cancelado ?? '');
$active_sheet->setCellValue('j'.$count, $row->desconto ?? '');
$active_sheet->setCellValue('k'.$count, $row->endereco ?? '');
$active_sheet->setCellValue('l'.$count, $row->bairro ?? '');
$active_sheet->setCellValue('m'.$count, $row->cidade ?? '');
$active_sheet->setCellValue('n'.$count, $row->estado ?? '');
$active_sheet->setCellValue('o'.$count, $row->cpf_cnpj ?? '');
$active_sheet->setCellValue('p'.$count, $row->setor ?? '');
$active_sheet->setCellValue('q'.$count, $row->funcionario ?? '');
$active_sheet->setCellValue('r'.$count, $row->recebido ?? '');
$active_sheet->setCellValue('s'.$count, $row->data_recebimento ?? '');
$active_sheet->setCellValue('t'.$count, $row->data_faturamento ?? '');
$active_sheet->setCellValue('u'.$count, $row->cobranca ?? '');
$active_sheet->setCellValue('v'.$count, $row->impresso ?? '');
$active_sheet->setCellValue('w'.$count, $row->confirmardoacao ?? '');
$active_sheet->setCellValue('x'.$count, $row->id_importacao ?? '');

$count = $count +1;
}

$writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($file, $formato);

$file_name = time().'.'.strtolower(($formato));
$writer->save($file_name);
header("Content-Type: application/x-www-form-urlencoded");
header("Content-Transfer-Encoding:Binary");
header("Content-disposition:attachment;filename=\"".$file_name."\"");
readfile($file_name);
unlink($file_name);
exit;

}//exportar boletos

public function faturamento(){
  $this->arr['list_js'] = array(
  'plugins/jquery.mask.min',
  'plugins/parsley/parsley.min',
  'plugins/parsley/pt-br',
  'mask_init',
  'preview_imagem',
  'uploadImage',
  'functions_js',
  'plugins/sweetalert2',
  'system'
  );

  $this->arr['contribuinte']  = (new Orm('leads'))->select('*')->order(['nome asc'])->get();

  if(isset($_POST['tipo']) && !empty($_POST['tipo'])){
  
    switch ($_POST['tipo']) {
      case 'fidelizado_recibo_avulso':
        $funcionario = $_POST['funcionario'];
          
        $r = new Financeiro();	           
        $rb = $r->fidelizado_recibo_avulso($_POST['tipo'],$_POST['contribuinte_sel'],$this->user->getId());        
        echo "fidelizado_recibo_avulso";
        break;
      case 'fidelizado_recibo':
        $funcionario = $_POST['funcionario'];
          
        $r = new Financeiro();	           
        $rb = $r->fidelizado_recibo($_POST['tipo'],$funcionario,$this->user->getId(),$_POST['dia_inicial'],$_POST['dia_final']);        
        echo "fidelizado_recibo";
        break;
      case 'fidelizado_deposito':
        $funcionario = $_POST['funcionario'];
          
        $r = new Financeiro();	           
        $rb = $r->fidelizado_deposito($_POST['tipo'],$funcionario,$this->user->getId(),$_POST['dia_inicial'],$_POST['dia_final']);          
          echo "fidelizado_deposito";
          break;
      case 'fidelizado_boleto':
        $funcionario = $_POST['funcionario'];
          
        $r = new Financeiro();	           
          $rb = $r->fidelizado_boleto($_POST['tipo'],$funcionario,$this->user->getId(),$_POST['dia_inicial'],$_POST['dia_final']);          
          echo "fidelizado_boleto";
          break;        
         // echo "aguardando configuração bancaria";
         // break;
      case 'extra_esporadico':
          /* TODOS NO financeiro_faturamento 
          VALOR > 0
          fpagamento != CANCELADO
          data_faturamento NULL
          atualizar o campo data_faturamento e usuario_faturou
          */
          $funcionario = $_POST['funcionario'];
          $fpagamento = 'MENSAGEIRO';

          $r = new Financeiro();	           
          $rb = $r->extra_esporadico($_POST['tipo'],$funcionario,$this->user->getId(),$_POST['data_inicial'],$_POST['data_final'],$fpagamento);


          echo "extra_esporadico_mensageiro";
          break;         
          
          case 'extra_esporadico_pix':
            /* TODOS NO financeiro_faturamento 
            VALOR > 0
            fpagamento != CANCELADO
            data_faturamento NULL
            atualizar o campo data_faturamento e usuario_faturou
            */
            $funcionario = $_POST['funcionario'];
            $fpagamento = 'PIX';
            
            $r = new Financeiro();	           
            $rb = $r->extra_esporadico($_POST['tipo'],$funcionario,$this->user->getId(),$_POST['data_inicial'],$_POST['data_final'],$fpagamento);
  
  
            echo "extra_esporadico_pix";
            break;     

            case 'extra_esporadico_boleto':
              /* TODOS NO financeiro_faturamento 
              VALOR > 0
              fpagamento != CANCELADO
              data_faturamento NULL
              atualizar o campo data_faturamento e usuario_faturou
              */
              $funcionario = $_POST['funcionario'];
              $fpagamento = 'BOLETO';
              
              $r = new Financeiro();	           
              $rb = $r->extra_esporadico($_POST['tipo'],$funcionario,$this->user->getId(),$_POST['data_inicial'],$_POST['data_final'],$fpagamento);
    
    
              echo "extra_esporadico_boleto";
              break;   


  }
      exit;
  
  }



  $this->loadTemplate('financeiro/financeiro_gerarfaturamento', $this->arr);
}//add

public function empresa(){
  $this->arr['list_js'] = array(
  'plugins/jquery.mask.min',
  'plugins/parsley/parsley.min',
  'plugins/parsley/pt-br',
  'mask_init',
  'preview_imagem',
  'uploadImage',
  'functions_js',
  'plugins/sweetalert2',
  'system'
  );
  
$tab = new Orm('financeiro_empresa');
$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);

if(isset($_GET['nome_empresa']) && !empty($_GET['nome_empresa'])){
$nome = addslashes($_GET['nome_empresa']);
$this->arr['lista'] = $tab->select('*')->search(['nome_empresa', $nome])->get();
}else{
$this->arr['lista'] = $tab->select('*')->paginate('10')->get();
$this->arr['paginacao'] = $tab->render("financeiro_empresa");
}
  
  $this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
  $this->loadTemplate('financeiro/empresa_listar', $this->arr);
}//add

public function empresaadd(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'preview_imagem',
'uploadImage',
'functions_js',
'plugins/sweetalert2',
'system'
);


$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('financeiro/empresa_adicionar', $this->arr);
}//add


public function empresaedit($id){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'preview_imagem',
'uploadImage',
);

$this->arr['id_empresa'] = $id;
$this->arr['info'] = (new Orm('financeiro_empresa'))->select('*')->where(['id_empresa', $id])
->first()->get();
$this->loadTemplate('financeiro/empresa_editar', $this->arr);
}//edit


public function empresasave(){

if(isset($_POST['nome_empresa']) && !empty($_POST['nome_empresa'])){
 $id_empresa = (isset($_POST['id_empresa'])) ? $this->limpaCampo($_POST['id_empresa']) : NULL; 
 $nome = $this->limpaCampo($_POST['nome_empresa']);

$consulta = (new Orm('financeiro_empresa'))->select('*')->where(['nome_empresa', $nome])->first()->get();

if(!empty($consulta)){
  $_SESSION['msg'] = array('type'=>'error', 'msg'=>'Ooppss, ja existe cadastro com esse número ou nome no sistema, por favor tente novamente!!!');
  header("Location:".BASE_URL."financeiro/empresa");
  exit;  
}
//echo $id_empresa;
//exit;
$dados_form = [
'nome_empresa'=>$_POST['nome_empresa'],
'cnpj'=>$_POST['cnpj'],
'banco'=>$_POST['banco'],
'ag'=>$_POST['ag'],
'ag_digito'=>$_POST['ag_digito'],
'cc'=>$_POST['cc'],
'cc_digito'=>$_POST['cc_digito'],
'convenio'=>$_POST['convenio'],
'variacao'=>$_POST['variacao'],
'carteira'=>$_POST['carteira']
];

if($id_empresa == null){
 $grv = (new Orm('financeiro_empresa'))->set($dados_form)->save();
 $_SESSION['msg'] = array('type'=>'success', 'msg'=>'Empresa cadastrada com sucesso!');
 $this->redirect(BASE_URL."financeiro/empresa"); 
}else{
 $grv = (new Orm('financeiro_empresa'))->set($dados_form)->where(['id_empresa', $id_empresa])->update();
 $_SESSION['msg'] = array('type'=>'success', 'msg'=>'Empresa Editada com sucesso!');
 header("Location:".BASE_URL."financeiro/empresa");
 exit;
}

}

}//save


public function remessasicredi($dti,$dtf,$unir,$tipo){
  $data = array();
  $u = new Users();
  /*
  $u->setLoggedUser();
  $company = new Companies($u->getCompany());
  $data['company_name'] = $company->getName();
  $data['user_email'] = $u->getEmail();
  $data['permitidos'] = $u->getPermissionList();
  */
  //echo 'Aqui';
  //exit;
  $unidade = $unir;
  $di = $dti;
  $df = $dtf;
  $tip = $tipo;
  //echo $tip;
  //exit;
  
  if($tip == "venda"){
   // echo $tip;
   // exit;
    $r = new Financeiro();	           
    $rb = $r->boleto_remessacomerciobb($unidade, $di, $df);
    //print_r($rb);
    //exit;
  }else{
    //$r = new tmprel();	           
    //$rb = $r->boleto_remessabb($unidade, $di, $df);
  }
    if (count($rb) == 0 ){
      echo ('NÃO EXISTEM BOLETOS PARA REMESSA NESSE PERIODO');
    
    }else{
    //echo 'REMESSA GERADA COM SUCESSO EM C:\REMESSA<BR><BR>';
  
  date_default_timezone_set('America/Sao_Paulo');
  $dt1 = date("Y-m-d H:i:s");
  $dt1n = explode("-", $dt1);
  $dt2 = explode(":", $dt1);
  $dia = substr($dt1n[2], 0,2);
  $mes = $dt1n[1];
  $ano = substr($dt1n[0], 2,4);
  
  if ($mes == 1){$mn = '1';};
  if ($mes == 2){$mn = '2';};
  if ($mes == 3){$mn = '3';};
  if ($mes == 4){$mn = '4';};
  if ($mes == 5){$mn = '5';};
  if ($mes == 6){$mn = '6';};
  if ($mes == 7){$mn = '7';};
  if ($mes == 8){$mn = '8';};
  if ($mes == 9){$mn = '9';};
  if ($mes == 10){$mn = 'O';};
  if ($mes == 11){$mn = 'N';};
  if ($mes == 12){$mn = 'D';};
  
    $uni = new Financeiro();
    $unid = $uni->getListboleto($unidade);
  
  //echo "<pre>";
  //print_r($unid);
  
  $cccc = $unid[0]['transmissao'];
  //print_r($cccc);
  //exit;
  
  
  $h = substr($dt2[0], 11,12);
  $m = $dt2[1];
  $s = $dt2[2];
  $dt = $dia.$mes.$ano;
  $hms = $h.$m.$s;
  
  
      header('Content-disposition: attachment; filename='.$cccc.$mn.$dia.'.CRM');
      header('Content-type: text/plain');
        
  //echo "<pre>";
  //print_r($unid);
  ////echo $sintetica;
  ////echo $analitica;
  ////print_r($data);
  //exit;
    foreach ($unid as $header0): 
    
  //escrever REGISTRO 0 = Header
  /*
  01.0 001 a 001 9(001) Identificação do Registro Header: “0” (zero)
  02.0 002 a 002 9(001) Tipo de Operação: “1” (um)
  03.0 003 a 009 X(007) Identificação por Extenso do Tipo de Operação 01
  04.0 010 a 011 9(002) Identificação do Tipo de Serviço: “01”
  05.0 012 a 019 X(008) Identificação por Extenso do Tipo de Serviço: “COBRANCA”
  06.0 020 a 026 X(007) Complemento do Registro: “Brancos”
  07.0 027 a 030 9(004)
  Prefixo da Agência: Número da Agência onde está cadastrado o
  convênio líder do cedente 02
  08.0 031 a 031 X(001) Dígito Verificador - D.V. - do Prefixo da Agência. 02
  09.0 032 a 039 9(008)
  Número da Conta Corrente: Número da conta onde está
  cadastrado o Convênio Líder do Cedente 02
  10.0 040 a 040 X(001)
  Dígito Verificador - D.V. – do Número da Conta Corrente do
  Cedente 02
  11.0 041 a 046 9(006) Complemento do Registro: “000000”
  12.0 047 a 076 X(030) Nome do Cedente
  13.0 077 a 094 X(018) 001BANCODOBRASIL
  14.0 095 a 100 9(006) Data da Gravação: Informe no formato “DDMMAA” 21
  15.0 101 a 107 9(007) Seqüencial da Remessa 03
  16.0 108 a 129 X(22) Complemento do Registro: “Brancos”
  17.0 130 a 136 9(007)
  Número do Convênio Líder (numeração acima de 1.000.000 um
  milhão)" 04
  18.0 137 a 394 X(258) Complemento do Registro: “Brancos”
  19.0 395 a 400 9(006) Seqüencial do Registro:”000001”
  */
  
  $h1001 = 0;
  $h1002 = 1;
  $h1003 = 'REMESSA';
  $h1010 = '01';
  
  $h1012i = 'COBRANCA';
  $h1012 = substr($h1012i, 0,15);
  if(strlen($h1012) <=15){
    $h1012t = str_pad($h1012, 15,'*', STR_PAD_RIGHT);
    $h1012 = str_replace("*", " ", $h1012t);
  }
  
  $h1027 = $header0['transmissao']; //PEGAR DO BANCO DE DADOS
  
  $h1032 = str_pad(str_replace('/', '',str_replace('-', '',str_replace('.', '',$header0['cnpj']))), 14,'0', STR_PAD_LEFT);
  //echo $h1032;
  //exit;
  
  $h1046i = '';
  
  $h1046 = substr($h1046i, 0,31);
  if(strlen($h1046) <=31){
    $h1046t = str_pad($h1046, 31,'*', STR_PAD_RIGHT);
    $h1046 = str_replace("*", " ", $h1046t);
  }
  
  $h1077 = '748';
  
  $h1080i = 'SICREDI';
  
  $h1080 = substr($h1080i, 0,15);
  if(strlen($h1080) <=15){
    $h1080t = str_pad($h1080, 15,'*', STR_PAD_RIGHT);
    $h1080 = str_replace("*", " ", $h1080t);
  }
  
  date_default_timezone_set('America/Sao_Paulo');
  $data = date("d/m/Y");
  $data = explode("/", $data);
  $dia = $data[0];
  $mes = $data[1];
  $ano = substr($data[2], 0,4);
  $h1095 = $ano.$mes.$dia;
  
  $h1103i = '';
  
  $h1103 = substr($h1103i, 0,8);
  if(strlen($h1103) <=8){
    $h1103t = str_pad($h1103, 8,'*', STR_PAD_RIGHT);
    $h1103 = str_replace("*", " ", $h1103t);
  }
  
  $h1111 = '0000001';
  
  
  $h1118i = '';
  
  $h1118 = substr($h1118i, 0,273);
  if(strlen($h1118) <=273){
    $h1118t = str_pad($h1118, 273,'*', STR_PAD_RIGHT);
    $h1118 = str_replace("*", " ", $h1118t);
  }
  
  $h1391 = '2.00';
  
  $h1395 = '000001';
  
    endforeach;
  
  $Header = $h1001.$h1002.$h1003.$h1010.$h1012.$h1027.$h1032.$h1046.$h1077.$h1080.$h1095.$h1103.$h1111.$h1118.$h1391.$h1395;
  echo $Header;
  //exit;
  echo "\r\n";
  
  //echo "<pre>";
  //print_r($unid);
  //echo $sintetica;
  //echo $analitica;
  //print_r($data);
  //exit;	
  
  //escrever REGISTRO 1 = Registro Movimento - Remessa
  /*
  01.7 001 a 001 9(001) Identificação do Registro Detalhe: 7 (sete)
  02.7 002 a 003 9(002) Tipo de Inscrição do Cedente 22
  03.7 004 a 017 9(014) Número do CPF/CNPJ do Cedente
  04.7 018 a 021 9(004) Prefixo da Agência 02
  05.7 022 a 022 X(001) Dígito Verificador - D.V. - do Prefixo da Agência 02
  06.7 023 a 030 9(008) Número da Conta Corrente do Cedente 02
  07.7 031 a 031 X(001) Dígito Verificador - D.V. - do Número da Conta Corrente do
  Cedente 02
  08.7 032 a 038 9(007) Número do Convênio de Cobrança do Cedente 02
  09.7 039 a 063 X(025) Código de Controle da Empresa 23
  10.7 064 a 080 9(017) Nosso-Número 06
  11.7 081 a 082 9(002) Número da Prestação: “00” (Zeros)
  12.7 083 a 084 9(002) Grupo de Valor: “00” (Zeros)
  13.7 085 a 087 X(003) Complemento do Registro: “Brancos”
  14.7 088 a 088 X(001) Indicativo de Mensagem ou Sacador/Avalista 13
  15.7 089 a 091 X(003) Prefixo do Título: “Brancos”
  16.7 092 a 094 9(003) Variação da Carteira 02
  17.7 095 a 095 9(001) Conta Caução: “0” (Zero)
  18.7 096 a 101 9(006) Número do Borderô: “000000” (Zeros)
  19.7 102 a 106 X(005) Tipo de Cobrança 24
  20.7 107 a 108 9(002) Carteira de Cobrança 25
  21.7 109 a 110 9(002) Comando 20
  22.7 111 a 120 X(010) Seu Número/Número do Título Atribuído pelo Cedente 05
  23.7 121 a 126 9(006) Data de Vencimento 08
  24.7 127 a 139 9(011)v99 Valor do Título 19
  25.7 140 a 142 9(003) Número do Banco: “001”
  26.7 143 a 146 9(004) Prefixo da Agência Cobradora: “0000” 26
  27.7 147 a 147 X(001) Dígito Verificador do Prefixo da Agência Cobradora: “Brancos”
  28.7 148 a 149 9(002) Espécie de Titulo 07
  29.7 150 a 150 X(001) Aceite do Título: 27
  30.7 151 a 156 9(006) Data de Emissão: Informe no formato “DDMMAA” 28
  31.7 157 a 158 9(002) Instrução Codificada 09
  32.7 159 a 160 9(002) Instrução Codificada 09
  33.7 161 a 173 9(011)v99 Juros de Mora por Dia de Atraso 10
  34.7 174 a 179 9(006) Data Limite para Concessão de Desconto/Data de Operação do
  BBVendor/Juros de Mora. 11
  35.7 180 a 192 9(011)v99 Valor do Desconto 29
  36.7 193 a 205 9(011)v99 Valor do IOF/Qtde Unidade Variável. 30
  37.7 206 a 218 9(011)v99 Valor do Abatimento 31
  38.7 219 a 220 9(002) Tipo de Inscrição do Sacado 32 - fisicao ou juridica 01 ou 02 pegar do cadatro do cliente.
  39.7 221 a 234 9(014) Número do CNPJ ou CPF do Sacado 33
  40.7 235 a 271 X(037) Nome do Sacado 
  41.7 272 a 274 X(003) Complemento do Registro: “Brancos”
  42.7 275 a 314 X(040) Endereço do Sacado
  43.7 315 a 326 X(012) Bairro do Sacado
  44.7 327 a 334 9(008) CEP do Endereço do Sacado
  45.7 335 a 349 X(015) Cidade do Sacado
  46.7 350 a 351 X(002) UF da Cidade do Sacado
  47.7 352 a 391 X(040) Observações/Mensagem ou Sacador/Avalista 13
  48.7 392 a 393 X(002) Número de Dias Para Protesto 34
  49.7 394 a 394 X(001) Complemento do Registro: “Brancos”
  50.7 395 a 400 9(006) Seqüencial de Registro 35
  */
  
  //	$r = new tmprel();	           
  //	$rb = $r->boleto_remessa($unidade, $di, $df);
  
  if($tip == "venda"){
    //echo $tip;
    //exit;
    $r = new Financeiro();	           
    $rb = $r->boleto_remessacomercio($unidade, $di, $df);
    //print_r($rb);
    //exit;
  }else{
   // $r = new tmprel();	           
  //  $rb = $r->boleto_remessabb($unidade, $di, $df);
  }
  
    $i = 2;
    $total2 = 0;
    foreach ($rb as $bol): 
    //echo '1';
    $mr001 = '1';
    $mr002 = 'AAA';
    $mr005i = '';
  
    $mr005 = substr($mr005i, 0,12);
    if(strlen($mr005) <=12){
      $mr005t = str_pad($mr005, 12,'*', STR_PAD_RIGHT);
      $mr005 = str_replace("*", " ", $mr005t);
    }
  
    $mr017 = 'AAB';
  
    $mr020i = '';
    $mr020 = substr($mr020i, 0,28);
    if(strlen($mr020) <=28){
      $mr020t = str_pad($mr020, 28,'*', STR_PAD_RIGHT);
      $mr020 = str_replace("*", " ", $mr020t);
    }
  
    $mr048 =  str_replace('/', '',str_replace('-', '',str_replace('.', '', $bol['nnumero'])));
  
    $mr057i = '';
    $mr057 = substr($mr057i, 0,6);
    if(strlen($mr057) <=6){
      $mr057t = str_pad($mr057, 6,'*', STR_PAD_RIGHT);
      $mr057 = str_replace("*", " ", $mr057t);
    }
  
    
  date_default_timezone_set('America/Sao_Paulo');
  $data1 = $bol['data'];
  $data1 = explode("-", $data1);
  $dia = $data1[2];
  $mes = $data1[1];
  $ano = substr($data1[0], 0,4);
    
    $mr063 =  $ano.$mes.$dia;
  
    $mr071i = '';
    $mr071 = substr($mr071i, 0,1);
    if(strlen($mr071) <=1){
      $mr071t = str_pad($mr071, 1,'*', STR_PAD_RIGHT);
      $mr071 = str_replace("*", " ", $mr071t);
    }
    
    $mr072 = 'N';
  
    $mr073i = '';
    $mr073 = substr($mr073i, 0,1);
    if(strlen($mr073) <=1){
      $mr073t = str_pad($mr073, 1,'*', STR_PAD_RIGHT);
      $mr073 = str_replace("*", " ", $mr073t);
    }
  
    $mr074 = 'B';
  
    $mr075 = '00';
  
    $mr077 = '00';
  
    $mr079i = '';
    $mr079 = substr($mr079i, 0,4);
    if(strlen($mr079) <=4){
      $mr079t = str_pad($mr079, 4,'*', STR_PAD_RIGHT);
      $mr079 = str_replace("*", " ", $mr079t);
    }
  
    $mr083 = '0000000000';
  
    $mr093 = '0200';
  
    $mr097i = '';
    $mr097 = substr($mr097i, 0,12);
    if(strlen($mr097) <=12){
      $mr097t = str_pad($mr097, 12,'*', STR_PAD_RIGHT);
      $mr097 = str_replace("*", " ", $mr097t);
    }	
  
  
    $mr109 = '01';
    $mr111 = '0'.$mr048;
  
    date_default_timezone_set('America/Sao_Paulo');
    $data1 = $bol['data'];
    $data1 = explode("-", $data1);
    $dia = $data1[2];
    $mes = $data1[1];
    $ano = substr($data1[0], 2,4);
    
    $mr121 =  $dia.$mes.$ano;
  
    if ($bol['vboleto'] >0){
    $mr127i = $bol['vboleto'];
    $mr127 = str_pad($mr127i, 13,'0', STR_PAD_LEFT);
    }else{
    $mr127i ='0';
    $mr127 = substr($mr127i, 0,13);
    if(strlen($mr127) <=13){
      $mr127 = str_pad($mr127, 13,'0', STR_PAD_LEFT);
      //$mr111 = str_replace("*", "&nbsp;", $mr111t);
    }
    }
  
    $mr140i = '';
    $mr140 = substr($mr140i, 0,9);
    if(strlen($mr140) <=9){
      $mr140t = str_pad($mr140, 9,'*', STR_PAD_RIGHT);
      $mr140 = str_replace("*", " ", $mr140t);
    }	
  
    $mr149 = 'J';
    $mr150 = 'N';
  
  date_default_timezone_set('America/Sao_Paulo');
  $dt1 = date("Y-m-d H:i:s");
  $dt1n = explode("-", $dt1);
  $dt2 = explode(":", $dt1);
  $dia = substr($dt1n[2], 0,2);
  $mes = $dt1n[1];
  $ano = substr($dt1n[0], 2,4);
  
  
    $mr151 =  $dia.$mes.$ano;
  //echo $mr151;
  //exit;
    $mr157 =  '00';
    $mr159 =  '00';
    $mr161 =  '0000000000003';
  
  $desc = str_replace('.', '',number_format($bol['valor']*.05, 2, '.', ''));
  $desc1 = str_pad($desc, 13,'0', STR_PAD_LEFT);
  
    
    if($bol['iduni'] == 37 || $bol['iduni'] == 36 || $bol['iduni'] == 75){
      $mr174 = '000000';
      $mr180 = '0000000000000';
    }else{
      $mr174 = $mr121;
      $mr180 = $desc1;
    }	
  
  //	$mr174 =  '000000';
  //	$mr180 =  '0000000000000';
  
    $mr193 =  '0000000000000';
    $mr206 =  '0000000000000';
  //	$mr219 =  substr($bol['tipocli'], 1,2);
    $mr221count =  strlen(str_replace('/', '',str_replace('-', '',str_replace('.', '', $bol['cpf_cnpj']))));
    if($mr221count < 12){
    $mr219 = '1';//PEGAR DO CADASTRO DO CLIENTE	
    }else{
    $mr219 = '2';
    }
  //	echo substr($bol['tipocli'], 1,2);
  //	exit;
    $mr220 =  '0';
  
    //$mr219 = $bol['tipocli'];//PEGAR DO CADASTRO DO CLIENTE
    $mr221 = str_pad(str_replace('/', '',str_replace('-', '',str_replace('.', '',$bol['cpf_cnpj']))), 14,'0', STR_PAD_LEFT);
  
    $mr235i = strtoupper($bol['nome_razao_social']);
  
       $mr235 = strtr(utf8_decode(substr($mr235i, 0,40)),
                   utf8_decode('ŠŒŽšœžŸ¥µÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜÝßàáâãäåæçèéêëìíîïðñòóôõöøùúûüýÿ'),
                               'SOZsozYYuAAAAAAACEEEEIIIIDNOOOOOOUUUUYsaaaaaaaceeeeiiiionoooooouuuuyy');
  
  //	$mr235 = substr($mr235i, 0,37);
    if(strlen($mr235) <=40){
      $mr235t = str_pad($mr235, 40,'*', STR_PAD_RIGHT);
      $mr235 = str_replace("*", " ", $mr235t);
    }
  
    $mr275i = strtoupper($bol['end_cli'].', '.$bol['n_cli']);
  
       $mr275 = strtr(utf8_decode(substr($mr275i, 0,40)),
                   utf8_decode('ŠŒŽšœžŸ¥µÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜÝßàáâãäåæçèéêëìíîïðñòóôõöøùúûüýÿ'),
                               'SOZsozYYuAAAAAAACEEEEIIIIDNOOOOOOUUUUYsaaaaaaaceeeeiiiionoooooouuuuyy');
  
  //	$mr335 = substr($mr335i, 0,15);
    if(strlen($mr275) <=40){
      $mr275t = str_pad($mr275, 40,'*', STR_PAD_RIGHT);
      $mr275 = str_replace("*", " ", $mr275t);
    }
  
  
    //$mr275i = strtoupper($bol['end_cli'].', '.$bol['n_cli']);
    //$mr275 = substr($mr275i, 0,40);
    //if(strlen($mr275) <=40){
  //		$mr275t = str_pad($mr275, 40,'*', STR_PAD_RIGHT);
  //		$mr275 = str_replace("*", " ", $mr275t);
  //	}	
  
  
  
    //$mr335i = strtoupper($bol['cid_cli']);
  
    $mr315 = '00000';
    $mr320 = '000000';
  
    $mr326i = '';
    $mr326 = substr($mr326i, 0,1);
    if(strlen($mr326) <=1){
      $mr326t = str_pad($mr326, 1,'*', STR_PAD_RIGHT);
      $mr326 = str_replace("*", " ", $mr326t);
    }	
  
    $mr327 = str_replace(".", "",str_replace("-", "",$bol['cep_cli']));
    //$mr332 = '';
    //$mr327 = str_replace(".", "",str_replace("-", "",substr($bol['cep_cli'],0,-4))).str_replace(".", "",str_replace("-", "",substr($bol['cep_cli'],6)));
    $mr335 = '00000';
  
    //$mr219 = $bol['tipocli'];//PEGAR DO CADASTRO DO CLIENTE
    $mr340 = str_pad(str_replace('/', '',str_replace('-', '',str_replace('.', '',$bol['cpf_cnpj']))), 14,'0', STR_PAD_LEFT);
  
    $mr354i = ' ';//strtoupper($bol['nome_razao_social']);
       $mr354 = strtr(utf8_decode(substr($mr354i, 0,41)),
                   utf8_decode('ŠŒŽšœžŸ¥µÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜÝßàáâãäåæçèéêëìíîïðñòóôõöøùúûüýÿ'),
                               'SOZsozYYuAAAAAAACEEEEIIIIDNOOOOOOUUUUYsaaaaaaaceeeeiiiionoooooouuuuyy');
  
  //	$mr235 = substr($mr235i, 0,37);
    if(strlen($mr354) <=41){
      $mr354t = str_pad($mr354, 41,'*', STR_PAD_RIGHT);
      $mr354 = str_replace("*", " ", $mr354t);
    }
  
    $mr395i = $i++;
    $mr395 = substr($mr395i, 0,6);
    if(strlen($mr395) <=6){
      $mr395 = str_pad($mr395i, 6,'0', STR_PAD_LEFT);
      
    }
  
    $Movimento = $mr001.$mr002.$mr005.$mr017.$mr020.$mr048.$mr057.$mr063.$mr071.$mr072.$mr073.$mr074.$mr075.$mr077.$mr079.$mr083.$mr093.$mr097.$mr109.$mr111.$mr121.$mr127.$mr140.$mr149.$mr150.$mr151.$mr157.$mr159.$mr161.$mr174.$mr180.$mr193.$mr206.$mr219.$mr220.$mr221.$mr235.$mr275.$mr315.$mr320.$mr326.$mr327.$mr335.$mr340.$mr354.$mr395;
    echo $Movimento;
    echo "\r\n";
    $total2 = $bol['valor'] + $total2;
    //exit;
    endforeach;
  //	}
  
  //exit;
  
  //escrever REGISTRO 1 = Registro Trailler - Remessa
  
  $t001 = '9';
  $t002 = '1';
  $t003 = '748';
  $t006 = $header0['transmissao'];
  
  
    $t021i = '';
    $t021 = substr($t021i, 0,384);
    if(strlen($t021) <=384){
      $mr021t = str_pad($t021, 384,'*', STR_PAD_RIGHT);
      $t021 = str_replace("*", " ", $mr021t);
      
    }
  
    $t395i = $i++;
    $t395 = str_pad($t395i, 6,'0', STR_PAD_LEFT);
  
  /*$t395
  */
    $Trailler = $t001.$t002.$t003.$t006.$t021.$t395;
    echo $Trailler;
    echo "\r\n";
  
  //echo "<pre>";
  //print_r($rb);
  //echo $sintetica;
  //echo $analitica;
  //print_r($data);
    
  //$this->loadTemplate('report_relapagar_sint', $data);
  
  //$salvaraquivo = strtoupper(str_replace("&nbsp;", " ", $Header)."\n".str_replace("&nbsp;", " ", $Movimento)."\n".str_replace("&nbsp;", " ", $Trailler))."\n";
  //echo 'criado com sucesso';
  //$texto = 'meu teste';
  
  //date_default_timezone_set('America/Sao_Paulo');
  //$dt1 = date("Y-m-d H:i:s");
  //$dt1n = explode("-", $dt1);
  //$dt2 = explode(":", $dt1);
  //$dia = substr($dt1n[2], 0,2);
  //$mes = $dt1n[1];
  //$ano = substr($dt1n[0], 2,4);
  //$h = substr($dt2[0], 11,12);
  //$m = $dt2[1];
  //$s = $dt2[2];
  //$dt = $dia.$mes.$ano;
  //$hms = $h.$m.$s;
  
  //echo '<br>'.$dt.$hms;
  //exit;
  
  
  //file_put_contents("relatorios/remesa"."BB".$dt.$hms.".txt", $salvaraquivo );
  
  //header("Location:".BASE_URL."/remessa/salvar");
  //echo 'criado com sucesso';
  
  //echo "\n";
  //echo file_get_contents("novo.txt");
  //file_put_contents("novo.txt", "Agora sim a segunda linha...", FILE_APPEND);
  
  
  
  }//end if
  
  }//remessa sicredi


  public function boleto_remessacomercio($iduni, $di, $df){
    $array = array();
    $mat2 = "VENDA";
    
    $sql = $this->db->prepare("SELECT * FROM vw_boleto_remessa_venda WHERE iduni = :iduni and tipo like '%".$mat2."%' and data_venda between '$di' AND '$df' ");
    $sql->bindValue(':iduni', $iduni);
    $sql->execute();
    
    if($sql->rowCount()>0){
    $array = $sql->fetchall(PDO::FETCH_ASSOC);
    }
    
    //echo "<pre>";
    //print_r($array);
    //exit;
    
    return $array;
    
    }//function offset

    public function boletosicredi()
    {

        $data = array();
        $u = new Users();

        $u->setLoggedUser();
        $company = new Companies($u->getCompany());
        $data['company_name'] = $company->getName();
        $data['user_email'] = $u->getEmail();
        $data['permitidos'] = $u->getPermissionList();


        $c = new Financeiro();
        $data['lista_contratos_parcelas_bol'] = $c->getListbol($u->getCompany());


        // NÃO ALTERAR!
        include("boleto/boletophp/include/layout_sicredi.php");
        exit;



        $this->loadTemplate('boleto', $data);
    } //boleto sicredi
    
    
}