<?php
use Core\Controller;
use Models\Users;
use Models\Leads;
use Models\Permissao;
use Models\Orm;
use Models\Helpers;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\IOFactory;


class GetnetController extends Controller {

  private $user;
  private $arr;
  private $permissao;

    public function __construct() {              
        $this->user = new Users();
        $this->permissao = new Permissao(); 

        if($this->user->isLogged() == false){                  
         header("Location: ".BASE_URL."login");        
         exit;         
        }
       
        $permissoes = $this->permissao->getPermissoes();
        $modulo_boleto = $this->permissao->getPermissoesBoleto();
        
         $this->arr = array(
          'user'=>$this->user,
          'menuActive'=>'home',
          'permissao'=>$permissoes,
          'modulo_boleto'=>$modulo_boleto
         );          
}

public function index(){
  $this->arr['list_js'] = array(
    'import_csv_leads',
    'plugins/sweetalert2',
    'system'
    );
  //echo 'aqui';
  //exit;
  $this->loadTemplate('getnet/apigetnet', $this->arr);
}

public function leadprodutor(){

$this->user = new Users();

$this->arr['list_js'] = array(
'import_csv_leads',
'plugins/sweetalert2',
'system'
);
//echo $this->user->getUid();
//exit;

$tab = new Orm('leads');
if(isset($_FILES['import_leads']) && $_FILES['import_leads']['name'] != ''){

$permitidas = array('xls', 'csv', 'xlsx');
$file_array = explode('.', $_FILES['import_leads']['name']);
$file_extension = end($file_array);

if(in_array($file_extension, $permitidas)){

$file_name = time().'.'.$file_extension;
move_uploaded_file($_FILES['import_leads']['tmp_name'], $file_name);

$file_type = \PhpOffice\PhpSpreadsheet\IOFactory::identify($file_name);
$reader    = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($file_type);

$spreadsheet = $reader->load($file_name);
unlink($file_name);
$data = $spreadsheet->getActivesheet()->toArray();
$saida = array();
//echo '<pre>';
//print_r($data);
//exit;
$acertos = 0;
$errors = 0;
foreach($data as $key=> $row){
//'tipo_cotacao'=>$row[5],
//'qtde_vidas'=>$row[6],
if($row[0] != '' && isset(($row[0])) ){
  if($key >0){
  $grava = $tab->set([
  'nome'=>$row[0],
  'produto'=>$row[1],
  'telefone'=>$row[2],
  'origem'=>$row[3],
  'status'=>$row[4],
  'funil_id'=>$row[5],
  'para'=>$this->user->getUid()
  ])->save();

  if($grava){
    $acertos += 1;
  }else{
    $errors += 1;
  }

  }
}

}//foreach

$_SESSION['msg'] = ['type'=>'success','msg'=>"Foram importadas {$acertos} linhas importadas com sucesso e {$errors} linhas importadas com erro!"];
  header("Location:".BASE_URL."import/leadprodutor");
  exit;
}else{
  $_SESSION['msg'] = ['type'=>'error','msg'=>'Apenas xlx, csv ou xlsx tipos permitidos'];
  header("Location:".BASE_URL."import/leadprodutor");
  exit; 
}

}//se tve posto do arquivo de excel


$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('leads/importar', $this->arr);
}//lead produtor

public function distribuirdisparo(){
  $this->arr['list_js'] = array(
  'import_csv_leads',
  'plugins/sweetalert2',
  'system'
  );
  
  
  $tab = new Orm('distribuirdisparo');
  if(isset($_FILES['import_leads']) && $_FILES['import_leads']['name'] != ''){
  
  $permitidas = array('xls', 'csv', 'xlsx');
  $file_array = explode('.', $_FILES['import_leads']['name']);
  $file_extension = end($file_array);
  
  if(in_array($file_extension, $permitidas)){
  
  $file_name = time().'.'.$file_extension;
  move_uploaded_file($_FILES['import_leads']['tmp_name'], $file_name);
  
  $file_type = \PhpOffice\PhpSpreadsheet\IOFactory::identify($file_name);
  $reader    = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($file_type);
  
  $spreadsheet = $reader->load($file_name);
  unlink($file_name);
  $data = $spreadsheet->getActivesheet()->toArray();
  $saida = array();
  $arrayduplicado = array();
  //echo '<pre>';
  //print_r($data);
  //exit;
  $acertos = 0;
  $errors = 0;
  $duplicado = 0;
  //print_r($data);
  foreach($data as $key=> $row){
  //'tipo_cotacao'=>$row[5],
  //'qtde_vidas'=>$row[6],
      if($row[0] != '' && isset(($row[0])) ){
        if($key >0){
            $grava = $tab->set([
            'nome'=>$row[0],
            'numero'=>$row[1],
            'email'=>$row[2],
            'usuario'=>$row[3],
            'fila'=>$row[4],
            'conexao'=>$row[5],
            'texto'=>$row[6],
            'token'=>$row[7],
            'telvendedor'=>$row[8]
            ])->save();
  
            if($grava){
              $acertos += 1;
            }else{
              $errors += 1;
            }
        }
      }
    
    
  }//foreach
  //echo '<pre>';
  //print_r($arrayduplicado);
  $i = 0;
  $texto = '';
  for($i = 0;$i < $duplicado;$i++){
  $texto = $texto.$arrayduplicado[$i];
  }
  //echo $texto;
  //exit;
  //exit;
  $_SESSION['msg'] = ['type'=>'success','msg'=>"Foram importadas {$acertos} linhas importadas com sucesso e {$errors} linhas importadas com erro! Duplicados {$duplicado}:  {$texto} "];
    header("Location:".BASE_URL."import/distribuirdisparo");
    exit;
  }else{
    $_SESSION['msg'] = ['type'=>'error','msg'=>'Apenas xlx, csv ou xlsx tipos permitidos'];
    header("Location:".BASE_URL."import/distribuirdisparo");
    exit; 
  }
  
  }//se tve posto do arquivo de excel
  
  
  $this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
  $this->loadTemplate('leads/importar', $this->arr);
  }//lead

public function lead(){
$this->arr['list_js'] = array(
'import_csv_leads',
'plugins/sweetalert2',
'system'
);


$tab = new Orm('leads');
if(isset($_FILES['import_leads']) && $_FILES['import_leads']['name'] != ''){

$permitidas = array('xls', 'csv', 'xlsx');
$file_array = explode('.', $_FILES['import_leads']['name']);
$file_extension = end($file_array);

if(in_array($file_extension, $permitidas)){

$file_name = time().'.'.$file_extension;
move_uploaded_file($_FILES['import_leads']['tmp_name'], $file_name);

$file_type = \PhpOffice\PhpSpreadsheet\IOFactory::identify($file_name);
$reader    = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($file_type);

$spreadsheet = $reader->load($file_name);
unlink($file_name);
$data = $spreadsheet->getActivesheet()->toArray();
$saida = array();
$arrayduplicado = array();
//echo '<pre>';
//print_r($data);
//exit;
$acertos = 0;
$errors = 0;
$duplicado = 0;
//print_r($data);
foreach($data as $key=> $row){
//'tipo_cotacao'=>$row[5],
//'qtde_vidas'=>$row[6],
    if($row[0] != '' && isset(($row[0])) ){
      if($key >0){
        $cel = $row[2];
        $l = new Leads();
        $sql = $l->getcel($cel);
        //echo '<pre>';
        //print_r($sql['total']);
        //exit;
        if($sql['total']>0){
            $arrayduplicado[] = $row[2];
            $duplicado += 1;
            $errors += 1;
         }else{


          $grava = $tab->set([
          'nome'=>$row[0],
          'produto'=>$row[1],
          'telefone'=>$row[2],
          'origem'=>$row[3],
          'status'=>$row[4],
          'funil_id'=>$row[5],
          'para'=>$row[6]
          ])->save();

          if($grava){
            $acertos += 1;
          }else{
            $errors += 1;
          }
        }
      }
    }
  
  
}//foreach
//echo '<pre>';
//print_r($arrayduplicado);
$i = 0;
$texto = '';
for($i = 0;$i < $duplicado;$i++){
$texto = $texto.$arrayduplicado[$i];
}
//echo $texto;
//exit;
//exit;
$_SESSION['msg'] = ['type'=>'success','msg'=>"Foram importadas {$acertos} linhas importadas com sucesso e {$errors} linhas importadas com erro! Duplicados {$duplicado}:  {$texto} "];
  header("Location:".BASE_URL."import/lead");
  exit;
}else{
  $_SESSION['msg'] = ['type'=>'error','msg'=>'Apenas xlx, csv ou xlsx tipos permitidos'];
  header("Location:".BASE_URL."import/lead");
  exit; 
}

}//se tve posto do arquivo de excel


$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('leads/importar', $this->arr);
}//lead


public function motoristas(){
$this->arr['list_js'] = array(
'import_csv',
'sweetalert2.all.min'
);  

$m = new Orm('motorista');

if(isset($_FILES['import_motorista']) && $_FILES['import_motorista']['name'] != ''){

$permitidas = array('xls', 'csv', 'xlsx');
$file_array = explode('.', $_FILES['import_motorista']['name']);
$file_extension = end($file_array);


if(in_array($file_extension, $permitidas)){

$file_name = time().'.'.$file_extension;
move_uploaded_file($_FILES['import_motorista']['tmp_name'], $file_name);

$file_type = \PhpOffice\PhpSpreadsheet\IOFactory::identify($file_name);
$reader    = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($file_type);

$spreadsheet = $reader->load($file_name);
unlink($file_name);
$data = $spreadsheet->getActivesheet()->toArray();
$saida = array();

$acertos = 0;
$errors = 0;
foreach($data as $key=> $row){

if($key >0){
$grava = $m->set([
'cpf'=>$row[0],
'rg'=>$row[1],
'nome'=>$row[2],
'bairro'=>$row[3],
'cidade'=>$this->getCidade($row[4]),
'estado'=>$this->getUf($row[5]),
'cep'=>$row[6],
'telefone1'=>$row[7],
'cnh'=>$row[8],
'categoria'=>$row[9],
'validade'=>$row[10],
'placa'=>$row[11],
'modelo'=>$row[12]
])->save();

if($grava){
  $acertos += 1;
}else{
  $errors += 1;
}

}

}//foreach
echo "importados<br>";
echo "acertos:".$acertos."<br>";
echo "erros :".$errors;
exit;

}else{
  $this->arr['msg'] = 'Apenas xlx, csv ou xlsx tipos permitidos';  
}


}//se tve posto do arquivo de excel


$this->loadTemplate('importar/motoristas', $this->arr);
}//motoristas

public function getUf($estado){
$c = (new Orm('estado'))->select(['id_estado'])->where(['uf_estado', $estado])->first()->get();
return $c->id_estado ?? NULL;
}//getCidade

public function getCidade($cidade){
    
$c = (new Orm('cidade'))->select(['id_cidade'])->where(['nome_cidade', $cidade])->first()->get();

return $c->id_cidade ?? NULL;
}//getCidade

}