<?php
use Core\Controller;
use Models\Users;
use Models\Permissao;
use Models\Orm;
use Models\Email;

class HomeController extends Controller {

  private $user;
  private $arr;
  private $permissao;

    public function __construct() {              
        $this->user = new Users();
        $this->permissao = new Permissao(); 

        if($this->user->isLogged() == false){                  
         header("Location: ".BASE_URL."login");        
         exit;         
        }
      
       $permissoes = $this->permissao->getPermissoes();

        $this->arr = array(
         'user'=>$this->user,
         'menuActive'=>'home',
         'permissao'=>$permissoes             
        );          
}


public function index() {   
$this->arr['list_js'] = array(
'plugins/sweetalert2',
'plugins/jquery.mask.min',
'flatpickr/flatpickr',
'flatpickr/pt',
'flatpickr/flatpickr_init'
); 

//muda para seu email sobe para o serv ja esta ja esta online? esse eh local
//so funciona online o phpmailer

//como utilizar

/*
$response = (new Email())->send([
     'from'=>'Jorge Santos',
     'para'=>'sistema@gestaocrm.crmd.com.br',
     'assunto'=>'Texte disparo de email',
     'mensagem'=>'conteudo da mensagem aqui'
     ]);

     if($response){
        echo "enviado";exit;
     }else{
     echo "erro ao enviar ";exit;
     }
*/

$this->arr['anuncios_recentes'] = [];
$this->arr['usuarios_recentes'] = [];


$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('home', $this->arr);
}//function index   


public function calendario(){

  switch($this->user->getTipo()){
    case 'Super Admin':
    $this->loadTemplate('calendario', $this->arr);
    break;
    case 'Produtor':
      //$this->loadTemplate('calendarioprod', $this->arr);
      echo 'acesso nao permitido';
      break;
    }   
}

public function calendarioprod(){


  $this->loadTemplate('calendarioprod', $this->arr);
}


//esse é o padrao para trazer os dados e exibir 
//vou pegar a tabela para vc ver
public function pegaeventos(){

  switch($this->user->getTipo()){
    case 'Super Admin':

  $where_sql = '';
  if(!empty($_GET['start']) && !empty($_GET['end'])){
  $where_sql .= "date_time BETWEEN '".$_GET['start']."' AND '".$_GET['end']."' ";
  }
  
  $result = (new Orm('shedules'))->select('*')
  ->wherecustom("$where_sql")
  ->get();
 
  
  $eventsArr = [];
  foreach($result as $row){
  
  $evento = [
  'title'=>$row->subject,
  'description'=>'descricao de teste',
  'start'=>date('Y-m-d', strtotime($row->date_time)),
  'end'=>date('Y-m-d', strtotime($row->from_date_time)),
  'color'=>$row->remark
  ];
  
  array_push($eventsArr, $evento);
  }
  
  
  echo json_encode($eventsArr);
  break;

  case 'Produtor':
    //$this->loadTemplate('calendarioprod', $this->arr);
    echo 'acesso nao permitido';
    break;
  }
 


  }//pegaeventos

  public function pegaeventosprod(){

    $where_sql = '';
    $id_usuario = $this->user->getId();
    if(!empty($_GET['start']) && !empty($_GET['end'])){
    $where_sql .= "date_time BETWEEN '".$_GET['start']."' AND '".$_GET['end']."' AND team_member = '$id_usuario' ";
    }
    
    $result = (new Orm('shedules'))->select('*')
    ->wherecustom("$where_sql")
    ->get();
   
    
    $eventsArr = [];
    foreach($result as $row){
    
    $evento = [
    'title'=>$row->subject,
    'description'=>'descricao de teste',
    'start'=>date('Y-m-d', strtotime($row->date_time)),
    'end'=>date('Y-m-d', strtotime($row->from_date_time)),
    'color'=>$row->remark
    ];
    
    array_push($eventsArr, $evento);
    }
    
    
    echo json_encode($eventsArr);
    }//pegaeventosprod




}