<?php

use Core\Controller;
use Models\Users;
use Models\Helpers;
use Models\Permissao;
use Models\Orm;

class ModulosController extends controller {


  private $user;
  private $arr;
  private $permissao;

    public function __construct() {              
        $this->user = new Users();
        $this->permissao = new Permissao(); 

        if($this->user->isLogged() == false){                  
         header("Location: ".BASE_URL."login");        
         exit;         
        }

       $usuario = $this->user->getId();       
       $permissoes = $this->permissao->getPermissoes();
       $modulo_boleto = $this->permissao->getPermissoesBoleto();
       
        $this->arr = array(
         'user'=>$this->user,
         'menuActive'=>'home',
         'permissao'=>$permissoes,
         'modulo_boleto'=>$modulo_boleto
        );            
}

public function index() {
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'mask_init',
'plugins/sweetalert2',
'system'
);


$c = new Orm('usuario_tabela');
$this->arr['list'] = $c->select('*')->get();
$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);

$this->loadTemplate('modulos/tabelas', $this->arr);

}//index 



public function add(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'mask_init',
'plugins/sweetalert2',
'system'
);    


$id_company  = 1;//$this->user->getCompany();
$c = new Orm('usuario_tabela');

if(isset($_POST['nome']) && !empty($_POST['nome'])):         
$nome   = $this->limpaCampo($_POST['nome']);
$ativa  = $this->limpaCampo($_POST['acao']);
$slug   = $this->Slug($nome);   

$c->set([
'nome_tabela'=>$nome,
'ativo_tabela'=>$ativa,
'alias_tabela'=>$slug
])->save();

   
$_SESSION['msg'] = ['type'=>'success','msg'=>'Tabela cadastrada com sucesso!']; 
header("Location:".BASE_URL."modulos");
exit;
endif;

$this->loadTemplate('modulos/adicionar', $this->arr);
}//add





public function edit($id){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'mask_init',
'plugins/sweetalert2',
'system'
);   


$id_company  = 1;//$this->user->getCompany();
$c = new Orm('usuario_tabela');
$this->arr['info'] = $c->select('*')->where(['id_tabela', $id])->first()->get();


if(isset($_POST['nome']) && !empty($_POST['nome'])):          
$nome   = $this->limpaCampo($_POST['nome']);
$ativa  = $this->limpaCampo($_POST['acao']);
$slug   = $this->Slug($nome);      



$up = $c->set([
'nome_tabela'=>$nome,
'ativo_tabela'=>$ativa,
'alias_tabela'=>$slug
])->where(['id_tabela', $id])->update();

if($up){
$_SESSION['msg'] = ['type'=>'success','msg'=>'Tabela atualizada com sucesso!']; 
header("Location:".BASE_URL."modulos");
exit;

}else{
$_SESSION['msg'] = ['type'=>'success','msg'=>'Tabela atualizada com sucesso!'];  
header("Location:".BASE_URL."modulos/edit/".$id);
exit; 
}      
endif;

$this->loadTemplate('modulos/editar', $this->arr);

}//edit


public function acoes($id_tabela){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'mask_init',
'plugins/sweetalert2',
'system'
); 


$p = new Permissao();  
if(!$id_tabela){
   header("Location:".BASE_URL."modulos");
   exit;
}else{
  $tabela = (new Orm('usuario_tabela'))->select('*')->where(['id_tabela', $id_tabela])->first()->get();

}

if(!$tabela){
   header("Location:".BASE_URL."modulos");
   exit;
}

$this->arr['tabela']  = $tabela; 
$this->arr['acoes']   = (new Orm('usuario_acao'))->select('*')->get(); 
$this->arr['tabelas'] = (new Orm('usuario_tabela'))->select('*')->get();
$this->arr['lista']   = $p->listaAcoes($id_tabela);

$this->loadTemplate('modulos/acoes', $this->arr);
}//ações



public function inserir(){ 
$id_tabela = isset($_POST['id_tabela']) ? strip_tags(filter_input(INPUT_POST, "id_tabela")): NULL;    
$id_acao = isset($_POST['id_acao']) ? strip_tags(filter_input(INPUT_POST, "id_acao")): NULL;

$tem = (new Orm('usuario_tabela_acao'))->select('*')->where(['id_tabela', $id_tabela])->e(['id_acao', $id_acao])->first()->get();


if(!$tem){
$insere = (new Orm('usuario_tabela_acao'))->set(['id_tabela'=>$id_tabela, 'id_acao'=>$id_acao])->save();
}

header("Location:".BASE_URL."modulos/acoes/".$id_tabela);
exit;
}//inserir



public function editar($id_tabela, $id_acao){
$c = new Crud();
$form = new \stdClass();
$form->id_tabela = $id_tabela;
$form->id_acao = $id_acao;

$atualizar = $c->atualizar('usuario_tabela_acao', $form, "id_tabela={$id_tabela} AND id_acao={$id_acao}");  

}//editar



public function remover($tabela){
$del = (new Orm('usuario_tabela_acao'))->del(['id_tabela', $tabela]);
$tabela = (new Orm('usuario_tabela'))->del(['id_tabela', $tabela]); 

$_SESSION['msg'] = ['type'=>'success','msg'=>"Removido com sucesso!"];
header("Location:".BASE_URL."modulos");
exit;
}//remover



public function del($tabela, $acao){

$id = (new Orm('usuario_tabela_acao'))->select(['id_tabela_acao'])
->wherecustom("id_tabela = '$tabela' AND id_acao = '$acao'") ->first()->get();

if($id){
$del = (new Orm('usuario_tabela_acao'))->del(['id_tabela_acao', $id->id_tabela_acao]);

$_SESSION['msg'] = ['type'=>'success','msg'=>"Removido com sucesso!"];
header("Location:".BASE_URL."modulos/acoes/".$tabela);
exit;
}
}//del

}