<?php
use Core\Controller;
use Models\Users;
use Models\Permissao;
use Models\Orm;

class OrigemController extends Controller {

  private $user;
  private $arr;
  private $permissao;

    public function __construct() {              
        $this->user = new Users();
        $this->permissao = new Permissao(); 

        if($this->user->isLogged() == false){                  
         header("Location: ".BASE_URL."login");        
         exit;         
        }

       $usuario = $this->user->getId();       
       $permissoes = $this->permissao->getPermissoes();
       $modulo_boleto = $this->permissao->getPermissoesBoleto();
       
        $this->arr = array(
         'user'=>$this->user,
         'menuActive'=>'home',
         'permissao'=>$permissoes,
         'modulo_boleto'=>$modulo_boleto
        );        
}

public function index() {   
$this->arr['list_js'] = array(
'plugins/sweetalert2',
'system'
);  

$tab = new Orm('origem_venda');
$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);

if(isset($_GET['nome']) && !empty($_GET['nome'])){
$nome = addslashes($_GET['nome']);
$this->arr['lista'] = $tab->select('*')->search(['nome_origem', $nome])->get();
}else{
$this->arr['lista'] = $tab->select('*')->paginate('10')->get();
$this->arr['paginacao'] = $tab->render("origem");
}


$this->loadTemplate('origem/listar', $this->arr);
}//function index  


public function add(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'preview_imagem',
'uploadImage',
'functions_js',
'plugins/sweetalert2',
'system'
);


$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('origem/adicionar', $this->arr);
}//add


public function edit($id){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'preview_imagem',
'uploadImage',
);

$this->arr['id_origem'] = $id;
$this->arr['info'] = (new Orm('origem_venda'))->select('*')->where(['id_origem', $id])
->first()->get();
$this->loadTemplate('origem/editar', $this->arr);
}//edit


public function save(){

if(isset($_POST['nome']) && !empty($_POST['nome'])){
 $id_origem   = (isset($_POST['id_origem'])) ? $this->limpaCampo($_POST['id_origem']) : NULL; 
 $nome            = $this->limpaCampo($_POST['nome']);

 
$consulta = (new Orm('origem_venda'))->select('*')->where(['nome_origem', $nome])->first()->get();

if(!empty($consulta)){
  $_SESSION['msg'] = array('type'=>'error', 'msg'=>'Ooppss, ja existe cadastro com esse número ou nome no sistema, por favor tente novamente!!!');
  header("Location:".BASE_URL."origem");
  exit;  
}

$dados_form = [
'nome_origem'=>$nome
];

if($id_origem == null){
 $grv = (new Orm('origem_venda'))->set($dados_form)->save();
 $_SESSION['msg'] = array('type'=>'success', 'msg'=>'Origem cadastrada com sucesso!');
 $this->redirect(BASE_URL."origem"); 
}else{
 $grv = (new Orm('origem_venda'))->set($dados_form)->where(['id_origem', $id_origem])->update();
 $_SESSION['msg'] = array('type'=>'success', 'msg'=>'Origem Editada com sucesso!');
 header("Location:".BASE_URL."origem");
 exit;
}

}

}//save

public function remover($id){
$del = (new Orm('origem_venda'))->del(['id_origem', $id]);
$_SESSION['msg'] = array('type'=>'success', 'msg'=>'Origem removida com sucesso!');
$this->redirect(BASE_URL."origem");
}//remover

}