<?php
use Core\Controller;
use Models\Users;
use Models\Helpers;
use Models\Permissao;
use Models\TabelaAcao;
use Models\Orm;

class PermissaoController extends controller {

  private $user;
  private $arr;
  private $permissao;

    public function __construct() {              
        $this->user = new Users();
        $this->permissao = new Permissao(); 

        if($this->user->isLogged() == false){                  
         header("Location: ".BASE_URL."login");        
         exit;         
        }

       $usuario = $this->user->getId();       
       $permissoes = $this->permissao->getPermissoes();
       $modulo_boleto = $this->permissao->getPermissoesBoleto();
       
        $this->arr = array(
         'user'=>$this->user,
         'menuActive'=>'home',
         'permissao'=>$permissoes,
         'modulo_boleto'=>$modulo_boleto
        );         
}

public function index($id = null) { 
$this->arr['list_js'] = array(
'js_permissao'
); 

$this->arr['lista'] = $this->lista($id);
$this->arr['usuario'] = (object )array('id_usuario'=> $id);    

//$this->debug($this->arr['lista']);


    $this->loadTemplate('permissoes/permissoes', $this->arr);
}//index 


public function lista($id_usuario){
$objTabelaAcao = new TabelaAcao();
$p = new Permissao(); 
         
$tabelas = (new Orm('usuario_tabela'))->select('*')->get();
$data = array();

foreach($tabelas as $tabela){   

 $acoes = $objTabelaAcao->getListaPorTabela($tabela->id_tabela);          
 $action = array();

foreach($acoes as $acao){

  $tem = $p->getPermissao($id_usuario, $tabela->id_tabela, $acao->id_acao);

  $marcado = ($tem) ? true : false;
  // echo "Marcado: ".$marcado."<br>";exit;

    $action[] = (object) array(
     'id_acao'=>$acao->id_acao,
     'id_tabela_acao'=>$acao->id_tabela_acao,
     'acao'=>$acao->acao,                 
     'marcado'=>$marcado
    );              
}//foreach acoes

    $data[] = (object) array(
    'tabela'=>$tabela,
    'acoes'=>$action            
    );
            
}//foreach tabelas

return $data;
}//lista


public function inserir() {
$p = new Permissao();

//$objPermissao = new QueryBuilder('usuario_tabela_acao_cliente');

$id_usuario = isset($_POST['id_usuario']) ? strip_tags(filter_input(INPUT_POST, "id_usuario")) : NULL;
$id_tabela = isset($_POST['id_tabela']) ? strip_tags(filter_input(INPUT_POST, "id_tabela")) : NULL;
$id_acao = isset($_POST['id_acao']) ? strip_tags(filter_input(INPUT_POST, "id_acao")) : NULL;

$tem = $p->getPermissao($id_usuario, $id_tabela, $id_acao);

if(!$tem){  
   $insere = $p->inserir($id_usuario, $id_tabela, $id_acao);
   echo json_encode("ok");
}else{
    echo json_encode("nao");
} 

}//inserir 


public function semPermissao(){

$this->loadView('permissoes/sem-permissao');
}//semPermissao    


public function excluir(){
$p = new Permissao();

$id_usuario = isset($_POST['id_usuario']) ? strip_tags(filter_input(INPUT_POST, "id_usuario")) : NULL;
$id_tabela = isset($_POST['id_tabela']) ? strip_tags(filter_input(INPUT_POST, "id_tabela")) : NULL;
$id_acao = isset($_POST['id_acao']) ? strip_tags(filter_input(INPUT_POST, "id_acao")) : NULL;

$p->excluir($id_usuario, $id_tabela, $id_acao);
echo json_encode("ok");
}//excluir


}