<?php
use Core\Controller;
use Models\Users;
use Models\Permissao;
use Models\Orm;
use Models\Validate;

class PlanosController extends Controller {

	private $user;
  private $arr;
  private $permissao;

    public function __construct() {              
        $this->user = new Users();
        $this->permissao = new Permissao(); 

        if($this->user->isLogged() == false){                  
         header("Location: ".BASE_URL."login");        
         exit;         
        }
           
        $permissoes = $this->permissao->getPermissoes();
        $modulo_boleto = $this->permissao->getPermissoesBoleto();
        
         $this->arr = array(
          'user'=>$this->user,
          'menuActive'=>'home',
          'permissao'=>$permissoes,
          'modulo_boleto'=>$modulo_boleto
         );           
}

public function index() {
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'mask_init',
'plugins/sweetalert2',
'system'
);

$tab = new Orm('planos');
//Filtrando pesquisas
if(isset($_GET['nome']) && !empty($_GET['nome'])){

}else{
$this->arr['lista'] = $tab->select('*')->paginate('10')->get();
$this->arr['paginacao']  = $tab->render('planos'); 
}

$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('planos/listar', $this->arr);
}//function index   



public function add(){
$this->arr['list_js'] = array(
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'plugins/jquery.mask.min',
'mask_init',
'plugins/sweetalert2'
);    


$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('planos/adicionar', $this->arr);
}//add



public function add_action(){
$validator = new Validate();  
$tab = new Orm('planos');

if(isset($_POST['nome']) && !empty($_POST['leads'])){ 

$validate = $validator->validate([
'id_plano'=>'null',
'nome'=>'required',
'leads'=>'required',
'url_inscricao'=>'required',
'url_zoho'=>'required'
],true);


if(!$validate){
$_SESSION['msg'] = ['type'=>'error','msg'=>'Ooops... Alguns campos estão inválidos, tente novamente'];
 unset($_SESSION['flash']);
 unset($_SESSION['old']);
 header("Location:".BASE_URL."planos/add");
 exit;   
}

$grava = (new Orm('planos'))->set($validate)->save();
if($grava){
$_SESSION['msg'] = ['type'=>'success', 'msg'=>"Plano cadastrado com sucesso!"];
header("Location: ".BASE_URL."planos");
exit;
}else{
$_SESSION['msg'] = ['type'=>'error', 'msg'=>"Oopss, erro ao cadastrar plano"];
header("Location: ".BASE_URL."planos/add");
exit;
}

}
}//add action


public function edit($id){
$this->arr['list_js'] = array(
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'plugins/jquery.mask.min',
'mask_init',
'plugins/sweetalert2',
'system'
);  


$tab = new Orm('planos');
$this->arr['info'] = $tab->select('*')->where(['id_plano', $id])->first()->get();
$this->arr['id_plano'] = $id;

$this->loadTemplate('planos/editar', $this->arr);
}//edit


public function edit_action($id){
$validator = new Validate();  
$tab = new Orm('planos');

if(isset($_POST['nome']) && !empty($_POST['leads'])){ 

$validate = $validator->validate([
'id_plano'=>'null',
'nome'=>'required',
'leads'=>'required',
'url_inscricao'=>'required',
'url_zoho'=>'required'
],true);

if(!$validate){
$_SESSION['msg'] = ['type'=>'error','msg'=>'Ooops... Alguns campos estão inválidos, tente novamente'];
 unset($_SESSION['flash']);
 unset($_SESSION['old']);
 header("Location:".BASE_URL."planos/edit/".$id);
 exit;   
}

$grava = (new Orm('planos'))->set($validate)->where(['id_plano', $validate['id_plano']])->update();
$_SESSION['msg'] = ['type'=>'success', 'msg'=>"Plano atualizado com sucesso!"];
header("Location: ".BASE_URL."planos");
exit;
}
}//edit action


public function del($id){ 
$tab = new Orm('planos');
$tab->del(['id_plano', $id]); 
       
$_SESSION['msg'] = ['type'=>'success', 'msg'=>"Removido com sucesso!"];
header("Location: ".BASE_URL."planos");
exit;
}//del

}