<?php
use Core\Controller;
use Models\Users;
use Models\Permissao;
use Models\Orm;
use Models\Leads;
use Models\Validate;
use Dompdf\Dompdf;
use Dompdf\Exception;
use Dompdf\Options;

class PrevendaController extends Controller {

  private $user;
  private $arr;
  private $permissao;

    public function __construct() {              
        $this->user = new Users();
        $this->permissao = new Permissao(); 

        if($this->user->isLogged() == false){                  
         header("Location: ".BASE_URL."login");        
         exit;         
        }

       $usuario = $this->user->getId();       
       $permissoes = $this->permissao->getPermissoes();
       $modulo_boleto = $this->permissao->getPermissoesBoleto();
       
        $this->arr = array(
         'user'=>$this->user,
         'menuActive'=>'home',
         'permissao'=>$permissoes,
         'modulo_boleto'=>$modulo_boleto
        );        
}

public function index() {   
$this->arr['list_js'] = array(
'plugins/sweetalert2',
'system'
);  

$tab = new Orm('leads');
$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);

if(isset($_GET['nome']) && !empty($_GET['nome'])){
$nome = addslashes($_GET['nome']);
$this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')->search(['nome', $nome])
->join(['usuarios'])
->on(
  ['leads.para','=','usuarios.id_usuario'])->get();
  $this->arr['paginacao'] = $tab->render('prevenda/pendencias');  
}else{
  if(isset($_GET['situacao_pesquisa']) && !empty($_GET['situacao_pesquisa'])){
    $situacao_pesquisa = addslashes($_GET['situacao_pesquisa']);
    $this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')->search(['situacao_pv', $situacao_pesquisa])    
    ->join(['usuarios'])
    ->on(
      ['leads.para','=','usuarios.id_usuario'])->get();
      $this->arr['paginacao'] = $tab->render('prevenda/pendencias');      
    }else{
    $this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')      
    ->join(['usuarios'])
    ->on(
      ['leads.para','=','usuarios.id_usuario'])->wherecustom("situacao_pv = 'Pre-Venda Pendente' or situacao_pv = 'Não Atende POV' or situacao_pv = 'Não Atende AUT' or situacao_pv = 'Não Atende POV e AUT'")->order(['data_entrada desc'])->paginate('10')->get();
      $this->arr['paginacao'] = $tab->render('prevenda/pendencias');
    }
}


$this->loadTemplate('prevenda/prevenda_inicio', $this->arr);
}//function index  

public function add_action(){

  
  $validator = new Validate();
  $validate = '';
if($_POST['nome'] != '' && $_POST['nome'] != NULL){
//echo '<pre>';
//print_r($_POST);
//exit;
$para = $this->user->getId();
$origem = $_POST['origem'];
$nome             = $_POST['nome'];
$produto          = $_POST['produto'];
$email            = $_POST['email'];
$telefone         = $_POST['telefone'];
$telefone2        = $_POST['telefone2'];
$telefone3        = $_POST['telefone3'];
$codsocio         = $_POST['codsocio'];
$rg               = $_POST['rg'];

$estado_civil     = $_POST['estado_civil'];
$sexo             = $_POST['sexo'];
$cep_cli          = $_POST['cep_cli'];
$end_cli = $_POST['end_cli'];
$n_cli = $_POST['n_cli'];
$bairro_cli = $_POST['bairro_cli'];
$complemento_cli = $_POST['complemento_cli'];
$cidade_cli = $_POST['cidade_cli'];
$estado_cli = $_POST['estado_cli'];
$co01nome = $_POST['co01nome'];
$co01cpf = $_POST['co01cpf'];

$co02nome = $_POST['co02nome'];
$co02cpf = $_POST['co02cpf'];

$co03nome = $_POST['co03nome'];
$co03cpf = $_POST['co03cpf'];

$co04nome = $_POST['co04nome'];
$co04cpf = $_POST['co04cpf'];

$co05nome = $_POST['co05nome'];
$co05cpf = $_POST['co05cpf'];

$vlr = $_POST['vlr'];
$entrada = $_POST['entrada'];
$adesao = $_POST['adesao'];
$saldo = $_POST['saldo'];
$desconto = $_POST['desconto'];
$parcelas = $_POST['parcelas'];
$vcomissao = $_POST['vcomissao'];
$forma_pagamento = $_POST['fpagamentoc'];
$situacao_pv = $_POST['situacao_pv'];
$obsn = $_POST['obsn'];

$l = new Leads();

if($_POST['data_nascimento'] != '' && $_POST['data_nascimento'] != NULL){
  $data_nascimento  = $_POST['data_nascimento'];
}else{
  $data_nascimento = 'NULL';
}

if($_POST['co01data_nasc'] != '' && $_POST['co01data_nasc'] != NULL){
  $co01data_nasc = $_POST['co01data_nasc'];
}else{
  $co01data_nasc = '0001-01-01';
}

if($_POST['co02data_nasc'] != '' && $_POST['co02data_nasc'] != NULL){
  $co02data_nasc = $_POST['co02data_nasc'];
}else{
  $co02data_nasc = '0001-01-01';
}

if($_POST['co03data_nasc'] != '' && $_POST['co03data_nasc'] != NULL){
  $co03data_nasc = $_POST['co03data_nasc'];
}else{
  $co03data_nasc = '0001-01-01';
}

if($_POST['co04data_nasc'] != '' && $_POST['co04data_nasc'] != NULL){
  $co04data_nasc = $_POST['co04data_nasc'];
}else{
  $co04data_nasc = '0001-01-01';
}

if($_POST['co05data_nasc'] != '' && $_POST['co05data_nasc'] != NULL){
  $co05data_nasc = $_POST['co05data_nasc'];
}else{
  $co05data_nasc = '0001-01-01';
}



$add = $l->addwaterfall($para,$origem,$nome,$produto,$email,$telefone,$telefone2,$telefone3,$codsocio,$rg,$data_nascimento,$estado_civil,$sexo,$cep_cli,$end_cli,$n_cli,$bairro_cli,$complemento_cli,$cidade_cli,$estado_cli,$co01nome,$co01cpf,$co01data_nasc,$co02nome,$co02cpf,$co02data_nasc,$co03nome,$co03cpf,$co03data_nasc,$co04nome,$co04cpf,$co04data_nasc,$co05nome,$co05cpf,$co05data_nasc,$vlr,$entrada,$adesao,$saldo,$desconto,$parcelas,$vcomissao,$forma_pagamento,$situacao_pv,$obsn); 

$id_lead = $add['idn'];
$gravacontrato = (new Orm('contrato'))->set(['id_lead'=>$id_lead])->save();

//exit;
//echo '<pre>';
//echo $id_lead.'<br>';
//print_r($gravacontrato);
//exit;

  if($_POST['anexos'] != '' && $_POST['anexos'] != NULL){
    //$id_lead = $id_lead;
    //$id_lead = $_POST['id_lead'];
    $files = '';
    $anexos = $_POST['anexos'];
    $anexosname = $_POST['mutiplo_upload'];
    $dados = array();


      if($_POST['anexosview'] != ''){
        $old = (new Orm('leads'))->select(['anexos'])
        ->where(['id_lead', $id_lead])->first()->get(); 
        $arquivo = json_decode($old->anexos, true);
       //print_r($arquivo);
       // exit;
        foreach($arquivo as $arq){
          array_push($dados, $arq);  
        }
        $novos = $this->gravaAnexos($anexos,$anexosname,$id_lead);
        $files = json_decode($novos['files'], true);
        foreach($files as $file){
          array_push($dados, $file);
        }
         $dados = json_encode($dados);     
         $files = $dados;
      }else{
        $files = $this->gravaAnexos($anexos,$anexosname,$id_lead);  
        $files = $files['files'];
      };   
 


      $grava = (new Orm('leads'))->set(['anexos'=>$files])->where(['id_lead', $id_lead])->update();
  };      

  $url = '../../leads/assinar/'.$id_lead;
  
  echo '<script type="text/javascript">window.open("'.$url.'");</script>';
  echo 'Contrato Enviado com Sucesso. Clique em Voltar' ;
  exit;
  //var url = '../../leads/assinar/'+idlead;
  //window.open(url, 'Contrato', "width=900,height=600"); 

/*
      
  $data['consulta'] = (new Orm('leads'))
  ->select(['leads.*, usuarios.nome as vendedor,usuarios.email as vendedoremail, usuarios.contato as vendedorcontato'])
  ->join(['usuarios'])
  ->on(
    ['leads.para','=','usuarios.id_usuario'])
  ->wherecustom("leads.id_lead = '$id_lead' LIMIT 1")
  ->get();  

  $data['empresa'] = (new Orm('clientes'))->select('*')->get();   
  $data['contrato'] = (new Orm('contrato'))->select('*')->wherecustom("contrato.id_lead = '$id_lead' LIMIT 1")->get();    

  $data['idlead'] = $id_lead;
  $nomearquivo = $id_lead.'_'.date("Ymd").date("His").'.pdf';
  $token = '1df644ef-fe08-41f1-831c-48197ae5ad7491639362-bc63-4f74-9baf-e0494cb1fa59';

  $nomedocontrato = 'PASSAPORTE VITALÍCIO EXCLUSIVO';

  ob_start();
  $this->loadview("/leads/leads_report_assinarwaterpark_pdf", $data);      
  //exit;
  $html = ob_get_contents();
  ob_end_clean();      
  $options = new Options();
  $options->set('isRemoteEnabled',true);
  $dompdf = new Dompdf($options);
  //$dompdf = new Dompdf();
  $dompdf->set_option('isHtml5ParserEnabled', true);
  $dompdf->set_option("isPhpEnabled", true);
  $dompdf->loadHtml($html);
  ini_set('xdebug.max_nesting_level', 2000);
  ini_set('memory_limit', '256M');

  // Render the HTML as PDF
  $dompdf->setPaper('A4', 'portrait');
  $dompdf->render();
  $dompdf->stream("Letter",["Attachment" => false]); 
  $output = $dompdf->output();
  file_put_contents('Contratos/'.$nomearquivo, $output);

$filq = 'https://waterfall.crmd.app.br/Contratos/'.$nomearquivo;
$image = '/home/wwcrmd/waterfall.crmd.app.br/Contratos/'.$nomearquivo;
//$image = 'https://luizaotenisclub.com.br/Teste123.pdf';

// Read image path, convert to base64 encoding
$imageData = base64_encode(file_get_contents($image));

//exit;
$pdf = $imageData;

$data = [
  //"open_id"=> 5,
  "token"=> $token,
  "status"=> "pending",
  "name"=> $nomedocontrato,
  "original_file"=> $filq,
  "base64_pdf"=> $pdf,
  "signed_file"=> null,
  "signers"=> [
          ["token"=> $token,
          "status"=> "new",
          "name"=> $data['consulta'][0]->nome,
          "email"=> $data['consulta'][0]->email,
          "phone_country"=> "55",
          "phone_number"=> str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$data['consulta'][0]->telefone)))),
          "send_automatic_whatsapp"=> false,
          "times_viewed"=> 0,
          "last_view_at"=> null,
          "signed_at"=> null]
  ,

          ["token"=> $token,
          "status"=> "new",
          "name"=> $data['consulta'][0]->vendedor,
          "email"=> $data['consulta'][0]->vendedoremail,
          "phone_country"=> "55",
          "phone_number"=> str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$data['consulta'][0]->vendedorcontato)))),
          "send_automatic_whatsapp"=> false,
          "times_viewed"=> 0,
          "last_view_at"=> null,
          "signed_at"=> null]
  ,
          ["token"=> $token,
          "status"=> "new",
          "name"=> $data['empresa'][0]->razao_social,
          "email"=> $data['empresa'][0]->email,
          "phone_country"=> "55",
          "phone_number"=> str_replace("-","",str_replace(" ","",str_replace(")","",str_replace("(","",$data['empresa'][0]->whats)))),
          "send_automatic_whatsapp"=> false,
          "times_viewed"=> 0,
          "last_view_at"=> null,
          "signed_at"=> null]       
  ]
];



// API URL
$url = 'https://sandbox.api.zapsign.com.br/api/v1/docs/';

$payload = json_encode($data);

$curl = curl_init();
curl_setopt_array($curl, [
CURLOPT_URL => $url,
CURLOPT_RETURNTRANSFER => true,
CURLOPT_POSTFIELDS=>$payload,
CURLOPT_ENCODING => "",
CURLOPT_MAXREDIRS => 10,
CURLOPT_TIMEOUT => 30,
CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
CURLOPT_CUSTOMREQUEST => "POST",
CURLOPT_HTTPHEADER => [
  "Content-type: application/json",
  "Authorization: Bearer $token"
],
]);

$response = curl_exec($curl);
$err = curl_error($curl);

$datax = json_decode($response);
//echo $err;
//exit;

$tokencrm = 'ASDFRE12313343D3213FD21';


if(isset($datax->signers) && !empty($datax->signers)){

  foreach($datax->signers as $signers){

    $message = "Olá ".$signers->name." 👋! Sua assinatura foi solicitada pela Water Fall no documento PASSAPORTE VITALÍCIO EXCLUSIVO.

    ✍️ Clique no link abaixo para ver o documento e assinar:".
    "
    ".
    $signers->sign_url.
    
    "

    Caso o link não esteja clicável, você pode selecioná-lo, copiar e colar em seu navegador Web: 
    
    Esta mensagem é automática, em caso de dúvidas entre em contato com telefone (16) 4042-1200";
    $number = $signers->phone_number;


    $data = [
      //"open_id"=> 5,
      "number"=> $number,
      "body"=> $message
    ];
    
    // API URL
    $url = 'https://apicrmclique.crmd.srv.br/api/messages/send';

    $payload = json_encode($data);
       
    $curl = curl_init();
    curl_setopt_array($curl, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POSTFIELDS=>$payload,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_HTTPHEADER => [
      "Content-type: application/json",
      "Authorization: Bearer $tokencrm"
    ],
    ]);
    
    $response = curl_exec($curl);
    $err = curl_error($curl);



  }
}
*/


  exit;


  
  }

}

public function prevenda_add(){
  $this->arr['list_js'] = array(
    'plugins/sweetalert2',
    'plugins/jquery.mask.min',
    'plugins/parsley/parsley.min',
    'plugins/parsley/pt-br',
    'mask_init', 
    'system',
    'flatpickr/flatpickr',
    'flatpickr/pt',
    'flatpickr/flatpickr_init',
    'multiuploads'
    ); 
    $this->arr['tipo']  = $this->user->getTipo();
    $this->arr['usuario_logado'] = $this->user->getId();
    //$this->arr['bairros'] = (new Orm('financeiro_bairro'))->select('*')->get();
    $this->arr['produtos'] = (new Orm('produtos'))->select('*')->order(['nome_produto asc'])->get();
    $this->arr['origens']  = (new Orm('origem_venda'))->select('*')->get();
    $l = new Leads();
    $teste = $l->getCliente();
    $cliente = $teste->nome;
    $this->arr['cliente'] = $cliente;
    
    $this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);

  $this->loadTemplate('prevenda/prevenda_add', $this->arr);
}

public function pendencias() {   
  $this->arr['list_js'] = array(
  'plugins/sweetalert2',
  'system'
  );  
  
  $tab = new Orm('leads');
  $this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
  
  if(isset($_GET['nome']) && !empty($_GET['nome'])){
  $nome = addslashes($_GET['nome']);
  $this->arr['lista'] = $tab->select('*')->search(['nome', $nome])->get();
  $this->arr['paginacao'] = $tab->render('prevenda/pendencias');  
  }else{
  $this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')      
  ->join(['usuarios'])
  ->on(
    ['leads.para','=','usuarios.id_usuario'])->wherecustom("situacao_pv != 'Pre-Venda Pendente' and situacao_pv != 'Concluído' and situacao_pv != '' and situacao_pv != 'Cancelar'")->order(['data_entrada desc'])->paginate('10')->get();
    $this->arr['paginacao'] = $tab->render('prevenda/pendencias');
  }
  
  
  $this->loadTemplate('prevenda/prevenda_pendencias', $this->arr);
  }//function index

  public function pendenciasprodutor() {   
    $this->arr['list_js'] = array(
    'plugins/sweetalert2',
    'system'
    );  
        
    $tab = new Orm('leads');
    $this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
    $id_usuario = $this->user->getId();

    if(isset($_GET['nome']) && !empty($_GET['nome'])){
    $nome = addslashes($_GET['nome']);
    $this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')
    ->join(['usuarios'])
    ->on(
      ['leads.para','=','usuarios.id_usuario'])->wherecustom("situacao_pv != '' and leads.nome like '%$nome%' and para = $id_usuario")->get();
    //$this->arr['paginacao'] = $tab->render('prevenda/pendencias');  
  }else{
    if(isset($_GET['situacao_pesquisa']) && !empty($_GET['situacao_pesquisa'])){
      //echo 'aqui';
      //exit;
      //echo $id_usuario;
      //exit;
      $situacao_pesquisa = addslashes($_GET['situacao_pesquisa']);
      //echo $situacao_pesquisa;
      //exit;
      $this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')->wherecustom("situacao_pv like '%$situacao_pesquisa%' and para = $id_usuario")
      ->join(['usuarios'])
      ->on(
        ['leads.para','=','usuarios.id_usuario'])->get();
        //$this->arr['paginacao'] = $tab->render('prevenda/arquivoprodutor');      
      //echo '<pre>';
      //print_r($this->arr['lista']);
      //exit;
      }else{
    $this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')      
    ->join(['usuarios'])
    ->on(
      ['leads.para','=','usuarios.id_usuario'])->wherecustom("para = $id_usuario and situacao_pv != 'Concluído' and situacao_pv != '' and situacao_pv != 'Cancelar'")->order(['data_entrada desc'])->paginate('10')->get();
      //$this->arr['paginacao'] = $tab->render('prevenda/pendencias');
    }
    }
    
    
    $this->loadTemplate('prevenda/prevenda_pendenciasprodutor', $this->arr);
    }//function index

  public function arquivoprodutor() {   
    $this->arr['list_js'] = array(
    'plugins/sweetalert2',
    'system'
    );  
    
    $tab = new Orm('leads');
    $this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
    /*
    if(isset($_GET['nome']) && !empty($_GET['nome'])){
    $nome = addslashes($_GET['nome']);
    $this->arr['lista'] = $tab->select('*')->search(['nome', $nome])->get();
    }else{
    $this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')      
    ->join(['usuarios'])
    ->on(
      ['leads.para','=','usuarios.id_usuario'])->wherecustom("situacao_pv != ''")->order(['data_entrada desc'])->paginate('10')->get();
    $this->arr['paginacao'] = $tab->render("origem");
    }*/
    $id_usuario = $this->user->getId();

    if(isset($_GET['nome']) && !empty($_GET['nome'])){
      $nome = addslashes($_GET['nome']);
      $this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')->wherecustom("situacao_pv != '' and leads.nome like '%$nome%' and para = $id_usuario")
      ->join(['usuarios'])
      ->on(
        ['leads.para','=','usuarios.id_usuario'])->get();
        //$this->arr['paginacao'] = $tab->render('prevenda/arquivoprodutor');        
      }else{
        if(isset($_GET['situacao_pesquisa']) && !empty($_GET['situacao_pesquisa'])){
          //echo 'aqui';
          //exit;
          //echo $id_usuario;
          //exit;
          $situacao_pesquisa = addslashes($_GET['situacao_pesquisa']);
          //echo $situacao_pesquisa;
          //exit;
          $this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')->wherecustom("situacao_pv like '%$situacao_pesquisa%' and para = $id_usuario")
          ->join(['usuarios'])
          ->on(
            ['leads.para','=','usuarios.id_usuario'])->get();
            //$this->arr['paginacao'] = $tab->render('prevenda/arquivoprodutor');      
          //echo '<pre>';
          //print_r($this->arr['lista']);
          //exit;
          }else{
          $this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')      
          ->join(['usuarios'])
          ->on(
            ['leads.para','=','usuarios.id_usuario'])->wherecustom("situacao_pv != '' and para = $id_usuario")->order(['data_entrada desc'])->paginate('10')->get();
          //$this->arr['paginacao'] = $tab->render('prevenda/arquivoprodutor');
          }
      }
    
    
    $this->loadTemplate('prevenda/prevenda_arquivoprodutor', $this->arr);
    }//function index

  public function arquivo() {   
    $this->arr['list_js'] = array(
    'plugins/sweetalert2',
    'system'
    );  
    
    $tab = new Orm('leads');
    $this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
    /*
    if(isset($_GET['nome']) && !empty($_GET['nome'])){
    $nome = addslashes($_GET['nome']);
    $this->arr['lista'] = $tab->select('*')->search(['nome', $nome])->get();
    }else{
    $this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')      
    ->join(['usuarios'])
    ->on(
      ['leads.para','=','usuarios.id_usuario'])->wherecustom("situacao_pv != ''")->order(['data_entrada desc'])->paginate('10')->get();
    $this->arr['paginacao'] = $tab->render("origem");
    }*/
    if(isset($_GET['nome']) && !empty($_GET['nome'])){
      $nome = addslashes($_GET['nome']);
      $this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')->search(['nome', $nome])
      ->join(['usuarios'])
      ->on(
        ['leads.para','=','usuarios.id_usuario'])->get();
       // $this->arr['paginacao'] = $tab->render('prevenda/arquivo');        
      }else{
        if(isset($_GET['situacao_pesquisa']) && !empty($_GET['situacao_pesquisa'])){
          $situacao_pesquisa = addslashes($_GET['situacao_pesquisa']);
          $this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')->search(['situacao_pv', $situacao_pesquisa])    
          ->join(['usuarios'])
          ->on(
            ['leads.para','=','usuarios.id_usuario'])->get();
          //  $this->arr['paginacao'] = $tab->render('prevenda/arquivo');            
          }else{
          $this->arr['lista'] = $tab->select('leads.*, usuarios.nome as vendedor')      
          ->join(['usuarios'])
          ->on(
            ['leads.para','=','usuarios.id_usuario'])->wherecustom("situacao_pv != ''")->order(['data_entrada desc'])->paginate('10')->get();
         // $this->arr['paginacao'] = $tab->render('prevenda/arquivo');
          }
      }
    
    
    $this->loadTemplate('prevenda/prevenda_arquivo', $this->arr);
    }//function index

public function updatesituacao() {   
  $this->arr['list_js'] = array(
  'plugins/sweetalert2',
  'system'
  );  

  $id_lead = $_POST['lead'];
  $situacao = $_POST['situacao'];
  $grava = (new Orm('leads'))->set(['situacao_pv'=>$situacao])->where(['id_lead', $id_lead])->update();
  return 'ok';
  
  }//function index 

  public function updateobsn() {   
    $this->arr['list_js'] = array(
    'plugins/sweetalert2',
    'system'
    );  
  
    $id_lead = $_POST['lead'];
    $obsn = $_POST['obsn'];
    $grava = (new Orm('leads'))->set(['obsn'=>$obsn])->where(['id_lead', $id_lead])->update();
    return 'ok';
    
    }//function index   

public function updateacao() {   
  $this->arr['list_js'] = array(
  'plugins/sweetalert2',
  'system'
  );  

  $id_lead = $_POST['lead'];
  $acao = $_POST['acao'];
  $grava = (new Orm('leads'))->set(['acao'=>$acao])->where(['id_lead', $id_lead])->update();
  return 'ok';
  
  }//function index  

public function add(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'preview_imagem',
'uploadImage',
'functions_js',
'plugins/sweetalert2',
'system'
);


$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('origem/adicionar', $this->arr);
}//add


public function edit($id){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'preview_imagem',
'uploadImage',
);

$this->arr['id_origem'] = $id;
$this->arr['info'] = (new Orm('origem_venda'))->select('*')->where(['id_origem', $id])
->first()->get();
$this->loadTemplate('origem/editar', $this->arr);
}//edit


public function save(){

if(isset($_POST['nome']) && !empty($_POST['nome'])){
 $id_origem   = (isset($_POST['id_origem'])) ? $this->limpaCampo($_POST['id_origem']) : NULL; 
 $nome            = $this->limpaCampo($_POST['nome']);

 
$consulta = (new Orm('origem_venda'))->select('*')->where(['nome_origem', $nome])->first()->get();

if(!empty($consulta)){
  $_SESSION['msg'] = array('type'=>'error', 'msg'=>'Ooppss, ja existe cadastro com esse número ou nome no sistema, por favor tente novamente!!!');
  header("Location:".BASE_URL."origem");
  exit;  
}

$dados_form = [
'nome_origem'=>$nome
];

if($id_origem == null){
 $grv = (new Orm('origem_venda'))->set($dados_form)->save();
 $_SESSION['msg'] = array('type'=>'success', 'msg'=>'Origem cadastrada com sucesso!');
 $this->redirect(BASE_URL."origem"); 
}else{
 $grv = (new Orm('origem_venda'))->set($dados_form)->where(['id_origem', $id_origem])->update();
 $_SESSION['msg'] = array('type'=>'success', 'msg'=>'Origem Editada com sucesso!');
 header("Location:".BASE_URL."origem");
 exit;
}

}

}//save

public function remover($id){
$del = (new Orm('origem_venda'))->del(['id_origem', $id]);
$_SESSION['msg'] = array('type'=>'success', 'msg'=>'Origem removida com sucesso!');
$this->redirect(BASE_URL."origem");
}//remover

public function fotos($id){

  //echo $id;
  //exit;
  $this->arr['item'] = (new Orm('leads'))->select('*')
  ->where(['id_lead', $id])->first()->get(); 
//  $this->arr['item'] = json_decode($old->anexos, true);

  //$this->loadview('prevenda/prevenda_fotos', $this->arr);
  $this->loadview('prevenda/prevenda_fotos', $this->arr);
  //exit; 

  
}//lendoAnexos 


public function lendoAnexos($anexos){
  //echo '<script>alert("aqui");</script>';
  if($anexos != ''){
   $anexos = json_decode($anexos, true);
   
    foreach($anexos as $key=> $value){
      $rota = BASE_URL.$value;
  
      if(substr($value, -3) == 'png' || substr($value, -3) == 'jpg' || substr($value, -4) == 'jpeg'){
       echo ' <li>
                  <div class="img_resp">
                  <img src="'.$rota.'">
                  </div>
                   <p>'.mb_strimwidth($value, 0, 30, "...").'</p>                  
                  <button type="button">
                  <a href="'.$rota.'" download style="color:white;"><i class="fa fa-download"></i></a></button>  
                  <button type="button" temporario class="apagarArquivo2"><i class="fa fa-times"></i></button>              
                  </li>'; 
      }
  
  
      if(substr($value, -3) == 'pdf'){
        echo '<li>
              <div class="img_icon"><i class="fa fa-file-pdf-o"></i></div>
              <p>'.mb_strimwidth($value, 0, 30, "...").'</p>
               <button type="button"><a href="'.$rota.'" download style="color:white;"><i class="fa fa-download"></i></a></button> 
               <button type="button" temporario class="apagarArquivo2"><i class="fa fa-times"></i></button>           
        </li>';
      }
  
      if(substr($value, -3) == 'doc' || substr($value, -4) == 'docx'){
        echo '<li>
                   <div class="img_icon"><i class="fa fa-file-word-o"></i></div>   
                    <p>'.mb_strimwidth($value, 0, 30, "...").'</p>                
                   <button type="button"><a href="'.$rota.'" download style="color:white;"><i class="fa fa-download"></i></a></button> 
                   <button type="button" temporario class="apagarArquivo2"><i class="fa fa-times"></i></button>                
                   </li>';
      }
  
      if(substr($value, -3) == 'xls' || substr($value, -4) == 'xlsx'){
        echo '<li>
                   <div class="img_icon"><i class="fa fa-file-excel-o"></i></div>
                    <p>'.mb_strimwidth($value, 0, 30, "...").'</p>
                   <button type="button"><a href="'.$rota.'" download style="color:white;"><i class="fa fa-download"></i></a></button>  
                   <button type="button" temporario class="apagarArquivo2"><i class="fa fa-times"></i></button>                
                   </li>  ';
      }
  
  
    }
  }
  
  }//lendoAnexos 

  
public function lendoAnexosprevenda($anexos){
  //echo '<script>alert("aqui");</script>';
  if($anexos != ''){
   $anexos = json_decode($anexos, true);
   
    foreach($anexos as $key=> $value){
      $rota = BASE_URL.$value;
      //echo '<script>alert("aqui");</script>';
      if(substr($value, -3) == 'png' || substr($value, -3) == 'jpg' || substr($value, -4) == 'jpeg'){
        if(substr($value, -3) == 'png'){
        $rotadownload = substr($value, -3).'.pdf';
        }
        if(substr($value, -3) == 'jpg'){
          $rotadownload = substr($value, -3).'.pdf';
        }        
        if(substr($value, -4) == 'jpeg'){
          $rotadownload = substr($value, -3).'.pdf';
        }        
     

        echo ' <li>
                   <div class="img_resp">
                   <img src="'.$rota.'" width="50%" >
                   </div>
                    <p>'.mb_strimwidth($value, 0, 30, "...").'</p>                  
                   <button type="button">
                   <a href="'.$rota.'" download style="color:white;"><i class="fa fa-download"></i></a></button>  
                   <button type="button" temporario class="apagarArquivo2"><i class="fa fa-times"></i></button>              
                   </li>'; 
       }
   
   
       if(substr($value, -3) == 'pdf'){
         echo '<li>
               <div class="img_icon"><i class="fa fa-file-pdf-o"></i></div>
               <p>'.mb_strimwidth($value, 0, 30, "...").'</p>
                <button type="button"><a href="'.$rota.'" download style="color:white;"><i class="fa fa-download"></i></a></button> 
                <button type="button" temporario class="apagarArquivo2"><i class="fa fa-times"></i></button>           
         </li>';
       }
   
       if(substr($value, -3) == 'doc' || substr($value, -4) == 'docx'){
         echo '<li>
                    <div class="img_icon"><i class="fa fa-file-word-o"></i></div>   
                     <p>'.mb_strimwidth($value, 0, 30, "...").'</p>                
                    <button type="button"><a href="'.$rota.'" download style="color:white;"><i class="fa fa-download"></i></a></button> 
                    <button type="button" temporario class="apagarArquivo2"><i class="fa fa-times"></i></button>                
                    </li>';
       }
   
       if(substr($value, -3) == 'xls' || substr($value, -4) == 'xlsx'){
         echo '<li>
                    <div class="img_icon"><i class="fa fa-file-excel-o"></i></div>
                     <p>'.mb_strimwidth($value, 0, 30, "...").'</p>
                    <button type="button"><a href="'.$rota.'" download style="color:white;"><i class="fa fa-download"></i></a></button>  
                    <button type="button" temporario class="apagarArquivo2"><i class="fa fa-times"></i></button>                
                    </li>  ';
       }
  
  
    }
  }
  
  }//lendoAnexos 

}