<?php
use Core\Controller;
use Models\Users;
use Models\Permissao;
use Models\Orm;
use Models\Validate;
use Models\Leads;

class TitulosController extends Controller {

private $user;
  private $arr;
  private $permissao;

    public function __construct() {              
        $this->user = new Users();
        $this->permissao = new Permissao(); 

        if($this->user->isLogged() == false){                  
         header("Location: ".BASE_URL."login");        
         exit;         
        }

       $usuario = $this->user->getId();       
       $permissoes = $this->permissao->getPermissoes();
       $modulo_boleto = $this->permissao->getPermissoesBoleto();
       
        $this->arr = array(
         'user'=>$this->user,
         'menuActive'=>'home',
         'permissao'=>$permissoes,
         'modulo_boleto'=>$modulo_boleto
        );          
}  

public function index() {   
$this->arr['list_js'] = array(
'plugins/sweetalert2',
'system'
);  

$tab = new Orm('titulos');

if(isset($_GET['nome']) && !empty($_GET['nome'])){
$nome = addslashes($_GET['nome']);
$this->arr['lista'] = $tab->select('*')->search(['novo_titulo',$nome])->get();
}else{
$this->arr['lista'] = $tab->select('*')->paginate('10')->get();
$this->arr['paginacao'] = $tab->render("titulos");
}

$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);


$this->loadTemplate('titulos/listar', $this->arr);
}//function index  


public function add(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'functions_js',
'plugins/sweetalert2',
'system'
);

$l = new Leads();
$this->arr['colunas'] = $l->listaColunas();


$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('titulos/adicionar', $this->arr);
}//add


public function edit($id){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'plugins/sweetalert2',
'system'
);

$this->arr['id_lead'] = $id;
$this->arr['info'] = (new Orm('leads'))->select('*')->where(['id_lead', $id])
->first()->get();
$this->loadTemplate('Leads/editar', $this->arr);
}//edit


public function save(){
$validator = new Validate();

if(isset($_POST['indice_titulo']) && !empty($_POST['novo_titulo'])){

$tem = (new Orm('titulos'))->select('*')->where(['indice_titulo', $_POST['indice_titulo']])->first()->get();

if(!empty($tem)){
$_SESSION['msg'] = ['type'=>'error','msg'=>'Titulo já informado!'];
header("Location:".BASE_URL."titulos");
exit;
}

$validate = $validator->validate([
'id_titulo'=>'null',
'indice_titulo'=>'required',
'novo_titulo'=>'required'
],true);


if(!$validate){
$_SESSION['msg'] = ['type'=>'error','msg'=>'Ooops... Alguns campos estão inválidos, tente novamente'];
 unset($_SESSION['flash']);
 unset($_SESSION['old']);
 header("Location:".BASE_URL."titulos/add");
 exit;   
}


if($validate['id_titulo'] == null){
  //grava no banco
  $grava = (new Orm('titulos'))->set($validate)->save(); 
  $_SESSION['msg'] = ['type'=>'success','msg'=>'Titulo Cadastrado com sucesso!'];
  header("Location:".BASE_URL."titulos");
  exit;
}else{
 $grava = (new Orm('titulos'))->set($validate)->where(['id_titulo', $validate['id_titulo']])->update(); 
 $_SESSION['msg'] = ['type'=>'success','msg'=>'Titulo atualizado com sucesso!'];
  header("Location:".BASE_URL."titulos");
  exit; 
}

}
}//save




public function remover($id){
$del = (new Orm('titulos'))->del(['id_titulo', $id]);
$_SESSION['msg'] = array('type'=>'success', 'msg'=>'Titulo removido com sucesso!');
$this->redirect(BASE_URL."titulos");
}//remover



}