<?php
use Core\Controller;
use Models\Users;
use Models\Permissao;
use Models\Orm;
use Models\Email;
use Models\Validate;
use Dompdf\Options;
use Dompdf\Dompdf;

class UsuariosController extends Controller {

	private $user;
  private $arr;
  private $permissao;

    public function __construct() {              
        $this->user = new Users();
        $this->permissao = new Permissao(); 

        if($this->user->isLogged() == false){                  
         header("Location: ".BASE_URL."login");        
         exit;         
        }
           
        $permissoes = $this->permissao->getPermissoes();
        $modulo_boleto = $this->permissao->getPermissoesBoleto();
        
         $this->arr = array(
          'user'=>$this->user,
          'menuActive'=>'home',
          'permissao'=>$permissoes,
          'modulo_boleto'=>$modulo_boleto
         );           
}

public function index() {
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'mask_init',
'plugins/sweetalert2',
'system'
);

 
$usuarios = new Orm('usuarios');
//Filtrando pesquisas

if(isset($_GET['nome']) && !empty($_GET['nome'])){
  $nome = $_GET['nome'];  
  //echo $nome;
  //exit;
  $this->arr['listaUsers'] = $usuarios->select('*')->search(['nome', $nome])->get(); 
  //$this->arr['paginacao'] = $usuarios->render('usuarios'); 
  //print_r($this->arr);
  //exit;
  }else{
$this->arr['listaUsers'] = $usuarios->select('*')->paginate('10')->get();
$this->arr['paginacao'] = $usuarios->render('usuarios'); 
}
//echo $nome;
//exit;
//$this->arr['listaUsers'] = $usuarios->select('*')->paginate('100')->order(['nome asc'])->get();
//$this->arr['paginacao'] = $usuarios->render('usuarios'); 
$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('usuarios/usuarios', $this->arr);

/*
if(isset($_GET['nome']) && !empty($_GET['nome'])){
$nome = addslashes($_GET['nome']);
$this->arr['lista'] = $tab->select('*')->search(['nome_origem', $nome])->get();
}else{
$this->arr['lista'] = $tab->select('*')->paginate('10')->get();
$this->arr['paginacao'] = $tab->render("origem");
}
*/



}//function index   


public function teste(){
    
//como utilizar
$response = (new Email())->send([
     'from'=>'Jorge Santos',
     'para'=>'jorgejs2013@gmail.com',
     'assunto'=>'Texte disparo de email',
     'mensagem'=>'conteudo da mensagem aqui'
     ]);
    
    echo "<pre>";
    var_dump($response);
    exit;
    
    
    
}



public function add(){
$this->arr['list_js'] = array(
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'plugins/jquery.mask.min',
'mask_init',
'plugins/sweetalert2'
);    

$this->arr['produtos'] = (new Orm('produtos'))->select('*')->get();

$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('usuarios/usuarios_add', $this->arr);
}//add



public function add_action(){
$validator = new Validate();  
$c = new Orm('usuarios');

if(isset($_POST['email']) && !empty($_POST['nome'])){ 

$validate = $validator->validate([
'id_usuario'=>'null',
'nome'=>'required',
'slug'=>'slug:nome',
'email'=>'required',
'email_crypt'=>'md5:email',
'contato'=>'required',
'senha'=>'required|senha',
'tipo'=>'required',
'status'=>'required',
'observacao'=>'null'
],true);

if(!$validate){
  $_SESSION['msg'] = ['type'=>'error','msg'=>'Ooops... Alguns campos estão inválidos, tente novamente'];
   unset($_SESSION['flash']);
   unset($_SESSION['old']);
   header("Location:".BASE_URL."usuarios/add");
   exit;   
  }
  
  $grava = (new Orm('usuarios'))->set($validate)->save();
  $id = $grava;
$del = (new Orm('usuario_produto'))->del(['id_usuario', $id]);
if(isset($_POST['produto']) && !empty($_POST['produto'])){ 
  //print_r($_POST['produto']);
  foreach($_POST['produto'] as $prod){
    //echo $prod;
    //exit;
    $validateprod = $validator->validate([
    'id_usuario'=>'definido:'.$id,
    'produto'=>'definido:'.$prod
  ],true);
  $gravaprod = (new Orm('usuario_produto'))->set($validateprod)->save();
  //exit;
  }
  $_SESSION['msg'] = ['type'=>'success', 'msg'=>"Usuário cadastrado com sucesso!"];
  header("Location: ".BASE_URL."usuarios");
  exit;

}



}

}//add action

public function lendoAnexos($anexos){
  //echo '<script>alert("aqui");</script>';
  if($anexos != ''){
   $anexos = json_decode($anexos, true);
   
    foreach($anexos as $key=> $value){
      $rota = BASE_URL.$value;
  
      if(substr($value, -3) == 'png' || substr($value, -3) == 'jpg' || substr($value, -4) == 'jpeg'){
       echo ' <li>
                  <div class="img_resp">
                  <img src="'.$rota.'">
                  </div>
                   <p>'.mb_strimwidth($value, 0, 30, "...").'</p>                  
                  <button type="button">
                  <a href="'.$rota.'" download style="color:white;"><i class="fa fa-download"></i></a></button>  
                  <button type="button" temporario class="apagarArquivo2"><i class="fa fa-times"></i></button>              
                  </li>'; 
      }
  
  
      if(substr($value, -3) == 'pdf'){
        echo '<li>
              <div class="img_icon"><i class="fa fa-file-pdf-o"></i></div>
              <p>'.mb_strimwidth($value, 0, 30, "...").'</p>
               <button type="button"><a href="'.$rota.'" download style="color:white;"><i class="fa fa-download"></i></a></button> 
               <button type="button" temporario class="apagarArquivo2"><i class="fa fa-times"></i></button>           
        </li>';
      }
  
      if(substr($value, -3) == 'doc' || substr($value, -4) == 'docx'){
        echo '<li>
                   <div class="img_icon"><i class="fa fa-file-word-o"></i></div>   
                    <p>'.mb_strimwidth($value, 0, 30, "...").'</p>                
                   <button type="button"><a href="'.$rota.'" download style="color:white;"><i class="fa fa-download"></i></a></button> 
                   <button type="button" temporario class="apagarArquivo2"><i class="fa fa-times"></i></button>                
                   </li>';
      }
  
      if(substr($value, -3) == 'xls' || substr($value, -4) == 'xlsx'){
        echo '<li>
                   <div class="img_icon"><i class="fa fa-file-excel-o"></i></div>
                    <p>'.mb_strimwidth($value, 0, 30, "...").'</p>
                   <button type="button"><a href="'.$rota.'" download style="color:white;"><i class="fa fa-download"></i></a></button>  
                   <button type="button" temporario class="apagarArquivo2"><i class="fa fa-times"></i></button>                
                   </li>  ';
      }
  
  
    }
  }
  
  }//lendoAnexos 

public function edit($id){
$this->arr['list_js'] = array(
  'plugins/sweetalert2',
  'plugins/jquery.mask.min',
  'plugins/parsley/parsley.min',
  'plugins/parsley/pt-br',
  'mask_init', 
  'system',
  'flatpickr/flatpickr',
  'flatpickr/pt',
  'flatpickr/flatpickr_init',
  'multiuploads'
  ); 

$this->arr['anexos'] = (new Orm('usuarios'))->select('anexos')->where(['id_usuario', $id])->first()->get();

$this->arr['produtos'] = (new Orm('produtos'))->select('*')->get();

$o = new Orm('usuarios');
$up = new Orm('usuario_produto');
$this->arr['info'] = $o->select('*')->where(['id_usuario', $id])->first()->get();
$this->arr['infoproduto'] = $up->select('*')->where(['id_usuario', $id])->get();
$this->arr['id_usuario'] = $id;


$this->loadTemplate('usuarios/usuarios_edit', $this->arr);
}//edit


public function edit_action($id){
  $this->arr['list_js'] = array(
    'plugins/sweetalert2',
    'plugins/jquery.mask.min',
    'plugins/parsley/parsley.min',
    'plugins/parsley/pt-br',
    'mask_init', 
    'system',
    'flatpickr/flatpickr',
    'flatpickr/pt',
    'flatpickr/flatpickr_init',
    'multiuploads'
    ); 
//echo '<pre>';
//print_r($_POST);
//echo $_POST['anexos'];
//exit;
$validator = new Validate();  
$c = new Orm('usuarios');


if(isset($_POST['email']) && !empty($_POST['nome'])){ 
$validate = $validator->validate([
'id_usuario'=>'null',
'nome'=>'required|unique:usuarios-id_usuario-'.$id,
'slug'=>'slug:nome',
'email'=>'required',
'email_crypt'=>'md5:email',
'contato'=>'required',
'senha'=>'senha:usuarios-id_usuario-'.$id,
'tipo'=>'required',
'status'=>'required',
'observacao'=>'null',
'cpf'=>'null',
'rg'=>'null',
'data_nascimento'=>'null',
'estado_civil'=>'null',
'end_rua'=>'null',
'end_n'=>'null',
'end_bairro'=>'null',
'end_cep'=>'null',
'end_cidade'=>'null',
'end_estado'=>'null',
'tel2'=>'null',
'codcorretor'=>'null',
'esp_numero'=>'null',
'esp_descricao'=>'null',
'esp_valor'=>'null'
],true);

$del = (new Orm('usuario_produto'))->del(['id_usuario', $id]);
if(isset($_POST['produto']) && !empty($_POST['produto'])){ 
  //print_r($_POST['produto']);
  foreach($_POST['produto'] as $prod){
    //echo $prod;
    //exit;
    $validateprod = $validator->validate([
    'id_usuario'=>'definido:'.$id,
    'produto'=>'definido:'.$prod
  ],true);
  //echo '<pre>';
  //echo $_POST['anexos'];
  //exit;
  if($_POST['anexos'] != '' && $_POST['anexos'] != NULL){
    $id_usuario = $id;
    //$id_lead = $_POST['id_lead'];
    $files = '';
    $anexos = $_POST['anexos'];
    $anexosname = $_POST['mutiplo_upload'];
    $dados = array();
    //echo $anexosname;
    //exit;

      if($_POST['anexosview'] != ''){
        $old = (new Orm('usuarios'))->select(['anexos'])
        ->where(['id_usuario', $id_usuario])->first()->get(); 
        $arquivo = json_decode($old->anexos, true);
       //print_r($arquivo);
       // exit;
        foreach($arquivo as $arq){
          array_push($dados, $arq);  
        }
        $novos = $this->gravaAnexos($anexos,$anexosname,$id_usuario);
        $files = json_decode($novos['files'], true);
        foreach($files as $file){
          array_push($dados, $file);
        }
         $dados = json_encode($dados);     
         $files = $dados;
      }else{
        $files = $this->gravaAnexos($anexos,$anexosname,$id_usuario);  
        $files = $files['files'];
      };   
 

      $grava = (new Orm('usuarios'))->set(['anexos'=>$files])->where(['id_usuario', $id_usuario])->update();
  }; 
  
  $gravaprod = (new Orm('usuario_produto'))->set($validateprod)->save();




  //exit;
  }

}

//exit;


if(!$validate){
$_SESSION['msg'] = ['type'=>'error','msg'=>'Ooops... Alguns campos estão inválidos, tente novamente'];
 unset($_SESSION['flash']);
 unset($_SESSION['old']);
 header("Location:".BASE_URL."usuarios/edit/".$id);
 exit;   
}
//echo '<pre>';
//print_r($validate);
//exit;
$grava = (new Orm('usuarios'))->set($validate)->where(['id_usuario', $validate['id_usuario']])->update();


$_SESSION['msg'] = ['type'=>'success', 'msg'=>"Usuário atualizado com sucesso!"];
header("Location: ".BASE_URL."usuarios");
exit;
}
}//edit action

public function assinarEspelho($idlead){
    
    
  $data['consulta'] = (new Orm('usuarios'))
  ->select(['*'])
  ->wherecustom("id_usuario = '$idlead' LIMIT 1")
  ->get();       

  //$data['empresa'] = (new Orm('clientes'))->select('*')->get();   
  //$data['contrato'] = (new Orm('contrato'))->select('*')->wherecustom("contrato.id_lead = '$idlead' LIMIT 1")->get();   
   // echo '<pre>';
   // print_r($data);
   // exit;


  $data['idlead'] = $idlead;

  ob_start();
  $this->loadview("/usuarios/usuario_report_contratoespelho_pdf", $data);      
  //exit;
  $html = ob_get_contents();
  ob_end_clean();      
  $options = new Options();
  $options->set('isRemoteEnabled',true);
  $dompdf = new Dompdf($options);
  //$dompdf = new Dompdf();
  $dompdf->set_option('isHtml5ParserEnabled', true);
  $dompdf->set_option("isPhpEnabled", true);
  $dompdf->loadHtml($html);
  ini_set('xdebug.max_nesting_level', 2000);
  ini_set('memory_limit', '256M');

  // Render the HTML as PDF
  $dompdf->setPaper('A4', 'portrait');
  $dompdf->render();
  $dompdf->stream("Letter",["Attachment" => false]); 
  $output = $dompdf->output();

}

public function assinar($idlead){
    
    
  $data['consulta'] = (new Orm('usuarios'))
  ->select(['*'])
  ->wherecustom("id_usuario = '$idlead' LIMIT 1")
  ->get();       

  //$data['empresa'] = (new Orm('clientes'))->select('*')->get();   
  //$data['contrato'] = (new Orm('contrato'))->select('*')->wherecustom("contrato.id_lead = '$idlead' LIMIT 1")->get();   
   // echo '<pre>';
   // print_r($data);
   // exit;


  $data['idlead'] = $idlead;

  ob_start();
  $this->loadview("/usuarios/usuario_report_contrato_pdf", $data);      
  //exit;
  $html = ob_get_contents();
  ob_end_clean();      
  $options = new Options();
  $options->set('isRemoteEnabled',true);
  $dompdf = new Dompdf($options);
  //$dompdf = new Dompdf();
  $dompdf->set_option('isHtml5ParserEnabled', true);
  $dompdf->set_option("isPhpEnabled", true);
  $dompdf->loadHtml($html);
  ini_set('xdebug.max_nesting_level', 2000);
  ini_set('memory_limit', '256M');

  // Render the HTML as PDF
  $dompdf->setPaper('A4', 'portrait');
  $dompdf->render();
  $dompdf->stream("Letter",["Attachment" => false]); 
  $output = $dompdf->output();

}

public function reset(){
$this->arrayInfo['list_js'] = array(
'parsley/parsley.min',
'parsley/pt-br',
'jquery.mask.min',
'mask_init',
'sweetalert2.all.min'
);  

$c = new Orm('usuarios');
$usuario = $this->user->getId();
$user = $c->select('*')->where(['id', $usuario])->first()->get();

if(isset($_POST['old_senha']) &&  !empty($_POST['senha']) && !empty($_POST['csenha'])){
 $senha = addslashes($_POST['old_senha']);
 $newSenha = addslashes($_POST['senha']); 
 $newpass = password_hash($newSenha, PASSWORD_DEFAULT);


if(password_verify($senha, $user->senha)){

 $form = new \stdClass();
 $form->senha = $newpass;

 $c->set(['senha'=>$newpass])->where(['id', $usuario])->update(); 
 $this->arrayInfo['msg'] = "Senha atualizada com sucesso!"; 
}else{
  $this->arrayInfo['msg'] = "senhas não conferem"; 
}

}

$this->loadTemplate('usuarios/reset', $this->arrayInfo);
}//reset

public function logout(){
session_destroy();
unset($_SESSION['token']);

header("Location: ".BASE_URL);
exit;
}//logout


public function del($id){ 
$c = new Orm('usuarios');
$c->del(['id_usuario', $id]);        

$_SESSION['msg'] = ['type'=>'success', 'msg'=>"Removido com sucesso!"];
header("Location: ".BASE_URL."usuarios");
exit;
}//del

}