<?php
use Core\Controller;
use Models\Users;
use Models\Permissao;
use Models\Orm;
use Models\Validate;

class UsuariosController extends Controller {

	private $user;
  private $arr;
  private $permissao;

    public function __construct() {              
        $this->user = new Users();
        $this->permissao = new Permissao(); 

        if($this->user->isLogged() == false){                  
         header("Location: ".BASE_URL."login");        
         exit;         
        }
           
       $permissoes = $this->permissao->getPermissoes();

        $this->arr = array(
         'user'=>$this->user,
         'menuActive'=>'home',
         'permissao'=>$permissoes             
        );          
}

public function index() {
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'mask_init',
'plugins/sweetalert2',
'system'
);

 
$usuarios = new Orm('usuarios');
//Filtrando pesquisas
if(isset($_GET['nome']) && !empty($_GET['nome'])){

}else{
$this->arr['listaUsers'] = $usuarios->select('*')->paginate('10')->get();
$this->arr['paginacao'] = $usuarios->render('usuarios'); 
}

$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('usuarios/usuarios', $this->arr);
}//function index   



public function add(){
$this->arr['list_js'] = array(
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'plugins/jquery.mask.min',
'mask_init',
'plugins/sweetalert2'
);    


$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('usuarios/usuarios_add', $this->arr);
}//add



public function add_action(){
$validator = new Validate();  
$c = new Orm('usuarios');

if(isset($_POST['email']) && !empty($_POST['nome'])){ 

$validate = $validator->validate([
'id_usuario'=>'null',
'nome'=>'required',
'slug'=>'slug:nome',
'email'=>'required',
'email_crypt'=>'md5:email',
'contato'=>'required',
'senha'=>'required|senha',
'tipo'=>'required',
'status'=>'required',
'observacao'=>'null'
],true);


if(!$validate){
$_SESSION['msg'] = ['type'=>'error','msg'=>'Ooops... Alguns campos estão inválidos, tente novamente'];
 unset($_SESSION['flash']);
 unset($_SESSION['old']);
 header("Location:".BASE_URL."usuarios/add");
 exit;   
}

$grava = (new Orm('usuarios'))->set($validate)->save();
$_SESSION['msg'] = ['type'=>'success', 'msg'=>"Usuário cadastrado com sucesso!"];
header("Location: ".BASE_URL."usuarios");
exit;
}

}//add action


public function edit($id){
$this->arr['list_js'] = array(
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'plugins/jquery.mask.min',
'mask_init',
'plugins/sweetalert2',
'system'
);  

$o = new Orm('usuarios');
$this->arr['info'] = $o->select('*')->where(['id_usuario', $id])->first()->get();
$this->arr['id_usuario'] = $id;


$this->loadTemplate('usuarios/usuarios_edit', $this->arr);
}//edit


public function edit_action($id){
$validator = new Validate();  
$c = new Orm('usuarios');

if(isset($_POST['email']) && !empty($_POST['nome'])){ 
$validate = $validator->validate([
'id_usuario'=>'null',
'nome'=>'required|unique:usuarios-id_usuario-'.$id,
'slug'=>'slug:nome',
'email'=>'required',
'email_crypt'=>'md5:email',
'contato'=>'required',
'senha'=>'senha:usuarios-id_usuario-'.$id,
'tipo'=>'required',
'status'=>'required',
'observacao'=>'null'
],true);

if(!$validate){
$_SESSION['msg'] = ['type'=>'error','msg'=>'Ooops... Alguns campos estão inválidos, tente novamente'];
 unset($_SESSION['flash']);
 unset($_SESSION['old']);
 header("Location:".BASE_URL."usuarios/edit/".$id);
 exit;   
}

$grava = (new Orm('usuarios'))->set($validate)->where(['id_usuario', $validate['id_usuario']])->update();
$_SESSION['msg'] = ['type'=>'success', 'msg'=>"Usuário atualizado com sucesso!"];
header("Location: ".BASE_URL."usuarios");
exit;
}
}//edit action


public function reset(){
$this->arrayInfo['list_js'] = array(
'parsley/parsley.min',
'parsley/pt-br',
'jquery.mask.min',
'mask_init',
'sweetalert2.all.min'
);  

$c = new Orm('usuarios');
$usuario = $this->user->getId();
$user = $c->select('*')->where(['id', $usuario])->first()->get();

if(isset($_POST['old_senha']) &&  !empty($_POST['senha']) && !empty($_POST['csenha'])){
 $senha = addslashes($_POST['old_senha']);
 $newSenha = addslashes($_POST['senha']); 
 $newpass = password_hash($newSenha, PASSWORD_DEFAULT);


if(password_verify($senha, $user->senha)){

 $form = new \stdClass();
 $form->senha = $newpass;

 $c->set(['senha'=>$newpass])->where(['id', $usuario])->update(); 
 $this->arrayInfo['msg'] = "Senha atualizada com sucesso!"; 
}else{
  $this->arrayInfo['msg'] = "senhas não conferem"; 
}

}

$this->loadTemplate('usuarios/reset', $this->arrayInfo);
}//reset

public function logout(){
session_destroy();
unset($_SESSION['token']);

header("Location: ".BASE_URL);
exit;
}//logout


public function del($id){ 
$c = new Orm('usuarios');
$c->del(['id_usuario', $id]);        

$_SESSION['msg'] = ['type'=>'success', 'msg'=>"Removido com sucesso!"];
header("Location: ".BASE_URL."usuarios");
exit;
}//del

}