<?php
namespace Models;
use Core\Model;
use PDO;

class Report extends Model {


public function homedash($data1, $data2, $comp1, $comp2, $produtor = null, $grupo = null, $convenio = null){
//por periodo
 $sql = "SELECT COUNT(id_contrato) as total_contratos, SUM(valor_contrato) as soma_contratos FROM contratos WHERE data_assinatura >= '$data1' AND data_assinatura <= '$data2'";
//por comparativo
 $sql2 = "SELECT COUNT(id_contrato) as total_contratos, SUM(valor_contrato) as soma_contratos FROM contratos WHERE data_assinatura >= '$comp1' AND data_assinatura <= '$comp2'";
 
 if($produtor != null){
   $sql.= " AND produtor = '$produtor'";
   $sql2.= " AND produtor = '$produtor'";
 } 

 if($grupo != null){
   $sql .= " AND grupoprodutor = '$grupo'";
   $sql2 .= " AND grupoprodutor = '$grupo'";
 }

 if($convenio != null){
   $sql .= " AND convenio = '$convenio'";
   $sq2 .= " AND convenio = '$convenio'";
 }

 $sql .= " AND status = 'Ativo'";
 $sql2 .= " AND status = 'Ativo'";

$sql = $this->db->query($sql);
$res = $sql->fetch();

$sql2 = $this->db->query($sql2);
$res2 = $sql2->fetch();

$retorno = [
'total1'=>$res->total_contratos,
'valor1'=>$res->soma_contratos,
'total2'=>$res2->total_contratos,
'valor2'=>$res2->soma_contratos
];

return $retorno;
}//homeDash


public function gerarBaixas($convenios, $filiais, $status, $ass_inicial, $ass_final,$pag_inicial,$pag_final, $baixa_inicial, $baixa_final, $parcela_inicial, $parcela_final, $produtor, $grupo,$origem, $tipo){
$ret = [];

$sql = "SELECT 
contratos.id_contrato,
contratos.numero_proposta,
contratos.data_assinatura,
contratos.data_cad,
contratos.convenio,
contratos.origem_venda,
contratos.produtor,
contratos.grupoprodutor,
contratos.dia_vencimento,
contratos.data_cancelamento,
contratos.data_vigencia,
contratos.status,
convenios.nome_convenio,
contratos.nome_cliente,
filiais.nome_filial,
lancamento_historico.id_historico,
lancamento_historico.data_pagamento,
lancamento_historico.num_parcela,
lancamento_historico.valor_parcela,
lancamento_historico.valor_baixa,
lancamento_historico.status_baixa,
lancamento_historico.data_baixa
FROM contratos 
INNER JOIN convenios
ON contratos.convenio = convenios.id_convenio
INNER JOIN filiais
ON contratos.filial = filiais.id_filial
INNER JOIN lancamento_historico
ON lancamento_historico.id_contrato = contratos.id_contrato
WHERE lancamento_historico.status_baixa = 'Recebida'";

//concatenando os tipos
if(!empty($status)){
$i = 0;
$tipos = '';

foreach($status as $st){
 $tipos .= '"'.$st.'",';    
}

$tipos = substr($tipos, 0, -1);
$sql .= " AND contratos.status IN($tipos)";
}//se status n esta vazio


//verificando se teve origem de venda
if(!empty($produtor)){
  $sql .= " AND contratos.produtor = {$produtor}";
}

//verificando se teve origem de venda
if(!empty($origem)){
  $sql .= " AND contratos.origem_venda = {$origem}";
}

//Trabalhando com as Datas
if(!empty($ass_inicial)){
 $sql .= " AND contratos.data_assinatura >= '{$ass_inicial}'";
}

if(!empty($ass_final)){
 $sql .= " AND contratos.data_assinatura <= '{$ass_final}'";
}

if(!empty($pag_inicial)){
 $sql .= " AND lancamento_historico.data_pagamento >= '{$pag_inicial}'";
}

if(!empty($pag_final)){
 $sql .= " AND lancamento_historico.data_pagamento <= '{$pag_final}'";
}

if(!empty($baixa_inicial)){
 $sql .= " AND lancamento_historico.data_baixa >= '{$baixa_inicial}'";
}

if(!empty($baixa_final)){
 $sql .= " AND lancamento_historico.data_baixa <= '{$baixa_final}'";
}
//pegando o numero da parcela inicial e final
$sql .= " AND num_parcela >= {$parcela_inicial}";
//verifica se tem a parcela final e adiciona
if(!empty($parcela_final)){
$sql .= " AND num_parcela <= {$parcela_final}";
}

$sql .= " AND lancamento_historico.convenio_id IN($convenios)
AND contratos.filial IN($filiais)";

if(!empty($grupo)){
  $sql .= " AND grupoprodutor = '$grupo'";
}

$sql = $this->db->query($sql);
$result = $sql->fetchAll();
foreach($result as $key=>$res){
$result[$key]->produtor = (new Orm('produtor'))->select(['nome'])->where(['id_produtor', $res->produtor])->first()->get()->nome;  
$result[$key]->origem_venda = (new Orm('origem_venda'))->select(['nome_origem'])->where(['id_origem', $res->origem_venda])->first()->get()->nome_origem;
}

switch($tipo){
case 1:
$retorno = $this->montaRelatorioBaixa($result);
break;

case 2:
$retorno = $this->montaRelatorioBaixaProdutor($result);
break;

case 3:
$retorno = $this->montaRelatorioBaixaFilial($result);
break;

case 4:
$retorno = $this->montaRelatorioGrupo($result);
break;

case 7:
$retorno = $this->montabaixasexcel($result);
break;
}


return $retorno;
}//gerarBaixas



public function gerarProducao($convenios, $filiais, $status, $ass_inicial, $ass_final, $produtor, $grupo,$origem, $tipo){
$ret = [];

$sql = "SELECT 
contratos.id_contrato,
contratos.numero_proposta,
contratos.data_assinatura,
contratos.data_vigencia,
contratos.vidas,
contratos.convenio,
contratos.origem_venda,
contratos.produtor,
contratos.grupoprodutor,
contratos.dia_vencimento,
contratos.data_cancelamento,
contratos.data_vigencia,
contratos.status,
contratos.valor_contrato,
convenios.nome_convenio,
contratos.nome_cliente,
filiais.nome_filial
FROM contratos 
INNER JOIN convenios
ON contratos.convenio = convenios.id_convenio
INNER JOIN filiais
ON contratos.filial = filiais.id_filial";


//concatenando os tipos
if(!empty($status)){
$i = 0;
$tipos = '';

foreach($status as $st){
 $tipos .= '"'.$st.'",';    
}

$tipos = substr($tipos, 0, -1);
$sql .= " AND contratos.status IN($tipos)";
}//se status n esta vazio


//verificando se teve origem de venda
if(!empty($produtor)){
  $sql .= " AND contratos.produtor = {$produtor}";
}

//verificando se teve origem de venda
if(!empty($origem)){
  $sql .= " AND contratos.origem_venda = {$origem}";
}

//Trabalhando com as Datas
if(!empty($ass_inicial)){
 $sql .= " AND contratos.data_assinatura >= '{$ass_inicial}'";
}

if(!empty($ass_final)){
 $sql .= " AND contratos.data_assinatura <= '{$ass_final}'";
}

$sql .= " AND contratos.convenio IN($convenios)
AND contratos.filial IN($filiais)";

if(!empty($grupo)){
  $sql .= " AND grupoprodutor = '$grupo'";
}


$sql = $this->db->query($sql);
$result = $sql->fetchAll();

foreach($result as $key=>$res){
$result[$key]->id_produtor = $res->produtor;
$result[$key]->produtor = (new Orm('produtor'))->select(['nome'])->where(['id_produtor', $res->produtor])->first()->get()->nome;  
$result[$key]->origem_venda = (new Orm('origem_venda'))->select(['nome_origem'])->where(['id_origem', $res->origem_venda])->first()->get()->nome_origem;

$superior = (new Orm('produtor'))->select(['id_produtor, superior'])->where(['nome', $res->produtor])
 ->first()->get();

$result[$key]->superior = $superior->superior; 
}


switch($tipo){
case 1:
$retorno = $this->montaRelatorioProducao($result);
break;

case 2:
$retorno = $this->montaRelatorioProducao2($result);
break;

case 3:
$retorno = $this->montaRelatorioProducao3($result);
break;

case 4:
$retorno = $this->montaRelatorioProducao4($result);
break;

case 5:
$retorno = $this->montaRelatorioProducao5($result);
break;

case 6:
$retorno = $this->montaRelatorioProducao6($result);
break;

case 7:
$retorno = $this->planilhaProducao($result);
break;

case 8:
$retorno = $this->montaRelatorioProducao7($result);
break;

}




return $retorno;

}//gerarBaixas

public function gerarRanking($convenios, $filiais, $grupo, $status, $ass_inicial, $ass_final, $limite, $tipo){
$ret = [];

$sql = "SELECT 
contratos.id_contrato,
contratos.numero_proposta,
contratos.data_assinatura,
contratos.data_vigencia,
contratos.vidas,
contratos.convenio,
contratos.origem_venda,
contratos.produtor,
contratos.grupoprodutor,
contratos.dia_vencimento,
contratos.data_cancelamento,
contratos.data_vigencia,
contratos.status,
contratos.valor_contrato,
convenios.nome_convenio,
contratos.nome_cliente,
filiais.nome_filial
FROM contratos 
INNER JOIN convenios
ON contratos.convenio = convenios.id_convenio
INNER JOIN filiais
ON contratos.filial = filiais.id_filial";

//concatenando os tipos
if(!empty($status)){
$i = 0;
$tipos = '';

foreach($status as $st){
 $tipos .= '"'.$st.'",';    
}

$tipos = substr($tipos, 0, -1);
$sql .= " AND contratos.status IN($tipos)";
}//se status n esta vazio

//concatenando os grupos
if(!empty($grupo)){
$i = 0;
$grupos = '';

foreach($grupo as $st){
 $grupos .= '"'.$st.'",';    
}

$grupos = substr($grupos, 0, -1);
$sql .= " AND contratos.grupoprodutor IN($grupos)";
}//se grupo n esta vazio



//Trabalhando com as Datas
if(!empty($ass_inicial)){
 $sql .= " AND contratos.data_assinatura >= '{$ass_inicial}'";
}

if(!empty($ass_final)){
 $sql .= " AND contratos.data_assinatura <= '{$ass_final}'";
}

$sql .= " AND contratos.convenio IN($convenios)
AND contratos.filial IN($filiais) GROUP BY produtor ORDER BY contratos.valor_contrato DESC";

if(!empty($limite)){
$sql .= " LIMIT {$limite}";
}


$sql = $this->db->query($sql);
$result = $sql->fetchAll();

foreach($result as $key=>$res){
$result[$key]->id_produtor = $res->produtor;
$result[$key]->produtor = (new Orm('produtor'))->select(['nome'])->where(['id_produtor', $res->produtor])->first()->get()->nome;  
$superior = (new Orm('produtor'))->select(['id_produtor, superior'])->where(['nome', $res->produtor])
 ->first()->get();
$result[$key]->superior = $superior->superior; 
}

if($tipo == 1){
$retorno  = $this->montaRelatorioProducao4($result);
}else if($tipo == 2){
$retorno = $this->montaRelatorioRanking($result);
}

return $retorno;
}//gerarRanking


public function montaRelatorioRanking($array){
$arr = [];

foreach($array as $key=>$value){

$conv = $this->getProdutor($value->id_produtor);
$retorno = [
'produtor'=>$value->produtor,
'qtd_contratos'=>$conv->qtdeContratos,
'qtd_vidas'=>$conv->total_vidas,
'valor_contrato'=>$conv->total_valor
];

$nome_superior = (new Orm('produtor'))->select(['nome'])->where(['id_produtor', $value->superior])->first()->get()->nome;


if(!isset($arr[$nome_superior])){  
$arr[$nome_superior] = [];
 array_push($arr[$nome_superior], $retorno);
}else{
 array_push($arr[$nome_superior], $retorno);
}
}//foreach


return $arr;
}//montaRelatorioRanking



public function gerarFinanceiro($convenios, $filiais, $status, $ass_inicial, $ass_final, $vigencia_inicial, $vigencia_final, $produtor, $grupo, $tipo){
$ret = [];

$sql = "SELECT 
contratos.id_contrato,
contratos.numero_proposta,
contratos.data_assinatura,
contratos.data_vigencia,
contratos.convenio,
contratos.produtor,
contratos.grupoprodutor,
contratos.dia_vencimento,
contratos.data_cancelamento,
contratos.data_vigencia,
contratos.status,
contratos.valor_contrato,
convenios.nome_convenio,
contratos.nome_cliente,
filiais.nome_filial,
lancamento_historico.data_pagamento,
lancamento_historico.num_parcela,
lancamento_historico.valor_parcela,
lancamento_historico.valor_baixa
FROM contratos 
INNER JOIN convenios
ON contratos.convenio = convenios.id_convenio
INNER JOIN filiais
ON contratos.filial = filiais.id_filial
INNER JOIN lancamento_historico
ON lancamento_historico.id_contrato = contratos.id_contrato
WHERE lancamento_historico.status_baixa = 'Recebida'";

//concatenando os tipos
if(!empty($status)){
$i = 0;
$tipos = '';

foreach($status as $st){
 $tipos .= '"'.$st.'",';    
}

$tipos = substr($tipos, 0, -1);
$sql .= " AND contratos.status IN($tipos)";
}//se status n esta vazio


//Trabalhando com as Datas
if(!empty($ass_inicial)){
 $sql .= " AND contratos.data_assinatura >= '{$ass_inicial}'";
}

if(!empty($ass_final)){
 $sql .= " AND contratos.data_assinatura <= '{$ass_final}'";
}

if(!empty($vigencia_inicial)){
 $sql .= " AND contratos.data_vigencia >= '{$vigencia_inicial}'";
}

if(!empty($vigencia_final)){
 $sql .= " AND contratos.data_vigencia <= '{$vigencia_final}'";
}

$sql .= " AND lancamento_historico.convenio_id IN($convenios)
AND contratos.filial IN($filiais)";

//verificando se teve produtor
if(!empty($produtor)){
  $sql .= " AND contratos.produtor = {$produtor}";
}
//verificando se teve grupo
if(!empty($grupo)){
  $sql .= " AND contratos.grupoprodutor = '$grupo'";
}

$sql = $this->db->query($sql);
$result = $sql->fetchAll();


foreach($result as $key=>$res){
$produtor = (new Orm('produtor'))->select(['nome, superior, cnpj'])->where(['id_produtor', $res->produtor])->first()->get();

$result[$key]->id_produtor = $res->produtor;
$result[$key]->produtor = $produtor->nome ?? '';
$result[$key]->superior = $produtor->superior ?? '';
$result[$key]->cnpj = $produtor->cnpj ?? '';
}


switch($tipo){
case 1:
$retorno = $this->montaRelatorioFinanceiro($result);
break;

case 2:
$retorno = $this->plan2($result, $ass_inicial, $ass_final);
break;

case 3:
$retorno = $this->plan3($result, $ass_inicial, $ass_final);
break;

case 4:
$retorno = $this->plan4($result, $ass_inicial, $ass_final);
break;

case 5:
$retorno = $this->plan5($result, $ass_inicial, $ass_final);
break;

case 6:
$retorno = $this->plan6($result, $ass_inicial, $ass_final);
break;

case 7:
$retorno = $this->plan7($result, $ass_inicial, $ass_final);
break;

case 8:
$retorno = $this->plan8($result, $ass_inicial, $ass_final);
break;

case 9:
$retorno = $this->plan9($result, $ass_inicial, $ass_final);
break;

case 10:
$retorno = $this->plan10($result, $ass_inicial, $ass_final);
break;

}

return $retorno;
}//gerarFinanceiro

public function plan2($array, $data_ini, $data_fim){
$mes_ini = date('m', strtotime($data_ini));
$mes_fim = date('m', strtotime($data_fim));

foreach($array as $key=>$arr){
  $meses = $this->mapa($mes_ini, $mes_fim, $arr->id_contrato);  
  
  foreach($meses as $ind=>$mes){
   $array[$key]->$ind = $mes;
  } 
}

echo "<pre>";
print_r($array);
exit;

}//plan2

//planilha de receita bruta prevista
public function plan3($array, $data_ini, $data_fim){
$mes_ini = date('m', strtotime($data_ini));
$mes_fim = date('m', strtotime($data_fim));


foreach($array as $key=>$arr){
  $meses = $this->mapa($mes_ini, $mes_fim, $arr->id_contrato);  
  
  foreach($meses as $ind=>$mes){
   $array[$key]->$ind = $mes;
  } 
}

foreach($array as $key=>$item){


$regras = (new Orm('grades'))->select('*')
->where(['id_convenio',$item->convenio])->first()->get();

echo "<pre>";
print_r($regras);
exit;

}


echo "planilha 3";exit;

}
public function plan4($array, $data_ini, $data_fim){}
public function plan5($array, $data_ini, $data_fim){}
public function plan6($array, $data_ini, $data_fim){}
public function plan7($array, $data_ini, $data_fim){}
public function plan8($array, $data_ini, $data_fim){}
public function plan9($array, $data_ini, $data_fim){}
public function plan10($array, $data_ini, $data_fim){}


private function mapa($ini, $fim, $contrato){  
$meses = [];

for($i = $ini;$i <= $fim;$i++){
$i =  (strlen($i) == 1) ? "0".$i : $i;

$tem = (new Orm('lancamento_historico'))->select('*')
->wherecustom("id_contrato = $contrato AND MONTH(data_pagamento) = '$i'")
->first()->get();

$meses[$i] = $tem->valor_baixa ?? '0';
}


return $meses;
}//mapa


public function montaRelatorioProducao($array){
$arr = [];

foreach($array as $key=>$value){
if(!isset($arr[$value->nome_convenio])){
$arr[$value->nome_convenio] = [];
array_push($arr[$value->nome_convenio], $value);
}else{
 array_push($arr[$value->nome_convenio], $value);
}
}//foreach


return $arr;
}//montaRelatorioProducao

public function planilhaProducao($array){
$arr = [];

foreach($array as $value){

$produtor = (new Orm('produtor'))->select('*')->where(['id_produtor', $value->id_produtor])->first()->get();
$superior = (new Orm('produtor'))->select(['nome'])->where(['id_produtor', $value->superior])->first()->get();

$value->nome_produtor = $produtor->nome;
$value->cpf = $produtor->cnpj;
$value->grupo_produtor = $produtor->grupo_produtor;
$value->nome_superior = $superior->nome;
$value->endereco = $produtor->endereco;
$value->numero = $produtor->numero;
$value->complemento = $produtor->complemento;
$value->bairro = $produtor->bairro;
$value->municipio = $produtor->municipio;
$value->uf = $produtor->uf;
$value->cep = $produtor->cep;
$value->celular = $produtor->celular;
$value->email = $produtor->email;
$value->observacoes = $produtor->observacoes;

array_push($arr, $value);
}//foreach

return $arr;
}//planilhaProducao


public function montaRelatorioProducao2($array){
$arr = [];

foreach($array as $key=>$value){
if(!isset($arr[$value->produtor])){
$arr[$value->produtor] = [];
array_push($arr[$value->produtor], $value);
}else{
 array_push($arr[$value->produtor], $value);
}
}//foreach

return $arr;
}//montaRelatorioProducao

public function montaRelatorioProducao3($array){
$arr = [];

foreach($array as $key=>$value){
$value->superior = (new Orm('produtor'))->select(['nome'])->where(['superior', $value->superior])->first()->get()->nome ?? 'Sem superior';

if(!isset($arr[$value->superior])){
$arr[$value->superior] = [];
array_push($arr[$value->superior], $value);
}else{
 array_push($arr[$value->superior], $value);
}
}//foreach

return $arr;
}//montaRelatorioProducao

public function montaRelatorioProducao4($array){
$arr = [];

foreach($array as $key=>$value){
if(!isset($arr[$value->produtor])){
$arr[$value->produtor] = [];

$conv = $this->getConvenio($value->id_produtor, $value->convenio);
$retorno = [
'convenio'=>$value->nome_convenio,
'qtd_contratos'=>$conv->qtdeContratos,
'qtd_vidas'=>$conv->total_vidas,
'taxa_adesao'=>$conv->total_taxa,
'valor_contrato'=>$conv->total_valor
];

array_push($arr[$value->produtor], (object)$retorno);
}else{
  $conv = $this->getConvenio($value->id_produtor, $value->convenio);
  $retorno = [
  'convenio'=>$value->nome_convenio,
  'qtd_contratos'=>$conv->qtdeContratos, 
  'qtd_vidas'=>$conv->total_vidas,
  'taxa_adesao'=>$conv->total_taxa,
  'valor_contrato'=>$conv->total_valor
  ];

 array_push($arr[$value->produtor], (object) $retorno);
}
}//foreach


return $arr;
}//montaRelatorioProducao

// Por Filial
public function montaRelatorioProducao5($array){
$arr = [];

foreach($array as $key=>$value){
if(!isset($arr[$value->nome_filial])){
$arr[$value->nome_filial] = [];
array_push($arr[$value->nome_filial], $value);
}else{
 array_push($arr[$value->nome_filial], $value);
}
}//foreach

return $arr;
}//montaRelatorioProducao

// Por Grupo produtor
public function montaRelatorioProducao6($array){
$arr = [];

foreach($array as $key=>$value){
if(!isset($arr[$value->grupoprodutor])){
$arr[$value->grupoprodutor] = [];
array_push($arr[$value->grupoprodutor], $value);
}else{
 array_push($arr[$value->grupoprodutor], $value);
}
}//foreach

return $arr;
}//montaRelatorioProducao


public function montaRelatorioProducao7($array){
$arr = [];

foreach($array as $key=>$value){

$conv = $this->getConvenio($value->id_produtor, $value->convenio);
$retorno = [
'convenio'=>$value->nome_convenio,
'qtd_contratos'=>$conv->qtdeContratos,
'qtd_vidas'=>$conv->total_vidas,
'taxa_adesao'=>$conv->total_taxa,
'valor_contrato'=>$conv->total_valor
];

array_push($arr, (object)$retorno);
}//foreach


return $arr;
}//montaRelatorioProducao


public function getProdutor($produtor){
$retorno = [];
$total_vidas = 0;
$total_taxa = 0;
$total_valor = 0;

$contratos = (new Orm('contratos'))->select('*')->where(['produtor', $produtor])
->get();

foreach($contratos as $contrato){
 $total_vidas += $contrato->vidas;
 $total_valor += $contrato->valor_contrato;
}

$retorno = [
'qtdeContratos'=>COUNT($contratos),
'total_vidas'=>$total_vidas,
'total_valor'=>$total_valor
];

return (object)$retorno;
}//getProdutor

public function getConvenio($produtor, $convenio){
$retorno = [];
$total_vidas = 0;
$total_taxa = 0;
$total_valor = 0;

$ttl = (new Orm('contratos'))->select('*')->where(['produtor', $produtor])->total()->get();
$contratos = (new Orm('contratos'))->select(['vidas,taxa_adesao,valor_contrato'])->where(['produtor', $produtor])->get();

foreach($contratos as $contrato){
 $total_vidas += $contrato->vidas;
 $total_taxa += $contrato->taxa_adesao;
 $total_valor += $contrato->valor_contrato;
}

$retorno = [
'qtdeContratos'=>$ttl,
'total_vidas'=>$total_vidas,
'total_taxa'=>$total_taxa,
'total_valor'=>$total_valor
];

return (object)$retorno;
}//getConvenio


public function montabaixasexcel($array){

foreach($array as $key=>$arr){

$lanc = (new Orm('contratos'))->select('*')
 ->wherecustom("id_contrato = {$arr->id_contrato}")
 ->first()->get();

$array[$key]->valor_contrato = $lanc->valor_contrato;
}

return $array;
}//montabaixasexcel

public function montaRelatorioBaixa($array){
$arr = [];

foreach($array as $key=>$value){
if(!isset($arr[$value->nome_convenio])){
$arr[$value->nome_convenio] = [];
array_push($arr[$value->nome_convenio], $value);
}else{
 array_push($arr[$value->nome_convenio], $value);
}
}//foreach

return $arr;
}//montaRelatorioBaixa

public function montaRelatorioBaixaProdutor($array){
$arr = [];

foreach($array as $key=>$value){
if(!isset($arr[$value->produtor])){
$arr[$value->produtor] = [];
array_push($arr[$value->produtor], $value);
}else{
 array_push($arr[$value->produtor], $value);
}
}//foreach

return $arr;
}//montaRelatorioBaixa


public function montaRelatorioBaixaFilial($array){
$arr = [];

foreach($array as $key=>$value){
if(!isset($arr[$value->nome_filial])){
$arr[$value->nome_filial] = [];
array_push($arr[$value->nome_filial], $value);
}else{
 array_push($arr[$value->nome_filial], $value);
}
}//foreach

return $arr;
}//montaRelatorioBaixa


public function montaRelatorioGrupo($array){
$arr = [];

foreach($array as $key=>$value){
if(!isset($arr[$value->grupoprodutor])){
$arr[$value->grupoprodutor] = [];
array_push($arr[$value->grupoprodutor], $value);
}else{
 array_push($arr[$value->grupoprodutor], $value);
}
}//foreach

return $arr;
}//montaRelatorioBaixa


public function montaRelatorioFinanceiro($array){
$arr = [];
$hoje = date('Y-m-d');

foreach($array as $key=>$value){
$dias = $this->calculoDias($value->data_pagamento, $hoje);

if($dias >30){
if(!isset($arr[$value->nome_convenio])){
$arr[$value->nome_convenio] = [];

 if(!isset($arr[$value->nome_convenio][$value->produtor])){
  $arr[$value->nome_convenio][$value->produtor] = [];
  array_push($arr[$value->nome_convenio][$value->produtor], $value);
 }

}else{

if(!isset($arr[$value->nome_convenio][$value->produtor])){
 $arr[$value->nome_convenio][$value->produtor] = [];
} 
 array_push($arr[$value->nome_convenio][$value->produtor], $value);
}
}
}//foreach


return $arr;
}//montaRelatorioFinanceiro


public function calculoDias($inicio,$termino){
$diferenca = strtotime($termino) - strtotime($inicio);
$prazo = floor($diferenca / (60 * 60 * 24)); 
return $prazo;
}//calculoDias



}