//Função para modal
function showModal(titleHtml, contentHtml, buttons) {
  const modal = document.createElement("div");

  modal.classList.add("modal");
  modal.innerHTML = `
        <div class="modal__inner">
            <div class="modal__top">
                <div class="modal__title">${titleHtml}</div>
                <button class="modal__close" type="button">
                    <span><i class="fas fa-times"></i></span>
                </button>
            </div>
            <div class="modal__content">${contentHtml}</div>
            <div class="modal__bottom"></div>
        </div>
    `;


  for (const button of buttons) {
    const element = document.createElement("button");
     
     if(typeof button.type !== 'undefined'){
      element.setAttribute("type", button.type);
     }else{
       element.setAttribute("type", "button");
     }    
    element.classList.add("modal__button");
    element.textContent = button.label; 
    if(typeof button.id != 'undefined'){
      element.id = button.id;
    }
    if(typeof button.form !== 'undefined'){
      element.form = button.form;
    }     
    element.addEventListener("click", () => {
      if (button.triggerClose) {
        document.body.removeChild(modal);
      }

      button.onClick(modal);
    });

    modal.querySelector(".modal__bottom").appendChild(element);
  }

  modal.querySelector(".modal__close").addEventListener("click", () => {
    console.log(modal);
    document.body.removeChild(modal);
  });

  document.body.appendChild(modal);
}
/********Funcao para modal****************/
/*****************************************/
/*****************************************/

//funcoes javascript para sleep semelhante ao php
// function sleep (time) {
//   return new Promise((resolve) => setTimeout(resolve, time));
// }
// // Usage!
// sleep(500).then(() => {
//     // Do something after the sleep!
// });

// //Sleep metodo 2
// function sleepFor(sleepDuration){
//     var now = new Date().getTime();
//     while(new Date().getTime() < now + sleepDuration){ 
//         /* Do nothing */ 
//     }
// }
// //usage
// sleepFor(2000);
// console.log("Hello, JavaScript sleep!");

// //Sleep metodo 03
// function sleep(ms) {
//       return new Promise(resolve => setTimeout(resolve, ms));
// }
// //usage
// await sleep(3000);



/****Função para validar formularios****/
/***************************************/
/***************************************/
function validaForm(frm) {
  console.log('vamos validar');
  console.log(frm);
  console.log(frm.cardholderName);
  return;
}