<?php
use Core\Controller;
use Models\Users;
use Models\Permissao;
use Models\Orm;
use Models\Validate;
use Models\Leads;
use Models\ReportLead;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\IOFactory;

class FunilController extends Controller {

  private $user;
  private $arr;
  private $permissao;

    public function __construct() {              
        $this->user = new Users();
        $this->permissao = new Permissao(); 

        if($this->user->isLogged() == false){                  
         header("Location: ".BASE_URL."login");        
         exit;         
        }
          
       $permissoes = $this->permissao->getPermissoes();

        $this->arr = array(
         'user'=>$this->user,
         'menuActive'=>'home',
         'permissao'=>$permissoes             
        );          
}

public function index() {   
$this->arr['list_js'] = array(
'plugins/sweetalert2',
'system',
'plugins/sortable.min'
);  

$tab = new Orm('funil');

if(isset($_GET['nome']) && !empty($_GET['nome'])){
$nome = addslashes($_GET['nome']);
$this->arr['lista'] = $tab->select('*')->search(['nome_funil', $nome])->get();

foreach($this->arr['lista'] as $key=>$item){
$this->arr['lista'][$key]->itens = (new Orm('leads'))->select('*')
->where(['funil_id', $item->id_funil])->get();
}

}else{

$this->arr['lista'] = $tab->select('*')->get();
foreach($this->arr['lista'] as $key=>$item){
$this->arr['lista'][$key]->itens = (new Orm('leads'))->select('*')
->where(['funil_id', $item->id_funil])->get();
}
}

$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('funil/listar', $this->arr);
}//function index  


public function dashboard(){

$hoje = date('Y-m-d');
$id_usuario = $this->user->getId();

switch($this->user->getTipo()){
case 'Super Admin':
$this->arr['tarefas_hoje'] = (new Orm('leads_comentarios'))
->select(['leads_comentarios.*, usuarios.nome, leads.nome as nome_lead, leads.telefone, leads.para'])
->join(['usuarios'],['leads'])
->on(
  ['leads_comentarios.id_user','=','usuarios.id_usuario'],
['leads_comentarios.id_lead','=','leads.id_lead'])
->wherecustom("data_agendamento = '$hoje' AND finalizado = 'N' AND leads_comentarios.tipo != 'comentario'")
->order(['hora_agendamento asc'])
->get();

$this->arr['tarefas_atrasadas'] = (new Orm('leads_comentarios'))
->select(['leads_comentarios.*, usuarios.nome, leads.nome as nome_lead, leads.telefone, leads.para'])
->join(['usuarios'],['leads'])
->on(['leads_comentarios.id_user','=','usuarios.id_usuario'],['leads_comentarios.id_lead','=','leads.id_lead'])
->wherecustom("data_agendamento < '$hoje' AND finalizado = 'N' AND leads_comentarios.tipo != 'comentario'")
->order(['hora_agendamento asc'])
->get();
break;

case 'Produtor':
$this->arr['tarefas_hoje'] = (new Orm('leads_comentarios'))
->select(['leads_comentarios.*, usuarios.nome, leads.nome as nome_lead, leads.telefone, leads.para'])
->join(['usuarios'],['leads'])
->on(
  ['leads_comentarios.id_user','=','usuarios.id_usuario'],
['leads_comentarios.id_lead','=','leads.id_lead'])->wherecustom("data_agendamento = '$hoje' AND para = $id_usuario AND finalizado = 'N' AND leads_comentarios.tipo != 'comentario'")
->order(['hora_agendamento asc'])->get();

$this->arr['tarefas_atrasadas'] = (new Orm('leads_comentarios'))
->select(['leads_comentarios.*, usuarios.nome, leads.nome as nome_lead, leads.telefone, leads.para'])
->join(['usuarios'],['leads'])
->on(['leads_comentarios.id_user','=','usuarios.id_usuario'],['leads_comentarios.id_lead','=','leads.id_lead'])
->wherecustom("data_agendamento < '$hoje' AND para = $id_usuario AND finalizado = 'N' AND leads_comentarios.tipo != 'comentario'")->order(['hora_agendamento asc'])->get();
break;
}//switch




$this->loadTemplate('funil/dashboard', $this->arr);
}//dashboard

public function getProdutor($id){
$p = (new Orm('usuarios'))->select(['nome'])->where(['id_usuario', $id])
->first()->get();


if(!empty($p)){
return $p->nome;
}

return '';
}//getProdutor


public function add(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'plugins/sweetalert2',
'system'
);


$this->loadTemplate('funil/adicionar', $this->arr);
}



public function filtro(){
$this->arr['list_js'] = array(
'plugins/sweetalert2',
'system',
'plugins/sortable.min'
);  

$this->arr['produtores'] = (new Orm('usuarios'))->select('*')->order(['nome asc'])->where(['tipo','Produtor'])->get();

$tab = new Orm('funil');
$id_usuario = $this->user->getId();

$this->arr['lista'] = $tab->select('*')->get();
$this->arr['tipo'] = $this->user->getTipo();

if(isset($_POST['nome']) && !empty($_POST['nome'])){
$produtor = addslashes(trim($_POST['nome']));


foreach($this->arr['lista'] as $key=>$item){
switch($this->user->getTipo()){
case 'Super Admin':

$this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
->wherecustom("funil_id = $item->id_funil AND para = $produtor")
->paginate('100')->get();

break;

case 'Produtor':
$this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
->wherecustom("funil_id = $item->id_funil AND para = $id_usuario")
->paginate('100')->get();
break;
}
}//foreach

}else{//se teve pesquisa

//aqui é quando n tem pesquisa
foreach($this->arr['lista'] as $key=>$item){
switch($this->user->getTipo()){
case 'Super Admin':

$this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
->wherecustom("funil_id = $item->id_funil ")->get();

break;

case 'Produtor':
$this->arr['lista'][$key]->itens  = (new Orm('leads'))->select('*')
->wherecustom("funil_id = $item->id_funil AND para = $id_usuario")->get();
break;
}
}//foreach
}//se n teve pesquisa

$this->arr['msg'] = $this->flashMessage($_SESSION['msg'] ?? null);
$this->loadTemplate('leads/funil', $this->arr);
}//filtro

public function save(){
$validator = new Validate();

if(isset($_POST['nome_funil']) && !empty($_POST['nome_funil'])){

$validate = $validator->validate([
'nome_funil'=>'required'
],true);


if(!$validate){
$_SESSION['msg'] = ['type'=>'error','msg'=>'Ooops... Alguns campos estão inválidos, tente novamente'];
 unset($_SESSION['flash']);
 unset($_SESSION['old']);
 header("Location:".BASE_URL."funil");
 exit;   
}

$grava = (new Orm('funil'))->set($validate)->save();
$_SESSION['msg'] = ['type'=>'success','msg'=>'Funil cadastrado com sucesso!'];
header("Location:".BASE_URL."funil");
exit;

}
}//save

public function relatorio(){
$this->arr['list_js'] = array(
'plugins/jquery.mask.min',
'plugins/parsley/parsley.min',
'plugins/parsley/pt-br',
'mask_init',
'plugins/sweetalert2',
'system',
'flatpickr/flatpickr',
'flatpickr/pt',
'flatpickr/flatpickr_init'
);


$this->arr['lista'] = [];  
$this->arr['origens'] = (new Orm('origem_venda'))->select('*')->get();
$this->arr['produtos'] = (new Orm('produtos'))->select('*')->get();
$this->arr['produtores'] = (new Orm('usuarios'))->select('*')->where(['tipo','Produtor'])->get();

if(isset($_GET['nome']) || isset($_GET['produto']) || isset($_GET['origem']) || isset($_GET['status'])){
$nome = $_GET['nome'];
$produto = $_GET['produto'];
$origem = $_GET['origem'];
$status = $_GET['status'];

$lista = (new Orm('leads'))->select('*')
->orSearch(
  ['nome', $nome],
  ['produto', $produto],
  ['origem', $origem],
  ['status', $status])
->get();

$this->arr['lista'] = $lista;
}

$this->loadTemplate('funil/relatorio', $this->arr);
}//relatori


public function exportar(){
$rl = new ReportLead();


$produtor = isset($_POST['produtor']) ? $_POST['produtor'] : null;
$origem   = isset($_POST['origem']) ? $_POST['origem'] : null;
$produto  = isset($_POST['produto']) ? $_POST['produto'] : null;
$tipo     = $_POST['tipo'];
$data_inicial = $_POST['data_inicial'];
$data_final   = $_POST['data_final'];

if($data_inicial != null){
$data_inicial = $this->converterData($data_inicial,'/');
$data_inicial = $data_inicial." 00:00:00";
}

if($data_final != null){
$data_final = $this->converterData($data_final,'/');
$data_final = $data_final." 23:59:59";
}

$filtro = (new Orm('leads'))
->select('*')
->in(
  ['produto', $produto],
  ['para', $produtor],
  ['origem', $origem])
->between(['data_entrada','>=',$data_inicial],['data_entrada','<=', $data_final])
->get();

if($tipo == 'excel'){
$this->exportarexcel($filtro);
}

$str_produto = $this->convertArrayToString($produto);
$str_origem = $this->convertArrayToString($origem);

$header = [
'produto'=>$str_produto,
'origem'=>$str_origem,
'datas'=>$data_inicial." / ".$data_final
];

$filtro = $this->montaLead($filtro);
$rl->gerar($filtro, $header);

}//exportar



public function montaLead($array){
$arr = [];

foreach($array as $key=>$value){
$produtor = (new Orm('usuarios'))->select(['nome'])->where(['id_usuario', $value->para])->first()->get();

$nome_produtor = $produtor->nome ?? 'Sem Produtor';
$value->para = $nome_produtor;

if(!isset($arr[$value->para])){
$arr[$value->para] = [];
array_push($arr[$value->para], $value);
}else{
 array_push($arr[$value->para], $value);
}
}//foreach


return $arr;
}//montaRelatorioProducao


public function export(){
$e = new SimpleXLSXGen();

$employees = [
  ['Nome', 'Produto', 'E-mail', 'Telefone', 'Origem']
];

foreach($dados as $item){
 $employees = array_merge($employees, array(
  array($item->nome, $item->produto, $item->email, $item->telefone, $item->origem)));
}

$xlsx = SimpleXLSXGen::fromArray($employees);
// This will download the file to your local system
$xlsx->downloadAs('Leads.xlsx'); 
// This will save the file to your server
// $xlsx->saveAs('employees.xlsx');

echo "<pre>";
print_r($employees);
}



public function exportarexcel($dados){
//Aqui começa a exportação
$formato = 'Xlsx';//Xlsx - Xls - Csv
$file = new Spreadsheet();
$active_sheet = $file->getActiveSheet();

$active_sheet->setCellValue('a1', 'Produtor');
$active_sheet->setCellValue('b1', 'Nome');
$active_sheet->setCellValue('c1', 'Produto');
$active_sheet->setCellValue('d1', 'E-mail');
$active_sheet->setCellValue('e1', 'Telefone');
$active_sheet->setCellValue('f1', 'Origem');
$active_sheet->setCellValue('g1', 'Tipo Cotacao');
$active_sheet->setCellValue('h1', 'Qtde de Vidas');
$active_sheet->setCellValue('i1', 'Data Entrada');
$active_sheet->setCellValue('j1', 'Status');

$count = 2;
foreach($dados as $row){

$produtor = (new Orm('produtor'))->select(['nome'])
->where(['id_produtor', $row->para])->first()->get();  

$active_sheet->setCellValue('a'.$count, $produtor->nome ?? '');
$active_sheet->setCellValue('b'.$count, $row->nome ?? '');
$active_sheet->setCellValue('c'.$count, $row->produto ?? '');
$active_sheet->setCellValue('d'.$count, $row->email ?? '');
$active_sheet->setCellValue('e'.$count, $row->telefone ?? '');
$active_sheet->setCellValue('f'.$count, $row->origem ?? '');
$active_sheet->setCellValue('g'.$count, $row->tipo_cotacao ?? '');
$active_sheet->setCellValue('h'.$count, $row->qtde_vidas ?? '');
$active_sheet->setCellValue('i'.$count, $row->data_entrada ?? '');
$active_sheet->setCellValue('j'.$count, $row->status ?? '');
$count = $count +1;
}

$writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($file, $formato);

$file_name = time().'.'.strtolower(($formato));
$writer->save($file_name);
header("Content-Type: application/x-www-form-urlencoded");
header("Content-Transfer-Encoding:Binary");
header("Content-disposition:attachment;filename=\"".$file_name."\"");
readfile($file_name);
unlink($file_name);
exit;

}//exportar



public function verificaTarefa($id_lead){
$reg = (new Orm('leads_comentarios'))->select(['status_tarefa, finalizado'])
->where(['id_lead', $id_lead])->get();

if(empty($reg)){
 return 0;
}

$status = '';
foreach($reg as $rg){
 if($rg->status_tarefa != '' || $rg->status_tarefa != null){
  
  if($rg->finalizado != 'N'){
    $status = 0;
  }else{
    $status = $rg->status_tarefa;
  } 
   
 }
}

return $status;
}//verificaTarefa


public function update(){
$funil = $_POST['funil'];
$lead = $_POST['lead'];

$up = (new Orm('leads'))->set(['funil_id'=>$funil])->where(['id_lead', $lead])->update();

if($up){
echo json_encode('1');
exit;
}

echo json_encode('0');
exit;

}//update


public function remover($id){
$qr = new Orm('funil');
$qr->del(['id_funil', $id]);
$_SESSION['msg'] = ['type'=>'success','msg'=>'Funil removido com sucesso!'];
header("Location:".BASE_URL."funil");
exit;
}


}